﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace ControlesAt{
using static Textos.Cods;

namespace SistemadeCoordenadas{
	public class FormLatLong : ControlesAt.FormOpcionesAlgo{
		internal RadioButton LatLong, LongLat;

		public FormLatLong(ControlesAt.IEntorno _Entorno, Control _Where, CValoresSistemas _c_) : base(_Entorno,_Where,_c_){}
		protected override void InitializeComponent(){
			LatLong= new RadioButton();
			LongLat= new RadioButton();
			LatLong.Location= new Point(12, 20);	LatLong.Width=92; LongLat.TabIndex= 3;
			LongLat.Location= new Point(104, 20);	LongLat.Width=92; LongLat.TabIndex= 4;
			this.Controls.Add(LatLong);
			this.Controls.Add(LongLat);
		}

		protected override void set_data(object obj){
			CValoresSistemas Csis=(CValoresSistemas)obj;
			if(Csis.V.LatLong==0) LatLong.Checked=true;
			else LongLat.Checked=true;
		}
		protected override void Aceptar_Click(object sender,EventArgs e){
			CValoresSistemas Csis=(CValoresSistemas)ref_to_Data;
			if(LongLat.Checked) Csis.V.LatLong=1;
			else Csis.V.LatLong=0;
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LatLong.Text=Textos.get_texto(Textos.Cods.LatLong,idioma);
			LongLat.Text=Textos.get_texto(Textos.Cods.LongLat,idioma);
		}
	}

	public class FormR : ControlesAt.FormOpcionesAlgo{
		internal ControlesAt.LTFloatPos LTxtR;

		public FormR(ControlesAt.IEntorno _Entorno, Control _Where, CTierra _c_) : base(_Entorno,_Where,_c_){}
		protected override void InitializeComponent(){
			LTxtR= new ControlesAt.LTFloatPos();
			LTxtR.TextLocation= new Point(88, 20);	LTxtR.TabIndex= 3;
			this.Controls.Add(LTxtR);
		}

		protected override void set_data(object obj){
			CTierra Ctierra=(CTierra)obj;
			LTxtR.T.Text=Convert.ToString((Ctierra.V.N+Ctierra.V.ρ)*0.5);	//es más predecible que la media geométrica
		}
		protected override void Aceptar_Click(object sender,EventArgs e){
			CTierra Ctierra=(CTierra)ref_to_Data;

			double r;
			try{r=Basicas._gcVarios.atodbl(LTxtR.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_R_erróneo,idioma));
				return;
			}
			if(2*r!=Ctierra.V.N+Ctierra.V.ρ)
				Ctierra.V.ρ=Ctierra.V.N=r;
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LTxtR.L.Text=Textos.get_texto(Radio,idioma);
		}
	}
	public class FormRk : ControlesAt.FormOpcionesAlgo{
		internal ControlesAt.LTFloatPos LTxta, LTxtN, LTxtρ, LTxtk;
		internal ControlesAt.LTFloat LTxtconv;
		private ControlesAt.MasMenos Masmenos;

		public FormRk(IEntorno _Entorno, Control _Where, CTierra _c_) : base(_Entorno,_Where,_c_){
			Masmenos.State=false;
		}

	#region InitializeComponent
		protected override void InitializeComponent(){
			LTxta= new LTFloatPos();
			LTxtN= new LTFloatPos();
			LTxtρ=new LTFloatPos();
			LTxtconv= new LTFloat();
			LTxtk= new LTFloatPos();
			Masmenos= new MasMenos();
			//
			// Masmenos
			Masmenos.Location= new Point(6,25);
			Masmenos.Click+=new EventHandler(Masmenos_Click);
			//
			// Position&Size
			//
			LTxta.TextLocation=	new Point(132, 20);		LTxta.TabIndex= 3;
			LTxtN.TextLocation=	new Point(132, 20);		LTxtN.TabIndex= 4;
			LTxtρ.TextLocation=new Point(132, 50);		LTxtρ.TabIndex= 5;
			LTxtconv.TextLocation=new Point(132, 80);	LTxtconv.TabIndex= 6;
			LTxtk.TextLocation=	new Point(132, 116);	LTxtk.TabIndex= 7;
			//
			// Aceptar, Cancelar
			Aceptar.Location= new Point(30, 126);
			Cancelar.Location= new Point(138, 126);
			//
			// FormRk
			//
			this.Controls.AddRange(new Control[]{
				Masmenos,	LTxta,
				LTxtN,		LTxtρ,
				LTxtconv,	LTxtk
			});
		}
		protected override Size DefaultSize{
			get{return new Size(232, 170);}
		}
	#endregion

		protected override void set_data(object obj){
			CTierra Ctierra=(CTierra)obj;

			LTxtN.T.Text=Convert.ToString(Ctierra.V.N);
			LTxtρ.T.Text=Convert.ToString(Ctierra.V.ρ);
			LTxta.T.Text=Convert.ToString((Ctierra.V.N+Ctierra.V.ρ)/2);
			LTxtconv.T.Text=Convert.ToString(Ctierra.V.conv);
			LTxtk.T.Text=Convert.ToString(Ctierra.V.k);
			Masmenos.State= Ctierra.V.N!=Ctierra.V.ρ || Ctierra.V.k!=1;
			Masmenos_Click(this,EventArgs.Empty);
		}

		private void Masmenos_Click(object sender,EventArgs e){
			bool b=Masmenos.State;
			LTxta.Visible=!b;
			LTxtN.Visible=b;
			LTxtρ.Visible=b;
			LTxtconv.Visible=b;
			LTxtk.Visible=b;
			int pos;
			if(b) pos=LTxtk.Top;
			else pos=LTxta.Top;
			Aceptar.Top=Cancelar.Top=pos+40;
			this.ClientSize=new Size(228, Aceptar.Top+44);
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			CTierra Ctierra=(CTierra)ref_to_Data;

			if(!Masmenos.State){
				try{Ctierra.V.N=Basicas._gcVarios.atodbl(LTxta.T.Text.ToCharArray());}
				catch(System.SystemException){
					Entorno.MessageBox.Show(Textos.get_texto(Valor_a_erróneo,idioma));
					return;
				}
				Ctierra.V.ρ=Ctierra.V.N;
				Ctierra.V.conv=0;
				Ctierra.V.k=1;
				this.Hide();
				return;
			}

			try{Ctierra.V.N=Basicas._gcVarios.atodbl(LTxtN.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_N_erróneo,idioma));
				return;
			}
			try{Ctierra.V.ρ=Basicas._gcVarios.atodbl(LTxtρ.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_ρ_erróneo,idioma));
				return;
			}
			try{Ctierra.V.conv=Basicas._gcVarios.atodbl(LTxtconv.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_convergencia_erróneo,idioma));
				return;
			}
			try{Ctierra.V.k=Basicas._gcVarios.atodbl(LTxtk.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_k_erróneo,idioma));
				return;
			}
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LTxta.L.Text=Textos.get_texto(Radio,idioma);
			LTxtN.L.Text=Textos.get_texto(Radio_mayor,idioma);
			LTxtρ.L.Text=Textos.get_texto(Radio_menor,idioma);
			LTxtconv.L.Text=Textos.get_texto(Conv_meridianos,idioma);
			LTxtk.L.Text=Textos.get_texto(Factor_de_escala,idioma);
		}
	}
	public class Formsis : ControlesAt.FormOpcionesAlgo
	{
		private ControlesAt.LabelTextoGrado LTxtFi0;
		private ContainerControl PanelFijo;
		private ControlesAt.LTFloat LTxtk, LTxtX, LTxtY;

		public Formsis(IEntorno _Entorno, Control _Where, CValoresSistemas _c_) : base(_Entorno,_Where,_c_){}
	#region InitializeComponent
		protected override void InitializeComponent(){
			PanelFijo= new ContainerControl();
			LTxtFi0= new LabelTextoGrado();
			LTxtk= new LTFloat();
			LTxtX= new LTFloat();
			LTxtY= new LTFloat();
			//
			// PanelFi0
			//
			LTxtFi0.TextLocation=new Point(124, 20);
			LTxtFi0.TabIndex=3;
			//
			// PanelFijo
			//
			PanelFijo.Location=new Point(24,52);
			PanelFijo.Size=new Size(188,100);
			PanelFijo.TabIndex=4;
			PanelFijo.Controls.AddRange(new Control[]{LTxtk, LTxtX, LTxtY});
			LTxtk.TextLocation= new Point(100, 4);	LTxtk.TabIndex= 0;
			LTxtX.TextLocation= new Point(100, 40);	LTxtX.TabIndex= 1;
			LTxtY.TextLocation= new Point(100, 76);	LTxtY.TabIndex= 2;
			//
			// Aceptar, Cancelar
			Aceptar.Location= new Point(28, 158);
			Cancelar.Location= new Point(128, 158);
			//
			// Formsis
			this.ClientSize= new Size(224, 212);
			this.Controls.Add(this.PanelFijo);
			this.Controls.Add(this.LTxtFi0);
		}
	#endregion

		short caso;
		protected override void set_data(object obj){
			CValoresSistemas Csistemas=(CValoresSistemas)obj;

			caso=(short)((ControlSistema)Entorno).Comsis.SelectedIndex;
			switch(caso){
				case 3:
					LTxtk.Text= Convert.ToString(Csistemas.V.kUTM);
					LTxtX.Text= Convert.ToString(Csistemas.V.XUTM);
					LTxtY.Text= Convert.ToString(Csistemas.V.YUTM);
					break;
				default:	//Serie Lambert
					LTxtk.Text= Convert.ToString(Csistemas.V.kLambert);
					LTxtX.Text= Convert.ToString(Csistemas.V.XLambert);
					LTxtY.Text= Convert.ToString(Csistemas.V.YLambert);
					LTxtFi0.Valor=Grados.ToGrados(Csistemas.V.Phi0Lambert);
					break;
			}
			if(caso==0) PanelFijo.Top=52;
			else	PanelFijo.Top=16;

			if(caso==1){	//Mercator
				LTxtX.Text=""; LTxtX.Enabled=false;
			}else{
				LTxtX.Enabled=true;
			}
			Aceptar.Top=Cancelar.Top=PanelFijo.Top+116;
			this.ClientSize=new Size(224,Aceptar.Top+44);
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			double k,X,Y;
			CValoresSistemas Csistemas=(CValoresSistemas)ref_to_Data;
			X=0;	//IMBÉCIL

			try{k=Basicas._gcVarios.atodbl(LTxtk.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_k_erróneo,idioma));
				return;
			}

			if(caso!=1){	//Mercator
				try{X=Basicas._gcVarios.atodbl(LTxtX.T.Text.ToCharArray());}
				catch(System.SystemException){
					Entorno.MessageBox.Show(Textos.get_texto(Valor_X_erróneo,idioma));
					return;
				}
			}

			try{Y=Basicas._gcVarios.atodbl(LTxtY.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_Y_erróneo,idioma));
				return;
			}

			switch(caso){
				case 3:
					Csistemas.V.kUTM=k;
					Csistemas.V.XUTM=X;
					Csistemas.V.YUTM=Y;
					break;
				default:	//Lambert Series
					if(caso==0){
						int phi0;
						try{
							if(LTxtFi0.Valor.i>60 || LTxtFi0.Valor.ii>60) throw new OverflowException();
							phi0=LTxtFi0.Valor.ToMilliseconds();
							if(phi0>90*3600*1000 || phi0<-90*3600*1000) throw new OverflowException();
						}
						catch(System.SystemException){
							Entorno.MessageBox.Show(Textos.get_texto(Valor_lat_origen_erróneo,idioma));
							return;
						}
						Csistemas.V.Phi0Lambert=phi0;
						if(phi0==90 || phi0==-90) ((ControlSistema)Entorno).Comsis.SelectedIndex=2;
						else if(phi0==0) ((ControlSistema)Entorno).Comsis.SelectedIndex=1;
					}
					Csistemas.V.kLambert=k;
					if(caso!=1) Csistemas.V.XLambert=X;
					Csistemas.V.YLambert=Y;
					break;
			}
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LTxtFi0.L.Text=Textos.get_texto(Latitud_origen,idioma);
			LTxtk.L.Text=Textos.get_texto(Escala_central,idioma);
			LTxtX.L.Text=Textos.get_texto(Desplazamiento_X,idioma);
			LTxtY.L.Text=Textos.get_texto(Desplazamiento_Y,idioma);
		}
	}
	public class Formelip : ControlesAt.FormOpcionesAlgo{
		internal ControlesAt.LTFloatPos LTxta;
		internal ControlesAt.LTFloat LTxte;

		public Formelip(IEntorno _Entorno, Control _Where, CElipsoide _c_) : base(_Entorno,_Where,_c_){}
		protected override void InitializeComponent(){
			LTxta= new LTFloatPos();
			LTxte= new LTFloat();
			//
			LTxta.TextLocation= new Point(124, 20);
			LTxte.TextLocation= new Point(124, 56);
			Aceptar.Location= new Point(30, 96);
			Cancelar.Location= new Point(128, 96);
			//
			// Formelip
			//
			this.ClientSize= new Size(220, 140);
			this.Controls.Add(LTxta);
			this.Controls.Add(LTxte);
		}

		protected override void set_data(object obj){
			CElipsoide Celipsoide=(CElipsoide)obj;
			LTxta.T.Text=Convert.ToString(Celipsoide.V.a);
			LTxte.T.Text=Convert.ToString(Celipsoide.V.ee);
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			CElipsoide Celipsoide=(CElipsoide)ref_to_Data;

			try{Celipsoide.V.a=Basicas._gcVarios.atodbl(LTxta.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_a_erróneo,idioma));
				return;
			}

			try{Celipsoide.V.ee=Basicas._gcVarios.atodbl(LTxte.T.Text.ToCharArray());}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Valor_e_erróneo,idioma));
				return;
			}
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LTxta.L.Text=Textos.get_texto(Semieje_mayor,idioma);
			LTxte.L.Text=Textos.get_texto(Excentricidad,idioma);
		}
	}
}}
