using System;
using System.Windows.Forms;
using System.Drawing;

namespace Calibracion{
	public class Formpixel : ControlesAt.FormValue{
		public Formpixel(ControlesAt.IEntorno _Entorno) : base(_Entorno,'F'){}

		protected override void OnLoad(EventArgs e) {
			base.OnLoad (e);
			LTxtR.T.Focus();
			LTxtR.T.Capture=true;
		}

		protected override void OnAceptar(System.ComponentModel.CancelEventArgs e){
			double r;
			try{r=Basicas._gcVarios.atodbl(LTxtR.T.Text.ToCharArray());
				if(r==0) throw new FormatException();
			}
			catch(System.SystemException){
				Entorno.MessageBox.Show(Textos.get_texto(Textos.Cods.Valor_errneo,idioma));
				e.Cancel=true;
				return;
			}
			this.DialogResult=DialogResult.OK;
		}
		protected override void update_idioma(){
			base.update_idioma();
			LTxtR.L.Text=Textos.get_texto(Textos.Cods.Tamao_de_pxel,idioma);
		}
	}
}
