using System;
using System.Windows.Forms;
using System.Drawing;
using PanelesSub;
using ControlesAt;

namespace Aerotri{
using static Textos.Cods;

	public class FormValoresAproximados : ControlesAt.FormLabelMove{
		private Label LblTitulo;
		private ContainerControl panel1;
		private Label label2;
		private CheckBox optMMcc;
		private GroupBox GBoxhacha;
		private RadioButton opthachaDeducir, opthachaValor;
		private ControlesAt.IntegerTextBox txthacha;
		private GroupBox GBoxcamino;
		private RadioButton optcaminoDeducir, optcaminoValor;
		private ControlesAt.FloatTextBox txtcamino;
		private GroupBox GBoxGPSINS;
		private RadioButton optGPSsi, optGPSno;

		PanelAerotri PanelPadre;
		public FormValoresAproximados(PanelAerotri Form1) : base(Form1){
			PanelPadre=Form1;
			InitializeComponent();
			txthacha.BackColor=this.BackColor;
			txtcamino.BackColor=this.BackColor;
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			LblTitulo= new Label();
			panel1= new ContainerControl();
			optMMcc= new CheckBox();
			label2= new Label();
			GBoxhacha= new GroupBox();
			opthachaDeducir= new RadioButton();
			opthachaValor= new RadioButton();
			txthacha= new IntegerTextBox();
			GBoxcamino= new GroupBox();
			optcaminoDeducir= new RadioButton();
			optcaminoValor= new RadioButton();
			txtcamino= new FloatTextBox();
			GBoxGPSINS= new GroupBox();
			optGPSsi= new RadioButton();
			optGPSno= new RadioButton();
			//
			// LblTitulo
			//
			LblTitulo.Font= new System.Drawing.Font("Franklin Gothic Medium", 11.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			LblTitulo.Location= new Point(12, 12);
			LblTitulo.Size= new Size(200, 20);
			LblTitulo.TabIndex= 38;
			LblTitulo.TextAlign= ContentAlignment.TopCenter;
			//
			// panel1
			//
			panel1.Controls.Add(optMMcc);
			panel1.Controls.Add(label2);
			panel1.Location= new Point(4, 44);
			panel1.Size= new Size(216, 16);
			panel1.TabIndex= 3;
			//
			// label2
			//
			label2.FlatStyle= FlatStyle.System;
			label2.Location= new Point(4, 0);
			label2.Size= new Size(84, 16);
			label2.TabIndex= 0;
			//
			// optMMcc
			//
			optMMcc.Checked= false;
			optMMcc.Location= new Point(88, 0);
			optMMcc.Size= new Size(140, 17);
			optMMcc.TabIndex= 1;
			//
			// GBoxhacha
			//
			GBoxhacha.Controls.Add(opthachaDeducir);
			GBoxhacha.Controls.Add(opthachaValor);
			GBoxhacha.Controls.Add(txthacha);
			GBoxhacha.Location= new Point(8, 68);
			GBoxhacha.Size= new Size(208, 76);
			GBoxhacha.TabIndex= 4;
			//
			// opthachaDeducir
			//
			opthachaDeducir.Checked= true;
			opthachaDeducir.FlatStyle= FlatStyle.System;
			opthachaDeducir.Location= new Point(8, 32);
			opthachaDeducir.Size= new Size(192, 16);
			opthachaDeducir.TabIndex= 0;
			//
			// opthachaValor
			//
			opthachaValor.FlatStyle= FlatStyle.System;
			opthachaValor.Location= new Point(8, 52);
			opthachaValor.Size= new Size(104, 16);
			opthachaValor.TabIndex= 1;
			opthachaValor.CheckedChanged+= new EventHandler(opthachaValor_CheckedChanged);
			//
			// txthacha
			//
			txthacha.Enabled= false;
			txthacha.Location= new Point(112, 51);
			txthacha.Width= 40;
			txthacha.TabIndex= 4;
			txthacha.Text= "6";
			//
			// GBoxcamino
			//
			GBoxcamino.Controls.Add(optcaminoDeducir);
			GBoxcamino.Controls.Add(optcaminoValor);
			GBoxcamino.Controls.Add(txtcamino);
			GBoxcamino.Location= new Point(8, 150);
			GBoxcamino.Size= new Size(208, 64);
			GBoxcamino.TabIndex= 5;
			//
			// optcaminoDeducir
			//
			optcaminoDeducir.Checked= true;
			optcaminoDeducir.FlatStyle= FlatStyle.System;
			optcaminoDeducir.Location= new Point(8, 20);
			optcaminoDeducir.Size= new Size(192, 16);
			optcaminoDeducir.TabIndex= 0;
			//
			// optcaminoValor
			//
			optcaminoValor.FlatStyle= FlatStyle.System;
			optcaminoValor.Location= new Point(8, 40);
			optcaminoValor.Size= new Size(104, 16);
			optcaminoValor.TabIndex= 1;
			optcaminoValor.CheckedChanged+= new EventHandler(optcaminoValor_CheckedChanged);
			//
			// txtcamino
			//
			txtcamino.Enabled= false;
			txtcamino.Location= new Point(112, 39);
			txtcamino.Width= 40;
			txtcamino.TabIndex= 5;
			txtcamino.Text= "7.9";
			//
			// GBoxGPSINS
			//
			GBoxGPSINS.Controls.Add(this.optGPSsi);
			GBoxGPSINS.Controls.Add(this.optGPSno);
			GBoxGPSINS.Location= new Point(8, 220);
			GBoxGPSINS.Size= new Size(208, 64);
			GBoxGPSINS.TabIndex= 39;
			//
			// optGPSsi
			//
			optGPSsi.Checked= true;
			optGPSsi.FlatStyle= FlatStyle.System;
			optGPSsi.Location= new Point(8, 40);
			optGPSsi.Size= new Size(188, 16);
			optGPSsi.TabIndex= 1;
			//
			// optGPSno
			//
			optGPSno.FlatStyle= FlatStyle.System;
			optGPSno.Location= new Point(8, 20);
			optGPSno.Size= new Size(148, 16);
			optGPSno.TabIndex= 0;
			//
			// Aceptar, Cancelar
			//
			Aceptar.Location= new Point(28, 302);
			Cancelar.Location= new Point(132, 302);
			//
			// FormValoresAproximados
			//
			this.ClientSize= new Size(224, 346);
			this.Controls.Add(LblTitulo);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.GBoxhacha);
			this.Controls.Add(this.GBoxcamino);
			this.Controls.Add(this.GBoxGPSINS);
		}
	#endregion

		protected override void OnLoad(EventArgs e){
			this.Top=PanelPadre.ParentForm.Top;
			this.Left=PanelPadre.ParentForm.Left + PanelPadre.ParentForm.Width-this.Width+20;

			InterComAerotri.ValoresAproximados aprox=PanelPadre.aproximados;
			 optMMcc.Checked=aprox.force_mmcc==0;
			if(aprox.hacha==0) opthachaDeducir.Checked=true;
			else{
				opthachaValor.Checked=true;
				txthacha.Text=Convert.ToString(aprox.hacha);
			}
			if(aprox.mult_contra==0) optcaminoDeducir.Checked=true;
			else{
				optcaminoValor.Checked=true;
				txtcamino.Text=Convert.ToString((float)aprox.mult_contra/100.0F);
			}
			if(aprox.usa_gps==0) optGPSno.Checked=true;
			else optGPSsi.Checked=true;

			base.OnLoad(e);
		}

		void opthachaValor_CheckedChanged(object sender,System.EventArgs e){
			txthacha.Enabled=opthachaValor.Checked;
			if(txthacha.Enabled) txthacha.BackColor=SystemColors.Window;
			else txthacha.BackColor=this.BackColor;
		}
		void optcaminoValor_CheckedChanged(object sender,System.EventArgs e){
			txtcamino.Enabled=optcaminoValor.Checked;
			if(txtcamino.Enabled) txtcamino.BackColor=SystemColors.Window;
			else txtcamino.BackColor=this.BackColor;
		}

		protected override void Aceptar_Click(object sender,EventArgs e){
					InterComAerotri.ValoresAproximados aprox=PanelPadre.aproximados;
			if(optMMcc.Checked) aprox.force_mmcc=0;
			else aprox.force_mmcc=1;

			if(opthachaDeducir.Checked){
				aprox.hacha=0;
			}else{
				try{aprox.hacha=Convert.ToUInt16(txthacha.Text);}
				catch(System.SystemException){
					PanelPadre.MessageBoxAT.Show(get_texto(Valor_mnimo_puntos_comunes_errneo));
					return;
				}
			}

			if(optcaminoDeducir.Checked){
				aprox.mult_contra=0;
			}else{
				try{aprox.mult_contra=(ushort)(Basicas._gcVarios.atofl(txtcamino.Text.ToCharArray())*100.0F);}
				catch(System.SystemException){
					PanelPadre.MessageBoxAT.Show(get_texto(Valor_parmetro_camino_errneo));
					return;
				}
			}
			if(optGPSno.Checked) aprox.usa_gps=0;
			else aprox.usa_gps=2;

			PanelPadre.aproximados=aprox;
			this.Hide();
		}

		protected override void update_idioma(){
			label2.Text=get_texto(Tipo_de_ajuste)+":";
			optMMcc.Text=get_texto(Fuerza_mmcc);
			LblTitulo.Text=get_texto(Valores_aproximados);
			GBoxhacha.Text=get_texto(Minimo_nmero_puntos_comunes);
			opthachaDeducir.Text=get_texto(Deduce_automticamente);
			opthachaValor.Text=get_texto(El_siguiente_valor)+":";
			optcaminoDeducir.Text= opthachaDeducir.Text;
			optcaminoValor.Text= opthachaValor.Text;
			GBoxcamino.Text=get_texto(Parmetro_de_camino);
			GBoxGPSINS.Text=get_texto(Uso_de_GPS);
			optGPSno.Text=get_texto(No_emplear);
			optGPSsi.Text=get_texto(Emplear_si_todos);
			Aceptar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Aceptar,idioma);
			Cancelar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Cancelar,idioma);

			if(idioma==Globales.Idioma.Eng){
				label2.Width=94;
				optMMcc.Left=102;
			}else{
				label2.Width=84;
				optMMcc.Left=88;
			}
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
