using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
using static Textos.Cods;
	public abstract class FormUnidades : ControlesAt.FormOpcionesAlgo{
		protected ControlesAt.LabelTextoSingle[] LTexts;
		protected uint n;

		public FormUnidades(uint _n, IEntorno _Entorno, Control _Where, object _c_) : base(_Entorno,_Where,_c_){
			n=_n;
			LTexts= new LabelTextoSingle[n];
			InitializeComponent2();
		}

	#region InitializeComponent
		protected override void InitializeComponent(){}
		private void InitializeComponent2(){
			//
			// LTexts
			int j=3, pos;
			pos=21;
			for(int i=0;i<n;i++,pos+=24){
				LTexts[i]= new LabelTextoSingle(35);
				LTexts[i].T.Height=18;
				LTexts[i].TextLocation= new Point(124,pos);
				LTexts[i].TabIndex= j++;
			}
			//
			// Aceptar, Cancelar
			pos+=15;
			Aceptar.Location= new Point(24, pos);
			Cancelar.Location= new Point(120, pos);
			//
			// FormR
			//
			this.ClientSize= new Size(204, pos+44);
			for(int i=0;i<n;i++){
				this.Controls.Add(LTexts[i]);
			}
		}
	#endregion

		protected override void set_data(object obj){
			String[] suni=(String[]) obj;
			for(int i=0;i<n;i++)
				LTexts[i].Text=suni[i];
		}
		protected override void Aceptar_Click(object sender,System.EventArgs e){
			String[] suni=(String[]) ref_to_Data;
			for(int i=0;i<n;i++)
				suni[i]=LTexts[i].Text;
			this.Hide();
		}
	}

	public class TwoStrings{
		public string f,t;
	}
	public class ThreeStrings{
		public string p,f,t;
	}
	public class FormUnidades_ft : ControlesAt.FormUnidades{
		public FormUnidades_ft(IEntorno _Entorno, Control _Where, TwoStrings _c_) : base(2,_Entorno,_Where,_c_){}

		protected override void set_data(object obj){
			TwoStrings suni=(TwoStrings) obj;
			LTexts[0].Text=suni.f;
			LTexts[1].Text=suni.t;
		}
		protected override void Aceptar_Click(object sender,System.EventArgs e){
			TwoStrings suni=(TwoStrings) ref_to_Data;
			suni.f=LTexts[0].Text;
			suni.t=LTexts[1].Text;
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LTexts[0].L.Text=Textos.get_texto(Sistema_imagen,idioma);
			LTexts[1].L.Text=Textos.get_texto(Sistema_terreno,idioma);
		}
	}
	public class FormUnidades_pft : ControlesAt.FormUnidades{
		public FormUnidades_pft(IEntorno _Entorno, Control _Where, ThreeStrings _c_) : base(3,_Entorno,_Where,_c_){}

		protected override void set_data(object obj){
			ThreeStrings suni=(ThreeStrings)obj;
			LTexts[0].Text=suni.p;
			LTexts[1].Text=suni.f;
			LTexts[2].Text=suni.t;
		}
		protected override void Aceptar_Click(object sender,System.EventArgs e){
			ThreeStrings suni=(ThreeStrings) ref_to_Data;
			suni.p=LTexts[0].Text;
			suni.f=LTexts[1].Text;
			suni.t=LTexts[2].Text;
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LTexts[0].L.Text=Textos.get_texto(Sistema_de_medida,idioma);
			LTexts[0].L.Text=Textos.get_texto(Sistema_fiducial,idioma);
			LTexts[2].L.Text=Textos.get_texto(Sistema_terreno,idioma);
		}
	}
}
