using System;
using System.Windows.Forms;
using System.Drawing;
using System.Runtime.InteropServices;
using ControlesAt;
using static Globales.FileTypes;

namespace Aerotri{
using static Textos.Cods;

	public class FormTrCamara : DependentForm{
		private ControlesAt.BaseLabel Label1, Label2;
		private ControlesAt.Labeltf  Tffot1, Tffot2;
		private ControlesAt.BotAceptar Transformar;
		private OpenFileDialog Open1;
		private SaveFileDialog Save1;
		private ControlesAt.TxtBotAbrir TxtBotfot1;
		private ControlesAt.TxtBotAbrir TxtBotfot2;

		PanelAerotri PanelPadre;
		public FormTrCamara(PanelAerotri Form1) : base(Form1){
			PanelPadre=Form1;
			InitializeComponent();
			this.AcceptButton=Transformar;
			Tffot1.Indice=TipoFichero.ImasterCamara;
			Tffot2.Indice=TipoFichero.AerotriCamara;
			colores();
		}

	#region InitializeComponent
		private void InitializeComponent(){
			TxtBotfot1= new TxtBotAbrir();
			TxtBotfot2= new TxtBotAbrir();
			Label1= new BaseLabel();
			Label2= new BaseLabel();
			Tffot1= new Labeltf(Filtros[TipoFiltro.InternaLeer]);
			Tffot2= new Labeltf(Filtros[TipoFiltro.InternaEscribir]);
			Transformar= new BotAceptar();
			Save1= new SaveFileDialog();
			Open1= new OpenFileDialog();
			//
			// Label1, 2
			//
			Label1.RefLocation= new Point(12, 10);		Label1.TabIndex= 2;
			Label2.RefLocation= new Point(240, 10);	Label2.TabIndex= 3;
			Label1.Font= new System.Drawing.Font("Microsoft Sans Serif", 8.25F, FontStyle.Bold);
			Label2.Font= Label1.Font;
			//
			// TxtBotfot1, 2
			//
			TxtBotfot1.Location= new Point(8, 32);			TxtBotfot1.TabIndex= 0;
			TxtBotfot2.Location= new Point(236, 32);		TxtBotfot2.TabIndex= 1;
			TxtBotfot1.Bot.Click+=new EventHandler(TxtBotfot1_Click);
			TxtBotfot2.Bot.Click+=new EventHandler(TxtBotfot2_Click);
			//
			// Tffot1, 2
			//
			Tffot1.Location= new Point(8, 60);		Tffot1.Width=92;		Tffot1.TabIndex= 4;
			Tffot2.Location= new Point(236, 60);	Tffot2.Width=92;		Tffot2.TabIndex= 5;
			//
			// Transformar
			//
			Transformar.Location= new Point(172, 100);
			Transformar.Size= new Size(84, 24);
			Transformar.TabIndex= 6;
			Transformar.Click+= new EventHandler(Transformar_Click);
			//
			// FormTrFotogramas
			//
			this.ClientSize= new Size(430, 143);
			this.Controls.Add(Transformar);
			this.Controls.Add(Tffot1);
			this.Controls.Add(Tffot2);
			this.Controls.Add(TxtBotfot1);
			this.Controls.Add(TxtBotfot2);
			this.Controls.Add(Label1);
			this.Controls.Add(Label2);
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.MaximizeBox= false;
		}
		#endregion

		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

	#region Abrir
		private void TxtBotfot1_Click(object sender,EventArgs e){
			PanelPadre.ahora_no_se_puede_cerrar++;
			Methods.BotAbrir_Click(TxtBotfot1,Tffot1,Open1, ref PanelPadre.ConfigPrograma.OpenPath,buildfiltro(TipoFiltro.InternaLeer,idioma));
			PanelPadre.ahora_no_se_puede_cerrar--;
		}
		private void TxtBotfot2_Click(object sender,EventArgs e){
			PanelPadre.ahora_no_se_puede_cerrar++;
			Methods.BotAbrir_Click(TxtBotfot2,Tffot2,Save1, ref PanelPadre.ConfigPrograma.OpenPath,buildfiltro(TipoFiltro.InternaEscribir,idioma));
			PanelPadre.ahora_no_se_puede_cerrar--;
		}
	#endregion

		private void Transformar_Click(object sender,System.EventArgs e){
			int returned;
			System.IntPtr P_fotos1, P_fotos2;
			string mensaje;
			System.IntPtr P_mensaje;

			if(TxtBotfot1.Text1.Text=="" || TxtBotfot1.Text1.Text==""){
				PanelPadre.MessageBoxAT.Show(get_texto(Debe_indicar_ambos_ficheros)); return;
			}
			if(!Methods.CheckExtension(PanelPadre.MessageBoxAT,TxtBotfot1.Text,Tffot1.Indice,TipoFiltro.InternaLeer,idioma)) return;
			if(!Methods.CheckExtension(PanelPadre.MessageBoxAT,TxtBotfot2.Text,Tffot2.Indice,TipoFiltro.InternaEscribir,idioma)) return;
			PanelPadre.ahora_no_se_puede_cerrar=1;

			P_mensaje=Marshal.AllocHGlobal(1024);
			P_fotos1=Marshal.StringToHGlobalUni(TxtBotfot1.Text1.Text);
			P_fotos2=Marshal.StringToHGlobalUni(TxtBotfot2.Text1.Text);

			try{
				returned=InterComAerotri.Trficheros_camara(P_fotos1,FileTypeInfos[Tffot1.Indice].aerotri, P_fotos2,FileTypeInfos[Tffot2.Indice].aerotri, P_mensaje,(byte)idioma);
			}catch(System.DllNotFoundException){
				returned=-2;
			}
			PanelPadre.set_message(PanelPadre.mensaje_pordefecto);
			if(returned!=-1){
				if(returned==-2) mensaje=get_texto(No_se_ha_podido_abrir_el_fichero_transfficheros);
				else if(returned==0) mensaje=get_texto(Tarea_terminada);
				else mensaje=Marshal.PtrToStringUni(P_mensaje);
				PanelPadre.MessageBoxAT.Show(mensaje);
			}

			Marshal.FreeHGlobal(P_fotos1);
			Marshal.FreeHGlobal(P_fotos2);
			Marshal.FreeHGlobal(P_mensaje);
			PanelPadre.ahora_no_se_puede_cerrar=0;
		}

		void colores(){
			this.BackColor= Globales.Colores.NETColor(Globales.Colores.cForm);
			Transformar.BackColor= Globales.Colores.NETColor(Globales.Colores.cBoton);
		}

		protected override void update_idioma(){
			this.Text=get_texto(Transformacin_de_ficheros_de_camara);
			Label1.Text=get_texto(Fichero_de_origen);
			Label2.Text=get_texto(Fichero_a_generar);
			Transformar.Text=get_texto(Textos.Cods.Transformar);
			Tffot1.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.InternaLeer,idioma));
			Tffot2.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.InternaEscribir,idioma));
			Tffot1.actualiza();
			Tffot2.actualiza();
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
