﻿using System;
using System.Windows.Forms;
using System.Drawing;
using System.Runtime.InteropServices;
using ControlesAt;
using static Globales.FileTypes;

namespace Aerotri{
using static Textos.Cods;

	public class FormTrGpsIns : DependentForm{
		private ControlesAt.BaseLabel Label1, Label2;
		private ControlesAt.TxtBotAbrir TxtBotfot1;
		private ControlesAt.TxtBotAbrir TxtBotfot2;
		private ControlesAt.Labeltf  Tffot1,	Tffot2;
		private ControlesAt.BotAceptar Transformar;
		private OpenFileDialog Open1;
		private SaveFileDialog Save1;
		private GroupBox GBoxOpcionesFormato;
		private Panel PanelAerotri, Panelori, PanelIMaster;
		private RadioButton OptSinMarcar, OptMarcadoprm, OptMarcadopym;
		private RadioButton Optori0, Optori1;
		private ControlesAt.BaseLabel labelPares;
		private RadioButton OptPairsOne, OptPairsBoth;

		PanelAerotri PanelPadre;
		public FormTrGpsIns(PanelAerotri Form1) : base(Form1){
			PanelPadre=Form1;
			InitializeComponent();
			this.AcceptButton=Transformar;
			Tffot1.Indice=TipoFichero.PATBori;
			Tffot2.Indice=TipoFichero.ΩΦΚ;
			Tffot2_IndexChanged();
			colores();
		}

	#region InitializeComponent
		private void InitializeComponent(){
			Label1=new BaseLabel();
			Label2=new BaseLabel();
			TxtBotfot1=new TxtBotAbrir();
			TxtBotfot2=new TxtBotAbrir();
			Tffot1= new Labeltf(Filtros[TipoFiltro.GPSTodosLeer]);
			Tffot2= new Labeltf(Filtros[TipoFiltro.GPSTodosEscribir]);
			GBoxOpcionesFormato=new GroupBox();
			PanelAerotri=new Panel();
			OptSinMarcar=new RadioButton();
			OptMarcadoprm=new RadioButton();
			OptMarcadopym=new RadioButton();
			Panelori=new Panel();
			Optori0=new RadioButton();
			Optori1=new RadioButton();
			PanelIMaster=new Panel();
			labelPares=new BaseLabel();
			OptPairsOne=new RadioButton();
			OptPairsBoth=new RadioButton();
			Save1=new SaveFileDialog();
			Open1=new OpenFileDialog();
			Transformar=new BotAceptar();
			//
			// Label1
			//
			Label1.RefLocation= new Point(12, 10);		Label1.TabIndex= 2;
			Label2.RefLocation= new Point(248, 10);		Label2.TabIndex= 3;
			Label1.Font= new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			Label2.Font= Label1.Font;
			//
			// TxtBotfot1, 2
			//
			TxtBotfot1.Location= new Point(8, 32);			TxtBotfot1.TabIndex= 0;
			TxtBotfot2.Location= new Point(244, 32);		TxtBotfot2.TabIndex= 1;
			TxtBotfot1.Bot.Click+=new EventHandler(TxtBotfot1_Click);
			TxtBotfot2.Bot.Click+=new EventHandler(TxtBotfot2_Click);
			//
			// Tffot1, 2
			//
			Tffot1.Location= new Point(8, 60);		Tffot1.Width=144;		Tffot1.TabIndex= 4;
			Tffot2.Location= new Point(244, 60);	Tffot2.Width=144;	Tffot2.TabIndex= 5;
			Tffot2.IndexChanged+=new EventVoid(Tffot2_IndexChanged);
			//
			// PanelAerotri
			//
			PanelAerotri.Size=new Size(140,68);
			PanelAerotri.Controls.Add(OptSinMarcar);
			PanelAerotri.Controls.Add(OptMarcadoprm);
			PanelAerotri.Controls.Add(OptMarcadopym);
			//
			OptSinMarcar.Location= new Point(11,4);		OptSinMarcar.Size= new Size(120,18);		OptSinMarcar.TabIndex=0;
			OptMarcadoprm.Location= new Point(11,24);	OptMarcadoprm.Size= new Size(120,18);		OptMarcadoprm.TabIndex=1;
			OptMarcadopym.Location= new Point(11,44);	OptMarcadopym.Size= new Size(120,18);		OptMarcadopym.TabIndex=2;
			OptMarcadoprm.Checked= true;
			//
			// Panelori
			//
			Panelori.Size=new Size(140,48);
			Panelori.Controls.Add(Optori0);
			Panelori.Controls.Add(Optori1);
			//
			Optori0.Location= new Point(11,4);		Optori0.Size= new Size(120,18);	Optori0.TabIndex=0;
			Optori1.Location= new Point(11,24);		Optori1.Size= new Size(120,18);	Optori1.TabIndex=1;
			Optori0.Checked= true;
			//
			// PanelIMaster
			//
			PanelIMaster.Size=new Size(160,68);
			PanelIMaster.Controls.Add(labelPares);
			PanelIMaster.Controls.Add(OptPairsOne);
			PanelIMaster.Controls.Add(OptPairsBoth);
			//
			labelPares.RefLocation= new Point(11,5);		labelPares.TabIndex=0;
			OptPairsOne.Location= new Point(11,24);		OptPairsOne.Size= new Size(120,18);		OptPairsOne.TabIndex=1;
			OptPairsBoth.Location= new Point(11,44);		OptPairsBoth.Size= new Size(140,18);	OptPairsBoth.TabIndex=2;
			OptPairsOne.Checked= true;
			//
			// GBoxOpcionesFormato
			//
			PanelIMaster.Location=Panelori.Location=PanelAerotri.Location=new Point(2,16);
			PanelAerotri.Visible=false;
			Panelori.Visible=false;
			PanelIMaster.Visible=false;
			//
			GBoxOpcionesFormato.Location= new Point(244,88);
			GBoxOpcionesFormato.TabIndex=10;
			GBoxOpcionesFormato.Controls.Add(PanelAerotri);
			GBoxOpcionesFormato.Controls.Add(Panelori);
			GBoxOpcionesFormato.Controls.Add(PanelIMaster);
			//
			// Transformar
			//
			Transformar.Location= new Point(80, 144);
			Transformar.Size= new Size(84, 24);
			Transformar.TabIndex= 11;
			Transformar.Click+= new EventHandler(Transformar_Click);
			//
			// FormTrGpsIns
			//
			this.ClientSize= new Size(436, 192);
			this.Controls.Add(Transformar);
			this.Controls.Add(Tffot1);
			this.Controls.Add(Tffot2);
			this.Controls.Add(TxtBotfot1);
			this.Controls.Add(TxtBotfot2);
			this.Controls.Add(Label1);
			this.Controls.Add(Label2);
			this.Controls.Add(GBoxOpcionesFormato);
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.MaximizeBox= false;
		}
	#endregion

		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

	#region Abrir
		private void TxtBotfot1_Click(object sender,EventArgs e){
			PanelPadre.ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotfot1,Tffot1,Open1, ref PanelPadre.ConfigPrograma.OpenPath,
				buildfiltro(TipoFiltro.GPSTodosLeer,idioma));
			PanelPadre.ahora_no_se_puede_cerrar=0;
		}
		private void TxtBotfot2_Click(object sender,EventArgs e){
			PanelPadre.ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotfot2,Tffot2,Save1, ref PanelPadre.ConfigPrograma.OpenPath,
				buildfiltro(TipoFiltro.GPSTodosEscribir,idioma));
			PanelPadre.ahora_no_se_puede_cerrar=0;
			Tffot2_IndexChanged();
		}
	#endregion

		private void Tffot2_IndexChanged(){
			Panel p;
			PanelAerotri.Visible=false;
			Panelori.Visible=false;
			PanelIMaster.Visible=false;
			p=null;
			if(Tffot2.Indice==TipoFichero.Aerotriccpp) p=PanelAerotri;
			else if(Tffot2.Indice==TipoFichero.PATBori) p=Panelori;
			else if(Tffot2.Indice==TipoFichero.IMasterpairlist) p=PanelIMaster;
			if(p==null) GBoxOpcionesFormato.Visible=false;
			else{
				GBoxOpcionesFormato.Visible=true;
				GBoxOpcionesFormato.Size= p.Size+new Size(4,18);
				p.Visible=true;
			}
		}

		private void Transformar_Click(object sender,System.EventArgs e){
			int returned;
			System.IntPtr P_fotos1, P_fotos2;
			string mensaje;
			System.IntPtr P_mensaje;
			InterComAerotri.OpcionesFormato opcs;

			if(TxtBotfot1.Text1.Text=="" || TxtBotfot1.Text1.Text==""){
				PanelPadre.MessageBoxAT.Show(get_texto(Debe_indicar_ambos_ficheros)); return;
			}

			if(!Methods.CheckExtension(PanelPadre.MessageBoxAT,TxtBotfot1.Text,Tffot1.Indice,TipoFiltro.GPSTodosLeer,idioma)) return;
			if(!Methods.CheckExtension(PanelPadre.MessageBoxAT,TxtBotfot2.Text,Tffot2.Indice,TipoFiltro.GPSTodosEscribir,idioma)) return;

			if(Tffot2.Indice==TipoFichero.Aerotriccpp){
				if(OptSinMarcar.Checked) opcs.var_formato=0;
				else if(OptMarcadoprm.Checked) opcs.var_formato=1;
				else opcs.var_formato=2;
			}else if(Tffot2.Indice==TipoFichero.PATBori){
				if(Optori0.Checked) opcs.var_formato=0;
				else opcs.var_formato=1;
			}else if(Tffot2.Indice==TipoFichero.IMasterpairlist){
				if(OptPairsOne.Checked) opcs.var_formato=0;
				else opcs.var_formato=1;
			}else{
				opcs.var_formato=0;	//Estúpido
			}

			PanelPadre.ahora_no_se_puede_cerrar=1;
			P_mensaje=Marshal.AllocHGlobal(512);
			P_fotos1=Marshal.StringToHGlobalUni(TxtBotfot1.Text1.Text);
			P_fotos2=Marshal.StringToHGlobalUni(TxtBotfot2.Text1.Text);

			try{
				returned=InterComAerotri.Trficheros_ccpp(P_fotos1,FileTypeInfos[Tffot1.Indice].aerotri, 0, P_fotos2,FileTypeInfos[Tffot2.Indice].aerotri, opcs, P_mensaje,(byte)idioma);
			}catch(System.DllNotFoundException){
				returned=-2;
			}
			PanelPadre.set_message(PanelPadre.mensaje_pordefecto);
			if(returned!=-1){
				if(returned==-2) mensaje=get_texto(No_se_ha_podido_abrir_el_fichero_transfficheros);
				else if(returned==0) mensaje=get_texto(Tarea_terminada);
				else mensaje=Marshal.PtrToStringUni(P_mensaje);
				PanelPadre.MessageBoxAT.Show(mensaje);
			}

			Marshal.FreeHGlobal(P_fotos1);
			Marshal.FreeHGlobal(P_fotos2);
			Marshal.FreeHGlobal(P_mensaje);
			PanelPadre.ahora_no_se_puede_cerrar=0;
		}

		void colores(){
			this.BackColor= Globales.Colores.NETColor(Globales.Colores.cForm);
			Transformar.BackColor= Globales.Colores.NETColor(Globales.Colores.cBoton);
		}

		protected override void update_idioma(){
			this.Text=get_texto(Transformación_de_ficheros_de_ccpp);
			Label1.Text=get_texto(Fichero_de_origen);
			Label2.Text=get_texto(Fichero_a_generar);
			Transformar.Text=get_texto(Textos.Cods.Transformar);
			GBoxOpcionesFormato.Text=get_texto(Opciones_del_formato);
			OptSinMarcar.Text=get_texto(Sin_marcar);
			OptMarcadoprm.Text=get_texto(Marcado_prm);
			OptMarcadopym.Text=get_texto(Marcado_pym);
			Optori0.Text=get_texto(Tipo0);
			Optori1.Text=get_texto(Tipo1);
			labelPares.Text=get_texto(Pares_a_generar);
			OptPairsOne.Text=get_texto(Pairs_one);
			OptPairsBoth.Text=get_texto(Pairs_both);
			Tffot1.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.GPSTodosLeer,idioma));
			Tffot2.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.GPSTodosEscribir,idioma));
			Tffot1.actualiza();
			Tffot2.actualiza();
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
