using System;
using System.Drawing;
using System.Windows.Forms;

namespace ControlesAt
{
	public class PanelControl : System.Windows.Forms.ContainerControl{
		protected System.Windows.Forms.ContainerControl Panelright;
		protected ControlesAt.PanelMoving Panelall;
		public System.Windows.Forms.Button BotCerrar, BotMin;

		public new string Text{
			get{return Panelall.Text;}
			set{Panelall.Text=value;}
		}
		public PanelControl(){
			Panelright= new ContainerControl();
			Panelall= new PanelMoving();
			BotCerrar= new Button();
			BotMin= new Button();

			Panelall.Dock= DockStyle.Fill;
			//Panelall.TextAlign= ContentAlignment.MiddleCenter;
			Panelall.Font= new Font("Verdana",8.25F,FontStyle.Bold);
			Panelall.ForeColor= Color.FromArgb(0xFF,0xFF,0xE0);

			Panelright.Dock= DockStyle.Right;
			Panelright.Width=30;
			Panelright.Controls.Add(BotCerrar);
			Panelright.Controls.Add(BotMin);
			Panelright.ControlAdded+=new ControlEventHandler(Panelright_Resize);
			Panelright.ControlRemoved+=new ControlEventHandler(Panelright_Resize);

			BotCerrar.FlatStyle= FlatStyle.System;
			BotCerrar.Location= new Point(16,2);
			BotCerrar.Size= new Size(13,11);
			BotCerrar.Font= new Font("Marlett",5F);
			BotCerrar.Text= "\u0072";
			//BotCerrar.TextAlign= ContentAlignment.MiddleCenter;	//Los textos como siempre en el malido .NET.

			BotMin.FlatStyle= FlatStyle.System;
			BotMin.Location= new Point(1,2);
			BotMin.Size= new Size(13,11);
			BotMin.Font= new Font("Marlett",8.5F);
			BotMin.Text= "\u0075";
			//BotMin.TextAlign= ContentAlignment.BottomCenter;	//Tan mal hecho est que ni siquiera es posible crear botones con texto iguales que los de Windows

			this.Controls.Add(Panelall);
			this.Controls.Add(Panelright);
		}

		protected override Size DefaultSize{
			get{return new Size(120,14);}
		}

		private void Panelright_Resize(object sender,ControlEventArgs e){
			int pos=1;
			if(BotMin.Parent==Panelright) pos+=15;
			if(BotCerrar.Parent==Panelright){
				BotCerrar.Left=pos;
				pos+=15;
			}
			Panelright.Width=pos-1;
		}
	}
	public class FormTools : ControlesAt.FormBorde{
		protected ControlesAt.PanelControl PanelTop;
		protected System.Windows.Forms.ContainerControl PanelFill;
		private ControlesAt.NoControl Thinline;
		public int normalHeight;
		private static int smallHeight=-1;
		private Size normalminSize;
		private ControlesAt.BorderMode normalBorde;

		protected Control wheretoAdd;
		public new System.Windows.Forms.Control.ControlCollection Controls{
			get{
				if(wheretoAdd==null || wheretoAdd==this) return base.Controls;
				else return wheretoAdd.Controls;
		}	}

		public new Size ClientSize{
			get{return base.ClientSize-new Size(0,16);}
			set{base.ClientSize=value + new Size(0,16);}
		}
		public new string Text{
			get{return PanelTop.Text;}
			set{PanelTop.Text=value;}
		}
		public new bool Enabled{
			get{return PanelFill.Enabled;}
			set{PanelFill.Enabled=value;}
		}

		public FormTools(){
			wheretoAdd=PanelTotal;
			InitializeComponent();
			wheretoAdd=PanelFill;
			this.BackColor= Globales.Colores.NETColor(Globales.Colores.cForm);
			PanelTop.BackColor= Color.FromArgb(0x80,0x80,0xA0);
			Thinline.BackColor=System.Drawing.SystemColors.Control;
		}
	#region InitializeComponent
		private void InitializeComponent()
		{
			PanelTop= new PanelControl();
			Thinline= new NoControl();
			PanelFill= new ContainerControl();
			//
			PanelTop.Dock= DockStyle.Top;
			PanelTop.Height=15;
			Thinline.Dock= DockStyle.Top;
			Thinline.Height=1;
			PanelFill.Dock= DockStyle.Fill;
			//
			this.BorderMode=BorderMode.PanelFixed;
			this.MinimumSize= new Size(38,23);
			this.Controls.Add(PanelFill);
			this.Controls.Add(Thinline);
			this.Controls.Add(PanelTop);
			this.ShowInTaskbar= false;
			this.PanelTop.BotCerrar.Click+=new EventHandler(BotCerrar_Click);
			this.PanelTop.BotMin.Click+=new EventHandler(BotMin_Click);
		}
		#endregion

		protected void BotCerrar_Click(object sender,EventArgs e){
			this.Close();
		}
		public void BotMin_Click(object sender,EventArgs e){
			if(this.ClientSize.Height==smallHeight){
				this.BorderMode= normalBorde;
				this.ClientSize= new Size(this.ClientSize.Width,normalHeight);
				this.MinimumSize=normalminSize;
			}else{
				normalHeight=this.ClientSize.Height;
				normalBorde=this.BorderMode;
				normalminSize= this.MinimumSize;
				this.MinimumSize=new Size(38,23);
				this.ClientSize= new Size(this.ClientSize.Width,smallHeight);
				this.BorderMode=BorderMode.PanelFixed;
			}
		}
	}
}