using System;
using System.Drawing;
using System.Windows.Forms;
using static Globales.Textos;

namespace ControlesAt{
	public class FormSiNo : FormAerotri{
		private System.Windows.Forms.Label label1;
		private ControlesAt.BotAceptar Si;
		private ControlesAt.BotAceptar No;
		private ControlesAt.BotAceptar Noatodos;
		private ControlesAt.BotAceptar Siatodos;
		private ControlesAt.BotAceptar Cancelar;
		public string Message{
			get{return label1.Text;}
			set{label1.Text=value;}
		}

		public FormSiNo(string s,Globales.Idioma _idioma){
			InitializeComponent();
			label1.Text=s;

			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			this.Si.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			this.Siatodos.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			this.No.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			this.Noatodos.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			this.Cancelar.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);

			this.AcceptButton=Si;
			this.CancelButton=Cancelar;

			idioma=Globales.Idioma.NIDIOMAS;
			set_idioma(_idioma);
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			Si= new BotAceptar();
			No= new BotAceptar();
			Siatodos= new BotAceptar();
			Noatodos= new BotAceptar();
			Cancelar= new BotAceptar();
			label1= new Label();
			//
			// Si
			//
			Si.Location= new Point(40, 60);
			Si.Size= new Size(65,20);
			Si.TabIndex= 0;
			Si.Click+= new EventHandler(Si_Click);
			//
			// No
			//
			No.Location= new Point(184, 60);
			No.Size= new Size(65, 20);
			No.TabIndex= 1;
			No.Click+= new EventHandler(No_Click);
			//
			// Siatodos
			//
			Siatodos.Location= new Point(40, 88);
			Siatodos.Size= new Size(65, 20);
			Siatodos.TabIndex= 2;
			Siatodos.Click+= new EventHandler(Siatodos_Click);
			//
			// Noatodos
			//
			Noatodos.Location= new Point(184, 88);
			Noatodos.Size= new Size(65, 20);
			Noatodos.TabIndex= 3;
			Noatodos.Click+= new EventHandler(Noatodos_Click);
			//
			// Cancelar
			//
			Cancelar.Location= new Point(112, 116);
			Cancelar.Size= new Size(65, 20);
			Cancelar.TabIndex= 4;
			Cancelar.Click+= new EventHandler(Cancelar_Click);
			//
			// label1
			//
			label1.FlatStyle= System.Windows.Forms.FlatStyle.System;
			label1.Location= new Point(8, 8);
			label1.Size= new Size(276, 44);
			label1.TabIndex= 5;
			label1.TextAlign= ContentAlignment.TopCenter;
			//
			// FormSiNo
			//
			this.BackColor= System.Drawing.SystemColors.Control;
			this.ClientSize= new Size(290, 143);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.Cancelar);
			this.Controls.Add(this.Noatodos);
			this.Controls.Add(this.Siatodos);
			this.Controls.Add(this.No);
			this.Controls.Add(this.Si);
			this.FormBorderStyle= FormBorderStyle.FixedDialog;
			this.MaximizeBox= false;
			this.MinimizeBox= false;
			this.ShowInTaskbar= false;
			this.Text= "Aerotri";
		}
	#endregion

		private void Si_Click(object sender,System.EventArgs e){		    this.DialogResult=(DialogResult)1;}
		private void Siatodos_Click(object sender,System.EventArgs e){	    this.DialogResult=(DialogResult)2;}
		private void No_Click(object sender,System.EventArgs e){		    this.DialogResult=(DialogResult)3;}
		private void Noatodos_Click(object sender,System.EventArgs e){ this.DialogResult=(DialogResult)4;}
		private void Cancelar_Click(object sender,System.EventArgs e){   this.DialogResult=(DialogResult)5;}

		protected override void update_idioma(){
			Si.Text=get_texto(Cods.S,idioma);
			Siatodos.Text=get_texto(Cods.Satodos,idioma);
			No.Text=get_texto(Cods.No,idioma);
			Noatodos.Text=get_texto(Cods.Noatodos,idioma);
			Cancelar.Text=get_texto(Cods.Cancelar,idioma);
			switch(idioma){
			  case Globales.Idioma.It:
				Noatodos.TextAlign=ContentAlignment.MiddleRight;
				break;
			  default:
				Noatodos.TextAlign=ContentAlignment.MiddleCenter;
				break;
			}
		}
	}
}
