using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
using static Textos.Cods;

	public class FormSalidastd : ControlesAt.FormOpcionesAlgo{
		private Label Label2,
						Label3,
						Label4;
		private ControlesAt.ChkSalida ChkR0,	ChkR1,
											 ChkR2,	ChkR3,
											 ChkR4,	ChkR5;
		private ControlesAt.ChkSalida ChkP0,	ChkP1,
											 ChkP2,	ChkP3,
											 ChkP4,	ChkP5,
											 ChkP6;

		internal const short nR=6, nP=7;
		private ControlesAt.ChkSalida[] ChkR, ChkP;

		public FormSalidastd(IEntorno _Entorno,Control _Where, InterComAerotri.CConfigSalida _c_) : base(_Entorno,_Where,_c_){}

	#region InitializeComponent
		protected override void InitializeComponent()
		{
			Label2= new Label();
			Label3= new Label();
			Label4= new Label();
			ChkR0= new ChkSalida();
			ChkR1= new ChkSalida();
			ChkR2= new ChkSalida();
			ChkR3= new ChkSalida();
			ChkR4= new ChkSalida();
			ChkR5= new ChkSalida();
			ChkP0= new ChkSalida();
			ChkP1= new ChkSalida();
			ChkP2= new ChkSalida();
			ChkP3= new ChkSalida();
			ChkP4= new ChkSalida();
			ChkP5= new ChkSalida();
			ChkP6= new ChkSalida();
			ChkR=new ChkSalida[nR];
			ChkP=new ChkSalida[nP];
			ChkR[0]=ChkR0;	ChkR[1]=ChkR1;
			ChkR[2]=ChkR2;	ChkR[3]=ChkR3;
			ChkR[4]=ChkR4;	ChkR[5]=ChkR5;

			ChkP[0]=ChkP0;	ChkP[1]=ChkP1;
			ChkP[2]=ChkP2;	ChkP[3]=ChkP3;
			ChkP[4]=ChkP4;	ChkP[5]=ChkP5;
			ChkP[6]=ChkP6;

			int pos, j;
			//
			// Location&size
			//
			pos=12;
			j=2;
			ChkR0.Location= new Point(5, pos);		ChkR0.TabIndex= j++;		pos+=20;
			Label2.Location= new Point(7, pos);		Label2.Size= new Size(145, 17);			Label2.TabIndex= j++;
			pos+=18;
			ChkR1.Location= new Point(5, pos);		ChkR1.TabIndex= j++;		pos+=16;
			ChkR3.Location= new Point(5, pos);		ChkR2.TabIndex= j++;		pos+=16;
			ChkR2.Location= new Point(5, pos);		ChkR3.TabIndex= j++;		pos+=16;
			ChkR4.Location= new Point(5, pos);		ChkR4.TabIndex= j++;		pos+=16;
			ChkR5.Location= new Point(5, pos);		ChkR5.TabIndex= j++;		pos+=24;

			pos=38;
			Label3.Location= new Point(7, pos);		Label3.Size= new Size(116, 17);			Label3.TabIndex= j++;
			pos+=18;
			ChkP0.Location= new Point(5, pos);		ChkP0.TabIndex= j++;		pos+=16;
			ChkP1.Location= new Point(5, pos);		ChkP1.TabIndex= j++;		pos+=16;
			ChkP2.Location= new Point(5, pos);		ChkP2.TabIndex= j++;		pos+=24;

			Label4.Location= new Point(7, pos);		Label4.Size= new Size(205, 17);			Label4.TabIndex= j++;
			pos+=18;
			ChkP3.Location= new Point(5, pos);		ChkP3.TabIndex= j++;		pos+=16;
			ChkP4.Location= new Point(5, pos);		ChkP4.TabIndex= j++;		pos+=16;
			ChkP5.Location= new Point(5, pos);		ChkP5.TabIndex= j++;		pos+=16;
			ChkP6.Location= new Point(5, pos);		ChkP6.TabIndex= j++;		pos+=16;

			Label2.Visible= false;
			ChkR1.Visible= false;
			ChkR2.Visible= false;
			ChkR3.Visible= false;
			ChkR4.Visible= false;
			ChkR5.Visible= false;
			//
			// Aceptar
			pos+=18;
			Aceptar.Location= new Point(28, pos);
			Cancelar.Location= new Point(136, pos);
			//
			// FormSalidastd
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(224, pos+44);
			this.Controls.Add(Label4);
			this.Controls.Add(Label3);
			this.Controls.Add(Label2);
			this.Controls.AddRange(new Control[]{
				ChkP6,	ChkP5,
				ChkP4,	ChkP3,
				ChkP2,	ChkP1,
				ChkP0
			});
			this.Controls.AddRange(new Control[]{
				ChkR5,	ChkR4,
				ChkR3,	ChkR2,
				ChkR1,	ChkR0
			});
		}
	#endregion

		protected override void set_data(object obj){
			short i;
			ushort t;
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)obj;

			t=CSalida.S.SalidaStd.ResRed;
			for(i=0;i<nR;i++,t>>=1){
				ChkR[i].Checked= (t&(ushort)1)!=0;
			}
			t=CSalida.S.SalidaStd.Precisiones;
			for(i=0;i<nP;i++,t>>=1){
				ChkP[i].Checked= (t&(ushort)1)!=0;
			}
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			short i;
			ushort t;
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)ref_to_Data;

			CSalida.S.SalidaStd.ResRed=0;
			CSalida.S.SalidaStd.Precisiones=0;

			for(i=0,t=1;i<nR;i++,t<<=1){
				if(ChkR[i].Checked) CSalida.S.SalidaStd.ResRed|=t;
			}
			for(i=0,t=1;i<nP;i++,t<<=1){
				if(ChkP[i].Checked) CSalida.S.SalidaStd.Precisiones|=t;
			}
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			ChkR[0].Text=get_texto(Estadsticas_de_los_residuos);
			Label2.Text=get_texto(Redundancias_parciales);
			ChkR[1].Text=get_texto(Por_grupos);
			ChkR[2].Text=get_texto(Por_grupos_a_posteriori);
			ChkR[3].Text=get_texto(Fotocoordenadas);
			ChkR[4].Text=get_texto(Puntos_de_apoyo);
			ChkR[5].Text=get_texto(GPS_INS);

			Label3.Text=get_texto(Precisiones);
			ChkP[0].Text=get_texto(Centros_de_proyeccin);
			ChkP[1].Text=get_texto(Puntos_de_apoyo);
			ChkP[2].Text=get_texto(Parmetros_GPS);

			Label4.Text=get_texto(Covarianzas_Correlaciones);
			ChkP[3].Text=get_texto(Cv_ccpp);
			ChkP[4].Text=get_texto(Crr_ccpp);
			ChkP[5].Text=get_texto(Cv_apoyo);
			ChkP[6].Text=get_texto(Crr_apoyo);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
