using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
	public class FormSalidapdf : ControlesAt.FormOpcionesAlgo	{
		private Label LabelIdioma;
		private RadioButton Opt255;
		private Label Label2;
		private RadioButton Opt0, Opt1, Opt2, Opt3;

		const short nidiomas=4;
		RadioButton[] OptIdom;

		public FormSalidapdf(IEntorno _Entorno, Control _Where, object _c_) : base(_Entorno,_Where,_c_){}

	#region InitializeComponent
		protected override void InitializeComponent()
		{
			LabelIdioma= new Label();
			Opt255= new RadioButton();
			Label2= new Label();
			Opt0= new RadioButton();
			Opt1= new RadioButton();
			Opt2= new RadioButton();
			Opt3= new RadioButton();
			OptIdom=new RadioButton[nidiomas];
			OptIdom[0]=Opt0;
			OptIdom[1]=Opt1;
			OptIdom[2]=Opt2;
			OptIdom[3]=Opt3;
			//
			// Opt0, 1, ...
			Opt0.Text= "Espaol";
			Opt1.Text= "English";
			Opt2.Text= "Italiano";
			Opt3.Text= "Portugues (bra)";
			//
			// Location, Size&TabIndex
			//
			LabelIdioma.Location= new Point(7, 10);	LabelIdioma.Size=new Size(120, 17);LabelIdioma.TabIndex=2;
			Opt255.Location= new Point(16, 30);		Opt255.Size= new Size(200, 18);		Opt255.TabIndex=3;
			Label2.Location= new Point(14, 50);			Label2.Size=new Size(120, 17);		Label2.TabIndex=4;
			Opt0.Location= new Point(16, 70);			Opt0.Size= new Size(160, 18);			Opt0.TabIndex=5;
			Opt1.Location= new Point(16, 88);			Opt1.Size= new Size(160, 18);			Opt0.TabIndex=6;
			Opt2.Location= new Point(16, 106);			Opt2.Size= new Size(160, 18);			Opt0.TabIndex=7;
			Opt3.Location= new Point(16, 124);			Opt3.Size= new Size(160, 18);			Opt0.TabIndex=8;
			//
			// Aceptar
			Aceptar.Location= new Point(28, 160);
			Cancelar.Location= new Point(136, 160);
			//
			// FormSalidapdf
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(224, 204);
			this.Controls.Add(Opt3);
			this.Controls.Add(Opt2);
			this.Controls.Add(Opt1);
			this.Controls.Add(Opt0);
			this.Controls.Add(Label2);
			this.Controls.Add(Opt255);
			this.Controls.Add(LabelIdioma);
		}
	#endregion

		short i;
		protected override void set_data(object obj){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)obj;
			for(i=0;i<nidiomas;i++) OptIdom[i].Checked=false;
			if(CSalida.S.General.idioma!=255) OptIdom[CSalida.S.General.idioma].Checked=true;
			else Opt255.Checked=true;
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)ref_to_Data;
			for(i=0;i<nidiomas;i++){
				if(OptIdom[i].Checked) break;
			}
			if(i!=nidiomas) CSalida.S.General.idioma=(byte)i;
			else CSalida.S.General.idioma=255;
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			LabelIdioma.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Idioma,idioma);
			Opt255.Text=get_texto(Textos.Cods.Igual_que_el_idioma_del_programa);
			Label2.Text=get_texto(Textos.Cods.Otro);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
