using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
using static Textos.Cods;

	public class FormSalidalog : ControlesAt.FormOpcionesAlgo	{
		internal CheckBox Chkajuste;
		internal CheckBox Chkpdfs;
		private Label	Lblminimo,	Lblfiles,
										Lblproceso,	Lblotros;
		internal CheckBox Chkminimo;
		internal ControlesAt.IntegerTextBox	Txtfiles,
													Txtproceso,
													Txtotros;
		private bool chkaj, chkpdf;
		private byte log_files, log_proceso, log_otros;

		public FormSalidalog(ControlesAt.IEntorno _Entorno,Control _Where) : base(_Entorno,_Where,null){}

	#region InitializeComponent
		protected override void InitializeComponent()
		{
			Chkajuste= new CheckBox();
			Chkpdfs= new CheckBox();
			Lblminimo= new Label();	Chkminimo= new CheckBox();
			Lblfiles= new Label();		Txtfiles= new IntegerTextBox();
			Lblproceso= new Label();	Txtproceso= new IntegerTextBox();
			Lblotros= new Label();		Txtotros= new IntegerTextBox();
			//
			//Txts, ...
			//
			Lblminimo.FlatStyle=FlatStyle.System;
			Lblfiles.FlatStyle=FlatStyle.System;
			Lblproceso.FlatStyle=FlatStyle.System;
			Lblotros.FlatStyle=FlatStyle.System;
			Chkminimo.Checked=true;
			Chkminimo.Enabled=false;
			Txtfiles.BorderStyle= BorderStyle.None;
			Txtproceso.BorderStyle= BorderStyle.None;
			Txtotros.BorderStyle= BorderStyle.None;

			int pos;
			//
			// Location&size
			//
			pos=12;
			Chkajuste.Location= new Point(12, pos);	Chkajuste.Size=new Size(180,17);		Chkajuste.TabIndex= 2;	pos+=20;
			Chkajuste.TextAlign= ContentAlignment.BottomLeft;
			Lblminimo.Location= new Point(24,pos);	Lblminimo.Size=new Size(120, 17);	Lblminimo.TabIndex= 3;
			Chkminimo.Location= new Point(180,pos);	Chkminimo.Size= new Size(17,16);	Chkminimo.TabIndex= 4;	pos+=16;
			Lblfiles.Location= new Point(24,pos);		Lblfiles.Size=new Size(152,17);		Lblfiles.TabIndex= 5;
			Txtfiles.Location= new Point(178,pos);		Txtfiles.Size=new Size(17,15);			Txtfiles.TabIndex= 6;		pos+=16;
			Lblproceso.Location= new Point(24,pos);	Lblproceso.Size=new Size(80,17);		Lblproceso.TabIndex= 7;
			Txtproceso.Location= new Point(178,pos);	Txtproceso.Size=new Size(17,15);	Txtproceso.TabIndex= 8;	pos+=16;
			Lblotros.Location= new Point(24,pos);		Lblotros.Size=new Size(80,17);		Lblotros.TabIndex= 9;
			Txtotros.Location= new Point(178,pos);		Txtotros.Size=new Size(17,15);		Txtotros.TabIndex= 10;	pos+=26;
			Chkpdfs.Location= new Point(12, pos);		Chkpdfs.Width=192;					Chkpdfs.TabIndex= 11;	pos+=16;
			//
			// Aceptar
			pos+=18;
			Aceptar.Location= new Point(28, pos);
			Cancelar.Location= new Point(116, pos);
			//
			// FormSalidalog
			//
			this.ClientSize= new Size(206, pos+44);
			this.Controls.Add(Chkajuste);
			this.Controls.AddRange(new Control[]{
				Lblminimo,	Chkminimo,
				Lblfiles,		Txtfiles,
				Lblproceso,	Txtproceso,
				Lblotros,		Txtotros
			});
			this.Controls.Add(Chkpdfs);
		}
	#endregion

		protected override void set_data(object obj){
			chkaj=Chkajuste.Checked;
			chkpdf=Chkpdfs.Checked;
			try{log_files=Convert.ToByte(Txtfiles.Text);}			catch(Exception){log_files=byte.MaxValue;}
			try{log_proceso=Convert.ToByte(Txtproceso.Text);}	catch(Exception){log_proceso=byte.MaxValue;}
			try{log_otros=Convert.ToByte(Txtotros.Text);}			catch(Exception){log_otros=byte.MaxValue;}
		}

		protected override void Cancelar_Click(object sender,System.EventArgs e){
			Chkajuste.Checked=chkaj;
			Chkpdfs.Checked=chkpdf;
			Txtfiles.Text=log_files.ToString();
			Txtproceso.Text=log_proceso.ToString();
			Txtotros.Text=log_otros.ToString();
			this.Hide();
		}
		protected override void Aceptar_Click(object sender,System.EventArgs e){
			try{log_files=Convert.ToByte(Txtfiles.Text);}			catch(Exception){Txtfiles.Text="-1";}
			try{log_proceso=Convert.ToByte(Txtproceso.Text);}	catch(Exception){Txtproceso.Text="-1";}
			try{log_otros=Convert.ToByte(Txtotros.Text);}			catch(Exception){Txtotros.Text="-1";}
			this.Hide();
		}

		public ushort get_log_level(){
			ushort k,level;

			try{k=Convert.ToByte(Txtfiles.Text);}		catch(Exception){k=byte.MaxValue;}		if(k>3) k=3;	level=k;
			try{k=Convert.ToByte(Txtotros.Text);}		catch(Exception){k=byte.MaxValue;}		if(k>1) k=1;	level|=(UInt16)(k<<2);
			try{k=Convert.ToByte(Txtproceso.Text);}	catch(Exception){k=byte.MaxValue;}		if(k>3) k=3;	level|=(UInt16)(k<<3);
			return level;
		}
		public void process_log_level(ushort level){
			Txtfiles.Text=(level&3).ToString();	level>>=2;
			Txtotros.Text=(level&1).ToString();	level>>=1;
			Txtproceso.Text=(level&3).ToString();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Chkajuste.Text=get_texto(Log_del_ajuste);
			Lblminimo.Text=get_texto(Log_bsico);
			Lblfiles.Text=get_texto(Lectura_y_escritura_de_ficheros);
			Lblproceso.Text=get_texto(Proceso);
			Lblotros.Text=get_texto(Otros);
			Chkpdfs.Text=get_texto(Logs_de_pdf);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
