using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Modelos
{
	public class FormSalidainf : ControlesAt.FormOpcionesAlgo
	{
		private System.Windows.Forms.Label Label2;
		private System.Windows.Forms.Label Label3;
		private ControlesAt.ChkSalida ChkP0,	ChkP1,
											 ChkP2,	ChkP3;
		private ControlesAt.ChkSalida ChkR0,	ChkR1,
											 ChkR2,	ChkR3;
		private ControlesAt.LTFloatPosPlano Txtpercent;
		internal const short nR=4, nP=4;
		private ChkSalida[] ChkR, ChkP;

		public FormSalidainf(IEntorno _Entorno,Control _Where, InterComModelos.CConfigSalida _c_) : base(_Entorno,_Where,_c_){}

	#region InitializeComponent
		protected override void InitializeComponent(){
			Label2=new Label();
			Label3=new Label();
			ChkR0=new ChkSalida();
			ChkR1=new ChkSalida();
			ChkR2=new ChkSalida();
			ChkR3=new ChkSalida();
			ChkP0=new ChkSalida();
			ChkP1=new ChkSalida();
			ChkP2=new ChkSalida();
			ChkP3=new ChkSalida();
			Txtpercent= new LTFloatPosPlano(26,(short)4);
			ChkR=new ChkSalida[nR];
			ChkP=new ChkSalida[nP];
			ChkR[0]=ChkR0;	ChkR[1]=ChkR1;
			ChkR[2]=ChkR2;	ChkR[3]=ChkR3;

			ChkP[0]=ChkP0;	ChkP[1]=ChkP1;
			ChkP[2]=ChkP2;	ChkP[3]=ChkP3;

			int pos, j;
			//
			// Location&size
			//
			j=2;
			pos=12;
			Label2.Location= new Point(7,pos);		Label2.Size= new Size(145,17);	Label2.TabIndex= j++;
			pos+=18;
			ChkR0.Location= new Point(5,pos);		ChkR0.TabIndex= j++;		pos+=16;
			ChkR1.Location= new Point(5,pos);		ChkR1.TabIndex= j++;		pos+=16;
			ChkR2.Location= new Point(5,pos);		ChkR2.TabIndex= j++;		pos+=16;
			ChkR3.Location= new Point(5,pos);		ChkR3.TabIndex= j++;		pos+=24;

			Label3.Location= new Point(7,pos);		Label3.Size= new Size(116,17);	Label3.TabIndex= j++;
			pos+=18;
			ChkP0.Location= new Point(5,pos);		ChkP0.TabIndex= j++;
			ChkP1.Location= new Point(5,pos);		ChkP1.TabIndex= j++;
			ChkP2.Location= new Point(5,pos);		ChkP2.TabIndex= j++;		pos+=16;
			ChkP3.Location= new Point(5,136);		ChkP3.TabIndex= j++;		pos+=16;

			ChkP0.Visible=false;
			ChkP1.Visible=false;
			//
			// Txtpercent
			//
			Txtpercent.L.Text="%";
			Txtpercent.TextLocation= new Point(192,63);
			Txtpercent.Text= "2";
			//
			// Aceptar
			pos+=18;
			Aceptar.Location= new Point(28,pos);
			Cancelar.Location= new Point(136,pos);
			//
			// FormSalidainf
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(224,pos+44);
			this.Controls.Add(Txtpercent);
			this.Controls.AddRange(new Control[]{
				ChkP3,	ChkP2,
				ChkP1,	ChkP0,
				ChkR3,	ChkR2,
				ChkR1,	ChkR0
			});
			this.Controls.Add(Label3);
			this.Controls.Add(Label2);
		}
	#endregion

		protected override void set_data(object obj){
			short i;
			ushort t;
			InterComModelos.CConfigSalida CSalida=(InterComModelos.CConfigSalida)obj;

			t=CSalida.S.SalidaInf.Residuos;
			for(i=0;i<nR;i++,t>>=1){
				ChkR[i].Checked= (t&(ushort)1)!=0;
			}
			t=CSalida.S.SalidaInf.ParamPrec;
			for(i=0;i<nP;i++,t>>=1){
				ChkP[i].Checked= (t&(ushort)1)!=0;
			}
			Txtpercent.Text=Convert.ToString(CSalida.S.SalidaInf.percent);
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			short i;
			ushort t;
			InterComModelos.CConfigSalida CSalida=(InterComModelos.CConfigSalida)ref_to_Data;

			byte err=0;
			float percent=0;	//Idiota
			try{percent= Basicas._gcVarios.atofl(Txtpercent.Text.ToCharArray());}
			catch(System.SystemException){err=1;}
			if(percent<0 || percent>100) err=1;
			if(err!=0){
				this.Entorno.MessageBox.Show(Textos.get_texto(Textos.Cods.Valor_erroneo_percent,idioma));
				return;
			}
			CSalida.S.SalidaInf.percent=percent;

			CSalida.S.SalidaInf.Residuos=0;
			CSalida.S.SalidaInf.ParamPrec=0;

			for(i=0,t=1;i<nR;i++,t<<=1){
				if(ChkR[i].Checked) CSalida.S.SalidaInf.Residuos|=t;
			}
			for(i=0,t=1;i<nP;i++,t<<=1){
				if(ChkP[i].Checked) CSalida.S.SalidaInf.ParamPrec|=t;
			}
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Label2.Text=Textos.get_texto(Textos.Cods.Residuos,idioma);
			ChkR[0].Text=Textos.get_texto(Textos.Cods.En_sistema_referencia,idioma);
			ChkR[1].Text=Textos.get_texto(Textos.Cods.En_sistema_atransformar,idioma);
			ChkR[2].Text=Textos.get_texto(Textos.Cods.Puntos_con_mayor_residuo,idioma);
			ChkR[3].Text=Textos.get_texto(Textos.Cods.Puntos_de_control,idioma);

			Label3.Text=Textos.get_texto(Textos.Cods.Precisiones,idioma);
			ChkP[2].Text=Textos.get_texto(Textos.Cods.Parmetros_transformacin,idioma);
			ChkP[3].Text=Textos.get_texto(Textos.Cods.Puntos_transformados,idioma);
		}
	}
}
