using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
using static Textos.Cods;

	public class Cbool{public bool b;}
	public class FormSalidainf : ControlesAt.FormOpcionesAlgo{
		private class AlgunosTodos : ContainerControl{
			public RadioButton Muestra, Todos;
			public AlgunosTodos(){
				Muestra=	new RadioButton();
				Todos=	new RadioButton();
				Muestra.Location=new Point(0,0);	Muestra.Size=new Size(80,16);	Muestra.TabIndex=0;
				Todos.Location=new Point(0,16);	Todos.Size=new Size(80,16);		Todos.TabIndex=1;
				this.ClientSize=new Size(80,32);
				this.Controls.Add(Todos);
				this.Controls.Add(Muestra);
			}
		}
		private CheckBox MostrarHtml;
		private ControlesAt.BaseLabel Label2;
		private ControlesAt.ChkSalida ChkR0,	ChkR1,
											 ChkR2,	ChkR3,
											 ChkR4,	ChkR5;
		private ControlesAt.BaseLabel Label3;
		private ControlesAt.ChkSalida ChkP0,	ChkP1,
											 ChkP2,	ChkP3;
		private ControlesAt.BaseLabel Label4;
		private ControlesAt.ChkSalida ChkP4,	ChkP5,
											 ChkP6;
		private FormSalidainf.AlgunosTodos Preccp, Precp;

		internal const short nR=6, nP=7;
		private ControlesAt.ChkSalida[] ChkR, ChkP;

		Cbool muestra_html;
		public FormSalidainf(IEntorno _Entorno,Control _Where, InterComAerotri.CConfigSalida _c_, Cbool _muestra_html) : base(_Entorno,_Where,_c_){
			muestra_html=_muestra_html;
		}
	#region InitializeComponent
		protected override void InitializeComponent()
		{
			Label2= new BaseLabel();
			Label3= new BaseLabel();
			Label4= new BaseLabel();
			MostrarHtml= new CheckBox();
			ChkR0= new ChkSalida();
			ChkR1= new ChkSalida();
			ChkR2= new ChkSalida();
			ChkR3= new ChkSalida();
			ChkR4= new ChkSalida();
			ChkR5= new ChkSalida();
			ChkP0= new ChkSalida();
			ChkP1= new ChkSalida();
			ChkP2= new ChkSalida();
			ChkP3= new ChkSalida();
			ChkP4= new ChkSalida();
			ChkP5= new ChkSalida();
			ChkP6= new ChkSalida();
			Preccp=new AlgunosTodos();
			Precp= new AlgunosTodos();
			ChkR=new ChkSalida[nR];
			ChkP=new ChkSalida[nP];
			ChkR[0]=ChkR0;	ChkR[1]=ChkR1;
			ChkR[2]=ChkR2;	ChkR[3]=ChkR3;
			ChkR[4]=ChkR4;	ChkR[5]=ChkR5;

			ChkP[0]=ChkP0;	ChkP[1]=ChkP1;
			ChkP[2]=ChkP2;	ChkP[3]=ChkP3;
			ChkP[4]=ChkP4;	ChkP[5]=ChkP5;
			ChkP[6]=ChkP6;

			int pos, j;
			pos=12;
			j=2;
			//
			// MostrarHtml
			//
			MostrarHtml.Location= new Point(12, pos);	pos+=10;
			MostrarHtml.Size= new Size(192, 30);
			MostrarHtml.TabIndex= j++;
			//
			// Location, Size&TabIndex
			//
			pos+=25;
			Label2.RefLocation= new Point(9, pos);		Label2.TabIndex= j++;		pos+=17;
			for(i=0;i<nR;i++,pos+=16){
				ChkR[i].Location= new Point(5,pos);
				ChkR[i].TabIndex= j++;
			}

			pos+=9;
			Label3.RefLocation= new Point(9, pos);		Label3.TabIndex= j++;		pos+=17;
			ChkP0.Location= new Point(5, pos);			ChkP0.TabIndex= j++;		pos+=16;
			ChkP1.Location= new Point(5, pos);			ChkP1.TabIndex= j++;		pos+=16;
			ChkP2.Location= new Point(5, pos);			ChkP2.TabIndex= j++;		pos+=16;
			ChkP3.Location= new Point(5, pos);			ChkP3.TabIndex= j++;		pos+=25;

			Label4.RefLocation= new Point(9, pos);		Label4.TabIndex= j++;		pos+=17;
			ChkP4.Location= new Point(5, pos);			ChkP4.TabIndex= j++;		pos+=16;
			Preccp.Location= new Point(32,pos);	pos+=36;
			ChkP5.Location= new Point(5, pos);			ChkP5.TabIndex= j++;		pos+=16;
			Precp.Location= new Point(32,pos);		pos+=36;
			ChkP6.Location= new Point(5, pos);			ChkP6.TabIndex= j++;		pos+=16;
			//
			ChkP4.CheckedChanged+=new EventHandler(ChkP4_CheckedChanged);
			ChkP5.CheckedChanged+=new EventHandler(ChkP5_CheckedChanged);
			//
			// Aceptar
			pos+=18;
			Aceptar.Location= new Point(28, pos);
			Cancelar.Location= new Point(136, pos);
			//
			// FormSalidainf
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(224, pos+44);
			this.Controls.Add(MostrarHtml);
			this.Controls.Add(Label4);
			this.Controls.Add(Label3);
			this.Controls.Add(Label2);
			this.Controls.Add(Precp);
			this.Controls.Add(Preccp);
			this.Controls.AddRange(new Control[]{
				ChkP6,	ChkP5,
				ChkP4,	ChkP3,
				ChkP2,	ChkP1,
				ChkP0
			});
			this.Controls.AddRange(new Control[]{
				ChkR5,	ChkR4,
				ChkR3,	ChkR2,
				ChkR1,	ChkR0
			});
		}
	#endregion

		short i;
		ushort t;
		protected override void set_data(object obj){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)obj;

			t=CSalida.S.SalidaInf.Residuos;
			for(i=0;i<nR;i++,t>>=1){
				ChkR[i].Checked= (t&(ushort)1)!=0;
			}
			t=CSalida.S.SalidaInf.ParamPrec;
			for(i=0;i<nP;i++,t>>=1){
				ChkP[i].Checked= (t&(ushort)1)!=0;
			}
			if((t&(ushort)1)!=0) Preccp.Todos.Checked=true;
			else	Preccp.Muestra.Checked=true;
			t>>=1;
			if((t&(ushort)1)!=0) Precp.Todos.Checked=true;
			else	Precp.Muestra.Checked=true;
		}
		public override void update_data(){
			base.update_data();
			MostrarHtml.Checked=muestra_html.b;
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)ref_to_Data;

			muestra_html.b=MostrarHtml.Checked;
			CSalida.S.SalidaInf.Residuos=0;
			CSalida.S.SalidaInf.ParamPrec=0;

			for(i=0,t=1;i<nR;i++,t<<=1){
				if(ChkR[i].Checked) CSalida.S.SalidaInf.Residuos|=t;
			}
			for(i=0,t=1;i<nP;i++,t<<=1){
				if(ChkP[i].Checked) CSalida.S.SalidaInf.ParamPrec|=t;
			}
			if(Preccp.Todos.Checked) CSalida.S.SalidaInf.ParamPrec|=t; t<<=1;
			if(Precp.Todos.Checked)   CSalida.S.SalidaInf.ParamPrec|=t;
			this.Hide();
		}

		protected void ChkP4_CheckedChanged(object sender,System.EventArgs e){
			Preccp.Enabled=ChkP4.Checked;
		}
		protected void ChkP5_CheckedChanged(object sender,System.EventArgs e){
			Precp.Enabled=ChkP5.Checked;
		}

		protected override void update_idioma(){
			base.update_idioma();
			MostrarHtml.Text=get_texto(Mostrar_html_al_final);

			Label2.Text=get_texto(Residuos);
			ChkR[0].Text=get_texto(Fotocoordenadas);
			ChkR[1].Text=get_texto(Puntos_de_apoyo);
			ChkR[2].Text=get_texto(Observaciones_GPS);
			ChkR[3].Text=get_texto(Puntos_de_control);
			ChkR[4].Text=get_texto(Estadsticas_de_los_residuos);
			ChkR[5].Text=get_texto(Puntos_con_algn_residuo_elevado);

			Label3.Text=get_texto(Parmetros_ajustados);
			ChkP[0].Text=get_texto(Centros_de_proyeccin);
			ChkP[1].Text=get_texto(Puntos);
			ChkP[2].Text=get_texto(Parmetros_GPS);
			ChkP[3].Text=get_texto(Matrices_de_rotacin_de_los_fotogramas);

			Label4.Text=get_texto(Precisiones);
			ChkP[4].Text=get_texto(Centros_de_proyeccin);
			ChkP[5].Text=get_texto(Puntos);
			ChkP[6].Text=get_texto(Parmetros_GPS);
			Preccp.Muestra.Text=get_texto(Muestra);
			Preccp.Todos.Text=get_texto(Todos);
			Precp.Muestra.Text=get_texto(Muestra);
			Precp.Todos.Text=get_texto(Todos);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
