﻿using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
using static Textos.Cods;

	public class FormSalidadec : ControlesAt.FormOpcionesAlgo	{
		private ControlesAt.BaseLabel Labelresiduos;
		private ControlesAt.BaseLabel Lblres2, Lblresigual;
		private ContainerControl Panelf, Panelp, Panelgps, Panelins;
		private Label Lblresf, Lblresp, Lblresgps, Lblresins;
		private RadioButton	Optf2, Optf0,
									Optp2, Optp0,
									Optgps2,	Optgps0,
									Optins2,	Optins0;
		private ControlesAt.BaseLabel Labelajs;
		private Label Lblajsdeducir, Lblajsvalor;
		private ContainerControl Paneljf, Paneljp, Paneljgps, Paneljins, Paneljrot;
		private Label Lblajsf, Lblajsp, Lblajsgps, Lblajsins, Lblajsrot;
		private RadioButton	Optjf0, Optjfx,
									Optjp0, Optjpx,
									Optjgps0,	Optjgpsx,
									Optjins0,	Optjinsx;
		private ControlesAt.IntegerTextSingle Txtfx, Txtpx, Txtgpsx, Txtinsx;
		private NumericUpDown Listdec_rot;
		private TextBox Lblrotx;

		public FormSalidadec(IEntorno _Entorno,Control _Where, InterComAerotri.CConfigSalida _c_) : base(_Entorno,_Where,_c_){}

	#region InitializeComponent
		protected override void InitializeComponent()
		{
			Labelresiduos=new BaseLabel();
			Lblres2=new BaseLabel();
			Lblresigual=new BaseLabel();
			Panelf=new ContainerControl();
			Panelp=new ContainerControl();
			Panelgps=new ContainerControl();
			Panelins=new ContainerControl();
			Lblresf=new Label();
			Lblresp=new Label();
			Lblresgps=new Label();
			Lblresins=new Label();
			Optf2=new RadioButton();	Optf0=new RadioButton();
			Optp2=new RadioButton();	Optp0=new RadioButton();
			Optgps2=new RadioButton();	Optgps0=new RadioButton();
			Optins2=new RadioButton();	Optins0=new RadioButton();
			Labelajs=new BaseLabel();
			Lblajsdeducir=new Label();
			Lblajsvalor=new Label();
			Paneljf=new ContainerControl();
			Paneljp=new ContainerControl();
			Paneljgps=new ContainerControl();
			Paneljins=new ContainerControl();
			Paneljrot=new ContainerControl();
			Lblajsf=new Label();
			Lblajsp=new Label();
			Lblajsgps=new Label();
			Lblajsins=new Label();
			Lblajsrot=new Label();
			Optjf0=new RadioButton();		Optjfx=new RadioButton();
			Optjp0=new RadioButton();		Optjpx=new RadioButton();
			Optjgps0=new RadioButton();		Optjgpsx=new RadioButton();
			Optjins0=new RadioButton();		Optjinsx=new RadioButton();
			Txtfx=new IntegerTextSingle();
			Txtpx=new IntegerTextSingle();
			Txtgpsx=new IntegerTextSingle();
			Txtinsx=new IntegerTextSingle();
			Lblrotx=new TextBox();
			Listdec_rot=new NumericUpDown();
			//Font
			Font fbig= new Font("Microsoft Sans Serif", 9.5F);
			//
			// Location, Size&TabIndex
			//
			int pos, j;
			pos=12;
			j=2;
			//
			// Residuos
			//
			Labelresiduos.Font= fbig;
			Labelresiduos.RefLocation= new Point(7,pos);	Labelresiduos.TabIndex=j++;
			pos+=18;
			Lblres2.RefLocation= new Point(100+42,pos+30);			Lblres2.MaxWidth=84;		Lblres2.TabIndex=j++;
			Lblresigual.RefLocation= new Point(176+48,pos+30);		Lblresigual.MaxWidth=96;	Lblresigual.TabIndex=j++;
			Lblres2.TextAlign= ContentAlignment.BottomCenter;
			Lblresigual.TextAlign= ContentAlignment.BottomCenter;
			pos+=40;
			//
			Lblresf.FlatStyle=FlatStyle.System;
			Lblresp.FlatStyle=FlatStyle.System;
			Lblresgps.FlatStyle=FlatStyle.System;
			Lblresins.FlatStyle=FlatStyle.System;
			//
			Optf2.Width=20;	Optf0.Width=20;
			Optp2.Width=20;	Optp0.Width=20;
			Optgps2.Width=20;	Optgps0.Width=20;
			Optins2.Width=20;	Optins0.Width=20;
			//
			// Panels
			//
			Panelf.Location= new Point(4,pos);		Panelf.Size= new Size(260,20);	pos+=20;
			Panelp.Location= new Point(4,pos);		Panelp.Size= new Size(260,20);	pos+=20;
			Panelgps.Location= new Point(4,pos);	Panelgps.Size= new Size(260,20);	pos+=20;
			Panelins.Location= new Point(4,pos);	Panelins.Size= new Size(260,20);	pos+=20;
			//
			Lblresf.Location=new Point(12,0);		Lblresf.Size= new Size(84,17);
			Optf2.Location= new Point(132,0);		Optf0.Location= new Point(214,0);
			Panelf.Controls.AddRange(new Control[]{ Lblresf, Optf2, Optf0 });
			//
			Lblresp.Location=new Point(12,0);		Lblresp.Size= new Size(64,17);
			Optp2.Location= new Point(132,0);		Optp0.Location= new Point(214,0);
			Panelp.Controls.AddRange(new Control[]{ Lblresp, Optp2, Optp0 });
			//
			Lblresgps.Location=new Point(12,0);		Lblresgps.Size= new Size(64,17);
			Optgps2.Location= new Point(132,0);	Optgps0.Location= new Point(214,0);
			Panelgps.Controls.AddRange(new Control[]{ Lblresgps, Optgps2, Optgps0 });
			//
			Lblresins.Location=new Point(12,0);		Lblresins.Size= new Size(64,17);
			Optins2.Location= new Point(132,0);	Optins0.Location= new Point(214,0);
			Panelins.Controls.AddRange(new Control[]{ Lblresins, Optins2, Optins0 });

			Lblresgps.Text="GPS";
			Lblresins.Text="INS";
			//
			// Valores ajustados
			//
			pos+=12;
			Labelajs.Font=fbig;
			Labelajs.RefLocation= new Point(7,pos);		Labelajs.TabIndex=j++;
			pos+=18;
			Lblajsdeducir.Location= new Point(100,pos);	Lblajsdeducir.Size=new Size(84, 17);	Lblres2.TabIndex=j++;
			Lblajsvalor.Location= new Point(176,pos);		Lblajsvalor.Size=new Size(96, 17);	Lblajsvalor.TabIndex=j++;
			Lblajsdeducir.TextAlign= ContentAlignment.BottomCenter;
			Lblajsvalor.TextAlign= ContentAlignment.BottomCenter;
			pos+=24;
			//
			Lblajsf.FlatStyle=FlatStyle.System;
			Lblajsp.FlatStyle=FlatStyle.System;
			Lblajsgps.FlatStyle=FlatStyle.System;
			Lblajsins.FlatStyle=FlatStyle.System;
			Lblajsrot.FlatStyle=FlatStyle.System;
			//
			Optjf0.Width=20;		Optjfx.Width=20;
			Optjp0.Width=20;		Optjpx.Width=20;
			Optjgps0.Width=20;	Optjgpsx.Width=20;
			Optjins0.Width=20;		Optjinsx.Width=20;
			//
			Txtfx.Size=new Size(25,18);
			Txtpx.Size=new Size(25,18);
			Txtgpsx.Size=new Size(25,18);
			Txtinsx.Size=new Size(25,18);
			Lblrotx.AutoSize=false;
			Lblrotx.BorderStyle= BorderStyle.FixedSingle;		Lblrotx.Size=new Size(29,16);	//18
			Listdec_rot.BorderStyle= BorderStyle.None;		Listdec_rot.Size=new Size(27,12);	//16, pero no hace caso
			//
			// Panels
			//
			Paneljf.Location= new Point(4,pos);		Paneljf.Size= new Size(260,20);	pos+=20;
			Paneljp.Location= new Point(4,pos);		Paneljp.Size= new Size(260,20);	pos+=20;
			Paneljgps.Location= new Point(4,pos);	Paneljgps.Size= new Size(260,20);pos+=20;
			Paneljins.Location= new Point(4,pos);	Paneljins.Size= new Size(260,20);	pos+=24;
			Paneljrot.Location= new Point(4,pos);	Paneljrot.Size= new Size(260,20);	pos+=20;
			//
			Lblajsf.Location=new Point(12,0);		Lblajsf.Size= new Size(84,17);
			Optjf0.Location= new Point(132,0);
			Optjfx.Location= new Point(200,0);
			Txtfx.Location= new Point(220,0);
			Paneljf.Controls.AddRange(new Control[]{ Lblajsf, Optjf0, Txtfx, Optjfx });
			//
			Lblajsp.Location=new Point(12,0);		Lblajsp.Size= new Size(64,17);
			Optjp0.Location= new Point(132,0);
			Optjpx.Location= new Point(200,0);
			Txtpx.Location= new Point(220,0);
			Paneljp.Controls.AddRange(new Control[]{ Lblajsp, Optjp0, Txtpx, Optjpx });
			//
			Lblajsgps.Location=new Point(12,0);		Lblajsgps.Size= new Size(68,17);
			Optjgps0.Location= new Point(132,0);
			Optjgpsx.Location= new Point(200,0);
			Txtgpsx.Location= new Point(220,0);
			Paneljgps.Controls.AddRange(new Control[]{ Lblajsgps, Optjgps0, Txtgpsx, Optjgpsx });
			//
			Lblajsins.Location=new Point(12,0);		Lblajsins.Size= new Size(80,17);
			Optjins0.Location= new Point(132,0);
			Optjinsx.Location= new Point(200,0);
			Txtinsx.Location= new Point(220,0);
			Paneljins.Controls.AddRange(new Control[]{ Lblajsins, Optjins0, Txtinsx, Optjinsx });
			//
			Lblajsrot.Location=new Point(12,0);		Lblajsrot.Size= new Size(100,17);
			Lblrotx.Location= new Point(216,0);
			Listdec_rot.Location= new Point(217,2);
			Paneljrot.Controls.AddRange(new Control[]{ Lblajsrot, Listdec_rot, Lblrotx });

			Lblajsgps.Text="cc.pp.,  X,Y,Z";
			Lblajsins.Text="cc.pp.,  Ω,Φ,Κ";
			Listdec_rot.BackColor= SystemColors.Window;
			Listdec_rot.Minimum=3;
			Listdec_rot.Maximum=7;
			Listdec_rot.ReadOnly=true;
			Listdec_rot.TextAlign= HorizontalAlignment.Center;
			Listdec_rot.Value=6;
			//
			// Aceptar
			pos+=20;
			Aceptar.Location= new Point(56, pos);
			Cancelar.Location= new Point(172, pos);
			//
			// FormSalidadec
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(274, pos+44);
			this.Controls.Add(this.Paneljrot);
			this.Controls.Add(this.Paneljins);
			this.Controls.Add(this.Paneljgps);
			this.Controls.Add(this.Paneljp);
			this.Controls.Add(this.Paneljf);
			this.Controls.Add(Lblajsvalor);
			this.Controls.Add(Lblajsdeducir);
			this.Controls.Add(Labelajs);
			this.Controls.Add(this.Panelins);
			this.Controls.Add(this.Panelgps);
			this.Controls.Add(this.Panelp);
			this.Controls.Add(this.Panelf);
			this.Controls.Add(Lblresigual);
			this.Controls.Add(Lblres2);
			this.Controls.Add(Labelresiduos);
		}
	#endregion

		protected override void set_data(object obj){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)obj;

			if(CSalida.S.General.decres.f>0)		Optf2.Checked=true;		else Optf0.Checked=true;
			if(CSalida.S.General.decres.p>0)		Optp2.Checked=true;		else Optp0.Checked=true;
			if(CSalida.S.General.decres.gps>0)		Optgps2.Checked=true;	else Optgps0.Checked=true;
			if(CSalida.S.General.decres.ins>0)		Optins2.Checked=true;		else Optins0.Checked=true;

			if(CSalida.S.General.decajs.f==0)	Optjf0.Checked=true;
			else{Optjfx.Checked=true;
				  Txtfx.Text=(~CSalida.S.General.decajs.f).ToString();
			}
			if(CSalida.S.General.decajs.p==0)	Optjp0.Checked=true;
			else{Optjpx.Checked=true;
				  Txtpx.Text=(~CSalida.S.General.decajs.p).ToString();
			}
			if(CSalida.S.General.decajs.gps==0)	Optjgps0.Checked=true;
			else{Optjgpsx.Checked=true;
				  Txtgpsx.Text=(~CSalida.S.General.decajs.gps).ToString();
			}
			if(CSalida.S.General.decajs.ins==0)	Optjins0.Checked=true;
			else{Optjinsx.Checked=true;
				  Txtinsx.Text=(~CSalida.S.General.decajs.ins).ToString();
			}
			try{Listdec_rot.Value=(~CSalida.S.General.decrot);}
			catch(Exception){}
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)ref_to_Data;

			if(Optf2.Checked)		CSalida.S.General.decres.f=2;		else CSalida.S.General.decres.f=0;
			if(Optp2.Checked)		CSalida.S.General.decres.p=2;		else CSalida.S.General.decres.p=0;
			if(Optgps2.Checked)	CSalida.S.General.decres.gps=2;	else CSalida.S.General.decres.gps=0;
			if(Optins2.Checked)	CSalida.S.General.decres.ins=2;	else CSalida.S.General.decres.ins=0;

			if(Optjf0.Checked) CSalida.S.General.decajs.f=0;
			else try{
				CSalida.S.General.decajs.f=(sbyte)(~Convert.ToSByte(Txtfx.Text));
			}catch(Exception){
				MessagePadre.Show(get_texto(Valor_decimales_fotocoordenadas_erróneo));
				return;
			}
			if(Optjp0.Checked) CSalida.S.General.decajs.p=0;
			else try{
				CSalida.S.General.decajs.p=(sbyte)(~Convert.ToSByte(Txtpx.Text));
			}catch(Exception){
				MessagePadre.Show(get_texto(Valor_decimales_puntos_erróneo));
				return;
			}
			if(Optjgps0.Checked) CSalida.S.General.decajs.gps=0;
			else try{
				CSalida.S.General.decajs.gps=(sbyte)(~Convert.ToSByte(Txtgpsx.Text));
			}catch(Exception){
				MessagePadre.Show(get_texto(Valor_decimales_GPS_erróneo));
				return;
			}
			if(Optjins0.Checked) CSalida.S.General.decajs.ins=0;
			else try{
				CSalida.S.General.decajs.ins=(sbyte)(~Convert.ToSByte(Txtinsx.Text));
			}catch(Exception){
				MessagePadre.Show(get_texto(Valor_decimales_INS_erróneo));
				return;
			}
			CSalida.S.General.decrot=(sbyte)(~(byte)Listdec_rot.Value);
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
				Labelresiduos.Text=get_texto(Escritura_de_los_residuos);
				Lblres2.Text=get_texto(dos_cifras_significativas);
				Lblresigual.Text=get_texto(Número_de_decimales_fijo);
				Lblresf.Text=get_texto(Fotocoordenadas_breve);
				Lblresp.Text=get_texto(Apoyo);

				Labelajs.Text=get_texto(Valores_ajustados);
				Lblajsdeducir.Text=get_texto(Deducir);
				Lblajsvalor.Text=get_texto(Este_valor)+":";
				Lblajsf.Text=get_texto(Fotocoordenadas_breve);
				Lblajsp.Text=get_texto(Apoyo);
				Lblajsrot.Text=get_texto(Matrices_de_rotación);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
