using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Modelos
{
	public class FormSalidaajs : ControlesAt.FormOpcionesAlgo
	{
		private System.Windows.Forms.Label Label2;
		private ControlesAt.ChkSalida ChkP0, ChkP1;

		internal const short nP=2;
		private ChkSalida[] ChkP;

		public FormSalidaajs(IEntorno _Entorno,Control _Where, InterComModelos.CConfigSalida _c_) : base(_Entorno,_Where,_c_){}

	#region InitializeComponent
		protected override void InitializeComponent(){
			Label2= new Label();
			ChkP0= new ChkSalida();
			ChkP1= new ChkSalida();
			ChkP=new ChkSalida[nP];
			ChkP[0]=ChkP0;
			ChkP[1]=ChkP1;
			//
			// Location&size
			//
			int pos=12;
			Label2.Location= new Point(7, pos);		Label2.Size= new Size(145, 17);	Label2.TabIndex= 3;
			pos+=18;
			ChkP0.Location= new Point(5, pos);		ChkP0.TabIndex= 4;	pos+=16;
			ChkP1.Location= new Point(5, pos);		ChkP1.TabIndex= 5;	pos+=16;
			//
			// Aceptar
			//
			pos+=18;
			Aceptar.Location= new Point(28, pos);
			Cancelar.Location= new Point(136, pos);
			//
			// FormSalidaajs
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(224, pos+44);
			this.Controls.Add(Label2);
			this.Controls.Add(ChkP0);
			this.Controls.Add(ChkP1);
		}
	#endregion

		protected override void set_data(object obj){
			short i;
			ushort t;
			InterComModelos.CConfigSalida CSalida=(InterComModelos.CConfigSalida)obj;

			t=CSalida.S.SalidaAjs.Param;
			for(i=0;i<nP;i++,t>>=1){
				ChkP[i].Checked= (t&(ushort)1)!=0;
			}
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			short i;
			ushort t;
			InterComModelos.CConfigSalida CSalida=(InterComModelos.CConfigSalida)ref_to_Data;

			CSalida.S.SalidaAjs.Param=0;
			for(i=0,t=1;i<nP;i++,t<<=1){
				if(ChkP[i].Checked) CSalida.S.SalidaAjs.Param|=t;
			}
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Label2.Text=Textos.get_texto(Textos.Cods.Parmetros,idioma);
			ChkP[0].Text=Textos.get_texto(Textos.Cods.Ccpp,idioma);
			ChkP[1].Text=Textos.get_texto(Textos.Cods.Puntos,idioma);
		}
	}
}
