using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Modelos
{
	public class FormSalida_Mod : ControlesAt.FormLabelMove
	{
		private System.Windows.Forms.CheckBox ChkF0, ChkF1;
		private ControlesAt.Botonppp BotAjs, BotInf;

		internal const short nF=2;
		CheckBox[] ChkF;//nF
		internal FormSalidaajs Ajs1;
		internal FormSalidainf Inf1;

		PanelModelos PanelPadre;
		public FormSalida_Mod(PanelModelos Form1) : base(Form1){
			InitializeComponent();

			PanelPadre=Form1;
			Ajs1=new FormSalidaajs(PanelPadre,PanelPadre.ParentForm,PanelPadre.CSalida);
			Inf1=new FormSalidainf(PanelPadre,PanelPadre.ParentForm,PanelPadre.CSalida);
			Ajs1.Owner=this;
			Inf1.Owner=this;

			this.AcceptButton=Aceptar;
			this.CancelButton=null;

			ChkF=new CheckBox[nF];
			ChkF[0]= ChkF0;
			ChkF[1]= ChkF1;

			colores();
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			BotAjs= new Botonppp();
			BotInf= new Botonppp();
			ChkF0= new CheckBox();
			ChkF1= new CheckBox();
			this.SuspendLayout();
			//
			// Aceptar, Cancelar
			//
			Aceptar.Location= new Point(78, 68);		Aceptar.Size= new Size(60, 22);
			//Cancelar.Location= new Point(128, 68);		Cancelar.Size= new Size(60, 22);
			Cancelar.Visible=false;	Cancelar.Enabled=false;
			//
			// ChkF0, 1
			//
			ChkF0.Location= new Point(16, 12);		ChkF0.Size= new Size(181, 16);		ChkF0.TabIndex= 1;
			ChkF1.Location= new Point(16, 32);		ChkF1.Size= new Size(180, 16);		ChkF1.TabIndex= 3;
			//
			// BotAjs, Inf
			//
			BotAjs.Location= new Point(184, 12);		BotAjs.TabIndex= 2;
			BotInf.Location= new Point(184, 32);		BotInf.TabIndex= 4;
			BotAjs.Click+= new EventHandler(BotAjs_Click);
			BotInf.Click+= new EventHandler(BotInf_Click);
			//
			// FormSalida_Mod
			//
			this.BackColor= Color.FromArgb((byte)(232), (byte)(229), (byte)(222));
			this.Controls.Add(BotInf);
			this.Controls.Add(BotAjs);
			this.Controls.Add(ChkF1);
			this.Controls.Add(ChkF0);
		}
		protected override Size DefaultSize{
			get{return new Size(220, 108);}
		}

	#endregion

		protected override void OnLoad(System.EventArgs e){
			short i;
			ushort t;

			this.Top=PanelPadre.ParentForm.Top+40;
			this.Left=PanelPadre.ParentForm.Left + 216;

			t=PanelPadre.CSalida.S.SalidaF;
			for(i=0;i<nF;i++,t>>=1){
				ChkF[i].Checked= (t&(ushort)1)!=0;
			}
			base.OnLoad(e);
		}

		private void BotAjs_Click(object sender,System.EventArgs e){
			Ajs1.Top=this.Top-12;
			Ajs1.Left=this.Left+3*this.Width/5;
			Ajs1.ShowDialog();
		}
		private void BotInf_Click(object sender,System.EventArgs e){
			Inf1.Top=this.Top-12;
			Inf1.Left=this.Left+3*this.Width/5;
			Inf1.ShowDialog();
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			short i;
			ushort t;

			PanelPadre.CSalida.S.SalidaF= 0;
			for(i=0,t=1;i<nF;i++,t<<=1){
				if(ChkF[i].Checked) PanelPadre.CSalida.S.SalidaF|=t;
			}
			this.Hide();
		}

		void colores(){
			this.BackColor= Globales.Colores.NETColor(Globales.Colores.cForm);
			Aceptar.BackColor= Globales.Colores.NETColor(Globales.Colores.cBoton);
			Cancelar.BackColor= Globales.Colores.NETColor(Globales.Colores.cBoton);
			BotAjs.BackColor=Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
			BotInf.BackColor=Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
		}
		protected override void update_idioma(){
			base.update_idioma();
			ChkF[0].Text=Textos.get_texto(Textos.Cods.Fichero_valores_ajustados,idioma);
			ChkF[1].Text=Textos.get_texto(Textos.Cods.Fichero_de_informacin,idioma);
		}
	}
}
