using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
using static Textos.Cods;

	public class FormSalidaPares : ControlesAt.FormOpcionesAlgo{
		private ControlesAt.LTIntegerSingle Txtmin;
		private ControlesAt.BaseLabel LabelModoPares, LabelOrientacion;
		private ContainerControl PanelModo;
		private RadioButton modoP0, modoP, modoS, modoTodas;
		private ControlesAt.ChkSalida ChkOrientacion;

		public FormSalidaPares(IEntorno _Entorno, Control _Where, InterComAerotri.CConfigSalida _c_) : base(_Entorno,_Where,_c_){}

	#region InitializeComponent
		protected override void InitializeComponent(){
			Txtmin=new LTIntegerSingle();
			LabelModoPares=new BaseLabel();
			PanelModo=new ContainerControl();
			modoP0=new RadioButton();
			modoP=new RadioButton();
			modoS=new RadioButton();
			modoTodas=new RadioButton();
			LabelOrientacion=new BaseLabel();
			ChkOrientacion=new ChkSalida();

			Txtmin.TextLocation= new Point(192,16);		Txtmin.L.MaxWidth=160;		Txtmin.TabIndex= 1;
			LabelModoPares.RefLocation= new Point(8,52);										LabelModoPares.TabIndex=2;
			PanelModo.Location= new Point(8,62);		PanelModo.Size= new Size(260,80);	PanelModo.TabIndex=3;
			//
			modoP0.FlatStyle= FlatStyle.System;
			modoP.FlatStyle= FlatStyle.System;
			modoS.FlatStyle= FlatStyle.System;
			modoTodas.FlatStyle= FlatStyle.System;
			modoP0.Location= new Point(4,4);		modoP0.Width=256;
			modoP.Location= new Point(4,23);			modoP.Width=256;
			modoS.Location= new Point(4,42);			modoS.Width=256;
			modoTodas.Location= new Point(4,61);	modoTodas.Width=256;
			PanelModo.Controls.AddRange(new Control[]{modoP0,modoP,modoS,modoTodas});
			//
			// Orientacion
			LabelOrientacion.RefLocation=new Point(8,160);		LabelOrientacion.TabIndex=4;
			ChkOrientacion.Location=new Point(12,178);			ChkOrientacion.TabIndex=5;
			ChkOrientacion.BorderStyle= ChkSalida.ExtendedBorderStyle.Alternating3D;
			//
			// Aceptar, Cancelar
			Aceptar.Location= new Point(52, 212);
			Cancelar.Location= new Point(168, 212);
			//
			// FormSalidaPares
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(280, 258);
			this.Controls.AddRange(new Control[]{
				Txtmin,
				LabelModoPares,	PanelModo,
				LabelOrientacion,	ChkOrientacion
			});
		}
	#endregion
		protected override void set_data(object obj){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)obj;
			Txtmin.Text= CSalida.S.ParesPasadas.nmin.ToString();
			switch(CSalida.S.ParesPasadas.modo){
				case 0: modoP0.Checked=true; break;
				case 1: modoP.Checked=true; break;
				case 2: modoS.Checked=true; break;
				case 3: modoTodas.Checked=true; break;
			}
			ChkOrientacion.Checked= (CSalida.S.ParesPasadas.brev!=0);
		}
		protected override void Aceptar_Click(object sender,System.EventArgs e){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)ref_to_Data;
			try{
				CSalida.S.ParesPasadas.nmin=Convert.ToByte(Txtmin.Text);
			}catch(Exception){
				MessagePadre.Show(get_texto(Valor_mnimo_puntos_comunes_modelo_errneo));
				return;
			}
			if(modoP0.Checked) CSalida.S.ParesPasadas.modo=0;
			else if(modoP.Checked) CSalida.S.ParesPasadas.modo=1;
			else if(modoS.Checked) CSalida.S.ParesPasadas.modo=2;
			else CSalida.S.ParesPasadas.modo=3;
			if(ChkOrientacion.Checked) CSalida.S.ParesPasadas.brev=1;
			else CSalida.S.ParesPasadas.brev=0;
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Txtmin.L.Text=get_texto(Mnimo_puntos_comunes_formar_modelo);
			LabelModoPares.Text=get_texto(Generacin_de_pares)+":";
			modoP0.Text=get_texto(Solo_pares_principales);
			modoP.Text=get_texto(Solo_pasadas_principales);
			modoS.Text=get_texto(Tambin_pasadas_secundarias);
			modoTodas.Text=get_texto(Todos_con_minimo_puntos_comunes);
			LabelOrientacion.Text=get_texto(Orientacin_de_las_pasadas);
			ChkOrientacion.Text=get_texto(Orientar_las_pasadas_en_el_mismo_sentido);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
