using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
	public class FormSalidaImaster : ControlesAt.FormOpcionesAlgo{
		private ContainerControl Panelext, Panelimc;
		private ControlesAt.BaseLabel		Labelgrupo1,	Labelgrupo2;
		private ControlesAt.BaseLabel		Labelruta1,	Labelruta2;
		private ControlesAt.TextBoxFocus TxtRuta1, TxtRuta2;
		private ControlesAt.ChkSalida Chkext,	Chkpairlist,	Chkrel,
											 Chkimc;

		TwoStrings rutaImaster;
		public FormSalidaImaster(IEntorno _Entorno, Control _Where, InterComAerotri.CConfigSalida _c_, TwoStrings _rutaImaster) : base(_Entorno,_Where,_c_){
			rutaImaster=_rutaImaster;
		}

	#region InitializeComponent
		protected override void InitializeComponent(){
			Panelext=new ContainerControl();
			Panelimc=new ContainerControl();
			Labelgrupo1= new BaseLabel();
			Labelgrupo2= new BaseLabel();
			Labelruta1= new BaseLabel();
			Labelruta2= new BaseLabel();
			Chkext= new ChkSalida();
			Chkpairlist= new ChkSalida();
			Chkrel= new ChkSalida();
			Chkimc= new ChkSalida();
			TxtRuta1= new TextBoxFocus();
			TxtRuta2= new TextBoxFocus();
			//
			//TxtRuta
			TxtRuta2.TextAlign=TxtRuta1.TextAlign= HorizontalAlignment.Left;
			TxtRuta2.BorderStyle=TxtRuta1.BorderStyle= BorderStyle.FixedSingle;
			//
			// Location&size
			//
			Panelext.Location= new Point(4,16);			Panelext.Size=new Size(226,104);
			Panelimc.Location= new Point(4,132);		Panelimc.Size=new Size(226,104);
			//
			// Labels
			//
			Labelgrupo1.Font= new Font("MSSansSerif",8.25F,FontStyle.Bold);
			Labelgrupo2.Font=Labelgrupo1.Font;
			Labelruta2.MaxWidth=Labelruta1.MaxWidth=208;
			// .rel ...
			Chkext.BorderStyle= ChkSalida.ExtendedBorderStyle.Alternating3D;
			Chkimc.BorderStyle=Chkrel.BorderStyle=Chkpairlist.BorderStyle=Chkext.BorderStyle;
			Chkext.Text=".ext";	Chkpairlist.Text=".pairlist";		Chkrel.Text=".rel";
			Chkimc.Text=".imc";
			//
			// Panelext
			//
			Labelgrupo1.RefLocation= new Point(4, 0);	Labelgrupo1.TabIndex=0;
			Chkext.Location= new Point(12,22);			Chkext.TabIndex=1;
			Chkpairlist.Location= new Point(82,22);		Chkpairlist.TabIndex=2;
			Chkrel.Location= new Point(152,22);		Chkrel.TabIndex=3;
			Labelruta1.RefLocation= new Point(12, 46);	Labelruta1.TabIndex= 4;
			TxtRuta1.Location= new Point(12,78);		TxtRuta1.Width= 198;			TxtRuta1.TabIndex=5;
			Panelext.Controls.AddRange(new Control[]{
				Labelgrupo1,
				Chkext, Chkpairlist, Chkrel,
				Labelruta1, TxtRuta1});
			//
			//Panelimc
			Labelgrupo2.RefLocation=Labelgrupo1.RefLocation;	Labelgrupo1.TabIndex=0;
			Chkimc.Location= new Point(52,22);
			Labelruta2.RefLocation=Labelruta1.RefLocation;		Labelruta2.TabIndex=1;
			Labelruta2.MaxWidth=240;
			TxtRuta2.Location= TxtRuta1.Location;		TxtRuta2.Width= 198;			TxtRuta2.TabIndex=3;
			//
			Panelimc.Controls.AddRange(new Control[]{
				Labelgrupo2,
				Chkimc,
				Labelruta2, TxtRuta2});
			//
			// Aceptar
			Aceptar.Location= new Point(28, 258);
			Cancelar.Location= new Point(144, 258);
			//
			// FormSalidaImaster
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(232, 302);
			this.Controls.AddRange(new Control[]{Panelext, Panelimc});
		}
	#endregion

		protected override void set_data(object obj){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)obj;

			Chkext.Checked= (CSalida.S.SalidaImaster.flags&1)!=0;
			Chkpairlist.Checked= (CSalida.S.SalidaImaster.flags&2)!=0;
			Chkrel.Checked= (CSalida.S.SalidaImaster.flags&4)!=0;
			Chkimc.Checked= (CSalida.S.SalidaImaster.flags&8)!=0;
		}
		public override void update_data(){
			base.update_data();
			if(rutaImaster.s1==null) TxtRuta1.Text="\\.";	else TxtRuta1.Text=rutaImaster.s1;
			if(rutaImaster.s2==null) TxtRuta2.Text="\\.";	else TxtRuta2.Text=rutaImaster.s2;
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)ref_to_Data;

			CSalida.S.SalidaImaster.flags=0;
			if(Chkext.Checked) CSalida.S.SalidaImaster.flags |= 1;
			if(Chkpairlist.Checked) CSalida.S.SalidaImaster.flags |= 2;
			if(Chkrel.Checked) CSalida.S.SalidaImaster.flags |= 4;
			if(Chkimc.Checked) CSalida.S.SalidaImaster.flags |= 8;

			rutaImaster.s1=TxtRuta1.Text;
			rutaImaster.s2=TxtRuta2.Text;

			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Labelgrupo1.Text=get_texto(Textos.Cods.Ficheros_IMaster1);
			Labelgrupo2.Text=get_texto(Textos.Cods.Ficheros_IMaster2);
			Labelruta2.Text=Labelruta1.Text=get_texto(Textos.Cods.Directorio_de_generacin_relativo_a_fotos)+":";
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
