using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
	public class TwoStrings{
		public string s1, s2;
	}
	public class FormSalidaDigi : ControlesAt.FormOpcionesAlgo{
		private ContainerControl Panelrel, Panelmod;
		private ControlesAt.BaseLabel		Labelgrupo1,	Labelgrupo2;
		private ControlesAt.BaseLabel		Labelruta1,	Labelruta2;
		private ControlesAt.TextBoxFocus TxtRuta1, TxtRuta2;
		private ControlesAt.ChkSalida Chkrel,	Chkabs,	Chkabs2,
											 Chkf,		Chkmod;

		TwoStrings rutamod;
		public FormSalidaDigi(IEntorno _Entorno, Control _Where, InterComAerotri.CConfigSalida _c_, TwoStrings _rutamod) : base(_Entorno,_Where,_c_){
			rutamod=_rutamod;
		}

	#region InitializeComponent
		protected override void InitializeComponent(){
			Panelrel=new ContainerControl();
			Panelmod=new ContainerControl();
			Labelgrupo1= new BaseLabel();
			Labelgrupo2= new BaseLabel();
			Labelruta1= new BaseLabel();
			Labelruta2= new BaseLabel();
			Chkrel= new ChkSalida();
			Chkabs= new ChkSalida();
			Chkabs2= new ChkSalida();
			Chkf= new ChkSalida();
			Chkmod=new ChkSalida();
			TxtRuta1= new TextBoxFocus();
			TxtRuta2= new TextBoxFocus();
			//
			//TxtRuta
			TxtRuta2.TextAlign=TxtRuta1.TextAlign= HorizontalAlignment.Left;
			TxtRuta2.BorderStyle=TxtRuta1.BorderStyle= BorderStyle.FixedSingle;
			//
			// Location&size
			//
			Panelrel.Location= new Point(4,16);			Panelrel.Size=new Size(226,104);
			Panelmod.Location= new Point(4,132);		Panelmod.Size=new Size(226,104);
			//
			// Labels
			//
			Labelgrupo1.Font= new Font("MSSansSerif",8.25F,FontStyle.Bold);
			Labelgrupo2.Font=Labelgrupo1.Font;
			Labelruta2.MaxWidth=Labelruta1.MaxWidth=208;
			// .rel ...
			Chkrel.BorderStyle= ChkSalida.ExtendedBorderStyle.Alternating3D;
			Chkmod.BorderStyle=Chkf.BorderStyle=Chkabs2.BorderStyle=Chkabs.BorderStyle=Chkrel.BorderStyle;
			Chkrel.Text=".rel";	Chkabs.Text=".abs";		Chkabs2.Text=".abs2";
			Chkf.Text=".f";		Chkmod.Text=".mod";
			//
			// Panelrel
			//
			Labelgrupo1.RefLocation= new Point(4, 0);	Labelgrupo1.TabIndex=0;
			Chkrel.Location= new Point(12,22);			Chkrel.TabIndex=1;
			Chkabs.Location= new Point(82,22);			Chkabs.TabIndex=2;
			Chkabs2.Location= new Point(152,22);		Chkabs2.TabIndex=3;
			Labelruta1.RefLocation= new Point(12, 46);	Labelruta1.TabIndex= 4;
			TxtRuta1.Location= new Point(12,78);		TxtRuta1.Width= 198;			TxtRuta1.TabIndex=5;
			Panelrel.Controls.AddRange(new Control[]{
				Labelgrupo1,
				Chkrel, Chkabs, Chkabs2,
				Labelruta1, TxtRuta1});
			//
			//Panelmod
			Labelgrupo2.RefLocation=Labelgrupo1.RefLocation;	Labelgrupo1.TabIndex=0;
			Chkf.Location= new Point(52,22);
			Chkmod.Location= new Point(112,22);
			Labelruta2.RefLocation=Labelruta1.RefLocation;		Labelruta2.TabIndex=1;
			Labelruta2.MaxWidth=240;
			TxtRuta2.Location= TxtRuta1.Location;		TxtRuta2.Width= 198;			TxtRuta2.TabIndex=3;
			//
			Panelmod.Controls.AddRange(new Control[]{
				Labelgrupo2,
				Chkf, Chkmod,
				Labelruta2, TxtRuta2});
			//
			// Aceptar
			Aceptar.Location= new Point(28, 258);
			Cancelar.Location= new Point(144, 258);
			//
			// FormSalidaDigi
			//
			this.AcceptButton= null;	this.CancelButton= null;
			this.ClientSize= new Size(232, 302);
			this.Controls.AddRange(new Control[]{Panelrel, Panelmod});
		}
	#endregion

		protected override void set_data(object obj){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)obj;

			Chkrel.Checked= (CSalida.S.SalidaDigi.flags&1)!=0;
			Chkabs.Checked= (CSalida.S.SalidaDigi.flags&2)!=0;
			Chkabs2.Checked= (CSalida.S.SalidaDigi.flags&4)!=0;
			Chkf.Checked= (CSalida.S.SalidaDigi.flags&16)!=0;
			Chkmod.Checked= (CSalida.S.SalidaDigi.flags&8)!=0;
		}
		public override void update_data(){
			base.update_data();
			if(rutamod.s1==null) TxtRuta1.Text="\\.";		else TxtRuta1.Text=rutamod.s1;
			if(rutamod.s2==null) TxtRuta2.Text="\\.";		else TxtRuta2.Text=rutamod.s2;
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			InterComAerotri.CConfigSalida CSalida=(InterComAerotri.CConfigSalida)ref_to_Data;

			CSalida.S.SalidaDigi.flags=0;
			if(Chkrel.Checked) CSalida.S.SalidaDigi.flags |= 1;
			if(Chkabs.Checked) CSalida.S.SalidaDigi.flags |= 2;
			if(Chkabs2.Checked) CSalida.S.SalidaDigi.flags |= 4;
			if(Chkf.Checked) CSalida.S.SalidaDigi.flags |= 16;
			if(Chkmod.Checked) CSalida.S.SalidaDigi.flags |= 8;

			rutamod.s1=TxtRuta1.Text;
			rutamod.s2=TxtRuta2.Text;

			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Labelgrupo1.Text=get_texto(Textos.Cods.Ficheros_Digi1);
			Labelgrupo2.Text=get_texto(Textos.Cods.Ficheros_Digi2);
			Labelruta2.Text=Labelruta1.Text=get_texto(Textos.Cods.Directorio_de_generacin_relativo_a_fotos)+":";
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
