using System;
using PanelesSub;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Calibracion{
using static Textos.Cods;

	public class FormSalidaCalgra : ControlesAt.FormOpcionesAlgo{
		internal ControlesAt.LTIntegerSingle Txtx, Txty;
		string txt,txt2;

		public FormSalidaCalgra(IEntorno _Entorno, Control _Where, InterComCalibracion.CConfigGrafico _c_) : base(_Entorno,_Where,_c_){}
		protected override void InitializeComponent(){
			Txtx= new LTIntegerSingle();
			Txty= new LTIntegerSingle();
			this.ClientSize= new Size(252, 120);
			//
			// Txtx
			//
			Txtx.TextLocation= new Point(194, 22);		Txtx.TabIndex= 4;
			Txty.TextLocation= new Point(194, 48);	Txty.TabIndex= 5;
			//
			// Aceptar, Cancelar
			Aceptar.Location= new Point(40, 78);		this.Aceptar.Height-=2;
			Cancelar.Location= new Point(this.ClientSize.Width-40-Cancelar.Width, 78);		this.Cancelar.Height-=2;
			//
			// FormRk
			//
			this.Controls.Add(Txty);
			this.Controls.Add(Txtx);
		}

		protected override void set_data(object obj){
			InterComCalibracion.CConfigGrafico CSalida=(InterComCalibracion.CConfigGrafico)obj;

			Txtx.Text=CSalida.S.nx.ToString();
			Txty.Text=CSalida.S.ny.ToString();
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			InterComCalibracion.CConfigGrafico CSalida=(InterComCalibracion.CConfigGrafico)ref_to_Data;

			ushort n;
			try{n=UInt16.Parse(Txtx.Text);
				if(n<3) throw new Exception();
			}catch(System.Exception){
				Entorno.MessageBox.Show(txt + ", x. "+txt2);
				return;
			}
			CSalida.S.nx=n;

			try{n=UInt16.Parse(Txty.Text);
				if(n<3) throw new Exception();
			}catch(System.Exception){
				Entorno.MessageBox.Show(txt + ", y. "+txt2);
				return;
			}
			CSalida.S.ny=n;

			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Txtx.L.Text=Textos.get_texto(No_de_puntos_x,idioma);
			Txty.L.Text=Textos.get_texto(No_de_puntos_y,idioma);
			txt=Textos.get_texto(Valor_errneo_de_puntos_en_malla,idioma);
			txt2=Textos.get_texto(Tiene_que_ser_al_menos_2,idioma);
		}
	}
}

