using System;
using System.Windows.Forms;
using System.Drawing;
using Globales;

namespace ControlesAt
{
	public abstract class FormLabelMove : DependentForm
	{
		protected ControlesAt.PanelMoving Panel1;
		protected ControlesAt.BotAceptar Aceptar;
		protected ControlesAt.BotAceptar Cancelar;
		protected Control wheretoAdd;
		public new System.Windows.Forms.Control.ControlCollection Controls{
			get{
				if(wheretoAdd==null || wheretoAdd==this) return base.Controls;
				else return wheretoAdd.Controls;
		}	}

		public FormLabelMove(IEntorno _Entorno) : base(_Entorno){
			//
			// Panel1
			Panel1= new PanelMoving();
			Panel1.BorderStyle= BorderStyle.FixedSingle;
			Panel1.Dock= DockStyle.Fill;
			Panel1.TabIndex= 0;
			this.Controls.Add(Panel1);
			wheretoAdd=Panel1;

			InitializeComponent();
			this.BackColor=Globales.Colores.NETColor(Colores.cFormLabel);
			this.Aceptar.BackColor=Globales.Colores.NETColor(Colores.cAceptarFormLabel);
			this.Cancelar.BackColor=Globales.Colores.NETColor(Colores.cAceptarFormLabel);

			this.AcceptButton=(Button)Aceptar;
			this.CancelButton=(Button)Cancelar;
		}

		private void InitializeComponent(){
			Aceptar= new BotAceptar();
			Cancelar=new BotAceptar();
			//
			// Aceptar, Cancelar
			//
			Aceptar.Location= new Point(24, 64);		Aceptar.TabIndex= 1;
			Cancelar.Location= new Point(120, 64);		Cancelar.TabIndex= 2;
			Aceptar.Click+= new EventHandler(Aceptar_Click);
			Cancelar.Click+= new EventHandler(Cancelar_Click);
			//
			// FormLabel
			//
			this.Controls.Add(Cancelar);
			this.Controls.Add(Aceptar);
			this.FormBorderStyle= FormBorderStyle.None;
			this.Location= new Point(646, 141);
			this.StartPosition= System.Windows.Forms.FormStartPosition.Manual;
		}
		protected override Size DefaultSize{
			get{return new Size(204, 108);}
		}

		public void ShowAt(int x, int y){this.Location=new Point(x,y); this.Show();}
		protected virtual void Cancelar_Click(object sender,System.EventArgs e){this.Hide();}
		protected virtual void Aceptar_Click(object sender,System.EventArgs e){this.Hide();}

		protected override void update_idioma(){
			Aceptar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Aceptar,idioma);
			Cancelar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Cancelar,idioma);
		}
	}

	public abstract class FormAceptar : ControlesAt.FormLabelMove{
		public FormAceptar(IEntorno _Entorno) : base(_Entorno){
			Cancelar.Enabled=false;
			Cancelar.Visible=false;
			this.CancelButton=null;
			Aceptar.Left=(this.Width-Aceptar.Width)/2;
		}
	}
}