using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Calibracion
{
	public class ParameterBox : ContainerControl{
		private CheckBox box;
		private BaseLabel label;
		public ParameterBox(){
			box=new CheckBox();
			label=new BaseLabel();
			box.Dock=DockStyle.Left;
			label.Dock=DockStyle.Left;
			box.Size=new Size(44,16);
			this.Size=box.Size;
			this.Controls.Add(label);
			this.Controls.Add(box);
			label.SizeChanged+=new EventHandler(label_SizeChanged);
			box.CheckedChanged+=new EventHandler(OnBoxChechedChanged);
		}
		private void label_SizeChanged(object sender,EventArgs e){
			this.Width=label.Right;
		}

		public string letter{
			get{return box.Text;}
			set{box.Text=value;}
		}
		public string formula{
			get{return label.Text;}
			set{label.Text=value;}
		}

		public bool Checked{
			get{return box.Checked;}
			set{box.Checked=value;}
		}
		public event EventHandler CheckedChanged;
		private void OnBoxChechedChanged(object sender,EventArgs e){
			if(CheckedChanged!=null) CheckedChanged(this,e);
		}
	}
	public abstract class FormDistorsiones : DependentForm
	{
		protected System.Windows.Forms.ContainerControl ContainerInfo;
		protected System.Windows.Forms.ContainerControl PanelParams;
		protected ControlesAt.BaseLabel LabelParams;
		internal ControlesAt.BotAceptar Aceptar, Cancelar;

		protected abstract byte get_nparametros();
		protected byte _modelo;	//This must be set before the form is shown
		protected readonly string letra;	//and this
		public byte modelo{
			get{return _modelo;}
			set{if(value==_modelo) return;
				_modelo=value;
				formulas();
			}
		}
		private bool[] checkeds;
		public ParameterBox[] checkboxes;
		protected LabelRight[] labelformulas;
		public byte npar;
		public static Font FormulaeFont;

		public FormDistorsiones(IEntorno _Entorno, string letra) : base(_Entorno){
			FormulaeFont= new Font("Tahoma",8.25F);
			checkeds=new bool[get_nparametros()+1];
			checkboxes=new ParameterBox[get_nparametros()+1];
			InitializeComponent();
			this.letra=letra;
			_modelo=0;
			npar=0;
			colores();
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			ContainerInfo= new ContainerControl();
			PanelParams= new ContainerControl();
			LabelParams= new BaseLabel();
			Aceptar= new BotAceptar();
			Cancelar= new BotAceptar();
			//
			// ContainerInfo
			//
			ContainerInfo.Dock= DockStyle.Top;
			ContainerInfo.Size= new Size(440, 108);
			ContainerInfo.TabIndex= 0;
			ContainerInfo.Font= new Font("Arial", 8.25F);
			ContainerInfo.SizeChanged+= new EventHandler(PanelParams_BottomChanged);
			//
			//PanelParams
			//
			PanelParams.Dock= DockStyle.Top;
			PanelParams.Controls.Add(LabelParams);
			PanelParams.Size= new Size(440,88);
			PanelParams.Font=FormulaeFont;
			PanelParams.SizeChanged+= new EventHandler(PanelParams_BottomChanged);
			//
			// LabelParams
			//
			LabelParams.Font= new Font("Microsoft Sans Serif", 9.75F);
			LabelParams.RefLocation= new Point(28, 9);
			LabelParams.TabIndex= 0;
			//
			// checkboxes
			//
			for(int i=1;i<=get_nparametros();i++){
				checkboxes[i]=new ParameterBox();
				checkboxes[i].TabIndex=i;
				checkboxes[i].CheckedChanged+=new EventHandler(CheckBox_CheckedChanged);
				PanelParams.Controls.Add(checkboxes[i]);
			}
			//
			// Aceptar, Cancelar
			//
			Aceptar.Location= new Point(88, 212);			Aceptar.TabIndex= 2;
			Cancelar.Location= new Point(276, 212);		Cancelar.TabIndex=3;
			Cancelar.Click+= new EventHandler(Cancelar_Click);
			Aceptar.Click+= new EventHandler(Aceptar_Click);
			//
			// FormRadialAsimetrica
			//
			this.ClientSize= new Size(440, 252);
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.Controls.Add(this.PanelParams);
			this.Controls.Add(this.ContainerInfo);
			this.Controls.Add(Cancelar);
			this.Controls.Add(Aceptar);
			this.MaximizeBox= false;
			this.MinimizeBox= false;
		}
	#endregion

		protected override void OnLoad(System.EventArgs e){
			npar=0;
			for(int i=1;i<=get_nparametros();i++){
				if(checkeds[i]=checkboxes[i].Checked) npar++;
			}
			base.OnLoad(e);
		}
		private void Aceptar_Click(object sender,System.EventArgs e){
			this.Hide();
		}
		private void Cancelar_Click(object sender,System.EventArgs e){
			for(int i=1;i<=get_nparametros();i++){
				checkboxes[i].Checked=checkeds[i];
			}
			this.Hide();
		}

		private void PanelParams_BottomChanged(object sender,System.EventArgs e){
			Aceptar.Top=Cancelar.Top=ContainerInfo.Height+PanelParams.Height+16;
			this.ClientSize= new Size(this.ClientSize.Width,Aceptar.Top+40);
		}

		private void CheckBox_CheckedChanged(object sender,System.EventArgs e){
			if(((ParameterBox)sender).Checked) npar++;
			else npar--;
		}

		void colores(){
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cFormLabel);
			this.ContainerInfo.BackColor=Globales.Colores.NETColor(Globales.Colores.cAmarillo);
			this.Aceptar.BackColor=Globales.Colores.NETColor(Globales.Colores.cAceptarFormLabel);
			this.Cancelar.BackColor=Globales.Colores.NETColor(Globales.Colores.cAceptarFormLabel);
		}

		protected abstract void formulas();
	}
}
