using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Calibracion{
	public class FormCalExterna : DependentForm{
		private ControlesAt.BaseLabel		Label3,	Label4;
		internal ControlesAt.LabelCheck	ChkExternaX,	ChkExternaY,
												ChkExternaZ,	ChkExternaW,
												ChkExternaFI,	ChkExternak;
		internal ControlesAt.FloatTextBox	TextExternaXapr,	TextExternaXcon,
													TextExternaYapr,	TextExternaYcon,
													TextExternaZapr,	TextExternaZcon,
													TextExternaWapr,	TextExternaWcon,
													TextExternaFIapr,	TextExternaFIcon,
													TextExternakapr,	TextExternakcon;
		internal ControlesAt.LabelCheck[] ChkExterna;
		internal TextBox[] TextExternaapr;
		internal TextBox[] TextExternacon;

		public FormCalExterna(IEntorno _Entorno) : base(_Entorno){
			Label3= new BaseLabel();		Label4= new BaseLabel();
			ChkExternaX= new LabelCheck();				ChkExternaY= new LabelCheck();
			ChkExternaZ= new LabelCheck((short)5);		ChkExternaW= new LabelCheck();
			ChkExternaFI= new LabelCheck((short)3);		ChkExternak= new LabelCheck();
			TextExternaXapr= new FloatTextBox();		TextExternaXcon= new FloatTextBox();
			TextExternaYapr= new FloatTextBox();		TextExternaYcon= new FloatTextBox();
			TextExternaZapr= new FloatTextBox();		TextExternaZcon= new FloatTextBox();
			TextExternaWapr= new FloatTextBox();	TextExternaWcon= new FloatTextBox();
			TextExternaFIapr= new FloatTextBox();		TextExternaFIcon= new FloatTextBox();
			TextExternakapr= new FloatTextBox();		TextExternakcon= new FloatTextBox();

			ChkExterna=new LabelCheck[6];
			TextExternaapr= new TextBox[6];
			TextExternacon= new TextBox[6];
			ChkExterna[0]= ChkExternaX;
			ChkExterna[1]= ChkExternaY;
			ChkExterna[2]= ChkExternaZ;
			ChkExterna[3]= ChkExternaW;
			ChkExterna[4]= ChkExternaFI;
			ChkExterna[5]= ChkExternak;
			TextExternaapr[0]= TextExternaXapr;
			TextExternaapr[1]= TextExternaYapr;
			TextExternaapr[2]= TextExternaZapr;
			TextExternaapr[3]= TextExternaWapr;
			TextExternaapr[4]= TextExternaFIapr;
			TextExternaapr[5]= TextExternakapr;
			TextExternacon[0]= TextExternaXcon;
			TextExternacon[1]= TextExternaYcon;
			TextExternacon[2]= TextExternaZcon;
			TextExternacon[3]= TextExternaWcon;
			TextExternacon[4]= TextExternaFIcon;
			TextExternacon[5]= TextExternakcon;

			int pos=20;
			//
			// Label3, 4
			Label3.RefLocation= new Point(90, pos);	Label3.TabIndex= 0;	Label3.TextAlign= new TwoDimAlignment(0.5F,1);
			Label4.RefLocation= new Point(174, pos);	Label4.TabIndex= 1;	Label4.TextAlign= new TwoDimAlignment(0.5F,1);	pos+=6;
			//
			// ChkExternas
			//
			for(int i=0;i<6;i++,pos+=20){
				ChkExterna[i].TextLocation= new Point(32, pos-2);	TextExternaapr[i].Location= new Point(52, pos);		TextExternacon[i].Location= new Point(136, pos);
				TextExternacon[i].Enabled=false;
				ChkExterna[i].TabIndex=i+2;		TextExternaapr[i].TabIndex=i+8;		TextExternacon[i].TabIndex=i+14;
				ChkExterna[i].CheckedChanged+=new EventHandler(ChkExterna_CheckedChanged);
			}
			ChkExternaX.Text="X";
			ChkExternaY.Text="Y";
			ChkExternaZ.Text="Z";
			ChkExternaW.L.Font= new Font("Symbol", 8.25F, FontStyle.Regular, GraphicsUnit.Point, (System.Byte)2);
			ChkExternaW.Text="W";
			ChkExternaFI.L.Font=ChkExternaW.L.Font;	ChkExternaFI.Text= "F";
			ChkExternak.L.Font=ChkExternaW.L.Font;	ChkExternak.Text= "K";
			//
			TextExternaWapr.Text= "0";
			TextExternaFIapr.Text= "0";
			//
			// this
			//
			this.FormBorderStyle= FormBorderStyle.FixedToolWindow;
			this.ClientSize= new Size(220, 152);
			this.Controls.AddRange(new Control[]{
				Label3, Label4,
				ChkExternaX,		TextExternaXcon,	TextExternaXapr,
				ChkExternaY,		TextExternaYcon,	TextExternaYapr,
				ChkExternaZ,		TextExternaZcon,	TextExternaZapr,
				ChkExternaW,		TextExternaWcon,	TextExternaWapr,
				ChkExternaFI,		TextExternaFIcon,	TextExternaFIapr,
				ChkExternak,		TextExternakcon,	TextExternakapr
			});
			this.StartPosition= System.Windows.Forms.FormStartPosition.Manual;
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
		}

		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

		void ChkExterna_CheckedChanged(Object sender,System.EventArgs e){
			int i=((Control)sender).TabIndex-2;
			if(ChkExterna[i].Checked){
				TextExternacon[i].Enabled=false;
				TextExternaapr[i].Enabled=true;
				if(i!=3 && i!=4) TextExternaapr[i].BackColor= Globales.Colores.NETColor(Globales.Colores.cOpcional);
			}else{
				if(i!=3 && i!=4) TextExternaapr[i].BackColor= TextBox.DefaultBackColor;
				TextExternaapr[i].Enabled=false;
				TextExternacon[i].Enabled=true;
			}
		}

		protected override void update_idioma(){
			this.Text=Textos.get_texto(Textos.Cods.Orientacin_externa,idioma);
			Label3.Text=Textos.get_texto(Textos.Cods.Aproximado,idioma);
			Label4.Text=Textos.get_texto(Textos.Cods.Conocido,idioma);
		}
	}
}
