using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
using static Textos.Cods;

	public delegate void EventVoid();
	/// <summary>
	/// Descripcin breve de FormBuscar.
	/// </summary>
	public class FormBuscar : DependentForm{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtbuscar;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox txtreemplazar;
		private ControlesAt.BotAceptar Buscar;
		private ControlesAt.BotAceptar Reemplazar;
		private ControlesAt.BotAceptar Reemplazartodo;

		public FormBuscar(IEntorno _Entorno) : base(_Entorno){
			InitializeComponent();

			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			this.Buscar.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			this.Reemplazar.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			this.Reemplazartodo.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			this.AcceptButton=Buscar;
			Estado=false;
		}

	#region InitializeComponent
		private void InitializeComponent()	{
			label1= new Label();
			txtbuscar= new TextBox();
			label2= new Label();
			txtreemplazar= new TextBox();
			Buscar= new BotAceptar();
			Reemplazar= new BotAceptar();
			Reemplazartodo= new BotAceptar();
			//
			// label1
			//
			label1.FlatStyle= FlatStyle.System;
			label1.Location= new Point(36, 16);
			label1.Size= new Size(48, 16);
			label1.TabIndex= 0;
			label1.TextAlign= ContentAlignment.TopRight;
			//
			// txtbuscar
			//
			txtbuscar.Location= new Point(88, 12);
			txtbuscar.Size= new Size(196, 20);
			txtbuscar.TabIndex= 1;
			//
			// label2
			//
			label2.FlatStyle= FlatStyle.System;
			label2.Location= new Point(4, 48);
			label2.Size= new Size(80, 16);
			label2.TabIndex= 2;
			label2.TextAlign= ContentAlignment.TopRight;
			//
			// txtreemplazar
			//
			txtreemplazar.Location= new Point(88, 44);
			txtreemplazar.Size= new Size(196, 20);
			txtreemplazar.TabIndex= 3;
			//
			// Buscar
			//
			Buscar.Location= new Point(296, 12);
			Buscar.Size= new Size(73, 20);
			Buscar.TabIndex= 4;
			Buscar.Click+= new EventHandler(Buscar_Click);
			//
			// Reemplazar
			//
			Reemplazar.Location= new Point(296, 44);
			Reemplazar.Size= new Size(73, 20);
			Reemplazar.TabIndex= 5;
			Reemplazar.Click+= new EventHandler(Reemplazar_Click);
			//
			// Reemplazartodo
			//
			Reemplazartodo.Location= new Point(264, 76);
			Reemplazartodo.Size= new Size(105, 20);
			Reemplazartodo.TabIndex= 6;
			Reemplazartodo.Click+= new EventHandler(Reemplazartodo_Click);
			//
			// FormBuscar
			//
			this.ClientSize= new Size(378, 106);
			this.Controls.Add(Reemplazartodo);
			this.Controls.Add(Reemplazar);
			this.Controls.Add(Buscar);
			this.Controls.Add(txtreemplazar);
			this.Controls.Add(label2);
			this.Controls.Add(txtbuscar);
			this.Controls.Add(label1);
			this.FormBorderStyle= FormBorderStyle.FixedToolWindow;
			this.MaximizeBox= false;
			this.MinimizeBox= false;
			//this.TopMost=true;	//No debera ser necesario, y no es correcto, pero Windows, para variar, falla.
		}
	#endregion

		public string Tbuscar,Treemplazar;
		public event EventVoid busca, reemplaza, reemplazatodo;
		private bool estado;
		public bool Estado{
			get{return estado;}
			set{
				estado=value;
				if(estado==false){
					if(this.Visible) this.Text=get_texto(BuscarReemplazar);
					Reemplazar.Enabled=true;
				}else{
					if(this.Visible) this.Text=get_texto(BR_entodos);
					Reemplazar.Enabled=false;
				}
			}
		}

		protected override void OnLoad(System.EventArgs e){
			Tbuscar=txtbuscar.Text;
			Treemplazar=txtreemplazar.Text;
			base.OnLoad(e);
		}

		private void Buscar_Click(object sender,System.EventArgs e){
			Tbuscar=txtbuscar.Text;
			Treemplazar=txtreemplazar.Text;
			busca();
		}

		private void Reemplazar_Click(object sender,System.EventArgs e){
			Tbuscar=txtbuscar.Text;
			Treemplazar=txtreemplazar.Text;
			reemplaza();
		}

		private void Reemplazartodo_Click(object sender,System.EventArgs e){
			Tbuscar=txtbuscar.Text;
			Treemplazar=txtreemplazar.Text;
			reemplazatodo();
		}
		protected override void update_idioma(){
			if(estado==false) this.Text=get_texto(BuscarReemplazar);
			else this.Text=get_texto(BR_entodos);

			label1.Text=get_texto(Textos.Cods.Buscar)+":";
			label2.Text=get_texto(Textos.Cods.Reemplazar)+":";
			Buscar.Text=get_texto(Textos.Cods.Buscar);
			Reemplazar.Text=get_texto(Textos.Cods.Reemplazar);
			Reemplazartodo.Text=get_texto(Reemplazar_todo);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
