using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace ControlesAt{
	public enum BorderMode : byte{FormFixed,FormSizable,PanelFixed,PanelSizable,PanelSizableAll}

	public class FormBorde : ControlesAt.FormAerotri{
		private ControlesAt.NoControl	label1, label2, label3, label4,
												label5, label6, label7, label8,
												label9, label10, label11, label12,
												label13, label14, label15,
												label16, label17, label18, label19,
												label20, label21, label22,
												label23, label24, label25, label26;
		protected System.Windows.Forms.Panel PanelTotal;
		private System.Windows.Forms.Panel	PanelNW,	PanelNE,
														PanelSW,		PanelSE;

		readonly MouseEventHandler mouseDown;
		readonly MouseEventHandler mouseUp;

		private new System.Windows.Forms.FormBorderStyle FormBorderSytle;	//Hide this property
		public new Size ClientSize{
			get{return base.ClientSize-new Size(extrasize.Width,extrasize.Height);}
			set{base.ClientSize=value + new Size(extrasize.Width,extrasize.Height);}
		}

		private Size extrasize;
		private Size[] extrasizes;
		private byte bordermode;
		bool eventson;
		bool ss;
		int X0,Y0,DX,DY;

		public FormBorde()
		{
			extrasizes=new Size[256];
			extrasizes[255]=new Size(0,0);
			extrasizes[0]=new Size(0,0);
			extrasizes[1]=new Size(0,0);
			extrasizes[2]=new Size(8,8);
			extrasizes[3]=new Size(8,8);
			extrasizes[4]=new Size(8,8);
			extrasize=extrasizes[0];

			mouseDown= new MouseEventHandler(LabelsBorde_MouseDown);
			mouseUp= new MouseEventHandler(LabelsBorde_MouseUp);
			InitializeComponent();

			label1.MouseUp+= mouseUp;
			label8.MouseUp+= mouseUp;
			label10.MouseUp+=mouseUp;
			label3.MouseUp+= mouseUp;
			label4.MouseUp+= mouseUp;
			label11.MouseUp+=mouseUp;
			label6.MouseUp+= mouseUp;
			label7.MouseUp+= mouseUp;
			label12.MouseUp+=mouseUp;

			label13.MouseDown+= mouseDown;
			label14.MouseDown+= mouseDown;
			label15.MouseDown+= mouseDown;
			label13.MouseMove+= new MouseEventHandler(PanelSE_MouseMove);
			label14.MouseMove+= new MouseEventHandler(PanelSE_MouseMove);
			label15.MouseMove+= new MouseEventHandler(PanelSE_MouseMove);
			label13.MouseUp+= mouseUp;
			label14.MouseUp+= mouseUp;
			label15.MouseUp+= mouseUp;

			label16.MouseDown+= mouseDown;
			label17.MouseDown+= mouseDown;
			label18.MouseDown+= mouseDown;
			label19.MouseDown+= mouseDown;
			label16.MouseMove+= new MouseEventHandler(PanelSW_MouseMove);
			label17.MouseMove+= new MouseEventHandler(PanelSW_MouseMove);
			label18.MouseMove+= new MouseEventHandler(PanelSW_MouseMove);
			label19.MouseMove+= new MouseEventHandler(PanelSW_MouseMove);
			label16.MouseUp+= mouseUp;
			label17.MouseUp+= mouseUp;
			label18.MouseUp+= mouseUp;
			label19.MouseUp+= mouseUp;

			label20.MouseDown+= mouseDown;
			label21.MouseDown+= mouseDown;
			label22.MouseDown+= mouseDown;
			label20.MouseMove+= new MouseEventHandler(PanelNW_MouseMove);
			label21.MouseMove+= new MouseEventHandler(PanelNW_MouseMove);
			label22.MouseMove+= new MouseEventHandler(PanelNW_MouseMove);
			label20.MouseUp+= mouseUp;
			label21.MouseUp+= mouseUp;
			label22.MouseUp+= mouseUp;

			label23.MouseDown+= mouseDown;
			label24.MouseDown+= mouseDown;
			label25.MouseDown+= mouseDown;
			label26.MouseDown+= mouseDown;
			label23.MouseMove+= new MouseEventHandler(PanelNE_MouseMove);
			label24.MouseMove+= new MouseEventHandler(PanelNE_MouseMove);
			label25.MouseMove+= new MouseEventHandler(PanelNE_MouseMove);
			label26.MouseMove+= new MouseEventHandler(PanelNE_MouseMove);
			label23.MouseUp+= mouseUp;
			label24.MouseUp+= mouseUp;
			label25.MouseUp+= mouseUp;
			label26.MouseUp+= mouseUp;

			eventson=false;
			bordermode=255;
			BorderMode=0;
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			label1= new NoControl();		label2= new NoControl();	label3= new NoControl();		label4= new NoControl();
			label5= new NoControl();		label6= new NoControl();	label7= new NoControl();		label8= new NoControl();
			label10= new NoControl();	label9= new NoControl();	label11=new NoControl();		label12=new NoControl();
			PanelTotal= new Panel();
			PanelSE= new Panel();
				label13= new NoControl();
				label14= new NoControl();
				label15= new NoControl();
			PanelSW= new Panel();
				label16= new NoControl();
				label17= new NoControl();
				label18= new NoControl();
				label19= new NoControl();
			PanelNW= new Panel();
				label20= new NoControl();
				label21= new NoControl();
				label22= new NoControl();
			PanelNE= new Panel();
				label23= new NoControl();
				label24= new NoControl();
				label25= new NoControl();
				label26= new NoControl();
			//
			// label1
			//
			label1.BackColor= System.Drawing.SystemColors.Control;
			label1.Dock= DockStyle.Left;
			label1.Location= new Point(0, 0);
			label1.Size= new Size(1, 275);
			label1.TabIndex= 2;
			//
			// label2
			//
			label2.BackColor= System.Drawing.SystemColors.Control;
			label2.Dock= DockStyle.Top;
			label2.Location= new Point(1, 0);
			label2.Size= new Size(290, 1);
			label2.TabIndex= 3;
			//
			// label3
			//
			label3.BackColor= System.Drawing.SystemColors.ControlDarkDark;
			label3.Dock= DockStyle.Right;
			label3.Location= new Point(291, 0);
			label3.Size= new Size(1, 276);
			label3.TabIndex= 4;
			//
			// label4
			//
			label4.BackColor= System.Drawing.SystemColors.ControlDark;
			label4.Dock= DockStyle.Right;
			label4.Location= new Point(290, 1);
			label4.Size= new Size(1, 274);
			label4.TabIndex= 5;
			//
			// label5
			//
			label5.BackColor= System.Drawing.SystemColors.ControlLightLight;
			label5.Dock= DockStyle.Top;
			label5.Location= new Point(2, 1);
			label5.Size= new Size(288, 1);
			label5.TabIndex= 6;
			//
			// label6
			//
			label6.BackColor= System.Drawing.SystemColors.ControlDarkDark;
			label6.Dock= DockStyle.Bottom;
			label6.Location= new Point(0, 275);
			label6.Size= new Size(291, 1);
			label6.TabIndex= 7;
			//
			// label7
			//
			label7.BackColor= System.Drawing.SystemColors.ControlDark;
			label7.Dock= DockStyle.Bottom;
			label7.Location= new Point(1, 274);
			label7.Size= new Size(289, 1);
			label7.TabIndex= 8;
			//
			// label8
			//
			label8.BackColor= System.Drawing.SystemColors.ControlLightLight;
			label8.Dock= DockStyle.Left;
			label8.Location= new Point(1, 1);
			label8.Size= new Size(1, 273);
			label8.TabIndex= 9;
			//
			// label10
			//
			label10.BackColor= System.Drawing.SystemColors.Control;
			label10.Dock= DockStyle.Left;
			label10.Location= new Point(2, 2);
			label10.Size= new Size(2, 270);
			label10.TabIndex= 11;
			//
			// label9
			//
			label9.BackColor= System.Drawing.SystemColors.Control;
			label9.Dock= DockStyle.Top;
			label9.Location= new Point(4, 2);
			label9.Size= new Size(284, 2);
			label9.TabIndex= 10;
			//
			// label11
			//
			label11.BackColor= System.Drawing.SystemColors.Control;
			label11.Dock= DockStyle.Right;
			label11.Location= new Point(288, 2);
			label11.Size= new Size(2, 270);
			label11.TabIndex= 12;
			//
			// label12
			//
			label12.BackColor= System.Drawing.SystemColors.Control;
			label12.Dock= DockStyle.Bottom;
			label12.Location= new Point(2, 272);
			label12.Size= new Size(288, 2);
			label12.TabIndex= 13;
			//
			// PanelTotal
			//
			PanelTotal.Dock= DockStyle.Fill;
			PanelTotal.Location= new Point(4, 4);
			PanelTotal.Size= new Size(284, 268);
			PanelTotal.TabIndex= 14;
			PanelTotal.ControlAdded+= new ControlEventHandler(PanelTotal_ControlAdded);
			//
			// label13
			//
			label13.BackColor= System.Drawing.SystemColors.ControlDarkDark;
			label13.Cursor= Cursors.SizeNWSE;
			label13.Location= new Point(0, 0);
			label13.Size= new Size(4, 4);
			label13.TabIndex= 0;
			//
			// label14
			//
			label14.BackColor= System.Drawing.SystemColors.ControlDark;
			label14.Cursor= Cursors.SizeNWSE;
			label14.Location= new Point(0, 0);
			label14.Size= new Size(3, 3);
			label14.TabIndex= 1;
			//
			// label15
			//
			label15.BackColor= System.Drawing.SystemColors.Control;
			label15.Cursor= Cursors.SizeNWSE;
			label15.Location= new Point(0, 0);
			label15.Size= new Size(2, 2);
			label15.TabIndex= 2;
			//
			// label16
			//
			label16.BackColor= System.Drawing.SystemColors.ControlDarkDark;
			label16.Cursor= Cursors.SizeNESW;
			label16.Location= new Point(0, 3);
			label16.Size= new Size(4, 1);
			label16.TabIndex= 0;
			//
			// label17
			//
			label17.BackColor= System.Drawing.SystemColors.Control;
			label17.Cursor= Cursors.SizeNESW;
			label17.Location= new Point(0, 0);
			label17.Size= new Size(4, 3);
			label17.TabIndex= 1;
			//
			// label18
			//
			label18.BackColor= System.Drawing.SystemColors.ControlDark;
			label18.Cursor= Cursors.SizeNESW;
			label18.Location= new Point(1, 2);
			label18.Size= new Size(3, 1);
			label18.TabIndex= 2;
			//
			// label19
			//
			label19.BackColor= System.Drawing.SystemColors.ControlLightLight;
			label19.Cursor= Cursors.SizeNESW;
			label19.Location= new Point(1, 0);
			label19.Size= new Size(1, 2);
			label19.TabIndex= 3;
			//
			// label20
			//
			label20.BackColor= System.Drawing.SystemColors.Control;
			label20.Cursor= Cursors.SizeNWSE;
			label20.Location= new Point(0, 0);
			label20.Size= new Size(4, 4);
			label20.TabIndex= 0;
			//
			// label21
			//
			label21.BackColor= System.Drawing.SystemColors.ControlLightLight;
			label21.Cursor= Cursors.SizeNWSE;
			label21.Location= new Point(1, 1);
			label21.Size= new Size(3, 3);
			label21.TabIndex= 1;
			//
			// label22
			//
			label22.BackColor= System.Drawing.SystemColors.Control;
			label22.Cursor= Cursors.SizeNWSE;
			label22.Location= new Point(2, 2);
			label22.Size= new Size(2, 2);
			label22.TabIndex= 2;
			//
			// label23
			//
			label23.BackColor= System.Drawing.SystemColors.ControlDarkDark;
			label23.Cursor= Cursors.SizeNESW;
			label23.Location= new Point(3, 0);
			label23.Size= new Size(1, 4);
			label23.TabIndex= 0;
			//
			// label24
			//
			label24.BackColor= System.Drawing.SystemColors.Control;
			label24.Cursor= Cursors.SizeNESW;
			label24.Location= new Point(0, 0);
			label24.Size= new Size(3, 4);
			label24.TabIndex= 1;
			//
			// label25
			//
			label25.BackColor= System.Drawing.SystemColors.ControlDark;
			label25.Cursor= Cursors.SizeNESW;
			label25.Location= new Point(2, 1);
			label25.Size= new Size(1, 3);
			label25.TabIndex= 2;
			//
			// label26
			//
			label26.BackColor= System.Drawing.SystemColors.ControlLightLight;
			label26.Cursor= Cursors.SizeNESW;
			label26.Location= new Point(0, 1);
			label26.Size= new Size(2, 1);
			label26.TabIndex= 3;
			//
			// PanelSE
			//
			PanelSE.Controls.Add(label15);
			PanelSE.Controls.Add(label14);
			PanelSE.Controls.Add(label13);
			PanelSE.Location= new Point(288, 272);
			PanelSE.Size= new Size(4, 4);
			PanelSE.TabIndex= 15;
			//
			// PanelSW
			//
			PanelSW.Controls.Add(label19);
			PanelSW.Controls.Add(label18);
			PanelSW.Controls.Add(label17);
			PanelSW.Controls.Add(label16);
			PanelSW.Location= new Point(0, 272);
			PanelSW.Size= new Size(4, 4);
			PanelSW.TabIndex= 16;
			//
			// PanelNW
			//
			PanelNW.Controls.Add(label22);
			PanelNW.Controls.Add(label21);
			PanelNW.Controls.Add(label20);
			PanelNW.Location= new Point(0, 0);
			PanelNW.Size= new Size(4, 4);
			PanelNW.TabIndex= 17;
			//
			// PanelNE
			//
			PanelNE.Controls.Add(label26);
			PanelNE.Controls.Add(label25);
			PanelNE.Controls.Add(label24);
			PanelNE.Controls.Add(label23);
			PanelNE.Location= new Point(288, 0);
			PanelNE.Size= new Size(4, 4);
			PanelNE.TabIndex= 18;
			//
			// FormBorde
			//
			this.BackColor= Color.FromArgb(232, 229, 222);
			base.ClientSize= new Size(292, 276);
			this.Controls.Add(this.PanelNW);
			this.Controls.Add(this.PanelNE);
			this.Controls.Add(this.PanelSW);
			this.Controls.Add(this.PanelSE);
			this.Controls.Add(this.PanelTotal);
			this.Controls.Add(label9);
			this.Controls.Add(label10);
			this.Controls.Add(label11);
			this.Controls.Add(label12);
			this.Controls.Add(label5);
			this.Controls.Add(label8);
			this.Controls.Add(label7);
			this.Controls.Add(label4);
			this.Controls.Add(label2);
			this.Controls.Add(label1);
			this.Controls.Add(label6);
			this.Controls.Add(label3);
			base.FormBorderStyle= FormBorderStyle.None;
			this.Deactivate+= new EventHandler(FormBorde_Deactivate);
		}
	#endregion

		protected override void OnLoad(System.EventArgs e){
			ss=false;
			base.OnLoad(e);
		}
		protected override void OnSizeChanged(EventArgs e){
			base.OnSizeChanged (e);
			this.PanelSE.Location=new Point(base.ClientSize-PanelSE.Size);
			this.PanelSW.Location=new Point(0,base.ClientSize.Height-PanelSW.Height);
			this.PanelNW.Location=new Point(0,0);
			this.PanelNE.Location=new Point(base.ClientSize.Width-PanelNE.Width,0);
		}

		public BorderMode BorderMode{
		  get{
			return (BorderMode)bordermode;
		  }
		  set{
			switch(value){
				case BorderMode.FormFixed:
					base.FormBorderStyle=FormBorderStyle.FixedSingle;
					this.MaximizeBox=false;
					if(bordermode==(byte)value) return;
					Labels_visiblefalse();
					break;
				case BorderMode.FormSizable:
					base.FormBorderStyle=FormBorderStyle.Sizable;
					this.MaximizeBox=true;
					if(bordermode==(byte)value) return;
					Labels_visiblefalse();
					break;
				case BorderMode.PanelFixed:
					base.FormBorderStyle=FormBorderStyle.None;
					if(bordermode==(byte)value) return;
					Labels_visibletrue();
					Labels_cursores_default();
					break;
				case BorderMode.PanelSizable:
					base.FormBorderStyle=FormBorderStyle.None;
					if(bordermode==(byte)value) return;
					Labels_visibletrue();
					Labels_cursores();
					break;
				case BorderMode.PanelSizableAll:
					base.FormBorderStyle=FormBorderStyle.None;
					if(bordermode==(byte)value) return;
					Labels_cursores_all();
					break;
			  };
			  base.ClientSize+=extrasizes[(byte)value]-extrasizes[bordermode];
			  extrasize=extrasizes[(byte)value];
			  bordermode=(byte)value;
		  }
		}

		void Labels_visiblefalse(){
			label1.Visible=false; label2.Visible=false; label3.Visible=false; label4.Visible=false;
			label5.Visible=false; label6.Visible=false; label7.Visible=false; label8.Visible=false;
			label9.Visible=false; label10.Visible=false; label11.Visible=false; label12.Visible=false;
			PanelSE.Visible=false;
			PanelSW.Visible=false;
			PanelNW.Visible=false;
			PanelNE.Visible=false;
		}
		void Labels_visibletrue(){
			label9.Visible=true; label10.Visible=true; label11.Visible=true; label12.Visible=true;
			label4.Visible=true; label5.Visible=true; label7.Visible=true; label8.Visible=true;
			label3.Visible=true; label6.Visible=true; label1.Visible=true; label2.Visible=true;
		}

		void Labels_cursores(){
			PanelNW.Visible=false;
			PanelNE.Visible=false;
			PanelSE.Visible=true;
			PanelSW.Visible=true;
			label1.Cursor=label8.Cursor=label10.Cursor=Cursors.SizeWE;
			label3.Cursor=label4.Cursor=label11.Cursor=Cursors.SizeWE;
			label6.Cursor=label7.Cursor=label12.Cursor=Cursors.SizeNS;

			if(eventson==true) return;
			label1.MouseDown+= mouseDown;
			label8.MouseDown+= mouseDown;
			label10.MouseDown+=mouseDown;
			label1.MouseMove+= new MouseEventHandler(LabelIzquierda_MouseMove);
			label8.MouseMove+= new MouseEventHandler(LabelIzquierda_MouseMove);
			label10.MouseMove+=new MouseEventHandler(LabelIzquierda_MouseMove);

			label3.MouseDown+= mouseDown;
			label4.MouseDown+= mouseDown;
			label11.MouseDown+=mouseDown;
			label3.MouseMove+= new MouseEventHandler(LabelDerecha_MouseMove);
			label4.MouseMove+= new MouseEventHandler(LabelDerecha_MouseMove);
			label11.MouseMove+=new MouseEventHandler(LabelDerecha_MouseMove);

			label6.MouseDown+= mouseDown;
			label7.MouseDown+= mouseDown;
			label12.MouseDown+=mouseDown;
			label6.MouseMove+= new MouseEventHandler(LabelAbajo_MouseMove);
			label7.MouseMove+= new MouseEventHandler(LabelAbajo_MouseMove);
			label12.MouseMove+=new MouseEventHandler(LabelAbajo_MouseMove);
			eventson=true;
		}
		void Labels_cursores_all(){
			Labels_cursores();
			PanelNW.Visible=true;
			PanelNE.Visible=true;
		}
		void Labels_cursores_default(){
			PanelSE.Visible=false;
			PanelSW.Visible=false;
			PanelNW.Visible=false;
			PanelNE.Visible=false;
			label1.Cursor=label8.Cursor=label10.Cursor=Cursors.Default;
			label3.Cursor=label4.Cursor=label11.Cursor=Cursors.Default;
			label6.Cursor=label7.Cursor=label12.Cursor=Cursors.Default;

			if(eventson==false) return;
			label1.MouseDown-=mouseDown;
			label8.MouseDown-=mouseDown;
			label10.MouseDown-=mouseDown;
			label1.MouseMove-= new MouseEventHandler(LabelIzquierda_MouseMove);
			label8.MouseMove-= new MouseEventHandler(LabelIzquierda_MouseMove);
			label10.MouseMove-=new MouseEventHandler(LabelIzquierda_MouseMove);

			label3.MouseDown-=mouseDown;
			label4.MouseDown-=mouseDown;
			label11.MouseDown-=mouseDown;
			label3.MouseMove-= new MouseEventHandler(LabelDerecha_MouseMove);
			label4.MouseMove-= new MouseEventHandler(LabelDerecha_MouseMove);
			label11.MouseMove-=new MouseEventHandler(LabelDerecha_MouseMove);

			label6.MouseDown-=mouseDown;
			label7.MouseDown-=mouseDown;
			label12.MouseDown-=mouseDown;
			label6.MouseMove-= new MouseEventHandler(LabelAbajo_MouseMove);
			label7.MouseMove-= new MouseEventHandler(LabelAbajo_MouseMove);
			label12.MouseMove-=new MouseEventHandler(LabelAbajo_MouseMove);
			eventson=false;
		}

		private void PanelTotal_ControlAdded(object sender,ControlEventArgs e){
			this.ClientSize=this.PanelTotal.Size=e.Control.Size;
		}

	#region Labels Mouse_Down,_Move,_Up (Form.Resize)
		private void LabelsBorde_MouseDown(object sender,MouseEventArgs e){
			if(e.Button != MouseButtons.Left) return;
			X0= e.X;
			Y0= e.Y;
			ss= true;
		}
		private void LabelDerecha_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DX=e.X-X0;
			this.Size+= new Size(DX,0);
		}
		private void LabelIzquierda_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DX=e.X-X0;
			if(this.Width-DX < this.MinimumSize.Width) DX=this.Width-this.MinimumSize.Width;
			this.Left+=DX;		//Size tiene que cambiarse despus para que el delegado llamado por
			this.Size+= new Size(-DX,0);	//Size_Changed se ejecute con el valor de Location correcto
		}
		private void LabelAbajo_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DY=e.Y-Y0;
			this.Size+= new Size(0,DY);
		}
		private void LabelArriba_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DY=e.Y-Y0;
			if(this.Height-DY < this.MinimumSize.Height) DY=this.Height-this.MinimumSize.Height;
			this.Top+=DY;
			this.Size+= new Size(0,-DY);
		}
		private void PanelSE_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DX=e.X-X0;
			DY=e.Y-Y0;
			this.Size+= new Size(DX,DY);
		}
		private void PanelSW_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DX=e.X-X0;
			DY=e.Y-Y0;
			if(this.Width-DX < this.MinimumSize.Width) DX=this.Width-this.MinimumSize.Width;
			this.Left+=DX;
			this.Size+= new Size(-DX,DY);
		}
		private void PanelNE_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DX=e.X-X0;
			DY=e.Y-Y0;
			if(this.Height-DY < this.MinimumSize.Height) DY=this.Height-this.MinimumSize.Height;
			this.Top+=DY;
			this.Size+= new Size(DX,-DY);
		}
		private void PanelNW_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			DX=e.X-X0;
			DY=e.Y-Y0;
			if(this.Width-DX < this.MinimumSize.Width) DX=this.Width-this.MinimumSize.Width;
			if(this.Height-DY < this.MinimumSize.Height) DY=this.Height-this.MinimumSize.Height;
			this.Left+=DX;
			this.Top+=DY;
			this.Size+= new Size(-DX,-DY);
		}

		protected virtual void LabelsBorde_MouseUp(object sender,MouseEventArgs e){
			ss=false;
		}
		private void FormBorde_Deactivate(object sender,System.EventArgs e){
			ss=false;
		}
	#endregion
	}
}
