using System.Windows.Forms;
using Globales;

namespace ControlesAt{
	public interface IIdioma{
		Idioma Idioma{get;}
		void set_idioma(Idioma _idioma);
	}
	public class FormAerotri : Form, IIdioma{
	#region vectores
		protected class vectorbool{
			public bool[] elems;
			public int n;
			private int N;
			public vectorbool(){elems=null; n=N=0;}
			public void set_size(int m){
				if(m>N){
					int k,i;
					k=N;
					N<<=1;
					if(m>N) N=m;
					bool[] _elems=new bool[k];
					for(i=0;i<k;i++) _elems[i]=elems[i];
					elems=new bool[N];
					for(i=0;i<k;i++) elems[i]=_elems[i];
				}
				n=m;
			}
		}
		protected class vectorForm{
			public Form[] elems;
			public int n;
			private int N;
			public vectorForm(){elems=null; n=N=0;}
			public void set_size(int m){
				if(m>N){
					int k,i;
					k=N;
					N<<=1;
					if(m>N) N=m;
					Form[] _elems=new Form[k];
					for(i=0;i<k;i++) _elems[i]=elems[i];
					elems=new Form[N];
					for(i=0;i<k;i++) elems[i]=_elems[i];
				}
				n=m;
			}
		}
	#endregion
		protected vectorbool visibles;
		protected vectorForm myOwnedForms;
		protected Idioma idioma;
		public Idioma Idioma{
			get{return idioma;}
		}
		public virtual void set_idioma(Idioma _idioma){
			if(idioma==_idioma) return;
			idioma=_idioma;
			update_idioma();
		}
		protected virtual void update_idioma(){}

		public FormAerotri(){
			this.AutoScaleBaseSize= new System.Drawing.Size(5, 13);
			myOwnedForms=new vectorForm();
			visibles=new vectorbool();
			idioma=Idioma.Esp;	//default
		}
		public void DoShow(){
			if(!this.Visible) base.Show();
			this.Opacity=100;
			int i,n;
			n=myOwnedForms.n;
			for(i=0;i<n;i++){
				if(visibles.elems[i]){try{
					((FormAerotri)myOwnedForms.elems[i]).DoShow();
				}catch(System.Exception){
					try{if(!myOwnedForms.elems[i].Visible) myOwnedForms.elems[i].Show();
						myOwnedForms.elems[i].Opacity=100;}
					catch(System.Exception){}
				}}
			}
		}
		public void DoDisappear(){
			int i,n;
			n=this.OwnedForms.Length;
			myOwnedForms.set_size(n);
			visibles.set_size(n);
			for(i=0;i<n;i++){
				myOwnedForms.elems[i]=OwnedForms[i];
				visibles.elems[i]=OwnedForms[i].Visible;
			}
			for(i=0;i<n;i++){
				if(visibles.elems[i]){try{
					((FormAerotri)myOwnedForms.elems[i]).DoDisappear();
				}catch(System.Exception){
					try{myOwnedForms.elems[i].Opacity=0;}
					catch(System.Exception){}
				}}
			}
			this.Opacity=0;
		}
	}
	public class IdiomaControl : UserControl, IIdioma{
		protected Idioma idioma;
		public Idioma Idioma{
			get{return idioma;}
		}
		public virtual void set_idioma(Idioma _idioma){
			if(idioma==_idioma) return;
			idioma=_idioma;
			update_idioma();
		}
		protected virtual void update_idioma(){}
	}
}
