using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;
using Calibracion;

namespace Aerotri{
using static Textos.Cods;

	public struct CDistorsionCheckeds{
		public bool distorsion;
		public bool radsim, tansim;
		public bool asimetricas;
	}
	public class CConfigInterna{
		public InterComAerotri.AutoClibCheckeds DChk;
		public Calibracion.InterComCalibracion.ConfigDistorsion S;
	}

	public class FormAutoCalib : ControlesAt.FormOpcionesAlgo
	{
		private ControlesAt.BaseLabel Label2;
		private ControlesAt.LabelCheck	Chkf, Chkpp;
		private CheckBox Chkdistorsion;
		private GroupBox GBoxdistorsion;
		private ControlesAt.LabelRight Labelpoli;
		internal ComboBox CBoxpoli;
		private Panel Paneldistorsion;
		private ControlesAt.ChkSalida Chkradial, Chktangencial;
		private ControlesAt.LabelCheck Chkasim;
		internal ComboBox CBoxasim;
		private ContainerControl PanelAsim;
		private Calibracion.LblParametros	lbl_radsim,	lbl_tansim,
													lbl_radasim,	lbl_tanasim,
													lbl_uvserie1,	lbl_uvserie2;
		public FormSimetrica FRadial1, FTangencial1;
		public FormAsimetricaRadTan FAsimetricaRad1;
		public FormAsimetricaRadTan FAsimetricaTan1;
		public FormAsimetricauv FAsimetricauvserie1;
		public FormAsimetricauv FAsimetricauvserie2;
		private bool simple;
		internal bool Simple{
			get{return simple;}
			set{if(simple!=value){
				simple=value;
				this.SuspendLayout();
				if(value){
					CBoxpoli.SelectedIndex=0;		CBoxpoli.Visible=false;
					CBoxasim.SelectedIndex=0;		CBoxasim.Visible=false;
					Paneldistorsion.Top=12;
					lbl_radsim.TextLocation= new Point(110, 18);
				}else{
					CBoxpoli.Visible=true;
					CBoxasim.Visible=true;
					Paneldistorsion.Top=60;
					lbl_radsim.TextLocation= new Point(110, 10);
				}
				Chkradial.Location= new Point(2, lbl_radsim.Location.Y+1);
				Chktangencial.Location= new Point(138, Chkradial.Top);
				lbl_tansim.TextLocation= new Point(242, lbl_radsim.Top);

				Labelpoli.Visible=CBoxpoli.Visible;
				heights();
				this.ResumeLayout(true);
			}}
		}

		public FormAutoCalib(IEntorno _Entorno,Control _Where, CConfigInterna _c_) : base(_Entorno,_Where,_c_){
			FRadial1= new FormSimetrica(_Entorno,1,"a",true);
			FTangencial1= new FormSimetrica(_Entorno,2,"b",true);
			FAsimetricaRad1= new FormAsimetricaRadTan(_Entorno,1,"c",true);
			FAsimetricaTan1= new FormAsimetricaRadTan(_Entorno,2,"d",true);
			FAsimetricauvserie1= new FormAsimetricauv(_Entorno,1,"c",true);
			FAsimetricauvserie2= new FormAsimetricauv(_Entorno,2,"d",true);

			FAsimetricaTan1.checkboxes[1].Checked=true;
			FAsimetricaTan1.checkboxes[2].Checked=true;
			FAsimetricauvserie2.checkboxes[1].Checked=true;
			FAsimetricauvserie2.checkboxes[2].Checked=true;
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_tanasim.T.Text= Convert.ToString(FAsimetricaTan1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
			lbl_uvserie2.T.Text= Convert.ToString(FAsimetricauvserie2.npar);

			FRadial1.Owner=this;
			FTangencial1.Owner=this;
			FAsimetricaRad1.Owner=this;
			FAsimetricaTan1.Owner=this;
			FAsimetricauvserie1.Owner=this;
			FAsimetricauvserie2.Owner=this;
		}

	#region InitializeComponent
		protected override void InitializeComponent(){
			Label2= new BaseLabel();
			Chkf= new LabelCheck();
			Chkpp= new LabelCheck();
			Chkdistorsion= new CheckBox();
			GBoxdistorsion= new GroupBox();
			Labelpoli= new LabelRight();			CBoxpoli= new ComboBox();
			Paneldistorsion= new Panel();
			Chkradial= new ChkSalida();			lbl_radsim= new LblParametros();
			Chktangencial= new ChkSalida();		lbl_tansim= new LblParametros();
			lbl_radsim.TextWidth=16;
			lbl_tansim.TextWidth=16;
			Chkasim= new LabelCheck();
			CBoxasim= new ComboBox();
			PanelAsim= new ContainerControl();
			lbl_radasim= new LblParametros();		lbl_tanasim= new LblParametros();
			lbl_uvserie1= new LblParametros();		lbl_uvserie2= new LblParametros();
			//
			// Label2
			//
			Label2.Font= new Font("Franklin Gothic Medium", 11.25F, System.Drawing.FontStyle.Regular);
			Label2.TextAlign= new TwoDimAlignment(0.5F,0);
			Label2.RefLocation= new Point(137, 20);
			Label2.TabIndex= 3;
			//
			// Chkf, pp
			//
			Chkf.TextLocation= new Point(84, 50);		Chkf.TabIndex= 8;
			Chkpp.TextLocation= new Point(220, 50);	Chkpp.TabIndex= 6;
			//
			// Chkdistorsion
			//
			Chkdistorsion.Checked=true;
			Chkdistorsion.Location= new Point(44, 82);
			Chkdistorsion.Size= new Size(16, 16);
			Chkdistorsion.TabIndex= 15;
			Chkdistorsion.CheckedChanged+= new EventHandler(Chkdistorsion_CheckedChanged);
			//
			// GBoxdistorsion
			//
			GBoxdistorsion.Controls.AddRange(new Control[]{
				Labelpoli,		CBoxpoli,
				Paneldistorsion
			});
			GBoxdistorsion.FlatStyle= FlatStyle.System;
			GBoxdistorsion.Location= new Point(4, 82);
			GBoxdistorsion.Width= 264;
			GBoxdistorsion.TabIndex= 16;
			//
			// CBoxpoli
			//
			Labelpoli.RefLocation= new Point(114,40);	Labelpoli.TabIndex=1;
			//
			CBoxpoli.DropDownStyle= ComboBoxStyle.DropDownList;
			CBoxpoli.Items.AddRange(new object[]{"Impar",
															"Completo"});
			CBoxpoli.Location= new Point(120, 26);
			CBoxpoli.Size= new Size(124, 21);
			CBoxpoli.TabIndex= 2;
			//
			// Paneldistorsion
			//
			Paneldistorsion.Controls.AddRange(new Control[]{
				Chkradial,		lbl_radsim,
				Chktangencial,	lbl_tansim,
				Chkasim,		CBoxasim,
				PanelAsim
			});
			Paneldistorsion.Location= new Point(2, 60);
			Paneldistorsion.Width= 260;
			Paneldistorsion.TabIndex= 4;
			//
			// lbl_radsim
			//
			lbl_radsim.TextLocation= new Point(110, 10);
			lbl_radsim.TabIndex= 1;
			lbl_radsim.T.Text= "3";
			lbl_radsim.Click+= new EventHandler(Lblradsim_Click);
			//
			//Chkradial
			Chkradial.Location= new Point(2, lbl_radsim.Location.Y+1);
			Chkradial.TabIndex= 0;
			Chkradial.BorderStyle= ChkSalida.ExtendedBorderStyle.Alternating3D;
			Chkradial.CheckedChanged+= new EventHandler(Chkradial_CheckedChanged);
			//
			//Chktangencial
			Chktangencial.Location= new Point(138, Chkradial.Top);
			Chktangencial.TabIndex= 2;
			Chktangencial.BorderStyle= ChkSalida.ExtendedBorderStyle.Alternating3D;
			Chktangencial.CheckedChanged+= new EventHandler(Chktangencial_CheckedChanged);
			//
			// lbl_tansim
			//
			lbl_tansim.TextLocation= new Point(242, lbl_radsim.Top);
			lbl_tansim.TabIndex= 3;
			lbl_tansim.T.Text= "3";
			lbl_tansim.Enabled=false;
			lbl_tansim.Click+= new EventHandler(Lbltansim_Click);
			//
			// Chkasim
			//
			Chkasim.TextLocation= new Point(90, lbl_radsim.TextLocation.Y + 38);
			Chkasim.TabIndex= 4;
			Chkasim.CheckedChanged+= new EventHandler(Chkasim_CheckedChanged);
			//
			// CBoxasim
			//
			CBoxasim.DropDownStyle= ComboBoxStyle.DropDownList;
			CBoxasim.Items.AddRange(new object[] {	"Radial / tangencial",
																"Vector giratorio"});
			CBoxasim.Location= new Point(130,Chkasim.Top);
			CBoxasim.Size= new Size(120, 21);
			CBoxasim.DropDownWidth= 120;
			CBoxasim.TabIndex= 5;
			CBoxasim.Enabled=false;
			CBoxasim.SelectedIndexChanged+= new EventHandler(CBoxasim_SelectedIndexChanged);
			//
			// PanelAsim
			//
			PanelAsim.Location= new Point(2,Chkasim.Top+20);
			PanelAsim.Size=new Size(GBoxdistorsion.Width-8,32);
			PanelAsim.Enabled=false;
			PanelAsim.Controls.AddRange(new Control[]{
				lbl_radasim,	lbl_tanasim,
				lbl_uvserie1,	lbl_uvserie2,
			});
			PanelAsim.TabIndex= 6;
			//
			// lbl_radasim
			//
			lbl_radasim.TextLocation= new Point(80, 8);
			lbl_radasim.TabIndex= 0;
			lbl_radasim.Click+= new EventHandler(Lblradasim_Click);
			//
			// lbl_tanasim
			//
			lbl_tanasim.TextLocation= new Point(216, 8);
			lbl_tanasim.TabIndex= 1;
			lbl_tanasim.Click+= new EventHandler(Lbltanasim_Click);
			//
			// lbl_uvserie1
			//
			lbl_uvserie1.TextLocation= new Point(80, 8);
			lbl_uvserie1.TabIndex= 0;
			lbl_uvserie1.Click+= new EventHandler(Lbluvserie1_Click);
			//
			// lbl_uvserie2
			//
			lbl_uvserie2.TextLocation= new Point(216, 8);
			lbl_uvserie2.TabIndex= 1;
			lbl_uvserie2.Click+= new EventHandler(Lbluvserie2_Click);
			//
			Paneldistorsion.Height=PanelAsim.Bottom;
			//
			simple=false;
			Simple=true;
			//
			// Aceptar, Cancelar
			//
			Aceptar.Left= 40;
			Cancelar.Left= 168;
			//
			// FormAutoCalib
			//
			this.ClientSize= new Size(273, Aceptar.Bottom+16);
			this.Controls.AddRange(new Control[]{
				Label2,
				Chkf,		Chkpp,
				Chkdistorsion,	this.GBoxdistorsion,
			});
		}
		private void heights(){
			GBoxdistorsion.Height=Paneldistorsion.Bottom+8;
			Cancelar.Top=Aceptar.Top=GBoxdistorsion.Bottom+14;
			this.ClientSize=new Size(this.ClientSize.Width, Aceptar.Bottom+16);
		}
	#endregion

		protected override void set_data(object obj){
			CConfigInterna CInterna=(CConfigInterna)obj;
			ushort i, l;

			Chkf.Checked=CInterna.DChk.f!=0;
			Chkpp.Checked=CInterna.DChk.pp!=0;

			Chkdistorsion.Checked=CInterna.DChk.distorsion!=0;
			Chkradial.Checked=CInterna.DChk.componentes.radsim!=0;
			Chktangencial.Checked=CInterna.DChk.componentes.tansim!=0;
			Chkasim.Checked=CInterna.DChk.componentes.asimetricas!=0;

			CBoxpoli.SelectedIndex=CInterna.S.modelo_poli-1;
			CBoxasim.SelectedIndex=CInterna.S.modelo_asim-1;

			for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
				if(FRadial1.checkboxes[i].Enabled== true){
					FRadial1.checkboxes[i].Checked= (CInterna.S.param_radsim&l)!=0;
				}
			}
			lbl_radsim.T.Text= Convert.ToString(FRadial1.npar);

			for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
				if(FTangencial1.checkboxes[i].Enabled== true){
					FTangencial1.checkboxes[i].Checked= (CInterna.S.param_tansim&l)!=0;
				}
			}
			lbl_tansim.T.Text= Convert.ToString(FTangencial1.npar);

			if(CBoxasim.SelectedIndex==0){
				for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
					if(FAsimetricaRad1.checkboxes[i].Enabled== true){
						FAsimetricaRad1.checkboxes[i].Checked= (CInterna.S.param_asim1&l)!=0;
				}	}
				for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
					if(FAsimetricaTan1.checkboxes[i].Enabled== true){
						FAsimetricaTan1.checkboxes[i].Checked= (CInterna.S.param_asim2&l)!=0;
				}	}
				lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
				lbl_tanasim.T.Text= Convert.ToString(FAsimetricaTan1.npar);
			}else if(CBoxasim.SelectedIndex==1){
				for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
					if(FAsimetricauvserie1.checkboxes[i].Enabled== true){
						FAsimetricauvserie1.checkboxes[i].Checked= (CInterna.S.param_asim1&l)!=0;
				}	}
				for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
					if(FAsimetricauvserie2.checkboxes[i].Enabled== true){
						FAsimetricauvserie2.checkboxes[i].Checked= (CInterna.S.param_asim2&l)!=0;
				}	}
				lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
				lbl_uvserie2.T.Text= Convert.ToString(FAsimetricauvserie2.npar);
			}
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			CConfigInterna CInterna=(CConfigInterna)ref_to_Data;
			ushort i,l;

			if(Chkf.Checked) CInterna.DChk.f=1;	else CInterna.DChk.f=0;
			if(Chkpp.Checked) CInterna.DChk.pp=1;	else CInterna.DChk.pp=0;

			CInterna.DChk.distorsion= Convert.ToByte(Chkdistorsion.Checked);
			CInterna.DChk.componentes.radsim= Convert.ToByte(Chkradial.Checked);
			CInterna.DChk.componentes.tansim= Convert.ToByte(Chktangencial.Checked);
			CInterna.DChk.componentes.asimetricas= Convert.ToByte(Chkasim.Checked);

			CInterna.S.modelo_poli=(byte)(CBoxpoli.SelectedIndex+1);
			CInterna.S.modelo_asim=(byte)(CBoxasim.SelectedIndex+1);

			CInterna.S.param_radsim=0;
			for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
				if(FRadial1.checkboxes[i].Checked){
					CInterna.S.param_radsim|=l;
			}	}
			CInterna.S.condicion=0;

			CInterna.S.param_tansim=0;
			for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
				if(FTangencial1.checkboxes[i].Checked){
					CInterna.S.param_tansim|=l;
			}	}

			Calibracion.ParameterBox[] chkboxes1, chkboxes2;
			byte n1, n2;
			if(CBoxasim.SelectedIndex==1){
				chkboxes1=FAsimetricauvserie1.checkboxes;
				chkboxes2=FAsimetricauvserie2.checkboxes;
				n1=n2=FormAsimetricaRadTan.nparametros;
			}else{
				chkboxes1=FAsimetricaRad1.checkboxes;
				chkboxes2=FAsimetricaTan1.checkboxes;
				n1=n2=FormAsimetricauv.nparametros;
			}
			CInterna.S.param_asim1=0;
			for(i=1,l=1;i<=n1;i++,l<<=1){
				if(chkboxes1[i].Checked){
					CInterna.S.param_asim1|=l;
			}	}
			CInterna.S.param_asim2=0;
			for(i=1,l=1;i<=n2;i++,l<<=1){
				if(chkboxes2[i].Checked){
					CInterna.S.param_asim2|=l;
			}	}

			this.Hide();
		}

		void Chkdistorsion_CheckedChanged(Object sender,System.EventArgs e){
			GBoxdistorsion.Enabled= Chkdistorsion.Checked;
		}

		void Chkradial_CheckedChanged(Object sender,System.EventArgs e){
			lbl_radsim.Enabled=Chkradial.Checked;
		}
		void Chktangencial_CheckedChanged(Object sender,System.EventArgs e){
			lbl_tansim.Enabled=Chktangencial.Checked;
		}
		void Chkasim_CheckedChanged(Object sender,System.EventArgs e){
			bool enabled= Chkasim.Checked;
			CBoxasim.Enabled=enabled;
			PanelAsim.Enabled=enabled;
		}
		void CBoxasim_SelectedIndexChanged(Object sender,System.EventArgs e){
			if(CBoxasim.SelectedIndex==0){
				lbl_radasim.Visible=true;
				lbl_tanasim.Visible=true;
				lbl_uvserie1.Visible=false;
				lbl_uvserie2.Visible=false;
			}else{
				lbl_radasim.Visible=false;
				lbl_tanasim.Visible=false;
				lbl_uvserie1.Visible=true;
				lbl_uvserie2.Visible=true;
			}
		}
	#region detalles
		void Lblradsim_Click(Object sender,System.EventArgs e){
			FRadial1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FRadial1.ShowDialog();
			lbl_radsim.T.Text= Convert.ToString(FRadial1.npar);
		}
		void Lbltansim_Click(Object sender,System.EventArgs e){
			FTangencial1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FTangencial1.ShowDialog();
			lbl_tansim.T.Text= Convert.ToString(FTangencial1.npar);
		}
		void Lblradasim_Click(Object sender,System.EventArgs e){
			FAsimetricaRad1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricaRad1.ShowDialog();
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
		}
		void Lbltanasim_Click(Object sender,System.EventArgs e){
			FAsimetricaTan1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricaTan1.ShowDialog();
			lbl_tanasim.T.Text= Convert.ToString(FAsimetricaTan1.npar);
		}
		void Lbluvserie1_Click(Object sender,System.EventArgs e){
			FAsimetricauvserie1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricauvserie1.ShowDialog();
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void Lbluvserie2_Click(Object sender,System.EventArgs e){
			FAsimetricauvserie2.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricauvserie2.ShowDialog();
			lbl_uvserie2.T.Text= Convert.ToString(FAsimetricauvserie2.npar);
		}
	#endregion

		protected override void update_idioma(){
			base.update_idioma();
			Label2.Text=get_texto(Parmetros_a_calcular);
			Chkf.Text=get_texto(Focal);
			Chkpp.Text=get_texto(Punto_principal);

			Labelpoli.Text=get_texto(Modelo_polinmico);
			CBoxpoli.Items[0]=get_texto(Impar);
			CBoxpoli.Items[1]=get_texto(Completo);
			CBoxasim.Items[0]=get_texto(Radial_tangencial);
			CBoxasim.Items[1]=get_texto(Vector_giratorio);

			GBoxdistorsion.Text=get_texto(Funcin_de_distorsin);
			lbl_radsim.L.Text=get_texto(Radial_simtrica)+":";
			lbl_tansim.L.Text=get_texto(Tangencial_sim)+":";
			Chkasim.L.Text=get_texto(Asimtricas);
			lbl_radasim.L.Text=get_texto(Radial)+":";
			lbl_tanasim.L.Text=get_texto(Tangencial)+":";
			lbl_uvserie1.L.Text=get_texto(Serie1)+":";
			lbl_uvserie2.L.Text=get_texto(Serie2)+":";
			if(idioma==Globales.Idioma.It) Chkdistorsion.Left=128;
			else Chkdistorsion.Left= 120;
		}
		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
