using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Calibracion{
using static Textos.Cods;

	public class FormAsimetricauv : Calibracion.FormDistorsiones{
		private System.Windows.Forms.Label Label1, Label3;
		private System.Windows.Forms.Label Label4;
		private System.Windows.Forms.Label Label2;
		private BaseLabel Labelq3;

		public const byte nparametros=12;
		protected override byte get_nparametros(){return nparametros;}
		public readonly byte serie;	//1: serie1, 2: serie2.
		protected readonly bool simple;
		string signo, ssen, scos;

		public FormAsimetricauv(ControlesAt.IEntorno _Entorno, byte serie, string letra, bool simple) : base(_Entorno,letra){
			InitializeComponent();
			checkboxes[5].Checked=true;
			checkboxes[6].Checked=true;
			PanelParams.Height=Labelq3.Top+16;
			this.serie=serie;
			this.simple=simple;
			if(serie==1 && simple){
				checkboxes[1].Enabled=false;
				checkboxes[2].Enabled=false;
			}
		}

	#region InitializeComponent
		private void InitializeComponent()	{
			Label1= new Label();
			Label2= new Label();
			Label3= new Label();
			Label4= new Label();
			Labelq3=new BaseLabel();
			//
			// ContainerInfo
			//
			ContainerInfo.Controls.Add(Label2);
			ContainerInfo.Controls.Add(Label1);
			ContainerInfo.Controls.Add(Label4);
			ContainerInfo.Controls.Add(Label3);
			ContainerInfo.Height=108;
			//
			// Label1
			//
			Label1.FlatStyle= FlatStyle.System;
			Label1.Location= new Point(4, 0);
			Label1.Size= new Size(436, 28);
			Label1.TabIndex= 0;
			//
			// Label3
			//
			Label3.FlatStyle= FlatStyle.System;
			Label3.Location= new Point(12, 32);
			Label3.Size= new Size(420, 16);
			Label3.TabIndex= 1;
			//
			// Label4
			//
			Label4.FlatStyle= FlatStyle.System;
			Label4.Location= new Point(364, 52);
			Label4.Size= new Size(72, 16);
			Label4.TabIndex= 2;
			Label4.Text= "s= r/semidiag.";
			//
			// Label2
			//
			Label2.FlatStyle= FlatStyle.System;
			Label2.Location= new Point(4, 72);
			Label2.Size= new Size(436, 64);
			Label2.TabIndex= 3;
			//
			// checkboxes
			//
			int pos=32;
			for(int i=1;i<=nparametros;pos+=20){
				checkboxes[i++].Location= new Point(52, pos);		checkboxes[i++].Location= new Point(240, pos);
			}
			//
			// Labelq3
			//
			pos+=12;
			Labelq3.RefLocation=new Point(44,pos);
			PanelParams.Controls.Add(Labelq3);
		}
	#endregion

		protected override void update_idioma(){
			this.Text=get_texto(DistorsinAsimtrica);
			if(serie==1){
				this.Text+=get_texto(Serie1);
				Label1.Text=get_texto(El_modelo_de_distorsin_uv_serie1);
				if(!simple) Label2.Text=get_texto(ExplicacinAsimtrica_radial);
				else Label2.Text=get_texto(ExplicacinAsimtrica_radial_simple);
				Label2.Text+="\n"+get_texto(ExplicacinAsimtricauv);
				ContainerInfo.Height=Label2.Bottom;
			}else{
				this.Text+=get_texto(Serie2);
				Label1.Text=get_texto(El_modelo_de_distorsin_uv_serie2);
				Label2.Text="";
				ContainerInfo.Height=Label4.Bottom;
			}
			switch(modelo){
				case 1: Label1.Text+=get_texto(con_poli_impares); break;
				case 2: Label1.Text+=get_texto(con_poli_completos); break;
			}
			LabelParams.Text=get_texto(Parmetros);
			ssen=get_texto(sen);
			scos=get_texto(cos);
			Aceptar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Aceptar,idioma);
			Cancelar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Cancelar,idioma);

			formulas();
		}
		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}

		protected override void formulas(){
			if(serie==1) signo="-";
			else signo="+";
			checkboxes[1].letter= letra+'1';	checkboxes[1].formula="s^2 #cosA";
			checkboxes[2].letter= letra+'2';	checkboxes[2].formula="s^2 #senA";
			checkboxes[3].letter= letra+'3';
			checkboxes[4].letter= letra+'4';
			checkboxes[5].letter= letra+'5';	checkboxes[5].formula="s u(#-2)";
			checkboxes[6].letter= letra+'6';	checkboxes[6].formula="s v(#-2)";
			checkboxes[7].letter= letra+'7';	checkboxes[7].formula="q_3 u(#-1)";
			checkboxes[8].letter= letra+'8';	checkboxes[8].formula="q_3 v(#-1)";
			checkboxes[9].letter= letra+'9';
			checkboxes[10].letter= letra+"10";
			checkboxes[11].letter= letra+"11";	checkboxes[11].formula="s^2 u(#-3)";
			checkboxes[12].letter= letra+"12";	checkboxes[12].formula="s^2 v(#-3)";
			switch(modelo){
				case 1:
					Label3.Text= "s^2(#b1#cosA+#b2#senA) + (2.5s^4-1.5s^2)(#b3u(#-1)+b4v(#-1)) + s(#b5v(#-2)+#b6v(#-2)) + ...";
					checkboxes[3].formula="(2.5s^4-1.5s^2) u(#-1)";
					checkboxes[4].formula="(2.5s^4-1.5s^2) v(#-1)";
					checkboxes[9].formula="(2s^3-s) u(#-2)";
					checkboxes[10].formula="(2s^3-s) v(#-2)";
					Labelq3.Text="q_3= 6.4s^6-7.2s^4+1.8s^2";
					break;
				case 2:
					Label3.Text= " s^2(#b1#cosA+#b2#senA) + (4s^3-3s^2)(#b3u(#-1)+b4v(#-1)) + s(#b5v(#-2)+#b6v(#-2)) + ...";
					checkboxes[3].formula="(4s^3-3s^2) u(#-1)";
					checkboxes[4].formula="(4s^3-3s^2) v(#-1)";
					checkboxes[9].formula="(3s^3-2s) u(#-2)";
					checkboxes[10].formula="(3s^3-2s) v(#-2)";
					Labelq3.Text="q_3= 14.5s^4-20.3s^3+6.8s^2";
					break;
			}
			Label3.Text=Label3.Text.Replace("#b",letra);
			Label3.Text=Label3.Text.Replace("#cos",scos);
			Label3.Text=Label3.Text.Replace("#sen",ssen);
			Label3.Text=Label3.Text.Replace("#-",signo);
			checkboxes[1].formula=checkboxes[1].formula.Replace("#cos",scos);
			checkboxes[2].formula=checkboxes[2].formula.Replace("#sen",ssen);
			for(int i=2;i<=nparametros;i++)
				checkboxes[i].formula=checkboxes[i].formula.Replace("#-",signo);
		}
	}
}
