using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public class EscalaResiduos : ContainerControl{
		protected System.Windows.Forms.TrackBar Trackbar;
		protected System.Windows.Forms.Label escala1,	escala2,	escala3;
		public System.Windows.Forms.TextBox Textescala;
		public event EventHandler ValueChanged;

		static readonly float[][] static_limits={
			new float[]{1.5F,	1.71F,	1.91F,	2.09F,	2.26F,	2.425F, 2.58F, 2.725F, 2.865F, 3.0F,},
			new float[]{1.8F,	2.0F,	2.19F,	2.36F,	2.52F,	2.67F,	2.81F,	2.95F,	3.08F,	3.2F},
			new float[]{2.8F,	3.0F,	3.2F,	3.4F,	3.6F,	3.8F,	4.0F,	4.2F,	4.4F,	4.6F},
			new float[]{3.1F,	3.31F,	3.53F,	3.76F,	4.0F,	4.25F,	4.51F,	4.78F,	5.06F,	5.35F}
		};
		float[] limites;
		bool ignore;
		static EventHandler text_updated;

		public int Value{
			get{ if(Trackbar.Value==Trackbar.Minimum) return -1000;
				  else return -Trackbar.Value;}
			set{ try{Trackbar.Value=-value;}
				 catch(Exception){Trackbar.Value=Trackbar.Minimum;}}
		}

		public EscalaResiduos(){
			ignore=false;
			InitializeComponent();
			text_updated=new EventHandler(Text_Updated);
		}

	#region InitializeComponent
		private void InitializeComponent(){
			Trackbar= new TrackBar();
			escala1= new Label();
			escala2= new Label();
			escala3= new Label();
			Textescala= new TextBox();
			//
			// Trackbar
			//
			Trackbar.AutoSize= false;
			Trackbar.LargeChange= 1;
			Trackbar.Location= new Point(0, 0);
			Trackbar.Maximum= -1;
			Trackbar.Minimum= -4;
			Trackbar.Orientation= Orientation.Vertical;
			Trackbar.Size= new Size(36, 87);
			Trackbar.TabIndex= 0;
			Trackbar.Value= -1;
			Trackbar.ValueChanged+=new EventHandler(Trackbar_ValueChanged);
			Trackbar.Value= -2;

			Font fescala= new Font("Arial", 8.25F);
			//
			// escala1
			//
			escala1.Font= fescala;
			escala1.Location= new Point(40, 6);
			escala1.FlatStyle= FlatStyle.System;
			escala1.Size= new Size(104, 16);
			escala1.TabIndex= 1;
			escala1.Text= "1 2 3 4 5 6 7 8 9 *";
			//
			// escala2
			//
			escala2.Font= fescala;
			escala2.Location= new Point(41, 26);
			escala2.FlatStyle= FlatStyle.System;
			escala2.Size= new Size(132, 16);
			escala2.TabIndex= 2;
			escala2.Text= "                  1  2   3  4  5 ...";
			//
			// escala3
			//
			escala3.Font= fescala;
			escala3.Location= new Point(41, 46);
			escala3.FlatStyle= FlatStyle.System;
			escala3.Size= new Size(132, 16);
			escala3.TabIndex= 3;
			escala3.Text= "                         1  2  3   4 ...";
			//
			// Textescala
			//
			Textescala.AutoSize= false;
			Textescala.BorderStyle= BorderStyle.FixedSingle;
			Textescala.Font=fescala;
			Textescala.Location= new Point(37,66);
			Textescala.Size= new Size(156,17);
			Textescala.TabIndex= 4;
			Textescala.Validated+=new EventHandler(Text_Updated);
			//
			// EscalaResiduos
			//
			this.Controls.Add(Textescala);
			this.Controls.AddRange(new Control[]{
				escala1,	escala2,	escala3,
				Trackbar});
		}
		protected override Size DefaultSize{
			get	{return new Size(194,88);}
		}
	#endregion

		void Trackbar_ValueChanged(object sender,EventArgs e){
			if(ignore) return;
			if(Value==-1000) make_limites();
			else limites=static_limits[Value];
			if(ValueChanged!=null) ValueChanged(this, e);
		}

		protected void set_text(){
			int i;
			Textescala.Text="";
			for(i=0;i<limites.Length;i++)
				Textescala.Text+="  "+limites[i].ToString();
		}
		public void set_limites_texto(string texto){
			Textescala.Text=texto;
			if(Value==-1000) make_limites();
			else Value=-1000;
		}
		public void set_limites(float[] blimites){
			ignore=true;
			int n=blimites.Length;
			if(n!=0 && (Single.IsInfinity(blimites[n-1]) || Single.IsNaN(blimites[n-1]))){
				n--;
				limites=new float[n];
				for(int i=0;i<n;i++) limites[i]=blimites[i];
			}else{
				limites=blimites;
			}
			set_text();
			Value=-1000;
			ignore=false;
		}
		public void set_to_limits(float[] blimites){
			ignore=true;
			int i,j,n,m;
			n=blimites.Length;
			for(i=0;i<static_limits.Length;i++){
				m=static_limits[i].Length;
				if(n==m || (n==m+1 && (Single.IsInfinity(blimites[n-1]) || Single.IsNaN(blimites[n-1])) )){
					for(j=0;j<m;j++){if(blimites[j]!=static_limits[i][j]) break;}
					if(j==m){
						Value=i; ignore=false; return;
				}	}
			}
			set_limites(blimites);
		}

		void make_limites(){
			int i;
			string[] palabras;

			palabras=Basicas._gcVarios.split(Textescala.Text);
			limites= new float[palabras.Length];
			for(i=0;i<palabras.Length;i++){
				try{limites[i]=Basicas._gcVarios.atofl(palabras[i].ToCharArray());}
				catch(Exception){
					if(i!=0) limites[i]=limites[i-1];
					else limites[i]=0;
				}
			}
		}
		private void Text_Updated(object sender,EventArgs e){
			if(Value==-1000) make_limites();
		}

		public float[] get_limites(){
			return limites;
		}
	}
}