﻿using Globales;

namespace EditorT{
	internal static class Textos{
		public enum Cods : uint{
			NuevaPestaña,
			Abrir,
			Recargar,
			Guardar,
			GuardarComo,
			GuardarTodo,
			Cerrar,
			Edición,
			BuscarReemplazar,
			BuscarSiguiente,
			BR_enTodos,
			SeleccionarTodo,
			Formato,
			AjustedeLínea,
			Fuente,
			Sintítulo,
			Antiguo,
			Acercade,
			Manualpath,
			Seguro,
			Elfichero,
			Elfichero_antiguo,
			está_abierto_y_modificado,
			ha_sido_modificado,
			No_se_encontró_texto,
			wasnt_found,
			nombre_no_válido,
			Desea_guardar_cambios,
			cambios_cierre,
			Caption,
			MsgCaption,
			FullTitle,
			NuevoGrupo,
			NTEXTOS,
		}

		private static readonly string[] esp,eng,it;
		private static readonly string[][] textos;

		static Textos(){
			textos=new string[(int)Idioma.NIDIOMAS][];
			esp=new string[(int)Cods.NTEXTOS];
			eng=new string[(int)Cods.NTEXTOS];
			it=new string[(int)Cods.NTEXTOS];
			setup_esp();
			setup_eng();
			setup_it();

			textos[(int)Idioma.Esp]=esp;
			textos[(int)Idioma.Eng]=eng;
			textos[(int)Idioma.It]=it;
		}

		public static string get_texto(Cods cod, Idioma idioma){
			string[] t=textos[(int)idioma];
				if(t==null) t=textos[(int)Idioma.Esp];
			string s=t[(int)cod];
				if(s==null) s=textos[(int)Idioma.Esp][(int)cod];
			return s;
		}

		static void setup_esp(){
			esp[(int)Cods.Caption]="Editor de Texto - Aerotri";
			esp[(int)Cods.MsgCaption]="Editor de Texto";
			esp[(int)Cods.Acercade]="Acerca de Editor de texto";
			esp[(int)Cods.FullTitle]="Editor de texto de Aerotri";
			esp[(int)Cods.Manualpath]="Manuales_html\\esp\\EditordeTexto.htm";
			esp[(int)Cods.NuevoGrupo]="Nuevo grupo";
			
			esp[(int)Cods.NuevaPestaña]="Nueva pestaña";
			esp[(int)Cods.Abrir]="Abrir...";
			esp[(int)Cods.Recargar]="Recargar";
			esp[(int)Cods.Guardar]="Guardar";
			esp[(int)Cods.GuardarComo]="Guardar como...";
			esp[(int)Cods.GuardarTodo]="Guardar todo";
			esp[(int)Cods.Cerrar]="Cerrar";
			esp[(int)Cods.Edición]="Edición";
			esp[(int)Cods.BuscarReemplazar]="Buscar/Reemplazar...";
			esp[(int)Cods.BuscarSiguiente]="Buscar siguiente";
			esp[(int)Cods.BR_enTodos]="B/R en todos los ficheros...";
			esp[(int)Cods.SeleccionarTodo]="Seleccionar todo";
			esp[(int)Cods.Formato]="Formato";
			esp[(int)Cods.AjustedeLínea]="Ajuste de línea";
			esp[(int)Cods.Fuente]="Fuente...";
			esp[(int)Cods.Sintítulo]="Sin título";
			esp[(int)Cods.Antiguo]=" (antiguo)";

			esp[(int)Cods.Seguro]="¿Seguro que desea reemplazar todos los casos en todos los ficheros?";
			esp[(int)Cods.Elfichero]="El fichero '";
			esp[(int)Cods.Elfichero_antiguo]="El fichero antiguo '";
			esp[(int)Cods.está_abierto_y_modificado]="' ya está abierto y ha sido modificado.\n¿Desea abrirlo de nuevo? Todos los cambios realizados en el fichero en este editor desde la última vez que se guardó se perderán.";
			esp[(int)Cods.ha_sido_modificado]="' ha sido modificado\nPara conservar los cambios realizados debe guardarlo con otro nombre.";
			esp[(int)Cods.nombre_no_válido]="' no es un nombre válido para un fichero";
			esp[(int)Cods.Desea_guardar_cambios]="¿Desea guardar los cambios al fichero '";
			esp[(int)Cods.cambios_cierre]="'?";
			esp[(int)Cods.No_se_encontró_texto]="No se encontró el texto '";
			esp[(int)Cods.wasnt_found]="'";
		}
		static void setup_eng(){
			eng[(int)Cods.Caption]="Text Editor - Aerotri";
			eng[(int)Cods.MsgCaption]="Text Editor";
			eng[(int)Cods.Acercade]="About Text Editor";
			eng[(int)Cods.FullTitle]="Aerotri Text Editor";
			eng[(int)Cods.Manualpath]="Manuales_html\\eng\\TextEditor.htm";
			eng[(int)Cods.NuevoGrupo]="New group";
			
			eng[(int)Cods.NuevaPestaña]="New page";
			eng[(int)Cods.Abrir]="Open...";
			eng[(int)Cods.Recargar]="Reload";
			eng[(int)Cods.Guardar]="Save";
			eng[(int)Cods.GuardarComo]="Save as...";
			eng[(int)Cods.GuardarTodo]="Save all";
			eng[(int)Cods.Cerrar]="Close";
			eng[(int)Cods.Edición]="Edit";
			eng[(int)Cods.BuscarReemplazar]="Find/Replace...";
			eng[(int)Cods.BuscarSiguiente]="Find next";
			eng[(int)Cods.BR_enTodos]="F/R in all files...";
			eng[(int)Cods.SeleccionarTodo]="Select all";
			eng[(int)Cods.Formato]="Format";
			eng[(int)Cods.AjustedeLínea]="Word wrap";
			eng[(int)Cods.Fuente]="Font...";
			eng[(int)Cods.Sintítulo]="No name";
			eng[(int)Cods.Antiguo]=" (old)";

			eng[(int)Cods.Seguro]="Do you want to replace all matching strings in all files?";
			eng[(int)Cods.Elfichero]="The file '";
			eng[(int)Cods.Elfichero_antiguo]="The old fle '";
			eng[(int)Cods.está_abierto_y_modificado]="' is already open and has been modified.\nDo yow want to open it again? All the actions permormed to the file within this editor since it was last saved will be lost.";
			eng[(int)Cods.ha_sido_modificado]="' has been modified\nIn order to save the changes made to it, it has to be saved with another name.";
			eng[(int)Cods.nombre_no_válido]="' is not a valid file name";
			eng[(int)Cods.Desea_guardar_cambios]="Do you want to save the changes to the file '";
			eng[(int)Cods.cambios_cierre]="'?";
			eng[(int)Cods.No_se_encontró_texto]="The text '";
			eng[(int)Cods.wasnt_found]="' wasn't found";
		}
		static void setup_it(){
			it[(int)Cods.Caption]="Editore di Testo - Aerotri";
			it[(int)Cods.MsgCaption]="Editore di Testo";
			it[(int)Cods.Acercade]="Su Editore di testo";
			it[(int)Cods.FullTitle]="Editore di testo di Aerotri";
			it[(int)Cods.Manualpath]="Manuales_html\\it\\EditorediTesto.htm";
			it[(int)Cods.NuevoGrupo]="Nuovo gruppo";
			
			it[(int)Cods.NuevaPestaña]="Nuova scheda";
			it[(int)Cods.Abrir]="Apri...";
			it[(int)Cods.Recargar]="Rilegge";
			it[(int)Cods.Guardar]="Salva";
			it[(int)Cods.GuardarComo]="Salva con nome...";
			it[(int)Cods.GuardarTodo]="Salva tutto";
			it[(int)Cods.Cerrar]="Chiudi";
			it[(int)Cods.Edición]="Modifica";
			it[(int)Cods.BuscarReemplazar]="Ricerca/Sostituzione...";
			it[(int)Cods.BuscarSiguiente]="Trova successivo";
			it[(int)Cods.BR_enTodos]="R/S in tutti i file...";
			it[(int)Cods.SeleccionarTodo]="Seleziona tutto";
			it[(int)Cods.Formato]="Formato";
			it[(int)Cods.AjustedeLínea]="A capo automatico";
			it[(int)Cods.Fuente]="Tipo di carattere...";
			it[(int)Cods.Sintítulo]="Senza nome";
			it[(int)Cods.Antiguo]=" (vecchio)";

			it[(int)Cods.Seguro]="Sicuro que vuole sostituire tutti i testi trovati in tutti i file?";
			it[(int)Cods.Seguro]="Do you want to replace all matching strings in all files?";
			it[(int)Cods.Elfichero]="Il file '";
			it[(int)Cods.Elfichero_antiguo]="Il file vecchio '";
			it[(int)Cods.está_abierto_y_modificado]="' è già aperto ed è stato modificato.\nVuole aprirlo un'altra volta? Tutte le azioni effettuati sul file in questo editore dopo l'ultima volta che è stato salvato saranno perduti.";
			it[(int)Cods.ha_sido_modificado]="' è stato modificato.\nPer conservare i cambi dev'essere salvato con altro nome.";
			it[(int)Cods.nombre_no_válido]="' non è un nome valido per un file";
			it[(int)Cods.Desea_guardar_cambios]="Vuole salvare le modifiche sul file '";
			it[(int)Cods.cambios_cierre]="'?";
			it[(int)Cods.No_se_encontró_texto]="Non è stato trovato il testo '";
			it[(int)Cods.wasnt_found]="'";
		}
	}
}
