﻿using Globales;

namespace EditorD{
	internal static class Textos{
		public enum Cods : uint{
			Caption,
			MsgCaption,
			Acercade,
			Manualpath,
			FullTitle,
			Abrir,
			Cerrar,
			Nombre,
			Marca,
			PrecisiónXY,
			PrecisiónZ,
			PrecisiónΩΦ,
			PrecisiónΚ,
			Fotograma,
			Punto,
			PrecisiónParticular,
			MarcaGPS,
			MarcaINS,
			Grupo,
			Residuox,
			Residuoy,
			Tipo,
			Ordx,
			Ordy,
			Aviso,
			ResiduoX,
			ResiduoY,
			ResiduoZ,
			ResiduoΩ,
			ResiduoΦ,
			ResiduoΚ,
			OrdX,
			OrdY,
			OrdZ,
			OrdΩ,
			OrdΦ,
			OrdΚ,
			FilterBin,
			No_todos_guardados,
			GTodo,
			Escala_para_marcas,
			Escala_de_marcas,
			Ficheros_de_entrada,
			Fotogramas,
			Valores_aproximados_ccpp,
			Valores_aproximados_pp,
			Apoyo,
			EventosGPS,
			Residuos_del_ajuste,
			porfotos,
			porpuntos,
			ApoyoControl,
			Guardar,
			GComo,
			Ordenar_por,
			Orden_por_defecto,
			Edición,
			Insertar_punto_arriba,
			Insertar_punto_abajo,
			Insertar_fg_arriba,
			Insertar_fg_abajo,
			Deshacer,
			Residuo,
			Residuo_normalizado,
			Eliminar_punto,
			Eliminar_fg,
			Los_datos_de_esta_tabla_no,
			Desea_guardar_los_cambios,
			Desea_guardar_cierre,
			Desea_continuar_cerrando,
			se_perderán,
			Focal,
			OffsetX,
			OffsetY,
			OffsetZ,
			tipogps,
			tipoins,
			NTEXTOS,
		}

		private static readonly string[] esp,eng,it;
		private static readonly string[][] textos;

		static Textos(){
			textos=new string[(int)Idioma.NIDIOMAS][];
			esp=new string[(int)Cods.NTEXTOS];
			eng=new string[(int)Cods.NTEXTOS];
			it=new string[(int)Cods.NTEXTOS];
			setup_esp();
			setup_eng();
			setup_it();

			textos[(int)Idioma.Esp]=esp;
			textos[(int)Idioma.Eng]=eng;
			textos[(int)Idioma.It]=it;
		}

		public static string get_texto(Cods cod, Idioma idioma){
			string[] t=textos[(int)idioma];
				if(t==null) t=textos[(int)Idioma.Esp];
			string s=t[(int)cod];
				if(s==null) s=textos[(int)Idioma.Esp][(int)cod];
			return s;
		}

		static void setup_esp(){
			esp[(int)Cods.Caption]="Visor de Resultados - Aerotri";
			esp[(int)Cods.MsgCaption]="Visor de Resultados";
			esp[(int)Cods.Acercade]="Acerca de Visor de resultados";
			esp[(int)Cods.FullTitle]="Visor de resultados del ajuste de Aerotri";
			esp[(int)Cods.Manualpath]="Manuales_html\\esp\\EditordeDatos.htm";
			esp[(int)Cods.Abrir]="Abrir";
			esp[(int)Cods.Cerrar]="Cerrar";
			esp[(int)Cods.GTodo]="Guardar todo y calcular";
			esp[(int)Cods.Escala_para_marcas]="Escala para las marcas de los residuos";
			esp[(int)Cods.FilterBin]="Ficheros binarios de resultados (*.bnf)|*.bnf|Ficheros de entrada|*.ftm;*.prm;*.ajs;*.pym;*.gpm";
			esp[(int)Cods.Escala_de_marcas]="Escala de marcas";
			esp[(int)Cods.Ficheros_de_entrada]="Ficheros de entrada";
			esp[(int)Cods.Fotogramas]="Fotogramas";
			esp[(int)Cods.Valores_aproximados_ccpp]="Valores aproximados, cc.pp.";
			esp[(int)Cods.Valores_aproximados_pp]="Valores aproximados, puntos";
			esp[(int)Cods.Apoyo]="Apoyo";
			esp[(int)Cods.EventosGPS]="Eventos GPS";
			esp[(int)Cods.Residuos_del_ajuste]="Residuos del ajuste";
			esp[(int)Cods.porfotos]="por fotogramas";
			esp[(int)Cods.porpuntos]="por puntos";
			esp[(int)Cods.ApoyoControl]="Apoyo/Control";

			esp[(int)Cods.Fotograma]="Fotograma";
			esp[(int)Cods.Punto]="Punto";
			esp[(int)Cods.Nombre]="Nombre";
			esp[(int)Cods.Grupo]="Grupo";
			esp[(int)Cods.Marca]="Marca";
			esp[(int)Cods.MarcaGPS]="Marca GPS";
			esp[(int)Cods.MarcaINS]="Marca INS";
			esp[(int)Cods.PrecisiónParticular]="Precisión particular";
			esp[(int)Cods.PrecisiónXY]="Precisión particular, XY";
			esp[(int)Cods.PrecisiónZ]="Precisión particular, Z";
			esp[(int)Cods.PrecisiónΩΦ]="Precisión particular, ΩΦ";
			esp[(int)Cods.PrecisiónΚ]="Precisión particular, Κ";
			esp[(int)Cods.Residuox]="Residuo x";
			esp[(int)Cods.Residuoy]="Residuo y";
			esp[(int)Cods.ResiduoX]="Residuo X";
			esp[(int)Cods.ResiduoY]="Residuo Y";
			esp[(int)Cods.ResiduoZ]="Residuo Z";
			esp[(int)Cods.ResiduoΩ]="Residuo Ω";
			esp[(int)Cods.ResiduoΦ]="Residuo Φ";
			esp[(int)Cods.ResiduoΚ]="Residuo Κ";
			esp[(int)Cods.Tipo]="Tipo";
			esp[(int)Cods.Ordx]="Ord. x";
			esp[(int)Cods.Ordy]="Ord. y";
			esp[(int)Cods.OrdX]="Ord. X";
			esp[(int)Cods.OrdY]="Ord. Y";
			esp[(int)Cods.OrdZ]="Ord. Z";
			esp[(int)Cods.OrdΩ]="Ord. Ω";
			esp[(int)Cods.OrdΦ]="Ord. Φ";
			esp[(int)Cods.OrdΚ]="Ord. Κ";
			esp[(int)Cods.Aviso]="Aviso";
			esp[(int)Cods.Focal]="Focal";
			esp[(int)Cods.OffsetX]="Offset X";
			esp[(int)Cods.OffsetY]="Offset Y";
			esp[(int)Cods.OffsetZ]="Offset Z";
			esp[(int)Cods.tipogps]="tipo gps";
			esp[(int)Cods.tipoins]="tipo ins";
			
			esp[(int)Cods.Guardar]="Guardar";
			esp[(int)Cods.GComo]="Guardar como...";
			esp[(int)Cods.Ordenar_por]="Ordenar por";
			esp[(int)Cods.Orden_por_defecto]="Orden por defecto";
			esp[(int)Cods.Edición]="Edición";
			esp[(int)Cods.Insertar_punto_arriba]="Insertar punto arriba";
			esp[(int)Cods.Insertar_punto_abajo]="Insertar punto abajo";
			esp[(int)Cods.Insertar_fg_arriba]="Insertar fotograma/grupo arriba";
			esp[(int)Cods.Insertar_fg_abajo]="Insertar fotograma/grupo abajo";
			esp[(int)Cods.Eliminar_punto]="Delete point";
			esp[(int)Cods.Eliminar_fg]="Delete photograph/group";
			esp[(int)Cods.Deshacer]="Deshacer";
			esp[(int)Cods.Residuo]="Residuo";
			esp[(int)Cods.Residuo_normalizado]="Residuo normalizado";

			esp[(int)Cods.No_todos_guardados]="No se han podido guardar todos los ficheros. ¿Desea volver a calcular de todas formas?";
			esp[(int)Cods.Los_datos_de_esta_tabla_no]="Los datos de esta tabla no se pueden guardar en un fichero";
			esp[(int)Cods.Desea_guardar_los_cambios]="¿Desea guardar los cambios al fichero '";
			esp[(int)Cods.Desea_guardar_cierre]="'?";
			esp[(int)Cods.Desea_continuar_cerrando]="¿Desea continuar cerrando? Los cambios realizados en el fichero '";
			esp[(int)Cods.se_perderán]="' se perderán";
		}
		static void setup_eng(){
			eng[(int)Cods.Caption]="Result Viewer - Aerotri";
			eng[(int)Cods.MsgCaption]="Result Viewer";
			eng[(int)Cods.Acercade]="About Result Viewer";
			eng[(int)Cods.FullTitle]="Aerotri viewer of the adjustment results";
			eng[(int)Cods.Manualpath]="Manuales_html\\eng\\DataEditor.htm";
			eng[(int)Cods.Abrir]="Open";
			eng[(int)Cods.Cerrar]="Close";
			eng[(int)Cods.GTodo]="Save all and calculate";
			eng[(int)Cods.Escala_para_marcas]="Scale for the residual marks";
			eng[(int)Cods.FilterBin]="Binary output files (*.bnf)|*.bnf|Input files|*.ftm;*.prm;*.ajs;*.pym;*.gpm";
			eng[(int)Cods.Escala_de_marcas]="Scale of marks";
			eng[(int)Cods.Ficheros_de_entrada]="Input files";
			eng[(int)Cods.Fotogramas]="Photographs";
			eng[(int)Cods.Valores_aproximados_ccpp]="Approximate values, cc.pp.";
			eng[(int)Cods.Valores_aproximados_pp]="Approximate values, points";
			eng[(int)Cods.Apoyo]="Control";
			eng[(int)Cods.EventosGPS]="GPS events";
			eng[(int)Cods.Residuos_del_ajuste]="Residuals from the adjustment";
			eng[(int)Cods.porfotos]="by photographs";
			eng[(int)Cods.porpuntos]="by points";
			eng[(int)Cods.ApoyoControl]="Control/Check points";

			eng[(int)Cods.Fotograma]="Photograph";
			eng[(int)Cods.Punto]="Point";
			eng[(int)Cods.Nombre]="Name";
			eng[(int)Cods.Grupo]="Group";
			eng[(int)Cods.Marca]="Mark";
			eng[(int)Cods.MarcaGPS]="Mark GPS";
			eng[(int)Cods.MarcaINS]="Mark INS";
			eng[(int)Cods.PrecisiónParticular]="Specific precision";
			eng[(int)Cods.PrecisiónXY]="Specific precision, XY";
			eng[(int)Cods.PrecisiónZ]="Specific precision, Z";
			eng[(int)Cods.PrecisiónΩΦ]="Specific precision, ΩΦ";
			eng[(int)Cods.PrecisiónΚ]="Specific precision, Κ";
			eng[(int)Cods.Residuox]="x residual";
			eng[(int)Cods.Residuoy]="y residual";
			eng[(int)Cods.ResiduoX]="X residual";
			eng[(int)Cods.ResiduoY]="Y residual";
			eng[(int)Cods.ResiduoZ]="Z residual";
			eng[(int)Cods.ResiduoΩ]="Ω Residual";
			eng[(int)Cods.ResiduoΦ]="Φ Residual";
			eng[(int)Cods.ResiduoΚ]="Κ Residual";
			eng[(int)Cods.Tipo]="Type";
			eng[(int)Cods.Ordx]="Ord. x";
			eng[(int)Cods.Ordy]="Ord. y";
			eng[(int)Cods.OrdX]="Ord. X";
			eng[(int)Cods.OrdY]="Ord. Y";
			eng[(int)Cods.OrdZ]="Ord. Z";
			eng[(int)Cods.OrdΩ]="Ord. Ω";
			eng[(int)Cods.OrdΦ]="Ord. Φ";
			eng[(int)Cods.OrdΚ]="Ord. Κ";
			eng[(int)Cods.Aviso]="Warning";
			eng[(int)Cods.Focal]="Focal length";
			eng[(int)Cods.OffsetX]="X offset";
			eng[(int)Cods.OffsetY]="Y offset";
			eng[(int)Cods.OffsetZ]="Z offset";
			eng[(int)Cods.tipogps]="gps type";
			eng[(int)Cods.tipoins]="ins type";
			
			eng[(int)Cods.Guardar]="Save";
			eng[(int)Cods.GComo]="Save as...";
			eng[(int)Cods.Ordenar_por]="Sort by";
			eng[(int)Cods.Orden_por_defecto]="Default sorting";
			eng[(int)Cods.Edición]="Edit";
			eng[(int)Cods.Insertar_punto_arriba]="Insert point above";
			eng[(int)Cods.Insertar_punto_abajo]="Insert point below";
			eng[(int)Cods.Insertar_fg_arriba]="Insert photograph/group above";
			eng[(int)Cods.Insertar_fg_abajo]="Insert photograph/group below";
			eng[(int)Cods.Eliminar_punto]="Delete point";
			eng[(int)Cods.Eliminar_fg]="Delete photograph/group";
			eng[(int)Cods.Deshacer]="Undo";
			eng[(int)Cods.Residuo]="Residual";
			eng[(int)Cods.Residuo_normalizado]="Normalized residual";

			eng[(int)Cods.No_todos_guardados]="Not all files were saved. ¿Do you still wish to calculate?";
			eng[(int)Cods.Los_datos_de_esta_tabla_no]="The data of this table cannot be saved to a file";
			eng[(int)Cods.Desea_guardar_los_cambios]="Do you want to save the changes to the file '";
			eng[(int)Cods.Desea_guardar_cierre]="'?";
			eng[(int)Cods.Desea_continuar_cerrando]="Do you want to continue closing? The changes made to the file '";
			eng[(int)Cods.se_perderán]="' will be lost";
		}
		static void setup_it(){
			it[(int)Cods.Caption]="Visore di Risultati - Aerotri";
			it[(int)Cods.MsgCaption]="Visore di Risultati";
			it[(int)Cods.Acercade]="Su Visore di risultati";
			it[(int)Cods.FullTitle]="Visore di risultati della compensazione di Aerotri";
			it[(int)Cods.Manualpath]="Manuales_html\\it\\EditorediTesto.htm";
			it[(int)Cods.Abrir]="Apri";
			it[(int)Cods.Cerrar]="Chiudi";
			it[(int)Cods.GTodo]="Salva tutto e calcola";
			it[(int)Cods.Escala_para_marcas]="Scala per i segni dei residui";
			it[(int)Cods.FilterBin]="File binari di risultati (*.bnf)|*.bnf|File di entrata|*.ftm;*.prm;*.ajs;*.pym;*.gpm";
			it[(int)Cods.Escala_de_marcas]="Scala di segni";
			it[(int)Cods.Ficheros_de_entrada]="File di entrata";
			it[(int)Cods.Fotogramas]="Fotogrammi";
			it[(int)Cods.Valores_aproximados_ccpp]="Valori approsimati, cc.pp.";
			it[(int)Cods.Valores_aproximados_pp]="Valori approsimati, punti";
			it[(int)Cods.Apoyo]="Appoggio";
			it[(int)Cods.EventosGPS]="Eventi GPS";
			it[(int)Cods.Residuos_del_ajuste]="Residui della compensazione";
			it[(int)Cods.porfotos]="per fotogrammi";
			it[(int)Cods.porpuntos]="per punti";
			it[(int)Cods.ApoyoControl]="Appoggio/Controllo";

			it[(int)Cods.Fotograma]="Fotogramma";
			it[(int)Cods.Punto]="Punto";
			it[(int)Cods.Nombre]="Nome";
			it[(int)Cods.Grupo]="Insieme";
			it[(int)Cods.Marca]="Segno";
			it[(int)Cods.MarcaGPS]="Segno GPS";
			it[(int)Cods.MarcaINS]="Segno INS";
			it[(int)Cods.PrecisiónParticular]="Precisione particolare";
			it[(int)Cods.PrecisiónXY]="Precisione particolare, XY";
			it[(int)Cods.PrecisiónZ]="Precisione particolare, Z";
			it[(int)Cods.PrecisiónΩΦ]="Precisione particolare, ΩΦ";
			it[(int)Cods.PrecisiónΚ]="Precisione particolare, Κ";
			it[(int)Cods.Residuox]="Residuo x";
			it[(int)Cods.Residuoy]="Residuo y";
			it[(int)Cods.ResiduoX]="Residuo X";
			it[(int)Cods.ResiduoY]="Residuo Y";
			it[(int)Cods.ResiduoZ]="Residuo Z";
			it[(int)Cods.ResiduoΩ]="Residuo Ω";
			it[(int)Cods.ResiduoΦ]="Residuo Φ";
			it[(int)Cods.ResiduoΚ]="Residuo Κ";
			it[(int)Cods.Tipo]="Tipo";
			it[(int)Cods.Ordx]="Ord. x";
			it[(int)Cods.Ordy]="Ord. y";
			it[(int)Cods.OrdX]="Ord. X";
			it[(int)Cods.OrdY]="Ord. Y";
			it[(int)Cods.OrdZ]="Ord. Z";
			it[(int)Cods.OrdΩ]="Ord. Ω";
			it[(int)Cods.OrdΦ]="Ord. Φ";
			it[(int)Cods.OrdΚ]="Ord. Κ";
			it[(int)Cods.Aviso]="Attenzione";
			it[(int)Cods.Focal]="Focale";
			it[(int)Cods.OffsetX]="Offset X";
			it[(int)Cods.OffsetY]="Offset Y";
			it[(int)Cods.OffsetZ]="Offset Z";
			it[(int)Cods.tipogps]="tipo gps";
			it[(int)Cods.tipoins]="tipo ins";
			
			it[(int)Cods.Guardar]="Salva";
			it[(int)Cods.GComo]="Salva con nome...";
			it[(int)Cods.Ordenar_por]="Ordine per";
			it[(int)Cods.Orden_por_defecto]="Ordine por difetto";
			it[(int)Cods.Edición]="Modifica";
			it[(int)Cods.Insertar_punto_arriba]="Inserisca un punto qui sopra";
			it[(int)Cods.Insertar_punto_abajo]="Inserisca un punto qui sotto";
			it[(int)Cods.Insertar_fg_arriba]="Inserisca fotogramma/insieme sopra";
			it[(int)Cods.Insertar_fg_abajo]="Inserisca fotogramma/insieme sotto";
			it[(int)Cods.Eliminar_punto]="Pulisci punto";
			it[(int)Cods.Eliminar_fg]="Pulisci fotogramma/insieme";
			it[(int)Cods.Deshacer]="Annulla";
			it[(int)Cods.Residuo]="Residuo";
			it[(int)Cods.Residuo_normalizado]="Residuo standardizzato";

			it[(int)Cods.No_todos_guardados]="Non è stato possibile salvare tutti i file. ¿Vuole calcolare nonostante?";
			it[(int)Cods.Los_datos_de_esta_tabla_no]="I dati di questa tabella non possono essere salvati in un file";
			it[(int)Cods.Desea_guardar_los_cambios]="Vuol salvare le modifiche sul file '";
			it[(int)Cods.Desea_guardar_cierre]="'?";
			it[(int)Cods.Desea_continuar_cerrando]="Vuol continuare a chiudere? Le modifica sul file '";
			it[(int)Cods.se_perderán]="' saranno persi";
		}
	}
}
