using System;

namespace ControlesAt{
	public interface IEntorno : IIdioma, IMessageBoxAT{}

	public abstract class DependentForm : FormAerotri{
		protected IEntorno Entorno;

		public DependentForm(IEntorno _Entorno){
			Entorno=_Entorno;
			this.ShowInTaskbar=false;
			idioma=Globales.Idioma.NIDIOMAS; //Unset, so that the first time this form is shown...
		}
		protected override void OnVisibleChanged(EventArgs e){
			if(this.Visible) set_idioma(Entorno.Idioma); //... here, set_idioma() will not exit immediately
			base.OnVisibleChanged(e);		//because of this.idioma==Entorno.Idioma, and will indeed set the idioma
		}
		protected MessageBoxAT MessagePadre{
			get{return Entorno.MessageBox;}
		}
	}
}
