﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using ControlesAt;
using PanelesSub;

namespace EditorD{
using static Textos.Cods;
	public struct ResidueLimits{
		public float[] limits;
		public int n{ get{return limits.Length-1;}}

		static readonly float[] numero2={2.8F, 3.0F, 3.2F, 3.4F, 3.6F, 3.8F, 4.0F, 4.2F, 4.4F, 4.6F, Single.PositiveInfinity};
		public void set_default(){
			limits=numero2;
		}
		public bool set_limits(float[] _limites){	//return 1 si algún límite cambia
			int t,i;
			t=_limites.Length;
			if(_limites[t-1]==Single.PositiveInfinity) t--;
			if(t+1==limits.Length){
				for(i=0;i<t;i++){
					if(_limites[i]!=limits[i]) break;
				}
				if(i==t) return false;
			}
			limits=new float[t+1];
			for(i=0;i<t;i++) limits[i]=_limites[i];
			limits[t]=Single.PositiveInfinity;
			return true;
		}
		public int number(float f){
			int i=0;
			if(f<0) f=-f;
			while(f>limits[i]) i++;
			return i;
		}
	}
	public class FormatResNorm : IFormatProvider, ICustomFormatter{
		public ResidueLimits limits;

		public FormatResNorm(){
			limits.set_default();
		}
		public object GetFormat(Type service){
			if(service==typeof(ICustomFormatter)) return this;
			else return null;
		}
		public string Format (string format, object arg, IFormatProvider provider){
			float f;
			int i;
			if(arg==null) return "";
			try{f=(float)arg;}
			catch(Exception){return String.Format ("{0}", arg);}

			i=limits.number(f);
			if(i==0) return "";
			if(i<limits.n) return i.ToString();
			return "*";
		}
	}

	public class DataGridEnhacedTextStyle : DataGridTextBoxColumn{
		protected override void Paint(Graphics g, Rectangle bounds, CurrencyManager source, int rowNum){
			object obj;
			obj=GetColumnValueAtRow(source, rowNum);
			PaintText(g,bounds, ((ICustomFormatter)FormatInfo).Format(Format,obj,FormatInfo),false);
		}
		protected override void Paint(Graphics g, Rectangle bounds, CurrencyManager source, int rowNum, Brush backBrush, Brush foreBrush, bool alignToRight){
			object obj;
			obj=GetColumnValueAtRow(source, rowNum);
			PaintText(g,bounds, ((ICustomFormatter)FormatInfo).Format(Format,obj,FormatInfo),backBrush,foreBrush,alignToRight);
		}
		protected override void Paint(Graphics g, Rectangle bounds, CurrencyManager source, int rowNum, bool alignToRight){
			object obj;
			obj=GetColumnValueAtRow(source, rowNum);
			PaintText(g,bounds, ((ICustomFormatter)FormatInfo).Format(Format,obj,FormatInfo),alignToRight);
		}
	}

	public delegate void EventSender(object sender);

	public class DataGridTab : IdiomaControl{
		public System.Windows.Forms.Splitter Splitter1;
		public System.Windows.Forms.TabControl tabControl1;
		public System.Windows.Forms.DataGrid DataGrid1;
		public System.Windows.Forms.ContextMenu pop1;
		private System.Windows.Forms.SaveFileDialog Save1;
		private System.Windows.Forms.MenuItem pop1Archivo,
																pop1AGuardar,
																pop1AGuardarcomo,
																pop1Ordenar,
																pop1ODefecto;
		private System.Windows.Forms.ContextMenu pop2;
		private System.Windows.Forms.MenuItem pop2Ordenar,
																pop2ODefecto,
																pop2OResiduo,
																pop2OResiduo_norm;
		private System.Windows.Forms.MenuItem pop1Edicion,
																pop1EInsertararr,
																pop1EInsertarab,
																pop1EEliminar,
																pop1EInsertarfotoarr,
																pop1EInsertarfotoab,
																pop1EDeshacer,
																pop1EEliminarfoto;

	#region Variables
		private PanelEditorD Panel1;
		internal short n,t,activa;
		public struct DGTabInfo{
			public string tipo;
			public string fichero;
			public FormatResNorm format_Lnorm;

			public bool  modificado;
			internal bool deshacer;
			internal int des_lim_ab;
			internal int des_lim_arr;
			internal DataTable DT_deshacer;
		}
		public DataSet DS;
		public short  MINW,MINH;
		internal byte menu_actual;
		public string fotos,aproximadas,apoyo,GPS;
		public DGTabInfo[] Tabinfo;
		bool enabled1;
		TresOpciones Tresopciones1;
		short lastgps;

		System.IO.StreamWriter filew;
		internal System.Globalization.NumberFormatInfo Formato;
		public byte uni;
	#endregion

	#region InitializeComponent
		private void InitializeComponent()	{
			DataGrid1= new DataGrid();
			Splitter1= new Splitter();
			tabControl1= new TabControl();
			pop1= new ContextMenu();
			pop1Archivo= new MenuItem();
			pop1AGuardar= new MenuItem();
			pop1AGuardarcomo= new MenuItem();
			pop1Ordenar= new MenuItem();
			pop1ODefecto= new MenuItem();
			pop1Edicion= new MenuItem();
			pop1EInsertararr= new MenuItem();
			pop1EInsertarab= new MenuItem();
			pop1EEliminar= new MenuItem();
			pop1EInsertarfotoarr= new MenuItem();
			pop1EInsertarfotoab= new MenuItem();
			pop1EEliminarfoto= new MenuItem();
			pop1EDeshacer= new MenuItem();
			Save1= new SaveFileDialog();
			pop2= new ContextMenu();
			pop2Ordenar= new MenuItem();
			pop2ODefecto= new MenuItem();
			pop2OResiduo= new MenuItem();
			pop2OResiduo_norm= new MenuItem();
			((System.ComponentModel.ISupportInitialize)(DataGrid1)).BeginInit();
			//
			// DataGrid1
			//
			DataGrid1.BackgroundColor= Color.FromArgb(((System.Byte)(221)), ((System.Byte)(216)), ((System.Byte)(205)));
			DataGrid1.CaptionBackColor= Color.FromArgb(((System.Byte)(221)), ((System.Byte)(216)), ((System.Byte)(205)));
			DataGrid1.CaptionForeColor= System.Drawing.SystemColors.WindowText;
			DataGrid1.DataMember= "";
			DataGrid1.Dock= DockStyle.Fill;
			DataGrid1.HeaderForeColor= System.Drawing.SystemColors.ControlText;
			DataGrid1.Location= new Point(0, 0);
			DataGrid1.Size= new Size(324, 184);
			DataGrid1.TabIndex= 0;
			DataGrid1.MouseDown+= new MouseEventHandler(DataGrid1_MouseDown);
			//
			// Splitter1
			//
			Splitter1.BackColor= System.Drawing.SystemColors.ControlDark;
			Splitter1.BorderStyle= BorderStyle.FixedSingle;
			Splitter1.Dock= DockStyle.Bottom;
			Splitter1.Location= new Point(0, 208);
			Splitter1.Size= new Size(324, 4);
			Splitter1.TabIndex= 1;
			Splitter1.TabStop= false;
			//
			// tabControl1
			//
			tabControl1.Alignment= TabAlignment.Bottom;
			tabControl1.Dock= DockStyle.Bottom;
			tabControl1.Location= new Point(0, 184);
			tabControl1.SelectedIndex= 0;
			tabControl1.Size= new Size(324, 24);
			tabControl1.TabIndex= 2;
			tabControl1.SelectedIndexChanged+= new EventHandler(tabControl1_SelectedIndexChanged);
			//
			// pop1
			//
			pop1.MenuItems.AddRange(new MenuItem[] {pop1Archivo,
																	  pop1Ordenar,
																	  pop1Edicion});
			//
			// pop1Archivo
			//
			pop1Archivo.Index= 0;
			pop1Archivo.MenuItems.AddRange(new MenuItem[] {	pop1AGuardar,
																				pop1AGuardarcomo});
			//
			// pop1AGuardar, ...
			//
			pop1AGuardar.Index= 0;
			pop1AGuardarcomo.Index= 1;
			pop1AGuardar.Click+= new EventHandler(AGuardar_Click);
			pop1AGuardarcomo.Click+= new EventHandler(AGuardarcomo_Click);
			//
			// pop1Ordenar
			//
			pop1Ordenar.Index= 1;
			pop1Ordenar.MenuItems.AddRange(new MenuItem[] { pop1ODefecto});
			//
			// pop1ODefecto
			//
			pop1ODefecto.Index= 0;
			pop1ODefecto.Click+= new EventHandler(ODefecto_Click);
			//
			// pop1Edicion
			//
			pop1Edicion.Index= 2;
			pop1Edicion.MenuItems.AddRange(new MenuItem[] {	pop1EInsertararr,	pop1EInsertarab,
																				pop1EEliminar,		pop1EInsertarfotoarr,
																				pop1EInsertarfotoab, pop1EEliminarfoto,
																				pop1EDeshacer});
			//
			// pop1EInsertararr, ...
			//
			pop1EInsertararr.Index= 0;
			pop1EInsertarab.Index= 1;		pop1EInsertarab.Shortcut= Shortcut.CtrlI;
			pop1EEliminar.Index= 2;			pop1EEliminar.Shortcut= Shortcut.CtrlDel;
			pop1EInsertarfotoarr.Index= 3;
			pop1EInsertarfotoab.Index= 4;	pop1EInsertarfotoab.Shortcut= Shortcut.CtrlShiftI;
			pop1EEliminarfoto.Index= 5;		pop1EEliminarfoto.Shortcut= Shortcut.ShiftDel;
			pop1EDeshacer.Index= 6;			pop1EDeshacer.Shortcut= Shortcut.CtrlZ;
			//
			pop1EInsertararr.Click+= new EventHandler(pop1EInsertararr_Click);
			pop1EInsertarab.Click+= new EventHandler(pop1EInsertarab_Click);
			pop1EEliminar.Click+= new EventHandler(pop1EEliminar_Click);
			pop1EInsertarfotoab.Click+= new EventHandler(pop1EInsertarfotoab_Click);
			pop1EEliminarfoto.Click+= new EventHandler(pop1EEliminarfoto_Click);
			pop1EDeshacer.Click+= new EventHandler(pop1EDeshacer_Click);
			//
			// pop2
			//
			pop2.MenuItems.AddRange(new MenuItem[] { pop2Ordenar});
			//
			// pop2Ordenar
			//
			pop2Ordenar.Index= 0;
			pop2Ordenar.MenuItems.AddRange(new MenuItem[] {	pop2ODefecto,
																				pop2OResiduo,
																				pop2OResiduo_norm});
			//
			// pop2ODefecto, etc.
			//
			pop2ODefecto.Index= 0;
			pop2OResiduo.Index= 1;
			pop2OResiduo_norm.Index= 2;
			pop2ODefecto.Click+= new EventHandler(ODefecto_Click);
			pop2OResiduo.Click+= new EventHandler(pop2OResiduo_Click);
			pop2OResiduo_norm.Click+= new EventHandler(pop2OResiduo_norm_Click);
			//
			// DataGridTab
			//
			this.BackColor= Color.FromArgb(221,216,205);
			this.DataGrid1.CaptionFont=new Font(Globales.Fuentes.FontTitle1,FontStyle.Bold);
			this.Controls.Add(DataGrid1);
			this.Controls.Add(tabControl1);
			this.Controls.Add(Splitter1);
			this.Size= new Size(324, 212);
			((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
		}
	#endregion

		public DataGridTab(string name, short _t, Globales.Idioma _idioma, PanelEditorD Form1){
			InitializeComponent();
			Panel1=Form1;
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			MINW=46;
			MINH=61;

			n=_t;
			t=_t;
			activa=-1;
			lastgps=1;
			set_idioma(idioma);

			Tabinfo= new DGTabInfo[n];
			GPS=apoyo=aproximadas=fotos="";
			DS=new DataSet(name);
			menu_actual=0;

			for(short i=0;i<n;i++){
				Tabinfo[i].fichero="";
				Tabinfo[i].format_Lnorm= new FormatResNorm();
				Tabinfo[i].deshacer=false;
				Tabinfo[i].des_lim_arr=Tabinfo[i].des_lim_ab=0;
			}

			Formato=new System.Globalization.NumberFormatInfo();
			Formato.NumberDecimalSeparator=".";
			Formato.NumberGroupSeparator="";
		}
		public void inicializa1()
		{
			DataTable DT;

			for(int i=0;i<t;i++){
				DT=DS.Tables[i];
				int m=DT.Columns.Count;
				Tabinfo[i].DT_deshacer= new DataTable();
				for(int j=0;j<m;j++)
					Tabinfo[i].DT_deshacer.Columns.Add(j.ToString(),DT.Columns[j].DataType);
				Tabinfo[i].deshacer=false;
				Tabinfo[i].des_lim_arr=Tabinfo[i].des_lim_ab=0;
			}
		}
		public void inicializa2(){
			int i;
			for(i=0;i<t;i++){
				DS.Tables[i].RowChanged+=new DataRowChangeEventHandler(Tables_RowChanged);
				Tabinfo[i].modificado=false;
			}
		}
		public void inicializa2(string _fotos,string _aproximadas, string _apoyo, string _GPS){
			int i;
			fotos=_fotos; aproximadas=_aproximadas;
			apoyo=_apoyo; GPS=_GPS;
			for(i=0;i<t;i++){
				switch(Tabinfo[i].tipo){
					case "fotogramas": Tabinfo[i].fichero=fotos; break;
					case "aproximadas_ccpp": case "aproximadas_pp":
						Tabinfo[i].fichero=aproximadas; break;
					case "apoyo": Tabinfo[i].fichero=apoyo; break;
					case "GPS": Tabinfo[i].fichero=GPS; break;
				}
				DS.Tables[i].RowChanged+=new DataRowChangeEventHandler(Tables_RowChanged);
				Tabinfo[i].modificado=false;
			}
		}

		private void clear_table(int i){
			DS.Tables[i].RowChanged-=new DataRowChangeEventHandler(Tables_RowChanged);
			DS.Tables[i].Clear();
			Tabinfo[i].DT_deshacer.Rows.Clear();
			Tabinfo[i].DT_deshacer.AcceptChanges();
			Tabinfo[i].deshacer=false;
			Tabinfo[i].des_lim_arr=Tabinfo[i].des_lim_ab=0;
			Tabinfo[i].modificado=false;
			Tabinfo[i].fichero="";
		}
		public void borra_tablas(){
			int i;
			for(i=0;i<t;i++) clear_table(i);
			//DS.Clear();
			fotos=""; aproximadas="";
			apoyo=""; GPS="";
			this.tabControl1.SelectedIndex=-1;
		}

		public void inicializa2_fotogramas(string nombre){
			fotos=nombre;
			int i;
			bool k=false;
			for(i=0;i<t;i++){
				if(Tabinfo[i].tipo=="fotogramas"){
					Tabinfo[i].fichero=fotos;
					DS.Tables[i].RowChanged+=new DataRowChangeEventHandler(Tables_RowChanged);
					Tabinfo[i].modificado=false;
					if(!k){
						SeleccionaIndice(i);
						k=true;
					}
				}
			}
		}
		public void inicializa2_aproximadas(string nombre){
			aproximadas=nombre;
			int i;
			bool k=false;
			for(i=0;i<t;i++){
				if(Tabinfo[i].tipo.Length>=11 && Tabinfo[i].tipo.Substring(0,11)=="aproximadas"){
					Tabinfo[i].fichero=aproximadas;
					DS.Tables[i].RowChanged+=new DataRowChangeEventHandler(Tables_RowChanged);
					Tabinfo[i].modificado=false;
					if(!k){
						SeleccionaIndice(i);
						k=true;
					}
				}
			}
		}
		public void inicializa2_apoyo(string nombre){
			apoyo=nombre;
			int i;
			bool k=false;
			for(i=0;i<t;i++){
				if(Tabinfo[i].tipo=="apoyo"){
					Tabinfo[i].fichero=apoyo;
					DS.Tables[i].RowChanged+=new DataRowChangeEventHandler(Tables_RowChanged);
					Tabinfo[i].modificado=false;
					if(!k){
						SeleccionaIndice(i);
						k=true;
					}
				}
			}
		}
		public void inicializa2_gps(string nombre){
			GPS=nombre;
			int i;
			bool k=false;
			for(i=0;i<t;i++){
				if(Tabinfo[i].tipo=="GPS"){
					Tabinfo[i].fichero=GPS;
					DS.Tables[i].RowChanged+=new DataRowChangeEventHandler(Tables_RowChanged);
					Tabinfo[i].modificado=false;
					if(!k){
						SeleccionaIndice(i);
						k=true;
					}
				}
			}
		}


		public void borra_fichero(ref string fichero){
			int i;
			for(i=0;i<t;i++){
				if(Tabinfo[i].fichero==fichero) clear_table(i);
			}
			fichero="";
		}
		public void borra_fotogramas(){	borra_fichero(ref fotos);}
		public void borra_aproximadas(){borra_fichero(ref aproximadas);}
		public void borra_apoyo(){		borra_fichero(ref apoyo);	}
		public void borra_gps(){			borra_fichero(ref GPS);}

		protected override void OnLoad(System.EventArgs e){
			update_idioma();
			base.OnLoad(e);
		}

		protected override void OnSizeChanged(EventArgs e){
			if(this.Width<MINW) this.Width=MINW;
			if(this.Height<MINH) this.Height=MINH;
			base.OnSizeChanged(e);
		}

		public void SeleccionaIndice(int i){
			if(tabControl1.SelectedIndex==i) tabControl1_SelectedIndexChanged(this, EventArgs.Empty);
			else tabControl1.SelectedIndex=i;
		}
		private void tabControl1_SelectedIndexChanged(object sender,System.EventArgs e){
			bool b;
			try{
			activa=(short)tabControl1.SelectedIndex;
			if(activa<0) return;
			DataGrid1.SetDataBinding(DS.Tables[tabControl1.SelectedTab.Name].DefaultView,"");

			if(((DataView)DataGrid1.DataSource).Table.Rows.Count==0) b=false;
			else b=true;
			}catch(Exception){return;}
			switch(Tabinfo[activa].tipo){
				case "fotogramas":
				case "GPS":
					pop1Ordenar.Visible=false;
					pop1EInsertarfotoarr.Visible=true;
					pop1EInsertarfotoab.Visible=true;
					pop1EEliminarfoto.Visible=true;
					pop1EInsertararr.Enabled=b;
					pop1EInsertarab.Enabled=b;
					goto case "Enabled1";
				case "aproximadas_ccpp":
				case "aproximadas_pp":
				case "apoyo":
					pop1Ordenar.Visible=true;
					pop1EInsertarfotoarr.Visible=false;
					pop1EInsertarfotoab.Visible=false;
					pop1EEliminarfoto.Visible=false;
					pop1EInsertararr.Enabled=true;
					pop1EInsertarab.Enabled=true;
					goto case "Enabled1";
				case "Enabled1":
					pop1Ordenar.Enabled=b;
					enabled1=pop1EEliminar.Enabled=b;
					pop1EEliminarfoto.Enabled=b;
					break;

				case "res_porfotos":
					pop2Ordenar.Visible=pop2Ordenar.Enabled=true;
					goto case "Enabled2";
				case "res_porpuntos":
					pop2Ordenar.Visible=pop2Ordenar.Enabled=true;
					goto case "Enabled2";
				case "res_apoyo":
					pop2Ordenar.Visible=pop2Ordenar.Enabled=true;
					goto case "Enabled2";
				case "res_GPS":
					pop2Ordenar.Visible=pop2Ordenar.Enabled=false;
					goto case "Enabled2";
				case "Enabled2":
					pop2Ordenar.Enabled=b;
					break;
			}
			pop1EDeshacer.Enabled=Tabinfo[activa].deshacer;
			if(Tabinfo[activa].tipo=="fotogramas" || Tabinfo[activa].tipo=="GPS" || Tabinfo[activa].tipo=="res_porpuntos")
				DataGrid1.CurrentCellChanged+=new EventHandler(DataGrid1_CurrentCellChanged);
			else DataGrid1.CurrentCellChanged-=new EventHandler(DataGrid1_CurrentCellChanged);
		}

		public void ActivaMenu(byte i){
			switch(i){
				case 1:
					DataGrid1.ContextMenu=pop1;
					break;
				case 2:
					DataGrid1.ContextMenu=pop2;
					break;
				default:	//Case 0 + default
					i=0;
					break;
			}
			menu_actual=i;
		}
		private void DataGrid1_MouseDown(object sender,System.Windows.Forms.MouseEventArgs e)
		{
			DataGrid.HitTestInfo Hit;
			if(e.Button!=MouseButtons.Right) return;

			if(menu_actual==0)return;
			Hit=DataGrid1.HitTest(e.X,e.Y);
			if(Hit.Row==-1){

			}
			else{
				pop1Edicion.Visible=true;
				DataGrid1.CurrentCell=new DataGridCell(Hit.Row,Hit.Column);

				pop1EEliminar.Enabled=enabled1;
				if(Tabinfo[activa].tipo=="fotogramas" || Tabinfo[activa].tipo=="GPS"){
					if((string)DataGrid1[DataGrid1.CurrentRowIndex,0]!="")
						pop1EEliminar.Enabled=false;
					if(Hit.Row<1) pop1EInsertararr.Enabled=false;
					else this.pop1EInsertararr.Enabled=enabled1;
				}
			}
			DataGrid1.ContextMenu.Show(DataGrid1,new Point(e.X,e.Y));
		}

	#region Archivo
		private void AGuardar_Click(object sender,System.EventArgs e)
		{
			if(Panel1!=null){
				Panel1.ahora_no_se_puede_cerrar++;
				Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_un_fichero,idioma));
			}
			guardar();
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
		}
		private bool guardar(){
			string fichero=Tabinfo[activa].fichero;
			short a;

			if(fichero==""){ return guardarcomo();}

			switch(Tabinfo[activa].tipo){
				case "fotogramas":
					 return guardaf(fichero,activa);
				case "aproximadas_ccpp":
					for(a=0;a<t;a++){
						if(Tabinfo[a].tipo=="aproximadas_pp" && Tabinfo[a].fichero==fichero) break;
					}
					return guardaapr(fichero,activa,a);
				case "aproximadas_pp":
					for(a=0;a<t;a++){
						if(Tabinfo[a].tipo=="aproximadas_ccpp" && Tabinfo[a].fichero==fichero) break;
					}
					return guardaapr(fichero,a,activa);
				case "apoyo":
					return guardaapy(fichero,activa);
				case "GPS":
					return guardagps(fichero,activa);
				default:
					Panel1.MessageBoxAT.Show(get_texto(Los_datos_de_esta_tabla_no));
					return true;
			}
		}

		private void AGuardarcomo_Click(object sender,System.EventArgs e)
		{
			if(Panel1!=null){
				Panel1.ahora_no_se_puede_cerrar++;
				Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_un_fichero,idioma));
			}
			guardarcomo();
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
		}
		private bool guardarcomo(){
			string fichero=Tabinfo[activa].fichero;
			string guardado;
			short a;
			bool b;

			if(fichero!="") Save1.FileName=fichero;
			else Save1.FileName=tabControl1.TabPages[activa].Text;

			if(subSave.ShowDialog(Panel1,Save1)!=DialogResult.OK) return true;
			guardado=Save1.FileName;
			switch(Tabinfo[activa].tipo){
				case "fotogramas":
					b=guardaf(guardado,activa);
					break;
				case "aproximadas_ccpp":
					for(a=0;a<t;a++){
						if(Tabinfo[a].tipo=="aproximadas_pp" && Tabinfo[a].fichero==fichero) break;
					}
					b=guardaapr(guardado,activa,a);
					break;
				case "aproximadas_pp":
					for(a=0;a<t;a++){
						if(Tabinfo[a].tipo=="aproximadas_ccpp" && Tabinfo[a].fichero==fichero) break;
					}
					b=guardaapr(guardado,a,activa);
					break;
				case "apoyo":
					b=guardaapy(guardado,activa);
					break;
				case "GPS":
					b=guardagps(guardado,activa);
					break;
				default:
					Panel1.MessageBoxAT.Show(get_texto(Los_datos_de_esta_tabla_no));
					return true;
			}

			if(!b){
				for(a=0;a<t;a++){
					if(Tabinfo[a].fichero==fichero)
						Tabinfo[a].fichero=guardado;
			}	}
			return b;
		}

		public bool guardatodo(){
			short i;
			bool b;

			b=false;
			i=activa;
			for(activa=0;activa<t;activa++){
				if(Tabinfo[activa].modificado) b=b || guardar();
			}
			activa=i;

			return b;
		}
		public bool cierra(){	//Como guardatodo pero preguntando
			short i;			//No se llama más que cuando se cierra el Editor
			bool b;
			ControlesAt.FormSiNo Formsino1;
			short ret=1;
			int dg;

			b=false;
			i=activa;
			for(activa=0;activa<t;activa++){
				if(Tabinfo[activa].modificado){
					if(ret!=2 && ret!=4){
						Formsino1=new FormSiNo(get_texto(Desea_guardar_los_cambios)+Tabinfo[activa].fichero+get_texto(Desea_guardar_cierre),idioma);
						ret=(short)Formsino1.ShowDialog(this.ParentForm);
						Formsino1.Dispose();
					}
					switch(ret){
						case 1:	case 2:
							if(b=guardar()){
								dg=Panel1.ShowMessageWait(get_texto(Desea_continuar_cerrando)+Tabinfo[activa].fichero+get_texto(se_perderán),Globales.Textos.YesNo(idioma),2);
								if(dg!=1) b=false;
								else{activa=i; return true;}
							}
							break;
						case 3:	case 4:
							break;
						case 5: {activa=i; return true;}
					}
			}	}
			return false;
		}
	#region guardaficheros
		private bool guardaf(string fichero,short a){
			int i,n;
			DataTable DT;
			DataRow Rowaux;
			string ss;

			try{
				try{
					filew= new System.IO.StreamWriter(fichero,false,System.Text.Encoding.Default);
				}catch(System.IO.IOException){
					Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(14,fichero,idioma));
					return true;
				}

				DT=DS.Tables[a];
				n=DT.Rows.Count;
				for(i=0;i<n;i++){
					Rowaux=DT.Rows[i];
					ss=(string)Rowaux.ItemArray[0];
					if(ss!=""){
						filew.WriteLine();
						filew.Write("-ff\t");
						filew.Write(ss); filew.Write('\t');
						filew.Write(Rowaux.ItemArray[1]); filew.Write('\t');
						filew.Write(Rowaux.ItemArray[2]);
						filew.WriteLine();
					}else{
						filew.Write( ((string)Rowaux.ItemArray[1]).PadLeft(9) ); filew.Write(' ');
						filew.Write( ((string)Rowaux.ItemArray[2]).PadLeft(10) ); filew.Write(' ');
						filew.Write( ((string)Rowaux.ItemArray[3]).PadLeft(10) ); filew.Write("   ");
						filew.Write(Rowaux.ItemArray[4]);
						if((string)Rowaux.ItemArray[5]!=""){
							filew.Write("  ;"); filew.Write(Rowaux.ItemArray[5]);
						}
						filew.WriteLine();
					}
				}

				filew.Close();
				Tabinfo[a].modificado=false;
			}catch(System.IO.IOException){
				Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(17,fichero,idioma));
				return true;
			}
			return false;
		}
		private bool guardaapr(string fichero,short a1,short a2){
			int i,n;
			DataTable DT;
			DataRow Rowaux;

			try{
				try{
					filew= new System.IO.StreamWriter(fichero,false,System.Text.Encoding.Default);
				}catch(System.IO.IOException){
					Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(14,fichero,idioma));
					return true;
				}

				if(a1>=0 && a1<t){
					DT=DS.Tables[a1];
					n=DT.Rows.Count;
					if(n==0) goto fincentros;
					filew.WriteLine("-ccpp");
					for(i=0;i<n;i++){
						Rowaux=DT.Rows[i];
						filew.Write( ((string)Rowaux.ItemArray[0]).PadLeft(9) ); filew.Write(' ');
						Formato.NumberDecimalDigits=3;
						filew.Write( ((double)Rowaux.ItemArray[1]).ToString("N",Formato).PadLeft(13) ); filew.Write(' ');
						filew.Write( ((double)Rowaux.ItemArray[2]).ToString("N",Formato).PadLeft(13) ); filew.Write(' ');
						filew.Write( ((double)Rowaux.ItemArray[3]).ToString("N",Formato).PadLeft(13) ); filew.Write(' ');
						if(uni==0) Formato.NumberDecimalDigits=6;
						else Formato.NumberDecimalDigits=4;
						filew.Write( ((double)Rowaux.ItemArray[4]).ToString("N",Formato).PadLeft(10) ); filew.Write(' ');
						filew.Write( ((double)Rowaux.ItemArray[5]).ToString("N",Formato).PadLeft(10) ); filew.Write(' ');
						filew.Write( ((double)Rowaux.ItemArray[6]).ToString("N",Formato).PadLeft(10) );
						filew.Write("   "); filew.Write(Rowaux.ItemArray[7]);
						filew.WriteLine();
					}
				}
			fincentros:

				if(a2>=0 && a2<t){
					DT=DS.Tables[a2];
					n=DT.Rows.Count;
					if(n==0) goto finpuntos;
					filew.WriteLine();
					filew.WriteLine("-pp");
					for(i=0;i<n;i++){
						Rowaux=DT.Rows[i];
						filew.Write( ((string)Rowaux.ItemArray[0]).PadLeft(9) ); filew.Write(' ');
						Formato.NumberDecimalDigits=3;
						filew.Write( ((double)Rowaux.ItemArray[1]).ToString("N",Formato).PadLeft(13) ); filew.Write(' ');
						filew.Write( ((double)Rowaux.ItemArray[2]).ToString("N",Formato).PadLeft(13) ); filew.Write(' ');
						filew.Write( ((double)Rowaux.ItemArray[3]).ToString("N",Formato).PadLeft(13) );
						filew.Write("   "); filew.Write(Rowaux.ItemArray[4]);
						filew.WriteLine();
					}
				}
			finpuntos:

				filew.Close();
				Tabinfo[a1].modificado=false;
				Tabinfo[a2].modificado=false;
			}catch(System.IO.IOException){
				Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(17,fichero,idioma));
				return true;
			}
			return false;
		}
		private bool guardaapy(string fichero,short a){
			int i,n;
			DataTable DT;
			DataRow Rowaux;
			string sp1,sp2;

			try{
				try{
					filew= new System.IO.StreamWriter(fichero,false,System.Text.Encoding.Default);
				}catch(System.IO.IOException){
					Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(14,fichero,idioma));
					return true;
				}

				DT=DS.Tables[a];
				n=DT.Rows.Count;
				if(n>0) filew.WriteLine("-pp");
				for(i=0;i<n;i++){
					Rowaux=DT.Rows[i];
					filew.Write( ((string)Rowaux.ItemArray[0]).PadLeft(9) ); filew.Write(' ');
					Formato.NumberDecimalDigits=3;
					filew.Write( ((double)Rowaux.ItemArray[1]).ToString("N",Formato).PadLeft(13) ); filew.Write(' ');
					filew.Write( ((double)Rowaux.ItemArray[2]).ToString("N",Formato).PadLeft(13) ); filew.Write(' ');
					filew.Write( ((double)Rowaux.ItemArray[3]).ToString("N",Formato).PadLeft(13) ); filew.Write("   ");
					filew.Write(Rowaux.ItemArray[4]);
					sp2=(string)Rowaux.ItemArray[6];
					if((sp1=(string)Rowaux.ItemArray[5])!="" || sp2!=""){
						filew.Write("  ;"); filew.Write(sp1);
						if(sp2!=""){ filew.Write(" ;"); filew.Write(sp2);}
					}
					filew.WriteLine();
				}
				filew.Close();
				Tabinfo[a].modificado=false;
			}catch(System.IO.IOException){
				Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(17,fichero,idioma));
				return true;
			}
			return false;
		}
		private bool guardagps(string fichero,short a){
			int i,n;
			DataTable DT;
			DataRow Rowaux;
			string ss;
			string sp1,sp2;
			bool bg,bi;
			short k;

			try{
				try{
					filew= new System.IO.StreamWriter(fichero,false,System.Text.Encoding.Default);
				}catch(System.IO.IOException){
					Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(14,fichero,idioma));
					return true;
				}

				bg=true; bi=false;
				DT=DS.Tables[a];
				n=DT.Rows.Count;
				for(i=0;i<n;i++){
					Rowaux=DT.Rows[i];
					ss=(string)Rowaux.ItemArray[0];
					if(ss!=""){
						bg=ss.IndexOf("gps")!=-1;
						bi=ss.IndexOf("ins")!=-1;
						filew.WriteLine();
						filew.Write(ss); filew.Write(' ');
						ss=(string)Rowaux.ItemArray[2];
						sp1=(string)Rowaux.ItemArray[3];
						sp2=(string)Rowaux.ItemArray[4];
						if(ss!="" || sp1!="" || sp2!=""){
							filew.Write("gpsoffset= ");
							filew.Write(ss.PadLeft(9)); filew.Write(' ');
							filew.Write(sp1.PadLeft(9)); filew.Write(' ');
							filew.Write(sp2.PadLeft(9)); filew.Write("   ");
						}
						ss=(string)Rowaux.ItemArray[6];
						if(ss!=""){
							filew.Write("tipogps= "+ss); filew.Write("   ");
						}
						ss=(string)Rowaux.ItemArray[7];
						if(ss!=""){
							filew.Write("tipoins= "+ss); filew.Write("   ");
						}
						if(bg){
							ss=(string)Rowaux.ItemArray[9];
							if(ss=="") ss="0";
							filew.Write(ss); filew.Write(' ');
						}
						if(bi){
							ss=(string)Rowaux.ItemArray[10];
							if(ss=="") ss="0";
							filew.Write(ss); filew.Write(' ');
						}
						k=0;
						if(bg){
							sp2=(string)Rowaux.ItemArray[12];
							if((sp1=(string)Rowaux.ItemArray[11])!="" || sp2!=""){
								k=1;
								filew.Write("  ;"); filew.Write(sp1);
								if(sp2!=""){
									k=2;
									filew.Write(" ;"); filew.Write(sp2);
								}
							}
						}else{ k=2;}
						if(bi){
							sp2=(string)Rowaux.ItemArray[14];
							if((sp1=(string)Rowaux.ItemArray[13])!="" || sp2!=""){
								for(;k<2;k++) filew.Write(" ;");
								k=3;
								filew.Write("  ;"); filew.Write(sp1);
								if(sp2!=""){
									k=4;
									filew.Write(" ;"); filew.Write(sp2);
								}
							}
						}
						filew.WriteLine();
					}else{
						filew.Write( ((string)Rowaux.ItemArray[1]).PadLeft(9) ); filew.Write(' ');
						if(bg){
							filew.Write( ((string)Rowaux.ItemArray[2]).PadLeft(13) ); filew.Write(' ');
							filew.Write( ((string)Rowaux.ItemArray[3]).PadLeft(13) ); filew.Write(' ');
							filew.Write( ((string)Rowaux.ItemArray[4]).PadLeft(13) ); filew.Write(' ');
						}
						if(bi){
							filew.Write( ((string)Rowaux.ItemArray[5]).PadLeft(13) ); filew.Write(' ');
							filew.Write( ((string)Rowaux.ItemArray[6]).PadLeft(13) ); filew.Write(' ');
							filew.Write( ((string)Rowaux.ItemArray[7]).PadLeft(13) ); filew.Write(' ');
						}
						filew.Write( ((string)Rowaux.ItemArray[8]).PadLeft(13) ); filew.Write("   ");
						if(bg){
							ss=(string)Rowaux.ItemArray[9];
							if(ss=="") ss="0";
							filew.Write(ss); filew.Write(' ');
						}
						if(bi){
							ss=(string)Rowaux.ItemArray[10];
							if(ss=="") ss="0";
							filew.Write(ss); filew.Write(' ');
						}
						k=0;
						if(bg){
							sp2=(string)Rowaux.ItemArray[12];
							if((sp1=(string)Rowaux.ItemArray[11])!="" || sp2!=""){
								k=1;
								filew.Write("  ;"); filew.Write(sp1);
								if(sp2!=""){
									k=2;
									filew.Write(" ;"); filew.Write(sp2);
								}
							}
						}else{ k=2;}
						if(bi){
							sp2=(string)Rowaux.ItemArray[14];
							if((sp1=(string)Rowaux.ItemArray[13])!="" || sp2!=""){
								for(;k<2;k++) filew.Write(" ;");
								k=3;
								filew.Write("  ;"); filew.Write(sp1);
								if(sp2!=""){
									k=4;
									filew.Write(" ;"); filew.Write(sp2);
								}
							}
						}
						filew.WriteLine();
					}
				}

				filew.Close();
				Tabinfo[a].modificado=false;
			}catch(System.IO.IOException){
				Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(17,fichero,idioma));
				return true;
			}
			return false;
		}
	#endregion
	#endregion
	#region Ordenar
		private void ODefecto_Click(object sender,System.EventArgs e)
		{
			((DataView)DataGrid1.DataSource).Sort="sort_def";
		}
		private void pop2OResiduo_Click(object sender,System.EventArgs e)
		{
			((DataView)DataGrid1.DataSource).Sort="sort_res";
		}
		private void pop2OResiduo_norm_Click(object sender,System.EventArgs e)
		{
			((DataView)DataGrid1.DataSource).Sort="sort_res_norm";
		}
	#endregion
	#region Edicion
		private void DataGrid1_CurrentCellChanged(object sender,System.EventArgs e){
			GridColumnStylesCollection GCS;
			switch(Tabinfo[activa].tipo){
			   case "fotogramas":
				GCS=DataGrid1.TableStyles["fotogramas"].GridColumnStyles;
				if((string)DataGrid1[DataGrid1.CurrentRowIndex,0]!=""){
					GCS[1].HeaderText="- "+get_texto(Focal)+" -";
					GCS[2].HeaderText="- "+get_texto(Marca)+" -";
					GCS[3].HeaderText="";
					GCS[4].HeaderText="";
					GCS[5].HeaderText="";
				}else{
					GCS[1].HeaderText="- "+get_texto(Punto)+" -";
					GCS[2].HeaderText="- x -";
					GCS[3].HeaderText="- y -";
					GCS[4].HeaderText="- "+get_texto(Marca)+" -";
					GCS[5].HeaderText="- "+get_texto(PrecisiónParticular)+" -";
				}
				DataGrid1.Refresh();
				break;
			   case "GPS":
				GCS=DataGrid1.TableStyles["GPS"].GridColumnStyles;
				if((string)DataGrid1[DataGrid1.CurrentRowIndex,0]!=""){
					GCS[1].HeaderText="";
					GCS[2].HeaderText="- "+get_texto(OffsetX)+" -";
					GCS[3].HeaderText="- "+get_texto(OffsetY)+" -";
					GCS[4].HeaderText="- "+get_texto(OffsetZ)+" -";
					GCS[5].HeaderText="";
					GCS[6].HeaderText="- "+get_texto(tipogps)+" -";
					GCS[7].HeaderText="- "+get_texto(tipoins)+" -";
					GCS[8].HeaderText="";
				}else{
					GCS[1].HeaderText="- "+get_texto(Nombre)+" -";
					GCS[2].HeaderText="- X -";
					GCS[3].HeaderText="- Y -";
					GCS[4].HeaderText="- Z -";
					GCS[5].HeaderText="- Ω -";
					GCS[6].HeaderText="- Φ -";
					GCS[7].HeaderText="- Κ -";
					GCS[8].HeaderText="- t -";
				}
				DataGrid1.Refresh();
				break;
			   case "res_porpuntos":
				GCS=DataGrid1.TableStyles["porpuntos"].GridColumnStyles;
				if((string)DataGrid1[DataGrid1.CurrentRowIndex,0]!=""){
					GCS[1].HeaderText="- "+get_texto(Tipo)+" -";
					GCS[2].HeaderText="- "+get_texto(Aviso)+" -";
					GCS[3].HeaderText="";
					GCS[4].HeaderText="";
					GCS[5].HeaderText="";
				}else{
					GCS[1].HeaderText="- "+get_texto(Fotograma)+" -";
					GCS[2].HeaderText="- "+get_texto(Residuox)+" -";
					GCS[3].HeaderText="- "+get_texto(Residuoy)+" -";
					GCS[4].HeaderText="- "+get_texto(Ordx)+" -";
					GCS[5].HeaderText="- "+get_texto(Ordy)+" -";
				}
				DataGrid1.Refresh();
				break;
			}
		}

		private void Tables_RowChanged(object sender,DataRowChangeEventArgs e)
		{
			Tabinfo[activa].modificado=true;
		}

		private void pop1EInsertararr_Click(object sender,System.EventArgs e)
		{
			int l,m;
			DataTable DT;
			bool b;
			b=(Tabinfo[activa].tipo!="fotogramas" && Tabinfo[activa].tipo!="GPS");

			DT=DS.Tables[activa];
			m=DT.Columns.Count;
			l=DataGrid1.CurrentRowIndex;
			if(l==-1){
				pop1EInsertarab_Click(sender,e);
				return;
			}
			if(b) l=(int)(uint)DataGrid1[l,m-1];
			insertafila(DT,activa,l,b);
		}
		private void pop1EInsertarab_Click(object sender,System.EventArgs e)
		{
			int l,m;
			DataTable DT;
			bool b;
			b=(Tabinfo[activa].tipo!="fotogramas" && Tabinfo[activa].tipo!="GPS");

			DT=DS.Tables[activa];
			m=DT.Columns.Count;
			l=DataGrid1.CurrentRowIndex;
			if(b && l!=-1) l=(int)(uint)DataGrid1[l,m-1];
			l++;
			insertafila(DT,activa,l,b);
		}
		private void insertafila(DataTable DT, short tabla, int l,bool b){
			int i,m,n;
			object[] Array;
			string s;

			m=DT.Columns.Count;
			n=DT.Rows.Count;
			Tabinfo[tabla].deshacer=true;
			pop1EDeshacer.Enabled=true;
			Tabinfo[tabla].des_lim_ab=l;
			Tabinfo[tabla].des_lim_arr=l+1;

			DT.Rows.Add(DT.NewRow());
			for(i=n;i>l;i--){
				Array=DT.Rows[i-1].ItemArray;
				if(b) Array[m-1]=(uint)i;
				DT.Rows[i].ItemArray=Array;
			}
			n++;
		 Array=DT.NewRow().ItemArray;
			switch(Tabinfo[tabla].tipo){
			  case "fotogramas":
				Array[1]="???";
				Array[2]=Array[3]="0";
				Array[4]="11";
				break;
			  case "GPS":
				for(i=l;i>0;){
					i--;
					if((string)DT.Rows[i].ItemArray[0]!="")
					break;
				}
				s=(string)DT.Rows[i].ItemArray[0];
				Array[1]="???";
				Array[8]="0";
				if(s=="-gps" || s=="-gpsins"){
					Array[2]=Array[3]=Array[4]="0";
					Array[9]="1";
				}
				if(s=="-ins" || s=="-gpsins"){
					Array[5]=Array[6]=Array[7]="0";
					Array[10]="1";
				}
				break;
			}
			if(b) Array[m-1]=l;
			DT.Rows[l].ItemArray=Array;
			DT.AcceptChanges();
			Tabinfo[tabla].modificado=true;
		 pop1EEliminar.Enabled=true;
			pop1ODefecto.Enabled=true;
		}

		private void pop1EEliminar_Click(object sender,System.EventArgs e)
		{
			int i,l,n,m;
			DataTable DT,DT2;
			object[] Array;
			bool b;
			b=(Tabinfo[activa].tipo!="fotogramas" && Tabinfo[activa].tipo!="GPS");

			DT=DS.Tables[activa];
			m=DT.Columns.Count;
			l=DataGrid1.CurrentRowIndex;
			if(b) l=(int)(uint)DataGrid1[l,m-1];
			n=DT.Rows.Count;
			DT2=Tabinfo[activa].DT_deshacer;

			DT2.Rows.Clear(); DT2.AcceptChanges();
			DT2.Rows.Add(DT.Rows[l].ItemArray);
			Tabinfo[activa].deshacer=true;
			pop1EDeshacer.Enabled=true;
			Tabinfo[activa].des_lim_ab=-l;
			Tabinfo[activa].des_lim_arr=-(l+1);

			for(i=l+1;i<n;i++){
				Array=DT.Rows[i].ItemArray;
				if(b) Array[m-1]=(uint)(i-1);
				DT.Rows[i-1].ItemArray=Array;
			}
			n--;
			DT.Rows.RemoveAt(n);
			DT.AcceptChanges();
			Tabinfo[activa].modificado=true;
			if(n==0){
				pop1EEliminar.Enabled=false;
				pop1ODefecto.Enabled=false;
				if(!b){
					pop1EInsertararr.Enabled=false;
					pop1EInsertarab.Enabled=false;
				}
			}
		}

		private void pop1EInsertarfotoarr_Click(object sender,System.EventArgs e)
		{
			int l,n,m;
			DataTable DT;
			bool b;
			b=(Tabinfo[activa].tipo!="fotogramas" && Tabinfo[activa].tipo!="GPS");

			DT=DS.Tables[activa];
			m=DT.Columns.Count;
			l=DataGrid1.CurrentRowIndex;
			if(l==-1){
				pop1EInsertarfotoab_Click(sender,e);
				return;
			}
			if(b) l=(int)(uint)DataGrid1[l,m-1];
			n=DT.Rows.Count;

			for(;l>0;l--){
				if((string)DT.Rows[l].ItemArray[0]!="")
					break;
			}
			insertagrupo(DT,activa,l,b);
		}
		private void pop1EInsertarfotoab_Click(object sender,System.EventArgs e)
		{
			int l,n,m;
			DataTable DT;
			bool b;
			b=(Tabinfo[activa].tipo!="fotogramas" && Tabinfo[activa].tipo!="GPS");

			DT=DS.Tables[activa];
			m=DT.Columns.Count;
			l=DataGrid1.CurrentRowIndex;
			if(b && l!=-1) l=(int)(uint)DataGrid1[l,m-1];
			n=DT.Rows.Count;

			for(l++;l<n;l++){
				if((string)DT.Rows[l].ItemArray[0]!="")
					break;
			}
			insertagrupo(DT,activa,l,b);
		}
		private void insertagrupo(DataTable DT, short tabla, int l,bool b){
			int i,m,n;
			object[] Array;

			m=DT.Columns.Count;
			n=DT.Rows.Count;
			Tabinfo[tabla].deshacer=true;
			pop1EDeshacer.Enabled=true;
			Tabinfo[tabla].des_lim_ab=l;
			Tabinfo[tabla].des_lim_arr=l+2;

			DT.Rows.Add(DT.NewRow());
			DT.Rows.Add(DT.NewRow());
			for(i=n;i>l;){
				i--;
				Array=DT.Rows[i].ItemArray;
				if(b) Array[m-1]=(uint)i+2;
				DT.Rows[i+2].ItemArray=Array;
			}
			n+=2;
			Array=DT.Rows[l].ItemArray;
			switch(Tabinfo[tabla].tipo){
				case "fotogramas":
					Array[0]="???";
					Array[1]="100.000";
					Array[2]="1";
					break;
				case "GPS":
					Tresopciones1=new TresOpciones(lastgps,idioma);
					lastgps=(short)Tresopciones1.ShowDialog(this.ParentForm);
					Tresopciones1.Dispose();
					switch(lastgps){
					  case 1:
						Array[0]="-gps";
						Array[9]="1";
						break;
					  case 2:
						Array[0]="-ins";
						Array[10]="1";
						break;
					  case 3:
						Array[0]="-gpsins";
						Array[9]="1";
						Array[10]="1";
						break;
					}
					break;
				default:
					Array[m-1]=l;
					break;
			}
			DT.Rows[l].ItemArray=Array;

			Array=DT.Rows[l+1].ItemArray;
			switch(Tabinfo[tabla].tipo){
				case "fotogramas":
					Array[1]="???";
					Array[2]=Array[3]="0";
					Array[4]="11";
					break;
				case "GPS":
					Array[1]="???";
					Array[8]="0";
					if(lastgps==1 || lastgps==3){
						Array[2]=Array[3]=Array[4]="0";
						Array[9]="1";
					}
					if(lastgps==2 || lastgps==3){
						Array[5]=Array[6]=Array[7]="0";
						Array[10]="1";
					}
					break;
				default:
					Array[m-1]=l;
					break;
			}
			DT.Rows[l+1].ItemArray=Array;

			Tabinfo[tabla].modificado=true;
			pop1EEliminarfoto.Enabled=true;
			pop1EEliminar.Enabled=true;
			pop1EInsertararr.Enabled=true;
			pop1EInsertarab.Enabled=true;
		}
		private void pop1EEliminarfoto_Click(object sender,System.EventArgs e)
		{
			int i,l,ll,n,m,k;
			DataTable DT,DT2;
			object[] Array;
			bool b;
			b=(Tabinfo[activa].tipo!="fotogramas" && Tabinfo[activa].tipo!="GPS");

			DT=DS.Tables[activa];
			m=DT.Columns.Count;
			l=DataGrid1.CurrentRowIndex;
			if(b) l=(int)(uint)DataGrid1[l,m-1];
			ll=l;
			n=DT.Rows.Count;
			DT2=Tabinfo[activa].DT_deshacer;

		 for(;l>0;l--){
				if((string)DT.Rows[l].ItemArray[0]!="")
					break;
			}
			for(ll++;ll<n;ll++){
				if((string)DT.Rows[ll].ItemArray[0]!="")
					break;
			}
			k=ll-l;

			DT2.Rows.Clear();
			for(i=l;i<ll;i++){
				DT2.Rows.Add(DT.Rows[i].ItemArray);
			}
			DT2.AcceptChanges();
			Tabinfo[activa].deshacer=true;
			pop1EDeshacer.Enabled=true;
			Tabinfo[activa].des_lim_ab=-l;
			Tabinfo[activa].des_lim_arr=-ll;

			for(i=ll;i<n;i++){
				Array=DT.Rows[i].ItemArray;
				if(b) Array[m-1]=(uint)(i-k);
				DT.Rows[i-k].ItemArray=Array;
			}
			for(i=0;i<k;i++){
				DT.Rows.RemoveAt(n-1-i);
			}
			DT.AcceptChanges();
			Tabinfo[activa].modificado=true;
			n-=k;
			if(n==0){
				pop1EEliminarfoto.Enabled=false;
				pop1EEliminar.Enabled=false;
				pop1EInsertararr.Enabled=false;
				pop1EInsertarab.Enabled=false;
			}
		}
		private void pop1EDeshacer_Click(object sender,System.EventArgs e)
		{
			int l,ll,k;
			int i,n,m;
			DataTable DT,DT2;
			object[] Array;
			bool b;

		 DT=DS.Tables[activa];
			b=DT.Columns.Contains("sort_def");
			n=DT.Rows.Count;
			m=DT.Columns.Count;
			DT2=Tabinfo[activa].DT_deshacer;

			if(Tabinfo[activa].des_lim_arr<0){
				l=-Tabinfo[activa].des_lim_ab;
				ll=-Tabinfo[activa].des_lim_arr;
				k=ll-l;
				for(i=0;i<k;i++)
					DT.Rows.Add(DT.NewRow());
				for(i=n;i>l;){
					i--;
					Array=DT.Rows[i].ItemArray;
					if(b) Array[m-1]=(uint)(i+k);
					DT.Rows[i+k].ItemArray=Array;
				}
				for(i=0;i<k;i++){
					DT.Rows[l+i].ItemArray=DT2.Rows[i].ItemArray;
				}
				DT2.Rows.Clear();
				DT.AcceptChanges();
				DT2.AcceptChanges();

				Tabinfo[activa].deshacer=false;
				pop1EDeshacer.Enabled=false;

			}else{
				l=Tabinfo[activa].des_lim_ab;
				ll=Tabinfo[activa].des_lim_arr;
				k=ll-l;

				for(i=ll;i<n;i++){
					Array=DT.Rows[i].ItemArray;
					if(b) Array[m-1]=(uint)(i-k);
					DT.Rows[i-k].ItemArray=Array;
				}
				for(i=0;i<k;i++){
					DT.Rows.RemoveAt(n-1-i);
				}
				DT.AcceptChanges();

				Tabinfo[activa].deshacer=false;
				pop1EDeshacer.Enabled=false;
			}
		}
		#endregion

		protected override void update_idioma(){
			pop1Archivo.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Archivo,idioma);
			pop1AGuardar.Text=get_texto(Guardar);
			pop1AGuardarcomo.Text=get_texto(GComo);

			pop1Ordenar.Text=get_texto(Ordenar_por);
			pop1ODefecto.Text=get_texto(Orden_por_defecto);

			pop1Edicion.Text=get_texto(Edición);
			pop1EInsertararr.Text=get_texto(Insertar_punto_arriba);
			pop1EInsertarab.Text=get_texto(Insertar_punto_abajo);
			pop1EEliminar.Text=get_texto(Eliminar_punto);
			pop1EInsertarfotoarr.Text=get_texto(Insertar_fg_arriba);
			pop1EInsertarfotoab.Text=get_texto(Insertar_fg_abajo);
			pop1EEliminarfoto.Text=get_texto(Eliminar_fg);
			pop1EDeshacer.Text=get_texto(Deshacer);

			pop2Ordenar.Text=get_texto(Ordenar_por);
			pop2ODefecto.Text=get_texto(Orden_por_defecto);
			pop2OResiduo.Text=get_texto(Residuo);
			pop2OResiduo_norm.Text=get_texto(Residuo_normalizado);
		}
		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
