﻿using Globales;

namespace ControlesAt{
	internal static class Textos{
		public enum Cods : uint{
			Versión,
			Elipsoide,
			Sistema,
			Ondulación,
			Geográficas,
			Conforme_genérico,
			Rectangular,
			Otro,
			Esfera,
			BuscarReemplazar,
			BR_entodos,
			Buscar,
			Reemplazar_con,
			Reemplazar,
			Reemplazar_todo,
			LatLong,
			LongLat,
			Valor_R_erróneo,
			Radio,
			Valor_a_erróneo,
			Valor_N_erróneo,
			Valor_ρ_erróneo,
			Valor_convergencia_erróneo,
			Valor_k_erróneo,
			Radio_mayor,
			Radio_menor,
			Conv_meridianos,
			Factor_de_escala,
			Valor_X_erróneo,
			Valor_Y_erróneo,
			Valor_lat_origen_erróneo,
			Latitud_origen,
			Escala_central,
			Desplazamiento_X,
			Desplazamiento_Y,
			Valor_e_erróneo,
			Semieje_mayor,
			Excentricidad,
			Sistema_imagen,
			Sistema_terreno,
			Sistema_de_medida,
			Sistema_fiducial,
			Tipo_de_grupo,
			NTEXTOS,
		}

		private static readonly string[] esp,eng,it;
		private static readonly string[][] textos;

		static Textos(){
			textos=new string[(int)Idioma.NIDIOMAS][];
			esp=new string[(int)Cods.NTEXTOS];
			eng=new string[(int)Cods.NTEXTOS];
			it=new string[(int)Cods.NTEXTOS];
			setup_esp();
			setup_eng();
			setup_it();

			textos[(int)Idioma.Esp]=esp;
			textos[(int)Idioma.Eng]=eng;
			textos[(int)Idioma.It]=it;
		}

		public static string get_texto(Cods cod, Idioma idioma){
			string[] t=textos[(int)idioma];
				if(t==null) t=textos[(int)Idioma.Esp];
			string s=t[(int)cod];
				if(s==null) s=textos[(int)Idioma.Esp][(int)cod];
			return s;
		}

		static void setup_esp(){
			esp[(int)Cods.Versión]="Versión";
			esp[(int)Cods.Elipsoide]="Elipsoide";
			esp[(int)Cods.Sistema]="Sistema";
			esp[(int)Cods.Ondulación]="Ondulación\ndel geoide";
			esp[(int)Cods.Geográficas]="Geográficas";
			esp[(int)Cods.Conforme_genérico]="Conforme genérico";
			esp[(int)Cods.Rectangular]="Rectangular";
			esp[(int)Cods.Otro]="Otro";
			esp[(int)Cods.Esfera]="Esfera";
			esp[(int)Cods.BuscarReemplazar]="Buscar/Reemplazar";
			esp[(int)Cods.BR_entodos]="Buscar/Reemplazar en todos los ficheros";
			esp[(int)Cods.Buscar]="Buscar";
			esp[(int)Cods.Reemplazar_con]="Reemplazar con";
			esp[(int)Cods.Reemplazar]="Reemplazar";
			esp[(int)Cods.Reemplazar_todo]="Reemplazar todo";
			esp[(int)Cods.LatLong]="Lat.-Long.";
			esp[(int)Cods.LongLat]="Long.-Lat.";
			esp[(int)Cods.Valor_R_erróneo]="Valor de R erróneo";
			esp[(int)Cods.Radio]="Radio";
			esp[(int)Cods.Valor_a_erróneo]="Valor de a erróneo";
			esp[(int)Cods.Valor_N_erróneo]="Valor de N erróneo";
			esp[(int)Cods.Valor_ρ_erróneo]="Valor de ρ erróneo";
			esp[(int)Cods.Valor_convergencia_erróneo]="Valor de convergencia de meridianos erróneo";
			esp[(int)Cods.Valor_k_erróneo]="Valor de k erróneo";
			esp[(int)Cods.Radio_mayor]="Radio mayor (N)";
			esp[(int)Cods.Radio_menor]="Radio menor (ρ)";
			esp[(int)Cods.Conv_meridianos]="Conv. de meridianos (°)";
			esp[(int)Cods.Factor_de_escala]="Factor de escala (k)";
			esp[(int)Cods.Valor_X_erróneo]="Valor de X erróneo";
			esp[(int)Cods.Valor_Y_erróneo]="Valor de Y erróneo";
			esp[(int)Cods.Valor_lat_origen_erróneo]="Valor de latitud origen erróneo";
			esp[(int)Cods.Latitud_origen]="Latitud origen (°)";
			esp[(int)Cods.Escala_central]="Escala central (K0)";
			esp[(int)Cods.Desplazamiento_X]="Desplazamiento X";
			esp[(int)Cods.Desplazamiento_Y]="Desplazamiento Y";
			esp[(int)Cods.Valor_e_erróneo]="Valor de e erróneo";
			esp[(int)Cods.Semieje_mayor]="Semieje mayor (a)";
			esp[(int)Cods.Excentricidad]="Excentricidad (e2)";
			esp[(int)Cods.Sistema_imagen]="Sistema imagen";
			esp[(int)Cods.Sistema_terreno]="Sistema terreno";
			esp[(int)Cods.Sistema_de_medida]="Sistema de medida";
			esp[(int)Cods.Sistema_fiducial]="Sistema fiducial";
			esp[(int)Cods.Tipo_de_grupo]="Tipo de grupo";
		}
		static void setup_eng(){
			eng[(int)Cods.Versión]="Version";
			eng[(int)Cods.Elipsoide]="Ellipsoid";
			eng[(int)Cods.Sistema]="System";
			eng[(int)Cods.Ondulación]="Geoid ondulation";
			eng[(int)Cods.Geográficas]="Geographical";
			eng[(int)Cods.Conforme_genérico]="Conformal generic";
			eng[(int)Cods.Rectangular]="Rectangular";
			eng[(int)Cods.Otro]="Other";
			eng[(int)Cods.Esfera]="Sphere";
			eng[(int)Cods.BuscarReemplazar]="Find/Replace";
			eng[(int)Cods.BR_entodos]="Find/Replace in all files";
			eng[(int)Cods.Buscar]="Find";
			eng[(int)Cods.Reemplazar_con]="Replace with";
			eng[(int)Cods.Reemplazar]="Replace";
			eng[(int)Cods.Reemplazar_todo]="Replace all";
			eng[(int)Cods.LatLong]="Lat.-Long.";
			eng[(int)Cods.LongLat]="Long.-Lat.";
			eng[(int)Cods.Valor_R_erróneo]="Wrong value for R";
			eng[(int)Cods.Radio]="Radius";
			eng[(int)Cods.Valor_a_erróneo]="Wrong value for a";
			eng[(int)Cods.Valor_N_erróneo]="Wrong value for N";
			eng[(int)Cods.Valor_ρ_erróneo]="Wrong value for ρ";
			eng[(int)Cods.Valor_convergencia_erróneo]="Wrong value for the meridian convergence";
			eng[(int)Cods.Valor_k_erróneo]="Wrong value for k";
			eng[(int)Cods.Radio_mayor]="Greatest radius (N)";
			eng[(int)Cods.Radio_menor]="Smallest radius (ρ)";
			eng[(int)Cods.Conv_meridianos]="Meridian conv. (°)";
			eng[(int)Cods.Factor_de_escala]="Scale factor (k)";
			eng[(int)Cods.Valor_X_erróneo]="Wrong value for X";
			eng[(int)Cods.Valor_Y_erróneo]="Wrong value for Y";
			eng[(int)Cods.Valor_lat_origen_erróneo]="Wrong value for the origin latitude";
			eng[(int)Cods.Latitud_origen]="Origin latitude (°)";
			eng[(int)Cods.Escala_central]="Central scale (K0)";
			eng[(int)Cods.Desplazamiento_X]="X displacement";
			eng[(int)Cods.Desplazamiento_Y]="Y displacement";
			eng[(int)Cods.Valor_e_erróneo]="Wrong value for e";
			eng[(int)Cods.Semieje_mayor]="Semi-mayor axis (a)";
			eng[(int)Cods.Excentricidad]="Eccentricity (e2)";
			eng[(int)Cods.Sistema_imagen]="Image system";
			eng[(int)Cods.Sistema_terreno]="Terrain system";
			eng[(int)Cods.Sistema_de_medida]="Measure system";
			eng[(int)Cods.Sistema_fiducial]="Fiducial system";
			eng[(int)Cods.Tipo_de_grupo]="Group type";
		}
		static void setup_it(){
			it[(int)Cods.Versión]="Versione";
			it[(int)Cods.Elipsoide]="Ellissoide";
			it[(int)Cods.Sistema]="Sistema";
			it[(int)Cods.Ondulación]="Ondulazione\ndel geoide";
			it[(int)Cods.Geográficas]="Geografiche";
			it[(int)Cods.Conforme_genérico]="Conforme generico";
			it[(int)Cods.Rectangular]="Rettangolare";
			it[(int)Cods.Otro]="Altro";
			it[(int)Cods.Esfera]="Sfera";
			it[(int)Cods.BuscarReemplazar]="Ricerca/Sostituzione";
			it[(int)Cods.BR_entodos]="Ricerca/Sostituzione in tutti i file";
			it[(int)Cods.Buscar]="Trova";
			it[(int)Cods.Reemplazar_con]="Sostituisci con";
			it[(int)Cods.Reemplazar]="Sostituisci";
			it[(int)Cods.Reemplazar_todo]="Sostituisci tutto";
			it[(int)Cods.LatLong]="Lat.-Long";
			it[(int)Cods.LongLat]="Long.-Lat.";
			it[(int)Cods.Valor_R_erróneo]="Valore di R erroneo";
			it[(int)Cods.Radio]="Raggio";
			it[(int)Cods.Valor_a_erróneo]="Valore di a erroneo";
			it[(int)Cods.Valor_N_erróneo]="Valore di N erroneo";
			it[(int)Cods.Valor_ρ_erróneo]="Valore di ρ erroneo";
			it[(int)Cods.Valor_convergencia_erróneo]="Valore di convergenza di meridiani erroneo";
			it[(int)Cods.Valor_k_erróneo]="Valore di k erroneo";
			it[(int)Cods.Radio_mayor]="Raggio maggiore (N)";
			it[(int)Cods.Radio_menor]="Raggio menore (ρ)";
			it[(int)Cods.Conv_meridianos]="Conv. di meridiani (°)";
			it[(int)Cods.Factor_de_escala]="Fattore di scala (k)";
			it[(int)Cods.Valor_X_erróneo]="Valore di X erroneo";
			it[(int)Cods.Valor_Y_erróneo]="Valore di Y erroneo";
			it[(int)Cods.Valor_lat_origen_erróneo]="Valore di latitude origine erroneo";
			it[(int)Cods.Latitud_origen]="Latitude origine (°)";
			it[(int)Cods.Escala_central]="Scala centrale (K0)";
			it[(int)Cods.Desplazamiento_X]="Spostamento X";
			it[(int)Cods.Desplazamiento_Y]="Spostamento Y";
			it[(int)Cods.Valor_e_erróneo]="Valore di e erroneo";
			it[(int)Cods.Semieje_mayor]="Semiasse maggiore (a)";
			it[(int)Cods.Excentricidad]="Eccentricità (e2)";
			it[(int)Cods.Sistema_imagen]="Sistema immagine";
			it[(int)Cods.Sistema_terreno]="Sistema terreno";
			it[(int)Cods.Sistema_de_medida]="Sistema di misura";
			it[(int)Cods.Sistema_fiducial]="Sistema fiduciale";
			it[(int)Cods.Tipo_de_grupo]="Tipo d'insieme";
		}
	}
}
