﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace ControlesAt{
using static Textos.Cods;
namespace SistemadeCoordenadas{
	public struct Elipsoide{
		public double a,e;
		private Elipsoide(double _a,double _e){a=_a; e=_e;}
		public static readonly Elipsoide[] conocidos={
			new Elipsoide(6378388, 0.00672267),	//Hayford
			new Elipsoide(6378137, 0.00669438),	//GRS80 / WGS84
			new Elipsoide(6377397, 0.006674372),	//Bessel 1841
			new Elipsoide(6378245, 0.006693422),	//Krassovsky
			new Elipsoide(6378160, 0.006694542),	//Sudamérica 1969
		};
	}
	public enum Proyeccion{Rectangular=0,Conforme,Lambert,Mercator,Mercator_Transversa,Geograficas=10};
	public struct Sistema{
		public struct Informacion{
			public System.IntPtr P_datum_and_projection_name;
			public System.IntPtr P_elip;
			public double lambda0;
			public double linear_units;
			public System.IntPtr P_linear_units_abr;
		}
		public Informacion infor;
		public struct Definicion{
			public double a, e;
			public double ond;
			public Proyeccion proy;
			public struct Param1{
				 public double par1; //Factor de escala por el que se multiplica sólo la y
				 public double par2; //Para pointed. Va de α=0: PlanoCuadra a α=1: Pointed
			};
			public Param1 param1;
			public double Λ0;
			public double k0;
			public double xO, yS;
		}
		public Definicion sis;
		private struct __0_{
			private double ak0;
		}
		private struct Valores_Proy{
			private double phi0;
			private double sinphi0;
			private double R0;
			private double d;
			private double c;
		}
		private struct Precalculados{
			private __0_ Comun;
			private Valores_Proy Lambert;
		};
		private Precalculados precalc;
		public struct Local{
			public double x1proy, y1proy;
			public double l1, phi1;
			public double X1, Y1, Z1;
			public double conv1;
		};
		public Local local;
	}

	public struct ElipsoideOtro{public double a,ee;}
	public struct Tierra{
		public double N,ρ,conv,k;
	}
	public struct ValoresSistemas{
		public double kUTM, kLambert;
		public double XUTM,YUTM, XLambert,YLambert;
		public int Phi0Lambert;		//milésismas de grado
		public byte LatLong;
	}
	public class CElipsoide{public ElipsoideOtro V;}
	public class CTierra{public Tierra V;}
	public class CValoresSistemas {public ValoresSistemas V;}

	public class ControlSistema : IdiomaControl, IEntorno{
	#region Variables
		public ControlesAt.MessageBoxAT MessageBoxAT;
		public MessageBoxAT MessageBox{get{return MessageBoxAT;}}
		protected BaseLabel Labelelip, Labelsis, Labelond;
		protected internal ComboBox Comsis, Comelip;
		protected internal ControlesAt.FloatTextBox TxtOndulacion;
		private byte indsis, nsis, nelip;
		private bool llamadaSis;

		protected FormR FormR1;
		protected FormRk FormRk1;
		protected FormLatLong FormLatLong1;
		protected Formsis Formsis1;
		protected Formelip Formelip1;
		public CElipsoide Celipsoideotro;
		public CTierra Ctierra;
		public CValoresSistemas Csistemas;
		internal Sistema sis;
		public Sistema Sistema{
		  get{
			set_sis_Sistema();
			set_sis_Elipsoide();
			return sis;
		}}
		protected static readonly string[] Comsis_nombres={
			"Lambert", //0
			"Mercator", //1
			"Estereográfica", //2
			"UTM", //3
			"Geográficas", //4
			"Conforme genérico", //5
			"", //6
			"Rectangular", //7
		};
		protected static readonly string[] Comelip_nombres={
			"Hayford (Int 24/29)", //0
			"GRS 80 / WGS 84", //1
			"Bessel 1841", //2
			"Krassovsky", //3
			"Sudamerica 1969", //4
			null, //5
			"Esfera", //6
		};
		public string get_elip_name(){
			return Comelip_nombres[Comelip.SelectedIndex];
		}

		public event EventHandler SistemaChanged, OndulacionChanged;
	#endregion

		public ControlSistema(){initialize(0);}
		public ControlSistema(Globales.Idioma _idioma){
			initialize(_idioma);
		}
		private void initialize(Globales.Idioma _idioma){
			InitializeComponent();
			base.idioma=_idioma;
			initializeb();
			update_idioma();
		}
		protected override Size DefaultSize{
			get{return new Size(204, 65);}
		}
		public void SetOwner(Form Fowner){
			FormR1.Owner=Fowner;
			FormRk1.Owner=Fowner;
			FormLatLong1.Owner=Fowner;
			Formsis1.Owner=Fowner;
			Formelip1.Owner=Fowner;
		}

		private void initializeb(){
			//Los encapsulados
			Celipsoideotro=new CElipsoide();
			Ctierra=new CTierra();
			Csistemas=new CValoresSistemas();

			MessageBoxAT=new MessageBoxAT();
			MessageBoxAT.Caption=MessageBoxAT.Caption=get_texto(Textos.Cods.Sistema);
			FormR1=new FormR(this,this.ParentForm,Ctierra);
			FormRk1=new FormRk(this,this.ParentForm,Ctierra);
			FormLatLong1=new FormLatLong(this,this.ParentForm,Csistemas);
			Formsis1=new Formsis(this,this.ParentForm,Csistemas);
			Formelip1=new Formelip(this,this.ParentForm,Celipsoideotro);

			nsis=(byte)Comsis.Items.Count;
			nelip=(byte)Comelip.Items.Count;

			Csistemas.V.LatLong=0;
			Csistemas.V.kUTM=0.9996;
			Csistemas.V.kLambert=1;
			Csistemas.V.XUTM=500000;		Csistemas.V.YUTM=0;
			Csistemas.V.XLambert=600000;	Csistemas.V.YLambert=600000;
			Csistemas.V.Phi0Lambert=40*3600*1000;
			Celipsoideotro.V.a=6378000;
			Celipsoideotro.V.ee=0;
			Ctierra.V.N=6376000;		Ctierra.V.ρ=6376000;
			Ctierra.V.conv=0;
			Ctierra.V.k=1;

			llamadaSis=true;
			Comsis.SelectedIndex=indsis=(byte)(nsis-3);
			Comelip.SelectedIndex=nelip-1;
			Comelip.Enabled=false;
			llamadaSis=false;

			sis.infor.P_datum_and_projection_name=IntPtr.Zero;
			sis.infor.linear_units=1.0;
			sis.infor.P_linear_units_abr=IntPtr.Zero;
			sis.infor.P_elip=IntPtr.Zero;
			sis.infor.lambda0=0;
			sis.sis.ond=0;
			TxtOndulacion.Text="0";
		}

	#region InitializeComponent
		private void InitializeComponent(){
			Labelelip= new BaseLabel();
			Labelsis= new BaseLabel();
			Labelond= new BaseLabel();
			Comsis= new ComboBox();
			Comelip= new ComboBox();
			TxtOndulacion= new FloatTextBox();

			this.Controls.AddRange(new Control[]{
				Labelsis,	Comsis,
				Labelelip,	Comelip,
				//Labelond,	TxtOndulacion
			});
			//
			// Comsis
			//
			Comsis.DropDownStyle= ComboBoxStyle.DropDownList;
			Comsis.Items.AddRange(new object[] {	"Lambert", "Mercator", "Estereográfica",
															"UTM", "Conforme genérico",
															"Geográficas",
															"",
															"Rectangular"});
			Comsis.Location= new Point(4, 4);
			Comsis.Size= new Size(120, 21);
			Comsis.TabIndex= 0;
			Comsis.SelectedIndexChanged+= new EventHandler(Comsis_Click);
			//
			// Comelip
			//
			Comelip.DropDownStyle= ComboBoxStyle.DropDownList;
			Comelip.Items.AddRange(new object[] {"Hayford (Int 24/29)",	"GRS 80 / WGS 84",
															"Bessel 1841",				"Krassovsky",
															"Otro",						"Esfera"});
			Comelip.Location= new Point(4, 40);
			Comelip.Size= new Size(132, 21);
			Comelip.TabIndex= 1;
			Comelip.SelectedIndexChanged+= new EventHandler(Comelip_Click);
			//
			//TxtOndulacion
			//
			TxtOndulacion.Location= new Point(4,76);
			TxtOndulacion.Width=72;
			TxtOndulacion.TabIndex=4;
			TxtOndulacion.Validated+=new EventHandler(TxtOndulacion_Validated);
			//
			// Labelsis, elip, ond
			//
			Labelsis.PositionModeY=PositionModeY.MidLine;
			Labelsis.TextAlign=new TwoDimAlignment(0,0.5F);
			Labelsis.MaxWidth= 64;
			Labelelip.Copy(Labelsis);	Labelelip.MaxWidth= 52;
			Labelond.Copy(Labelsis);	Labelond.MaxWidth= 76;
			//
			Labelsis.RefLocation= new Point(128, 18);		Labelsis.TabIndex= 3;
			Labelelip.RefLocation= new Point(140, 54);		Labelelip.TabIndex= 2;
			Labelond.RefLocation= new Point(80, 81);		Labelond.TabIndex= 5;
		}
	#endregion

		protected byte sistema_code_a_index(Proyeccion k){
			byte l;
			if(k==Proyeccion.Rectangular){l=nsis; l--;}
			else if(k==Proyeccion.Conforme){l=nsis; l-=3;}
			else if(k==Proyeccion.Geograficas){l=nsis; l-=4;}
			else{l=(byte)(int)k; l-=2;}
			return l;
		}
		protected Proyeccion sistema_index_a_code(byte k){
			if(k==nsis-1) return Proyeccion.Rectangular;
			else if(k==nsis-3) return Proyeccion.Conforme;
			else if(k==nsis-4) return Proyeccion.Geograficas;
			else return (Proyeccion)(k+2);
		}
	#region Click
		void Comsis_Click(object sender,System.EventArgs e){
			if(llamadaSis) return;
			if(Formsis1.Visible || FormLatLong1.Visible) return;

			if(Comsis.SelectedIndex==nsis-2){
				llamadaSis=true;
				Comsis.SelectedIndex=indsis;
				llamadaSis=false;
				return;
			}

			indsis=(byte)Comsis.SelectedIndex;
			Proyeccion isis=sistema_index_a_code(indsis);
			TxtOndulacion.Enabled=true;
			if(isis==Proyeccion.Rectangular || isis==Proyeccion.Conforme){
				Comelip.Enabled=false;
				if(isis==Proyeccion.Rectangular) TxtOndulacion.Enabled=false;
				else Methods.ShowDialogAboveOf(Comsis,FormRk1);
			}else{
				Comelip.Enabled=true;
				if(isis==Proyeccion.Geograficas) Methods.ShowDialogAboveOf(Comsis,FormLatLong1);
				else Methods.ShowDialogAboveOf(Comsis,Formsis1);
			}
			SistemaChanged(this,EventArgs.Empty);
		}
		void set_sis_Sistema(){
			sis.sis.proy=sistema_index_a_code((byte)Comsis.SelectedIndex);
			if(sis.sis.proy==Proyeccion.Rectangular) return;
			if(sis.sis.proy==Proyeccion.Conforme){
				sis.sis.a=Ctierra.V.N;
				sis.sis.e=Ctierra.V.ρ;
				sis.sis.param1.par1=Ctierra.V.conv;
				sis.sis.k0=Ctierra.V.k;
				return;
			}
			if(sis.sis.proy==Proyeccion.Geograficas){
				if(Csistemas.V.LatLong==0) sis.sis.param1.par1=0;
				else{unsafe{fixed(double * p=&sis.sis.param1.par1){
				     *(byte*)p=1;
				}}}
				return;
			}
			switch(indsis){
			 case 0: sis.sis.param1.par1=(double)Csistemas.V.Phi0Lambert/1000.0; goto case 100;
			 case 1: sis.sis.param1.par1=0; goto case 100;
			 case 2: sis.sis.param1.par1=90; goto case 100;
			case 100:
				sis.sis.k0=Csistemas.V.kLambert;
				sis.sis.xO=Csistemas.V.XLambert;
				sis.sis.yS=Csistemas.V.YLambert;
				break;
			 case 3:
				sis.sis.k0=Csistemas.V.kUTM;
				sis.sis.xO=Csistemas.V.XUTM;
				sis.sis.yS=Csistemas.V.YUTM;
				break;
			}
		}

		void Comelip_Click(object sender,System.EventArgs e){
			if(llamadaSis) return;

			if(Comelip.SelectedIndex==(byte)(nelip-1)){		//Esfera
				Methods.ShowDialogAboveOf(Comelip,FormR1);
			}else if(Comelip.SelectedIndex==(byte)(nelip-2)){	//Otro
				Methods.ShowDialogAboveOf(Comelip,Formelip1);
			}
		}
		void set_sis_Elipsoide(){
			if(indsis>=nsis-3) return;

			if(Comelip.SelectedIndex==(byte)(nelip-1)){	//Esfera
				sis.sis.a=(Ctierra.V.N+Ctierra.V.ρ)*0.5;
				sis.sis.e=0;
				return;
			}if(Comelip.SelectedIndex==(byte)(nelip-2)){ //desconocido
				sis.sis.a=Celipsoideotro.V.a;
				sis.sis.e=Celipsoideotro.V.ee;
				return;
			}
			sis.sis.a=Elipsoide.conocidos[Comelip.SelectedIndex].a;
			sis.sis.e=Elipsoide.conocidos[Comelip.SelectedIndex].e;
		}
		void TxtOndulacion_Validated(object sender,System.EventArgs e){
			if(llamadaSis) return;
			if(TxtOndulacion.Text==""){
				TxtOndulacion.Text="0";
				sis.sis.ond=0;
				OndulacionChanged(this,EventArgs.Empty);
				return;
			}
			try{sis.sis.ond=Basicas._gcVarios.atofl(TxtOndulacion.Text.ToCharArray());}
			catch(System.SystemException){
				//MessageBoxAT.Show(textos(44));
				sis.sis.ond=0;
			}
			TxtOndulacion.Text=sis.sis.ond.ToString();
			OndulacionChanged(this,EventArgs.Empty);
		}
	#endregion

		//Devuelve un índice al sistema seleccionado, que
		// coincidirá con Comsis.SelectedIndex, o -1 si ninguno se llama nombre_sistema
		public int SetSistema(Proyeccion n){
			byte k;
			k=sistema_code_a_index(n);
			SelectIndexSistema(k);
			if(k>=nsis) return -1;
			return k;
		}
		public int SetSistemaFromNombre(string nombre_sistema){
			string[] palabras;
			palabras=Basicas._gcVarios.split(nombre_sistema);
			return SetSistemaFromNombre(palabras);
		}
		public int SetSistemaFromNombre(string[] palabras_nombre){
			byte i,n;
			int k;
			int nmax, j,m;

			n=(byte)palabras_nombre.Length;
			k=-1;
			nmax=0;
			for(i=0;i<Comsis.Items.Count;i++){
				string[] candidato=Basicas._gcVarios.split(Comsis_nombres[i]);
				if(candidato.Length<n) m=candidato.Length;
				else m=n;
				for(j=0;j<m;j++){
					if(palabras_nombre[j]!=candidato[j]) break;
				}
				if(j>nmax){
					nmax=j;
					k=i;
				}
			}
			if(k==-1) return -1;
			SelectIndexSistema((byte)k);
			return k;
		}
		private void SelectIndexSistema(byte k){
			if(k>=nsis) return;
			llamadaSis=true;
			Comsis.SelectedIndex=indsis=(byte)k;
			if(k>=nsis-3) Comelip.Enabled=false;
				else Comelip.Enabled=true;
			if(k==nsis-1) TxtOndulacion.Enabled=false;
				else TxtOndulacion.Enabled=true;
			llamadaSis=false;
		}
		public int SetElipsoide(byte n){
			llamadaSis=true;
			switch(n){
				case 0: Comelip.SelectedIndex=nelip-1; break;
				case 1: Comelip.SelectedIndex=nelip-2; break;
				default: if(n<2 || n>=nelip) break;
					Comelip.SelectedIndex=n-2; break;
			}
			llamadaSis=false;
			if(n<2 || n>=nelip) return -1;
			return n;
		}
		public void SetOndulacion(float fl){
			llamadaSis=true;
			TxtOndulacion.Text=fl.ToString();
			llamadaSis=false;
		}

		public byte GetSistema(){
			return (byte)(int)sistema_index_a_code((byte)Comsis.SelectedIndex);
		}
		public string GetSistemaNombre(){
			return Comsis_nombres[indsis];
		}
		public byte GetElipsoide(){
			if(Comelip.SelectedIndex==nelip-1) return 0;
			else if(Comelip.SelectedIndex==nelip-2) return 1;
			else return (byte)(Comelip.SelectedIndex+2);
		}
		public string GetOndulacionText(){
			return TxtOndulacion.Text;
		}

		#region etiquetas_idiomas
		protected override void update_idioma(){
			if(MessageBoxAT!=null) MessageBoxAT.Caption=get_texto(Textos.Cods.Sistema);
			Labelelip.Text=get_texto(Textos.Cods.Elipsoide);
			Labelsis.Text=get_texto(Textos.Cods.Sistema);
			Labelond.Text=get_texto(Ondulación);
			llamadaSis=true;
			Comsis.Items[nsis-4]=get_texto(Geográficas);
			Comsis.Items[nsis-3]=get_texto(Conforme_genérico);
			Comsis.Items[nsis-1]=get_texto(Rectangular);
			Comelip.Items[nelip - 2]=get_texto(Otro);
			Comelip.Items[nelip - 1]=get_texto(Esfera);
			llamadaSis=false;
		}
		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
		#endregion
	}
}}
