using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public class ChkSalida : ContainerControl{
		private System.Windows.Forms.Label LblChk;
		private ControlesAt.PaddedLabel Label1;
		bool ignore=false;
		public EventHandler CheckedChanged;
		public enum ExtendedBorderStyle{None, FixedSingle, Fixed3D, AlternatingSingle, Alternating3D};
		protected ChkSalida.ExtendedBorderStyle borderstyle;
		public ChkSalida.ExtendedBorderStyle BorderStyle{
			get{return this.borderstyle;}
			set{borderstyle=value;
				if(value==ExtendedBorderStyle.None || (this.BorderStyle>=ExtendedBorderStyle.AlternatingSingle && this.Checked)) LblChk.BorderStyle=System.Windows.Forms.BorderStyle.None;
				else if(value==ExtendedBorderStyle.FixedSingle || value==ExtendedBorderStyle.AlternatingSingle) LblChk.BorderStyle=System.Windows.Forms.BorderStyle.FixedSingle;
				else LblChk.BorderStyle=System.Windows.Forms.BorderStyle.Fixed3D;
			}
		}

		private bool _checked;
		public bool Checked{
			get{return _checked;}
			set{if(_checked==value) return;
				_checked=value;
				if(value){
					LblChk.Text= "a";
					if(this.BorderStyle==ExtendedBorderStyle.AlternatingSingle || this.BorderStyle==ExtendedBorderStyle.Alternating3D) LblChk.BorderStyle=System.Windows.Forms.BorderStyle.None;
				}else{
					LblChk.Text="";
					if(this.BorderStyle==ExtendedBorderStyle.AlternatingSingle) LblChk.BorderStyle=System.Windows.Forms.BorderStyle.FixedSingle;
					else if(this.BorderStyle==ExtendedBorderStyle.Alternating3D) LblChk.BorderStyle=System.Windows.Forms.BorderStyle.Fixed3D;
				}
				if(CheckedChanged!=null) CheckedChanged(this, EventArgs.Empty);
			}
		}

		public override string Text{
			get{return Label1.Text;}
			set{Label1.Text=value;}
		}

		public ChkSalida(){
			LblChk=new Label();
			Label1=new PaddedLabel();

			LblChk.Dock=DockStyle.Left;
			LblChk.Width=13;
			Label1.PositionModeY=PositionModeY.FirstBaseLine;
			Label1.dWidth=2;
			Label1.RefLocation= new Point(13,10);
			LblChk.TabIndex=0;
			Label1.TabIndex=1;
			this.Controls.Add(Label1);
			this.Controls.Add(LblChk);

			LblChk.Font= new System.Drawing.Font("Marlett", 9.75F);
			LblChk.TextAlign= ContentAlignment.TopCenter;

			Label1.SizeChanged+=new EventHandler(Label1_SizeChanged);
			LblChk.Click+=new EventHandler(ChkSalida_Click);
			Label1.Click+=new EventHandler(ChkSalida_Click);
		}
		protected override Size DefaultSize{
			get{return new Size(15,13);}
		}
		private void Label1_SizeChanged(object sender,EventArgs e){
			if(ignore) return;
			ignore=true;	this.Width=Label1.Right;	ignore=false;
		}

		private void ChkSalida_Click(object sender,EventArgs e){
			this.Checked=!this._checked;
			this.OnClick(e);
		}
	}
	unsafe public class Chkbits : ChkSalida{
		public ushort *pu16;
		public ushort mask;

		public Chkbits(){entry(0);}
		public Chkbits(ushort _mask){entry(_mask);}
		void entry(ushort _mask){
			mask=_mask;
		}
		protected override void OnClick(EventArgs e){//El espido complador/lenguaje se pasa de listo, como siempre
			if(this.Checked) (*pu16)|=mask;		//por eso no puedo hacer simplemente ~mask, porque para hacer ~ lo pasa a un entero
			else (*pu16)&=(ushort)(~mask);//(ushort)(mask^0xFFFF);//y claro,le sale un nmero negativo que no puede pasar a unsigned
			base.OnClick (e);				//Si no fuese tan listo...
		}
		public void set(ushort* p){
			pu16=p;
			this.Checked=((*p)&mask)!=0;
		}
		public void Check(){
			this.Checked=true;
			(*pu16)|=mask;
		}
		public void unCheck(){
			this.Checked=false;
			(*pu16)&=(ushort)(~mask);
		}
	}
}