﻿using Globales;

namespace Calibracion{
	internal static class Textos{
		public enum Cods : uint{
			Caption,
			MsgCaption,
			Acercade,
			Manualpath,
			FullTitle,
			Abrir,
			Cerrar,
			Guardar,
			Información_salida,
			Gráfico,
			Símbolos_unidades,
			Fotocoordenadas,
			Píxeles_mm,
			Píxeles_micras,
			Píxeles_píxeles,
			Modelo_polinómico,
			Impar,
			Completo,
			Radial_tangencial,
			Vector_giratorio,
			Fotograma,
			Apoyo,
			Otros_parámetros,
			no_se_suele_modificar,
			Coord_medidas_fotocoord,
			focal_y_pp,
			Orientación_externa,
			Función_de_distorsión,
			Semidiagonal,
			Radial_simétrica,
			Tangencial_sim,
			Asimétricas,
			Radial_,
			Tangencial_,
			Serie1_,
			Serie2_,
			Calcular,
			Filtrocfg,
			Calculando_valores_aproximados,
			Realizando_el_ajuste_del_bloque,
			Debe_indicar_fich_foto,
			Debe_indicar_fich_apoyo,
			Cajas_fondo_blanco_obligatorias,
			En_medidas_a_foto,
			Tx_erróneo,
			Ty_erróneo,
			escala_errónea,
			escalaxy_errónea,
			ángulo_ejes_erróneo,
			En_externa,
			X_erróneo,
			Y_erróneo,
			Z_erróneo,
			Ω_erróneo,
			Φ_erróneo,
			Κ_erróneo,
			focal_errónea,
			ppx_erróneo,
			ppy_erróneo,
			En_distorsión,
			semidiag_errónea,
			r1_erróneo,
			Debe_indicar_r1,
			giro_y_pp,
			No_se_ha_podido_abrir_ajcalibracion,
			No_más_de_25puntos,
			Error_al_abrir_archivo,
			Fichero_vacío,
			Lone_Begin,
			Error_apertura_fichero,
			Tamaño_de_píxel,
			Fotogramas_carcteres_no_válidos,
			Apoyo_caracteres_no_válidos,
			Esperando_cálculo,
			Escribiendo_configuración,
			Leyendo_configuración,
			Explicaradial,
			Explicaradial_simple,
			Explicatangencial,
			Explicatangencial_simple,
			DistorsiónSimétrica,
			El_modelo_de_distorsión_radsim,
			El_modelo_de_distorsión_tansim,
			con_poli_impares,
			con_poli_completos,
			Parámetros,
			Radial,
			Tangencial,
			ExplicaciónAsimétrica_radial,
			ExplicaciónAsimétrica_radial_simple,
			DistorsiónAsimétrica,
			El_modelo_de_distorsión_radasim,
			El_modelo_de_distorsión_tanasim,
			sen,
			cos,
			ExplicaciónAsimétricauv,
			Serie1,
			Serie2,
			El_modelo_de_distorsión_uv_serie1,
			El_modelo_de_distorsión_uv_serie2,
			Coord_medidas_fotocoordenadas,
			Aproximado,
			Conocido,
			Relación_pixel_xy,
			Traslación_x,
			Traslación_y,
			Giro,
			Escala,
			Escalas_xy,
			Ángulo_de_ejes,
			Focal,
			Punto_principal,
			Ajuste_focal_DRS,
			Valor_erróneo,
			No_de_puntos_x,
			No_de_puntos_y,
			Valor_erróneo_de_puntos_en_malla,
			Tiene_que_ser_al_menos_2,
			NTEXTOS,
		}

		private static readonly string[] esp,eng,it;
		private static readonly string[][] textos;

		static Textos(){
			textos=new string[(int)Idioma.NIDIOMAS][];
			esp=new string[(int)Cods.NTEXTOS];
			eng=new string[(int)Cods.NTEXTOS];
			it=new string[(int)Cods.NTEXTOS];
			setup_esp();
			setup_eng();
			setup_it();

			textos[(int)Idioma.Esp]=esp;
			textos[(int)Idioma.Eng]=eng;
			textos[(int)Idioma.It]=it;
		}

		public static string get_texto(Cods cod, Idioma idioma){
			string[] t=textos[(int)idioma];
				if(t==null) t=textos[(int)Idioma.Esp];
			string s=t[(int)cod];
				if(s==null) s=textos[(int)Idioma.Esp][(int)cod];
			return s;
		}

		static void setup_esp(){
			esp[(int)Cods.Caption]="Calibración";
			esp[(int)Cods.MsgCaption]="Calibración";
			esp[(int)Cods.Acercade]="Acerca de Calibración";
			esp[(int)Cods.FullTitle]="Calibración geométrica de cámaras";
			esp[(int)Cods.Manualpath]="Manuales_html\\esp\\Calibracion.htm";
			esp[(int)Cods.Abrir]="Abrir configuración";
			esp[(int)Cods.Guardar]="GuardarConfig";
			esp[(int)Cods.Información_salida]="Información de salida";
			esp[(int)Cods.Gráfico]="Gráfico";
			esp[(int)Cods.Símbolos_unidades]="Símbolos de unidades";
			esp[(int)Cods.Fotocoordenadas]="Fotocoordenadas";
			esp[(int)Cods.Píxeles_mm]="Píxeles / mm";
			esp[(int)Cods.Píxeles_micras]="Píxeles / micras";
			esp[(int)Cods.Píxeles_píxeles]="Píxeles / píxeles";
			esp[(int)Cods.Modelo_polinómico]="Modelo polinómico";
			esp[(int)Cods.Impar]="Impar";
			esp[(int)Cods.Completo]="Completo";
			esp[(int)Cods.Radial_tangencial]="Radial / tangencial";
			esp[(int)Cods.Vector_giratorio]="Vector giratorio";
			esp[(int)Cods.Fotograma]="Fotograma";
			esp[(int)Cods.Apoyo]="Apoyo";
			esp[(int)Cods.Otros_parámetros]="Otros parámetros";
			esp[(int)Cods.no_se_suele_modificar]="En una calibración normal la configuración de estos parámetros no se suele modificar";
			esp[(int)Cods.Coord_medidas_fotocoord]="Coord. medidas --> fotocoordenadas";
			esp[(int)Cods.focal_y_pp]="Longitud focal y punto principal";
			esp[(int)Cods.Orientación_externa]="Orientación externa";
			esp[(int)Cods.Función_de_distorsión]="Función de distorsión";
			esp[(int)Cods.Semidiagonal]="Semidiagonal del fotograma:";
			esp[(int)Cods.Radial_simétrica]="Radial simétrica:";
			esp[(int)Cods.Tangencial_sim]="Tangencial sim.:";
			esp[(int)Cods.Asimétricas]="Asimétricas:";
			esp[(int)Cods.Radial_]="Radial:";
			esp[(int)Cods.Tangencial_]="Tangencial:";
			esp[(int)Cods.Serie1_]="Serie 1:";
			esp[(int)Cods.Serie2_]="Serie 2:";
			esp[(int)Cods.Calcular]="Calcular";
			esp[(int)Cods.Filtrocfg]="Ficheros de configuración (*.cfg)|*.cfg|Todos los archivos (*.*)|*.*";

			esp[(int)Cods.Calculando_valores_aproximados]="Calculando valores aproximados";
			esp[(int)Cods.Realizando_el_ajuste_del_bloque]="Realizando el ajuste del bloque";
			esp[(int)Cods.Debe_indicar_fich_foto]="Debe indicar algún fichero de fotogramas";
			esp[(int)Cods.Debe_indicar_fich_apoyo]="Debe indicar un fichero de apoyo";
			esp[(int)Cods.Cajas_fondo_blanco_obligatorias]="Todas las cajas de texto con fondo blanco requieren un valor";
			esp[(int)Cods.En_medidas_a_foto]="En Coordenadas medidas --> fotocoordenadas:";
			esp[(int)Cods.Tx_erróneo]="Valor de Traslación x erróneo";
			esp[(int)Cods.Ty_erróneo]="Valor de Traslación y erróneo";
			esp[(int)Cods.Ty_erróneo]="Valor del giro erróneo";
			esp[(int)Cods.escala_errónea]="Valor de la escala erróneo";
			esp[(int)Cods.escalaxy_errónea]="Valor de la escala x/y erróneo";
			esp[(int)Cods.ángulo_ejes_erróneo]="Valor del ángulo entre ejes erróneo";
			esp[(int)Cods.En_externa]="En Orientación externa:";
			esp[(int)Cods.X_erróneo]="valor de X erróneo";
			esp[(int)Cods.Y_erróneo]="valor de Y erróneo";
			esp[(int)Cods.Z_erróneo]="valor de Z erróneo";
			esp[(int)Cods.Ω_erróneo]="valor de Ω erróneo";
			esp[(int)Cods.Φ_erróneo]="valor de Φ erróneo";
			esp[(int)Cods.Κ_erróneo]="valor de Κ erróneo";
			esp[(int)Cods.focal_errónea]="Valor de la focal erróneo";
			esp[(int)Cods.ppx_erróneo]="Valor del punto principal, x, erróneo";
			esp[(int)Cods.ppy_erróneo]="Valor del punto principal, y, erróneo";
			esp[(int)Cods.En_distorsión]="En función de distorsión:";
			esp[(int)Cods.semidiag_errónea]="valor de semidiagonal erróneo";
			esp[(int)Cods.r1_erróneo]="valor de r1 erróneo";
			esp[(int)Cods.Debe_indicar_r1]="Debe indicar un valor de r1";
			esp[(int)Cods.giro_y_pp]="Si el giro en 'coordenadas medidas --> fotocoordenadas' se ha de calcular o es distinto de cero\n"+
												"entonces las coordenadas del punto principal deben ser ambas conocidas o ambas desconocidas";
			esp[(int)Cods.No_se_ha_podido_abrir_ajcalibracion]="No se ha podido abrir el fichero AjCalibracion.dll";
			esp[(int)Cods.No_más_de_25puntos]="No se permiten más de 25 puntos, los resultados no son correctos";
			esp[(int)Cods.Error_al_abrir_archivo]="Error al abrir el archivo";
			esp[(int)Cods.Fichero_vacío]="Fichero vacío";
			esp[(int)Cods.Lone_Begin]="Línea que empieza con \\begin sin nada a continuación";
			esp[(int)Cods.Error_apertura_fichero]="Error en la apertura del fichero";
			esp[(int)Cods.Tamaño_de_píxel]="Tamaño píxel";
			esp[(int)Cods.Fotogramas_carcteres_no_válidos]="El nombre indicado para el fichero de fotogramas contiene caracteres no válidos";
			esp[(int)Cods.Apoyo_caracteres_no_válidos]="El nombre indicado para el fichero de apoyo contiene caracteres no válidos";
			esp[(int)Cods.Esperando_cálculo]="Esperando a que termine el cálculo";
			esp[(int)Cods.Escribiendo_configuración]="Escribiendo fichero de configuración";
			esp[(int)Cods.Leyendo_configuración]="Leyendo fichero de configuración";

			esp[(int)Cods.Explicaradial]="    Si además de la DRS se calibra la focal o un factor de escala\n" +
							"es necesario imponer una condición a la DRS (restringir un grado de libertad).\n" +
							"    La condición de ortogonalidad es la definición natural de la focal y se traduce\n" +
							"en que no existe término a1·s.";
			esp[(int)Cods.Explicaradial_simple]="    Si además de la DRS se calibra la focal es necesario\n" +
							"imponer una condición a la DRS (restringir un grado de libertad).\n" +
							"    La condición de ortogonalidad es la definición natural de la focal y se traduce\n" +
							"en que no existe término a1·s.";
			esp[(int)Cods.Explicatangencial]="    El primer término no existirá a menos que no se calcule el giro del fotograma (Κ).";
			esp[(int)Cods.Explicatangencial_simple]="    El primer término no existirá nunca, pues se elimina con el giro Κ.";
			esp[(int)Cods.DistorsiónSimétrica]="Distorsión Simétrica: ";
			esp[(int)Cods.Radial]="Radial";
			esp[(int)Cods.Tangencial]="Tangencial";
			esp[(int)Cods.El_modelo_de_distorsión_radsim]="    El modelo de distorsión radial simétrica (DRS) ";
			esp[(int)Cods.El_modelo_de_distorsión_tansim]="    El modelo de distorsión tangencial simétrica ";
			esp[(int)Cods.con_poli_impares]="con polinomios impares es el siguiente:";
			esp[(int)Cods.con_poli_completos]="con polinomios completos es el siguiente:";
			esp[(int)Cods.Parámetros]="Parámetros:";
			esp[(int)Cods.ExplicaciónAsimétrica_radial]="    Los dos primeros términos no existirán, salvo que no se calcule\n" +
													"el punto principal o los ángulos que definen la orientación del eje óptico.";
			esp[(int)Cods.ExplicaciónAsimétrica_radial_simple]="    Los dos primeros términos nunca existen porque se eliminan\n"+
													"al calcular el punto principal de mejor simetría";
			esp[(int)Cods.DistorsiónAsimétrica]="Distorsión Asimétrica: ";
			esp[(int)Cods.El_modelo_de_distorsión_radasim]="    El modelo de distorsión radial asimétrica ";
			esp[(int)Cods.El_modelo_de_distorsión_tanasim]="    El modelo de distorsión tangencial asimétrica ";
			esp[(int)Cods.sen]="sen";
			esp[(int)Cods.cos]="cos";
			esp[(int)Cods.ExplicaciónAsimétricauv]="    c5 y c6 son los parámetros de afinidad: diferencia de escala\n" +
													"entre los ejes x/y y desviación de 90º del ángulo que forman.";
			esp[(int)Cods.Serie1]="Serie 1";
			esp[(int)Cods.Serie2]="Serie 2";
			esp[(int)Cods.El_modelo_de_distorsión_uv_serie1]="    La serie 1 del modelo de distorsión asimétrica u/v ";
			esp[(int)Cods.El_modelo_de_distorsión_uv_serie2]="    La serie 2 del modelo de distorsión asimétrica u/v ";

			esp[(int)Cods.Coord_medidas_fotocoordenadas]="Coordenadas medidas --> fotocoordenadas";
			esp[(int)Cods.Aproximado]="Aproximado";
			esp[(int)Cods.Conocido]="Conocido";
			esp[(int)Cods.Relación_pixel_xy]="Relación pixel x/y";
			esp[(int)Cods.Traslación_x]="Traslación x";
			esp[(int)Cods.Traslación_y]="Traslación y";
			esp[(int)Cods.Giro]="Giro";
			esp[(int)Cods.Escala]="Escala";
			esp[(int)Cods.Escalas_xy]="Escalas x/y";
			esp[(int)Cods.Ángulo_de_ejes]="Ángulo de ejes";
			esp[(int)Cods.Focal]="Focal";
			esp[(int)Cods.Punto_principal]="Punto principal";
			esp[(int)Cods.Ajuste_focal_DRS]="Ajuste de la focal y la DRS:";
			esp[(int)Cods.Valor_erróneo]="Valor erróneo";
			esp[(int)Cods.No_de_puntos_x]="Número de puntos de la cuadrícula, x";
			esp[(int)Cods.No_de_puntos_y]="Número de puntos de la cuadrícula, y";
			esp[(int)Cods.Valor_erróneo_de_puntos_en_malla]="Valor erróneo del número de puntos de la cuadrícula";
			esp[(int)Cods.Tiene_que_ser_al_menos_2]="Tiene que ser al menos 2";
		}

		static void setup_eng(){
			eng[(int)Cods.Caption]="Calibration";
			eng[(int)Cods.MsgCaption]="Calibration";
			eng[(int)Cods.Acercade]="About Calibration";
			eng[(int)Cods.FullTitle]="Geometric camera calibration";
			eng[(int)Cods.Manualpath]="Manuales_html\\eng\\Calibration.htm";
			eng[(int)Cods.Abrir]="Open configuration";
			eng[(int)Cods.Guardar]="Save configuration";
			eng[(int)Cods.Información_salida]="Output information";
			eng[(int)Cods.Gráfico]="Graphic";
			eng[(int)Cods.Símbolos_unidades]="Unit Symbols";
			eng[(int)Cods.Fotocoordenadas]="Photo coordinates";
			eng[(int)Cods.Píxeles_mm]="Pixels / mm";
			eng[(int)Cods.Píxeles_micras]="Pixels / microns";
			eng[(int)Cods.Píxeles_píxeles]="Pixels / pixels";
			eng[(int)Cods.Modelo_polinómico]="Polynomial model";
			eng[(int)Cods.Impar]="Odd";
			eng[(int)Cods.Completo]="Complete";
			eng[(int)Cods.Radial_tangencial]="Radial / tangential";
			eng[(int)Cods.Vector_giratorio]="Rotating vector";
			eng[(int)Cods.Fotograma]="Photograph";
			eng[(int)Cods.Apoyo]="Control";
			eng[(int)Cods.Otros_parámetros]="Other parameters";
			eng[(int)Cods.no_se_suele_modificar]="In a normal calibration, the configuration of these parameters is not usually varied";
			eng[(int)Cods.Coord_medidas_fotocoord]="Measured coord. --> Photo coord.";
			eng[(int)Cods.focal_y_pp]="Focal length and principal point";
			eng[(int)Cods.Orientación_externa]="Outer orientation";
			eng[(int)Cods.Función_de_distorsión]="Function of distortion";
			eng[(int)Cods.Semidiagonal]="Photograph half diagonal:";
			eng[(int)Cods.Radial_simétrica]="Radial, symmetric:";
			eng[(int)Cods.Tangencial_sim]="Tangential, sym.:";
			eng[(int)Cods.Asimétricas]="Asymmetric:";
			eng[(int)Cods.Radial_]="Radial:";
			eng[(int)Cods.Tangencial_]="Tangential:";
			eng[(int)Cods.Serie1_]="Series 1:";
			eng[(int)Cods.Serie2_]="Series 2:";
			eng[(int)Cods.Calcular]="Calculate";
			eng[(int)Cods.Filtrocfg]="Configuration files (*.cfg)|*.cfg|All files (*.*)|*.*";

			eng[(int)Cods.Calculando_valores_aproximados]="Computing approximate values";
			eng[(int)Cods.Realizando_el_ajuste_del_bloque]="Carrying out block adjustment";
			eng[(int)Cods.Debe_indicar_fich_foto]="A photographs file has to be specified";
			eng[(int)Cods.Debe_indicar_fich_apoyo]="A control file has to be specified";
			eng[(int)Cods.Cajas_fondo_blanco_obligatorias]="All the text boxes with a white colour require a value";
			eng[(int)Cods.En_medidas_a_foto]="In Measured coordinates --> photo coordinates:";
			eng[(int)Cods.Tx_erróneo]="Wrong value for the x translation";
			eng[(int)Cods.Ty_erróneo]="Wrong value for the y translation";
			eng[(int)Cods.Ty_erróneo]="Wrong value for the rotation";
			eng[(int)Cods.escala_errónea]="Wrong value for the scale";
			eng[(int)Cods.escalaxy_errónea]="Wrong value for the x/y scale";
			eng[(int)Cods.ángulo_ejes_erróneo]="Wrong value for the angle between axis";
			eng[(int)Cods.En_externa]="In Outer orientation:";
			eng[(int)Cods.X_erróneo]="wrong value for X";
			eng[(int)Cods.Y_erróneo]="wrong value for Y";
			eng[(int)Cods.Z_erróneo]="wrong value for Z";
			eng[(int)Cods.Ω_erróneo]="wrong value for Ω";
			eng[(int)Cods.Φ_erróneo]="wrong value for Φ";
			eng[(int)Cods.Κ_erróneo]="wrong value for Κ";
			eng[(int)Cods.focal_errónea]="Wrong value for the focal length";
			eng[(int)Cods.ppx_erróneo]="Wrong value for the principal point, x";
			eng[(int)Cods.ppy_erróneo]="Wrong value for the principal point, y";
			eng[(int)Cods.En_distorsión]="In the function of distortion:";
			eng[(int)Cods.semidiag_errónea]="wrong value for the half-diagonal";
			eng[(int)Cods.r1_erróneo]="wrong value for r1";
			eng[(int)Cods.Debe_indicar_r1]="A value for r1 has to be specified";
			eng[(int)Cods.giro_y_pp]="If the rotation in 'measured coordinates --> photo coordinates' is to be caculated or is nor zero\n" +
					"then the principal point coordinates must both be known or both be unknown";
			eng[(int)Cods.No_se_ha_podido_abrir_ajcalibracion]="The file AjCalibracion.dll couldn't be opened";
			eng[(int)Cods.No_más_de_25puntos]="It is not allowed more than 25 points, the results aren't correct";
			eng[(int)Cods.Error_al_abrir_archivo]="Error opening the file";
			eng[(int)Cods.Fichero_vacío]="Empty file";
			eng[(int)Cods.Lone_Begin]="Line starting with \\begin without anything following";
			eng[(int)Cods.Error_apertura_fichero]="Error opening the file";
			eng[(int)Cods.Tamaño_de_píxel]="Pixel size";
			eng[(int)Cods.Fotogramas_carcteres_no_válidos]="The name given for the photographs file includes invalid characters";
			eng[(int)Cods.Apoyo_caracteres_no_válidos]="The name given for the control file includes invalid characters";
			eng[(int)Cods.Esperando_cálculo]="Waiting for the end of the adjustment";
			eng[(int)Cods.Escribiendo_configuración]="Writing the configuration file";
			eng[(int)Cods.Leyendo_configuración]="Reading the configuration file";

			eng[(int)Cods.Explicaradial]="       If the focal length or an scale factor is calibrated as well as the SRD\n" +
							"   it is necesary to impose a condition on the SRD (to take out one degree of freedom).\n" +
							"       The condition of ortogonality is the natural definition of the focal length and leads\n" +
							"   to the non-existence of the term a1·s.";
			eng[(int)Cods.Explicaradial_simple]=
							"    If the focal length is calibrated as well as the SRD it is necesary\n" +
							"to impose a condition on the SRD (to take out one degree of freedom).\n" +
							"    The condition of ortogonality is the natural definition of the focal length and leads\n" +
							"to the non-existence of the term a1·s.";
			eng[(int)Cods.Explicatangencial]="    The first term will not exist unless the photograph rotation (Κ) is not computed";
			eng[(int)Cods.Explicatangencial_simple]="    The first term will never exist, since it is made to vanish wiht a Κ rotation.";
			eng[(int)Cods.DistorsiónSimétrica]="Symmetric Distortion: ";
			eng[(int)Cods.Radial]="Radial";
			eng[(int)Cods.Tangencial]="Tangential";
			eng[(int)Cods.El_modelo_de_distorsión_radsim]="    The model of symmetric radial distortion (DRS) ";
			eng[(int)Cods.El_modelo_de_distorsión_tansim]="    The model of symmetric tangential distortion ";
			eng[(int)Cods.con_poli_impares]="with odd polynomials is as follows:";
			eng[(int)Cods.con_poli_completos]="with complete polynomials is as follows:";
			eng[(int)Cods.Parámetros]="Parameters:";
			eng[(int)Cods.ExplicaciónAsimétrica_radial]="    The first two terms will not exist, unless the principal point\n" +
											"or the angles that define the orientation of the optical axis are not computed.";
			eng[(int)Cods.ExplicaciónAsimétrica_radial_simple]="    The first two terms will never exist because they vanish\n"+
											"by virtue of the computation of the best-symety principal point";
			eng[(int)Cods.DistorsiónAsimétrica]="Asymmetric ditortion";
			eng[(int)Cods.El_modelo_de_distorsión_radasim]="    The model of asymmetric radial distortion ";
			eng[(int)Cods.El_modelo_de_distorsión_tanasim]="    The model of asymmetric tangential distortion ";
			eng[(int)Cods.sen]="sin";
			eng[(int)Cods.cos]="cos";
			eng[(int)Cods.ExplicaciónAsimétricauv]="    c5 and c6 are the affinity parameters: a difference in the scales of\n" +
											"the x/y axis and a deviation from 90º of the angle contained in between.";
			eng[(int)Cods.Serie1]="Series 1";
			eng[(int)Cods.Serie2]="Series 2";
			eng[(int)Cods.El_modelo_de_distorsión_uv_serie1]="    The series 1 from the model u/v of asymmetric distortions ";
			eng[(int)Cods.El_modelo_de_distorsión_uv_serie2]="    The series 2 from the model u/v of asymmetric distortions ";
			eng[(int)Cods.Coord_medidas_fotocoordenadas]="Measured coord. --> Photo coordinates";
			eng[(int)Cods.Aproximado]="Approximate";
			eng[(int)Cods.Conocido]="Known";
			eng[(int)Cods.Relación_pixel_xy]="Pixel ratio x/y";
			eng[(int)Cods.Traslación_x]="x translation";
			eng[(int)Cods.Traslación_y]="y translation";
			eng[(int)Cods.Giro]="Rotation";
			eng[(int)Cods.Escala]="Scale";
			eng[(int)Cods.Escalas_xy]="Scales x/y";
			eng[(int)Cods.Ángulo_de_ejes]="Angle of axes";
			eng[(int)Cods.Focal]="Focal length";
			eng[(int)Cods.Punto_principal]="Principal point";
			eng[(int)Cods.Ajuste_focal_DRS]="Fitting of the focal length and the SRD:";
			eng[(int)Cods.Valor_erróneo]="Wrong value";
			eng[(int)Cods.No_de_puntos_x]="Number of points in the grid, x";
			eng[(int)Cods.No_de_puntos_y]="Number of points in the grid, y";
			eng[(int)Cods.Valor_erróneo_de_puntos_en_malla]="Wrong value for the number of points in the grid";
			eng[(int)Cods.Tiene_que_ser_al_menos_2]="It must be at least 2";
		}
		static void setup_it(){
			it[(int)Cods.Caption]="Calibrazione";
			it[(int)Cods.MsgCaption]="Calibrazione";
			it[(int)Cods.Acercade]="Su Calibrazione";
			it[(int)Cods.FullTitle]="Calibrazione geometrica di camere";
			it[(int)Cods.Manualpath]="Manuales_html\\it\\Calibrazione.htm";
			it[(int)Cods.Abrir]="Apri configurazione";
			it[(int)Cods.Guardar]="Salva configurazione";
			it[(int)Cods.Información_salida]="Informazione d'uscita";
			it[(int)Cods.Gráfico]="Grafico";
			it[(int)Cods.Símbolos_unidades]="Simboli delle unità";
			it[(int)Cods.Fotocoordenadas]="Coordinate immagine";
			it[(int)Cods.Píxeles_mm]="Pixel / mm";
			it[(int)Cods.Píxeles_micras]="Pixel / micron";
			it[(int)Cods.Píxeles_píxeles]="Pixel / pixel";
			it[(int)Cods.Modelo_polinómico]="Modello polinomico";
			it[(int)Cods.Impar]="Impari";
			it[(int)Cods.Completo]="Completo";
			it[(int)Cods.Radial_tangencial]="Radiale / tangenziale";
			it[(int)Cods.Vector_giratorio]="Vettore giratorio";
			it[(int)Cods.Fotograma]="Fotogramma";
			it[(int)Cods.Apoyo]="Appoggio";
			it[(int)Cods.Otros_parámetros]="Altri parametri";
			it[(int)Cods.no_se_suele_modificar]="In una calibrazione normale la configurazione di questi parametri non viene normalmente modificata";
			it[(int)Cods.Coord_medidas_fotocoord]="Coord. misurate --> coord. immagine";
			it[(int)Cods.focal_y_pp]="Longitude focale e punto principale";
			it[(int)Cods.Orientación_externa]="Orientazione esterna";
			it[(int)Cods.Función_de_distorsión]="Funzione di distorsione";
			it[(int)Cods.Semidiagonal]="Semidiagonale della fotografia:";
			it[(int)Cods.Radial_simétrica]="Radiale simmetrica:";
			it[(int)Cods.Tangencial_sim]="Tangenziale sim.:";
			it[(int)Cods.Asimétricas]="Asimmetriche";
			it[(int)Cods.Radial_]="Radiale:";
			it[(int)Cods.Tangencial_]="Tangenziale:";
			it[(int)Cods.Serie1_]="Serie 1:";
			it[(int)Cods.Serie2_]="Serie 2:";
			it[(int)Cods.Calcular]="Calcola";
			it[(int)Cods.Filtrocfg]="File di configurazione (*.cfg)|*.cfg|Tutti i file (*.*)|*.*";

			it[(int)Cods.Calculando_valores_aproximados]="Calcolando valori approssimati";
			it[(int)Cods.Realizando_el_ajuste_del_bloque]="Realizzando la compensazione del blocco";
			it[(int)Cods.Debe_indicar_fich_foto]="Deve indicare un file di fotogramma";
			it[(int)Cods.Debe_indicar_fich_apoyo]="Deve indicare un file di di appoggio";
			it[(int)Cods.Cajas_fondo_blanco_obligatorias]="Tutti le textbox bianche richiedono un valore";
			it[(int)Cods.En_medidas_a_foto]="In Coordinate misurate --> coordinate immagine:";
			it[(int)Cods.Tx_erróneo]="Valore di Traslazione x erroneo";
			it[(int)Cods.Ty_erróneo]="Valore di Traslazione y erroneo";
			it[(int)Cods.Ty_erróneo]="Valore del giro erroneo";
			it[(int)Cods.escala_errónea]="Valore dell'escala erroneo";
			it[(int)Cods.escalaxy_errónea]="Valore dell'escala x/y erroneo";
			it[(int)Cods.ángulo_ejes_erróneo]="Valore dell'angolo tra assi erroneo";
			it[(int)Cods.En_externa]="In Orientazione esterna:";
			it[(int)Cods.X_erróneo]="valore di X erroneo";
			it[(int)Cods.Y_erróneo]="valore di Y erroneo";
			it[(int)Cods.Z_erróneo]="valore di Z erroneo";
			it[(int)Cods.Ω_erróneo]="valore di Ω erroneo";
			it[(int)Cods.Φ_erróneo]="valore di Φ erroneo";
			it[(int)Cods.Κ_erróneo]="valore di Κ erroneo";
			it[(int)Cods.focal_errónea]="Valore della focale erroneo";
			it[(int)Cods.ppx_erróneo]="Valore del punto principale, x, erroneo";
			it[(int)Cods.ppy_erróneo]="Valore del punto principale, y, erroneo";
			it[(int)Cods.En_distorsión]="In funzione di distorsione:";
			it[(int)Cods.semidiag_errónea]="valore di semidiagonale erroneo";
			it[(int)Cods.r1_erróneo]="valore di r1 erroneo";
			it[(int)Cods.Debe_indicar_r1]="Deve indicare un valore di r1";
			it[(int)Cods.giro_y_pp]="Se il giro in 'coordinate misurate --> coordinate immagine' si deve calcolare o è diverso si zero\n" +
					"dunque le coordinate del punto principale devono essere tutti e due conosciute o sconosciute";
			it[(int)Cods.No_se_ha_podido_abrir_ajcalibracion]="Il file AjCalibracion.dll non ha potuto essere aperto";
			it[(int)Cods.No_más_de_25puntos]="Non sono permessi più di 25 punti, i resultati non sono corretti";
			it[(int)Cods.Error_al_abrir_archivo]="Errore al aprire il file";
			it[(int)Cods.Fichero_vacío]="File vuoto";
			it[(int)Cods.Lone_Begin]="Linea che comincia con \\begin con niente di seguito";
			it[(int)Cods.Error_apertura_fichero]="Errore nell'apertura del file";
			it[(int)Cods.Tamaño_de_píxel]="Lato dei pixel";
			it[(int)Cods.Fotogramas_carcteres_no_válidos]="Il nome indicato per il file di fotogrammi contiene caratteri invalidi";
			it[(int)Cods.Apoyo_caracteres_no_válidos]="Il nome indicato per il file di appoggio contiene caratteri invalidi";
			it[(int)Cods.Esperando_cálculo]="Attendento che finisca il calcolo";
			it[(int)Cods.Escribiendo_configuración]="Scrivendo il file di configurazione";
			it[(int)Cods.Leyendo_configuración]="Leggendo il file di configurazione";

			it[(int)Cods.Explicaradial]="    Se inoltre la DRS si calibrano la focale o un fattore di scala\n" +
							"bisogna imporre una condizione sulla DRS (restringere un grado di libertà).\n" +
							"    La condizione di ortogonalità è la definizione naturale della focale e implica\n" +
							"che non esiste termine a1·s.";
			it[(int)Cods.Explicaradial_simple]="    Se inoltre la DRS si calibrano la focale o un fattore di scala\n" +
							"bisogna imporre una condizione sulla DRS (restringere un grado di libertà).\n" +
							"    La condizione di ortogonalità è la definizione naturale della focale e implica\n" +
							"che non esiste termine a1·s.";
			it[(int)Cods.Explicatangencial]="    Il primo termino non esistirà a meno che non si calcoli la rotazione della fotografia (Κ).";
			it[(int)Cods.Explicatangencial_simple]="    Il primo termine non esistirà mai, perché egli è eliminato con il giro Κ.";
			it[(int)Cods.DistorsiónSimétrica]="Distorsione Simmetrica: ";
			it[(int)Cods.Radial]="Radiale";
			it[(int)Cods.Tangencial]="Tangenziale";
			it[(int)Cods.El_modelo_de_distorsión_radsim]="    Il modello di distorsione radiale simmetrica (DRS) ";
			it[(int)Cods.El_modelo_de_distorsión_tansim]="    Il modello di distorsione tangenziale simmetrica ";
			it[(int)Cods.con_poli_impares]=" con polinomi impari è il seguente:";
			it[(int)Cods.con_poli_completos]=" con polinomi completi è il seguente:";
			it[(int)Cods.Parámetros]="Parametri:";
			it[(int)Cods.ExplicaciónAsimétrica_radial]="    I due primi termini non esistiranno, a meno che non si calcoli\n" +
											"il punto principale o gli angoli che definiscono l'orientazione dell'asse ottico.";
			it[(int)Cods.ExplicaciónAsimétrica_radial_simple]="    I due primi termini non esistiranno mai perché essi si eliminano\n"+
											"grazie al calcolo del punto principale di migliore simetria";
			it[(int)Cods.DistorsiónAsimétrica]="Distorsione Assimmetrica: ";
			it[(int)Cods.El_modelo_de_distorsión_radasim]="    Il modello di distorsione radiale assimmetrica ";
			it[(int)Cods.El_modelo_de_distorsión_tanasim]="    Il modello di distorsione tangenziale assimmetrica ";
			it[(int)Cods.sen]="sen";
			it[(int)Cods.cos]="cos";
			it[(int)Cods.ExplicaciónAsimétricauv]="    c5 e c6 sono i parametri di affinità: differenza di scala tra\n" +
											"gli assi x/y e deviazione rispetto di 90º dell'angolo che formano.";
			it[(int)Cods.Serie1]="Serie 1";
			it[(int)Cods.Serie2]="Serie 2";
			it[(int)Cods.El_modelo_de_distorsión_uv_serie1]="    La serie 1 del modello di distorsioni assimmetrica u/v ";
			it[(int)Cods.El_modelo_de_distorsión_uv_serie2]="    La serie 2 del modello di distorsioni assimmetrica u/v ";
			it[(int)Cods.Coord_medidas_fotocoordenadas]="Coord. misurate --> coordinate immagine";
			it[(int)Cods.Aproximado]="Approssimato";
			it[(int)Cods.Conocido]="Conosciuto";
			it[(int)Cods.Relación_pixel_xy]="Relazione pixel x/y";
			it[(int)Cods.Traslación_x]="Traslazione x";
			it[(int)Cods.Traslación_y]="Traslazione y";
			it[(int)Cods.Giro]="Giro";
			it[(int)Cods.Escala]="Scala";
			it[(int)Cods.Escalas_xy]="Scale x/y";
			it[(int)Cods.Ángulo_de_ejes]="Angolo tra assi";
			it[(int)Cods.Focal]="Focale";
			it[(int)Cods.Punto_principal]="Punto principale";
			it[(int)Cods.Ajuste_focal_DRS]="Aggiustamento della focale e la DRS:";
			it[(int)Cods.Valor_erróneo]="Valore erroneo";
			it[(int)Cods.No_de_puntos_x]="Numero di punti del reticolato, x";
			it[(int)Cods.No_de_puntos_y]="Numero di punti del reticolato, y";
			it[(int)Cods.Valor_erróneo_de_puntos_en_malla]="Valore erroneo del numero di punti del reticolato";
			it[(int)Cods.Tiene_que_ser_al_menos_2]="Deve essere 2 o più";
		}
	}
}
