using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	class ByteUpDown : UpDownBase{
		private byte valor;
		public byte Value{
			get{return valor;}
			set{valor=value;
				this.Text=valor.ToString();
			}
		}
		public event EventHandler ValueChanged;

		public ByteUpDown(){}
		protected override Size DefaultSize{
			get{return new Size(40,20);}
		}

		public override void UpButton(){
			if(valor<255) this.Value++;
		}
		public override void DownButton(){
			if(valor>0) this.Value--;
		}

		protected override void OnKeyPress(KeyPressEventArgs e){
			if((e.KeyChar<'0' || e.KeyChar>'9') && e.KeyChar!=127 && e.KeyChar!='\b') e.Handled=true;
			base.OnKeyPress (e);
		}

		protected override void OnTextChanged(EventArgs e){
			base.OnTextChanged(e);
			ushort i;
			if(this.Text!=""){
				try{i=Convert.ToUInt16(this.Text);}
				catch(Exception){
					this.Text=valor.ToString();
					return;
				}
				if(i>255){valor=255;}
				else valor=(byte)i;
				if(ValueChanged!=null) ValueChanged(this,EventArgs.Empty);
			}
		}
		protected override void UpdateEditText(){
			OnTextChanged(EventArgs.Empty);
		}

		protected override void OnLostFocus(EventArgs e){
			this.Text=valor.ToString();
			base.OnLostFocus(e);
		}
	}
}