using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt
{
	/// <summary>
	/// Esta va a ser la base de casi todos mis botones
	/// </summary>
	public class BotAceptar : System.Windows.Forms.Button
	{
		private ControlesAt.NoControl label1, label2, label3, label4;
		public BotAceptar(){
			label1= new NoControl();
			label2= new NoControl();
			label3= new NoControl();
			label4= new NoControl();
			this.Controls.Add(label1);
			this.Controls.Add(label2);
			this.Controls.Add(label3);
			this.Controls.Add(label4);
			this.FlatStyle=FlatStyle.System;
			OnBackColorChanged(EventArgs.Empty);
			OnSizeChanged(EventArgs.Empty);
		}
		protected override Size DefaultSize{
			get{return new Size(60, 24);}
		}
		public new FlatStyle FlatStyle{
			get{return base.FlatStyle;}
			set{base.FlatStyle=value; UpdateLabels();}
		}
		protected void UpdateLabels(){
			bool b= FlatStyle==FlatStyle.Standard || this.FlatStyle==FlatStyle.System;
			label1.Visible=label2.Visible=label3.Visible=label4.Visible=b;
		}
		protected override void OnBackColorChanged(EventArgs e){
			label2.BackColor=label1.BackColor=Color.FromArgb(this.BackColor.R*2/3,this.BackColor.G*2/3,this.BackColor.B*2/3);
			base.OnBackColorChanged(e);
		}
		protected override void OnSizeChanged(System.EventArgs e){
			label1.Left=this.Width-2;
			label1.Top=1;
			label1.Width=1;
			label1.Height=this.Height-2;

			label2.Left=1;
			label2.Top=this.Height-2;
			label2.Width=this.Width-3;
			label2.Height=1;

			label3.Left=this.Width-3;
			label3.Top=2;
			label3.Width=1;
			label3.Height=this.Height-4;

			label4.Left=2;
			label4.Top=this.Height-3;
			label4.Width=this.Width-5;
			label4.Height=1;
		}
	}
	/// <summary>
	/// Botn Popup sin borde mientras no est activo.
	/// </summary>
	public class BotonToolBar : Button
	{
		private ControlesAt.NoControl label1, label2, label3, label4;

		public BotonToolBar()
		{
			label1= new NoControl();
			label2= new NoControl();
			label3= new NoControl();
			label4= new NoControl();
			//
			// label1
			label1.Dock=DockStyle.Top;		label1.Size= new Size(34,1);		label1.TabIndex= 0;
			label2.Dock=DockStyle.Left;		label2.Size= new Size(1,34);		label2.TabIndex= 1;
			label3.Dock=DockStyle.Bottom;	label3.Size= new Size(34,1);		label3.TabIndex= 2;
			label4.Dock=DockStyle.Right;		label4.Size= new Size(1,34);		label4.TabIndex= 3;
			//
			// BotonToolBar
			//
			this.Controls.Add(label1);
			this.Controls.Add(label2);
			this.Controls.Add(label3);
			this.Controls.Add(label4);
			this.FlatStyle=FlatStyle.Popup;
		}
		protected override Size DefaultSize{
			get	{return new Size(36,36);}
		}

		protected override void OnMouseEnter(EventArgs e){
			label1.Visible=false; label2.Visible=false;
			label3.Visible=false; label4.Visible=false;
			base.OnMouseEnter(e);
		}
		protected override void OnMouseLeave(EventArgs e){
			label1.Visible=true; label2.Visible=true;
			label3.Visible=true; label4.Visible=true;
			base.OnMouseLeave(e);
		}
	}
	public class Botonppp : BotAceptar{
		protected Color savedbc, savedfc;
		public Botonppp(bool f){this.FlatStyle= FlatStyle.Standard;}	//Con system no dibuja sobre el botn.
		public Botonppp(){
			this.FlatStyle= FlatStyle.Popup;
			savedbc=this.BackColor;
			savedfc=this.ForeColor;
		}
		protected override Size DefaultSize{
			get	{return new Size(21,17);}
		}
		protected override void OnEnabledChanged(EventArgs e){
			base.OnEnabledChanged(e);
			if(this.Enabled==true){
				this.BackColor=savedbc;	this.ForeColor=savedfc;
			}else{
				savedbc=this.BackColor;	savedfc=this.ForeColor;
				this.BackColor=SystemColors.InactiveBorder;
				this.ForeColor=SystemColors.GrayText;
			}
		}
		protected override void OnPaint(PaintEventArgs e){
			int ho=this.Height-6;
			base.OnPaint(e);
			if(e.ClipRectangle.Bottom>=ho){
				Pen p= new Pen(this.ForeColor,2);
				int xc=this.Width/2;
				Point pt= new Point(xc-4,ho);
				Point qt= new Point(xc,ho);
				Point rt= new Point(xc+4,ho);
				e.Graphics.DrawLine(p,xc-5,ho,xc-3,ho);
				e.Graphics.DrawLine(p, xc-1,ho,xc+1,ho);
				e.Graphics.DrawLine(p,xc+3,ho,xc+5,ho);
			}
		}
	}
}
