﻿//Compile with /J
#include <ATcrt/ATsystem.h>
#include <ATcrt/ATmemstr.h>
namespace Basicas{
public ref class _nogcVarios{
  public:
	static char16_t* pointat(char16_t* fichero){
		char16_t *ext, *fin;
		ext=fichero; while(*ext) ext++;
		fin=ext;
		while(*ext!='.' && ext!=fichero) ext--;
		if(*ext!='.' || fin-ext>4) ext=fin;
		return ext;
	}
	//Se asume que _fichero tiene espacio suficiente
	static void extension(/*char16_t **/System::IntPtr _fichero, char16_t x1, char16_t x2, char16_t x3){
		char16_t* fichero=(char16_t*)_fichero.ToPointer();
		char16_t* ext=pointat(fichero);
		*ext++=u'.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext=u'\0';
	}
	static void extension4(/*char16_t **/System::IntPtr _fichero, char16_t x1, char16_t x2, char16_t x3, char16_t x4){
		char16_t* fichero=(char16_t*)_fichero.ToPointer();
		char16_t* ext=pointat(fichero);
		*ext++=u'.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext++=x4; *ext=u'\0';
	}

	static unsigned short str_b16_rev(char* cifras){
		unsigned short n,l;
		char i;
		n=0;
		for(i=0,l=1;*cifras && i<16;i++,cifras++,l<<=1){
			if(*cifras!='0') n|=l;
		}
		return n;
	}
	static unsigned short str_b16_mask(char* cifras, unsigned short default){
		unsigned short n,l;
		char i;
		n=0;
		for(i=0,l=1;*cifras && i<16;i++,cifras++,l<<=1){
			if(*cifras=='-') n|=default&l;
			else if(*cifras!='0') n|=l;
		}
		default&=-l; //~(l-1)
		return n|default;
	}

	//Escribe hasta el último 1
	static void b16_str_rev(unsigned short n, char* cifras){	//cifras[17]
		do{ //write at least one
			*cifras++=(n&1)+'0';
			n>>=1;
		}while(n);
		*cifras='\0';
	}
	//Si kcifras=0 se escribirán los dieciséis
	static void b16_str_kcifras(unsigned short n, char* cifras, unsigned char kcifras){	//cifras[17]
		kcifras--; kcifras&=0xF; kcifras++;
		for(;kcifras--; n>>=1) *cifras++=(n&1)+'0';
		*cifras='\0';
	}
	//Escribe mientras haya máscara
	static void b16_str_mask(unsigned short n, char* cifras, unsigned short mask){	//cifras[17]
		do{ //write at least one
			if(!(mask&1)) *cifras='-';
			else *cifras=(n&1)+'0';
			mask>>=1, n>>=1;
			cifras++;
		}while(mask);
		*cifras='\0';
	}

	static char16_t** split_cmdline(char16_t *cmdline){
		char16_t** argv;
		char16_t *pc;
		uint n=0;	//incremented at beginning of word
		pc=cmdline;
		for(;;){
			while(*pc==u' ' || *pc==u'\t' || *pc==u'\n') pc++;
			if(*pc==0) break;
			n++;
			if(*pc==u'"'){
	falseend:	pc++;
				while(*pc!=u'"' && *pc!=0) pc++;		//within ", \ represents itself, except before "
				if(*(pc-1)==u'\\' && *pc==u'"') goto falseend;
				if(*pc!=0) pc++;
				continue;
			}
			while(*pc!=u' ' && *pc!=u'\t' && *pc!=u'\n' && *pc!=u'"' && *pc!=0){
				if(*pc==u'\\'){
					if(*(pc+1)==0) *pc=0;
					else pc+=2;
				}else pc++;
			}
		}
		//n may be one greater if \0 (literally) appears at beginning-of-word position.
		argv=new char16_t*[n+1];
		char16_t **ptr=argv;
		pc=cmdline;
		for(;;){
			while(*pc==u' ' || *pc==u'\t' || *pc==u'\n') pc++;
			if(*pc==0) break;
			if(*pc==u'"'){
				*pc++=0;	//It may be the end of the previous word
				*ptr++=pc;
				while(*pc!=u'"' && *pc!=0) pc++;
				char16_t *jc=pc;
				goto test_end;
falseend_2:	*(jc-1)=u'"'; pc++;
				while(*pc!=u'"' && *pc!=0) *jc++=*pc++;
test_end:		if(*(jc-1)==u'\\' && *pc==u'"') goto falseend_2;
				if(*pc!=0 && *(jc-1)==u' ') *(jc-1)=0;	//Last space removed so that it is possible to end a "" arg with \ 
				else *jc=0;
				*pc++;
				continue;
			}
			*ptr++=pc;
			while(*pc!=u' ' && *pc!=u'\t' && *pc!=u'\n' && *pc!=u'"' && *pc!=0){
				if(*pc==u'\\') pc++;
				pc++;
			}
			if(*pc!=0 && *pc!=u'"') *pc++=0;
		}
		*ptr=NULL;
		return argv;
	}
	static void unscape(char16_t* s){	//passes by \0
		char16_t *pc=s;
		while(*pc){
			if(*pc==u'\\') pc++;
			*s++=*pc++;
		}
		*s=0;
	}
	static void unscape_stop(char16_t* s){	//also stops at \0
		char16_t *pc=s;
		for(;;){
			if(*pc==u'\\') pc++;
			*s=*pc;
			if(*pc==0) break;
			pc++, s++;
		}
	}
};
void extension(/*char16_t __nogc**/System::IntPtr _fichero, char16_t x1, char16_t x2, char16_t x3){
	return _nogcVarios::extension(_fichero,x1,x2,x3);
}
}

#include <malloc.h>
#include <cstring>
#include "..\relativa/Aerotri_defs_internal.h"
#include <ATcrt\ATarrays.h>

typedef struct{
	uint n,N;
	void* ppio;
	uint umbral;
	uint last_full;
} Hash;

#define uint unsigned int
namespace Basicas{
	public value struct Hash{
		uint n,N;
		void* ppio;
		private:
			uint umbral;
			uint last_full;
	};
	public ref class Hash_utils{
	public:
		static bint get_Hash_uint(Hash *hash, uint n){
			huint *pm=geth_huint((Hash_huint*)hash,n);
			if(pm==NULL) return 0;
			return 1;
		}
	};
}
