using System;
using System.Drawing;
using System.Windows.Forms;	//Just for DockStyle

namespace ControlesAt
{
	public struct Margenes{
		public int Left, Right;
		public int Top, Bottom;
		public Margenes(int Left, int Right, int Top, int Bottom){
			this.Left=Left;	this.Right=Right;
			this.Top=Top;	this.Bottom=Bottom;
		}
		/// <summary>
		/// Returns Left+Right
		/// </summary>
		public int H{get{return Left+Right;}}
		/// <summary>
		/// Returns Top+Bottom
		/// </summary>
		public int V{get{return Top+Bottom;}}
	}
	//typedef float OneDimAlignment;	//0 left, 0.5 middel, 1 right;
	public struct TwoDimAlignment{
		public float AlignX;
		public float AlignY;
		public TwoDimAlignment(float X, float Y){
			AlignX=X;
			AlignY=Y;
		}

		public static implicit operator TwoDimAlignment(ContentAlignment alignment){
			TwoDimAlignment a;
			a.AlignX=a.AlignY=0;	//Si no el compilador protesta
			switch(alignment){
				case ContentAlignment.TopLeft:		a.AlignX=0;		a.AlignY=0;	break;
				case ContentAlignment.TopCenter:	a.AlignX=0.5F;	a.AlignY=0;	break;
				case ContentAlignment.TopRight:	a.AlignX=1;		a.AlignY=0;	break;
				case ContentAlignment.MiddleLeft:		a.AlignX=0;		a.AlignY=0.5F;	break;
				case ContentAlignment.MiddleCenter:	a.AlignX=0.5F;	a.AlignY=0.5F;	break;
				case ContentAlignment.MiddleRight:		a.AlignX=1;		a.AlignY=0.5F;	break;
				case ContentAlignment.BottomLeft:		a.AlignX=0;		a.AlignY=1;	break;
				case ContentAlignment.BottomCenter:	a.AlignX=0.5F;	a.AlignY=1;	break;
				case ContentAlignment.BottomRight:	a.AlignX=1;		a.AlignY=1;	break;
			}
			return a;
		}
		public static explicit operator ContentAlignment(TwoDimAlignment a){
			if(a.AlignX<=0){
				if(a.AlignY<=0) return ContentAlignment.TopLeft;
				else if(a.AlignY>=1) return ContentAlignment.BottomLeft;
				else return ContentAlignment.MiddleLeft;
			}else if(a.AlignX>=1){
				if(a.AlignY<=0) return ContentAlignment.TopRight;
				else if(a.AlignY>=1) return ContentAlignment.BottomRight;
				else return ContentAlignment.MiddleRight;
			}else{
				if(a.AlignY<=0) return ContentAlignment.TopCenter;
				else if(a.AlignY>=1) return ContentAlignment.BottomCenter;
				else return ContentAlignment.MiddleCenter;
			}
		}
	}
	public enum PositionModeY{
		/// <summary>Use TextAlign.AlignY normally</summary>
		None,
		/// <summary>Set the first baseline to RefLocation.Y</summary>
		FirstBaseLine,
		/// <summary>Set the last baseline to RefLocation.Y</summary>
		LastBaseLine,	
		/// <summary>Set to RefLocation.Y either the middle baseline, if the number of lines is odd
		/// or the midpoint between the two central baselines, if it is even</summary>
		MidLine,
		/// <summary>Compute the location according to TextAlign.AlignY, then move the content so that the nearest baseline to RefLocation.Y coincides with the location thus computed</summary>
		NearestBaseline,
	}
	public struct Box{
		public Point Location;	//Where do we need to tell the .NET/Windows to display the text in order that it appears exactly within the box
									//Obviously, this should not exist
		public Rectangle box;
		public int first, n;	//Characters
		public int baseline;	//With respect to top of box
	}
	/** <summary>
	Etiqueta con punto de referencia a elegir, as como la posicin del texto dentro de ella.
	</summary>
	<remarks>
	Las coordenadas del punto de referencia son RefLocation. La posicin de este punto
	en relacin al rectngulo que ocupa el control es (RefPositionx, RefPositiony), que son
	variables float: 0 el extremo izquierdo/superior, 1 el extremo derecho/inferior.
	Location se puede leer pero no asignar directamente.
	
	La alineacin del texto dentro de la etiqueta es TextAlign. Se puede acceder separadamente
	a la X y a la Y mediante AlignmentX y AlignmentY. Son float que van de 0 a 1 (normalmente).
	La variable Autoref controla si un cambio se TextAlign cambia automticamente
	(RefPositionx, RefPositiony) al mismo valor.
	
	TextAlign.AlignX alinea cada lnea dentro del ancho total (InteriorWidth)
	TextAlign.AlignY alinea el conjunto del texto dentro del ancho total (InteriorHeight).
	En realidad, el modo de alinear en Y puede ser distinto. Depende del valor de PositionModeY.
	Algunos de estos modos usan TextAlign.AlignY y otros no.
	</remarks>
	*/
	public class BaseLabel : System.Windows.Forms.Control
	{
		private float refpositionx=0, refpositiony=0;	//Alignment of the point reflocation
		private Point reflocation;
		private int offsetx, offsety;	//Location=reflocation-offset
		private PositionModeY positionmodey;
		protected TwoDimAlignment alignmentxy;	//Alignment of text within label
		public bool Autoref=true;	//Whether a change of alignmentxy automatically changes refpostionx/y to the same values
		private Size size;
		private int maxwidth=10000;
		private int maxheight=10000;
		private bool autosizex=true, autosizey=true;
		private Margenes margins;
		private bool wordwrap=true;
		private int interlinespace=0;

		protected Rectangle onelinebox;
		protected int totalheight=0;
		protected Box[] boxes;

		public void Copy(BaseLabel B){
			this.Autoref=B.Autoref;
			this.positionmodey=B.positionmodey;
			this.alignmentxy=B.alignmentxy;
			this.margins=B.margins;
			this.maxwidth=B.maxwidth;
			this.maxheight=B.maxheight;
			this.size=B.size;
			this.autosizex=B.autosizex;
			this.autosizey=B.autosizey;
			this.margins=B.margins;
			this.wordwrap=B.wordwrap;
			this.interlinespace=B.interlinespace;
			setlabel();
			this.RefPositionx=B.RefPositionx;
			this.RefPositiony=B.RefPositiony;
		}

		public float RefPositionx{
			get{return refpositionx;}
			set{refpositionx=value; update_offsetx();}	//Location not changed, intended. If it be wanted to be updated now, write RefLocation=RefLocation
		}
		public float RefPositiony{
			get{return refpositiony;}
			set{refpositiony=value; update_offsety();}
		}
		public PositionModeY PositionModeY{
			get{return positionmodey;}
			set{positionmodey=value; update_offsety();
				if(this.Top!=base.Top){
					OnInternalLocationChanged(EventArgs.Empty);
					base.Location=this.Location;
			}	}
		}
		public Point RefLocation{
			get{return reflocation;}
			set{reflocation=value;
				base.Location= new Point(value.X-offsetx,value.Y-offsety);
			}
		}
		public new Point Location{
			get{return new Point(reflocation.X-offsetx,reflocation.Y-offsety);}
		}
		public new int Left{get{return Location.X;}}
		public new int Top{get{return Location.Y;}}

		private void update_offsetx(){
			offsetx=Basicas._gcVarios.floor(refpositionx*CurrentWidth+0.5F);
		}
		private void update_offsety(){
			if(positionmodey==PositionModeY.None){
				offsety=Basicas._gcVarios.floor(refpositiony*CurrentHeight+0.5F); return;
			}
			if(Lines==0){offsety=0; return;}
			if(Lines==1 || positionmodey==PositionModeY.FirstBaseLine){offsety=boxes[0].box.Top+boxes[0].baseline; return;}
			if(positionmodey==PositionModeY.LastBaseLine){offsety=boxes[Lines-1].box.Top+boxes[Lines-1].baseline; return;}
			if(positionmodey==PositionModeY.MidLine){
				int k=Lines>>1;
				if((Lines&1)==1) offsety=boxes[k].box.Top+boxes[k].baseline;
				else offsety=(boxes[k-1].box.Top+boxes[k-1].baseline+boxes[k].box.Top+boxes[k].baseline+1)/2;
			}else{//Nearestbaseline
				int k1=0,k2,i;		//Lo de siempre. Estpido compilador!
				offsety=Basicas._gcVarios.floor(refpositiony*CurrentHeight+0.5F);
				k2=boxes[0].box.Top+boxes[0].baseline;
				for(i=1;i<Lines;i++){
					k1=k2;
					k2=boxes[0].box.Top+boxes[0].baseline;
					if(k2>=offsety) break;
				}
				if(k2-offsety<offsety-k1) offsety=k2;	//this also works for offsety<0 or >lastbaseline
				else offsety=k1;
			}
		}


		public TwoDimAlignment TextAlign{
			get{return alignmentxy;}
			set{if(!alignmentxy.Equals(value)){alignmentxy=value; OnTextAlignChanged(EventArgs.Empty);}}
		}
		public float AlignmentX{
			get{return alignmentxy.AlignX;}
			set{if(alignmentxy.AlignX!=value){alignmentxy.AlignX=value; OnTextAlignChanged(EventArgs.Empty);}}
		}
		public float AlignmentY{
			get{return alignmentxy.AlignY;}
			set{if(alignmentxy.AlignY!=value){alignmentxy.AlignY=value; OnTextAlignChanged(EventArgs.Empty);}}
		}

		public bool WordWrap{
			get{return wordwrap;}
			set{if(wordwrap!=value){wordwrap=value; OnWordWrapChanged(EventArgs.Empty);}}
		}
		public int InterlineSpace{
			get{return interlinespace;}
			set{if(interlinespace!=value){interlinespace=value; OnInterlineSpaceChanged(EventArgs.Empty);}}
		}
		public int[] BaseLines{
			get{int[] array=new int[boxes.Length];
				for(int i=0;i<boxes.Length;i++){
					array[i]=boxes[i].box.Top+boxes[i].baseline;
				}
				return array;
		}	}

		public new Size Size{
			get{return size;}
			set{Size sz=size;
				if(autosizex==false) sz.Width=value.Width;
				if(autosizey==false) sz.Height=value.Height;
				if(size!=sz){size=sz; setlabel();}
			}
		}
		public new int Width{
			get{return size.Width;}
			set{if(!autosizex && size.Width!=value){size.Width=value; setlabel();}}
		}
		public new int Height{
			get{return size.Height;}
			set{if(autosizey && size.Height!=value){size.Height=value; setvlabel();}}
		}
		protected int CurrentWidth{get{
			if(DockedInx) return Bounds.Width;
			else return size.Width;
		}}
		protected int CurrentHeight{get{
			if(DockedIny) return Bounds.Height;
			else return size.Height;
		}}
		public int InteriorWidth{get{return CurrentWidth-margins.H;}}
		public int InteriorHeight{get{return CurrentHeight-margins.V;}}

		public int MaxWidth{
			get{return maxwidth;}
			set{if(maxwidth==value) return;
				bool b= Math.Min(value,maxwidth)<onelinebox.Width+margins.H;
				maxwidth=value;
				if(b) setlabel();
			}
		}
		public int MaxHeight{
			get{return maxheight;}
			set{if(maxheight==value) return;
				bool b= Math.Min(value,maxheight)<totalheight+margins.V;
				maxheight=value;
				if(b) setvlabel();
			}
		}
		public int Lines{get{return boxes.Length;}}

		public Margenes Margins{
			get{return margins;}
			set{if(!margins.Equals(value)){margins=value; OnMarginsChanged(EventArgs.Empty);}}
		}

		public bool AutoSizex{
			get{return autosizex;}
			set{if(autosizex!=value){autosizex=value; OnAutoSizeChanged(EventArgs.Empty);}}
		}
		public bool AutoSizey{
			get{return autosizey;}
			set{if(autosizey!=value){autosizey=value; OnAutoSizeChanged(EventArgs.Empty);}}
		}
		public override bool AutoSize{
			set{if(autosizex!=value || autosizey!=value){
				    autosizex=autosizey=value;
				    OnAutoSizeChanged(EventArgs.Empty);
			    }}
		}
		protected bool DockedInx{get{
			if(Dock==DockStyle.None) return false;
			return (Dock==DockStyle.Fill || Dock==DockStyle.Top || Dock==DockStyle.Bottom);
		}}
		protected bool DockedIny{get{
			if(Dock==DockStyle.None) return false;
			return (Dock==DockStyle.Fill || Dock==DockStyle.Right || Dock==DockStyle.Left);
		}}
		public bool CanAutoSizex{get{return (autosizex && !DockedInx);}}
		public bool CanAutoSizey{get{return (autosizey && !DockedIny);}}

		EventHandler rParent_SizeChanged;
		protected override void OnDockChanged(EventArgs e){
			base.OnDockChanged(e);
			setlabel();
			if(this.Parent!=null){
				if(this.Dock!=DockStyle.None) this.Parent.SizeChanged+= rParent_SizeChanged;
				else this.Parent.SizeChanged-= rParent_SizeChanged;
			}
		}
		protected override void OnParentChanged(EventArgs e){
			base.OnParentChanged(e);
			if(this.Dock!=DockStyle.None && this.Parent!=null){
				setlabel();
				this.Parent.SizeChanged+= rParent_SizeChanged;
			}
		}
		private void Parent_SizeChanged(object sender,EventArgs e){
			if(sender!=this.Parent){((Control)sender).SizeChanged-= rParent_SizeChanged; return;}
			if(this.Dock!=DockStyle.None) setlabel();
		}

		public event EventHandler TextAlignChanged,
										WordWrapChanged,
										MarginsChanged,
										//AutoSizeChanged,
										InterlineSpaceChanged,
										LinesChanged,
										InternalSizeChanged,
										InternalLocationChanged;
		public new event EventHandler AutoSizeChanged;

	//Constructor
		public BaseLabel(){
			this.TabStop=false;
			margins=DefaultMargins;
			size=DefaultSize;
			boxes=new Box[0];
			rParent_SizeChanged= new EventHandler(Parent_SizeChanged);
		}
		protected virtual Margenes DefaultMargins{
			get{return new Margenes(0,0,0,0);}
		}
		protected override Size DefaultSize{
			get{return new Size(80,0);}
		}
	//fin Constructor

		protected virtual void OnTextAlignChanged(EventArgs e){
			if(Autoref){refpositionx=alignmentxy.AlignX; refpositiony=alignmentxy.AlignY;}
			placeboxes();
			if(TextAlignChanged!=null) TextAlignChanged(this,e);
		}
		protected virtual void OnWordWrapChanged(EventArgs e){
			if(wordwrap==false && boxes.Length>1 ||
			   wordwrap==true && onelinebox.Width>InteriorWidth)
				setlabel();
			if(WordWrapChanged!=null) WordWrapChanged(this,e);
		}
		protected virtual void OnInterlineSpaceChanged(EventArgs e){
			if(boxes.Length>1) setvlabel();
			if(InterlineSpaceChanged!=null) InterlineSpaceChanged(this,e);
		}
		protected virtual void OnMarginsChanged(EventArgs e){
			setlabel();
			if(MarginsChanged!=null) MarginsChanged(this,e);
		}
		protected override void OnAutoSizeChanged(EventArgs e){
			if(AutoSizeChanged!=null) AutoSizeChanged(this,e);
			setlabel();
		}
		protected override void OnTextChanged(EventArgs e){base.OnTextChanged(e);	setlabel();}
		protected override void OnFontChanged(EventArgs e){base.OnFontChanged(e);	setlabel();}

		protected Rectangle MeasureText(string ss){
			if(this.Text==null || ss=="" || this.Font==null)
				return new Rectangle(0,0,0,0);

			Graphics g=this.CreateGraphics();
			SizeF sF=g.MeasureString(ss,this.Font);

			StringFormat stringFormat= new StringFormat();
			stringFormat.SetMeasurableCharacterRanges(new CharacterRange[]{new CharacterRange(0, ss.Length)});
			RectangleF rect= new RectangleF(0, 0, sF.Width, sF.Height);
			Region[] region= g.MeasureCharacterRanges(ss,this.Font,rect,stringFormat);
			rect=region[0].GetBounds(g);

			float f,ff;
			int x,y,w,h;
			f=rect.X+rect.Width;	w=(int)f;		if(f!=(float)w) w++;
			ff=rect.Y+rect.Height;	h=(int)ff;		if(ff!=(float)h) h++;

			x=(int)rect.X;
			y=(int)rect.Y;
			return new Rectangle(x,y,w-x,h-y);
		}

		protected struct BreakPoint{
			public int previous;	//Index into possiblebreaks. If ==-1 this is the first line
			public int pos;
			public int width;	//Width of this line
			public int wmax;	//Maximum width of the remaining lines
		}
		private Box[] decide_boxes(int maxhsize,int baseline,string texto, out int w1){
			texto=texto.TrimEnd();
			if(texto==""){w1=0; return new Box[0];}
			Point pt= new Point(0);	//#$%&
			Rectangle onelinebox;
			Box[] boxes;
			int i,n,k;
			char c;

			onelinebox=MeasureText(texto);
			n=texto.Length;

			int[] prov, possiblebreaks;
			if(!( onelinebox.Width<=maxhsize || WordWrap==false)){//Tengo que hacer esto aqu porque este lenguaje no deja hacer un goto hacia atrs
				//Feasible break points. The break point is placed before the position indexed by the integer.
				//Thus, 10 indicates ten characters before the break, and the remaining ones after.
				//If the element at the position indexed is a space, tab it disappears after the break, and the index is stored negative;
				prov= new int[n];
				for(k=0,i=1;i<n;i++){
					c=texto[i];
					if(Char.IsWhiteSpace(c) || c=='-' || c=='\\'){
						if(Char.IsWhiteSpace(c)) prov[k]=-i;
						else prov[k]=i;
						k++;
					}
				}
				possiblebreaks= new int[k+1];
				Array.Copy(prov,possiblebreaks,k);
				possiblebreaks[k]=n;
				prov=null;
				if(k>0) goto morethanoneline;
			}
			boxes= new Box[1];
			boxes[0].box=onelinebox;
			boxes[0].first=0;
			boxes[0].n=n;
			boxes[0].baseline=baseline;
			boxes[0].n=texto.Length;
			w1=boxes[0].box.Width;
			return boxes;

	morethanoneline:
			int j,k1,l1;
			int w0,v0,v1;
			w0=w1=v1=v0=0;	//Estoy hasta las narices de que el stpido del compilador se pase de listo
							//Estas asignaciones son slo para que no me diga ms abajo
							//'Uso de la variable local no asignada', por supuesto en un punto en
							//el que s ha sido asignada. Lo mismo el tener que declarar w1 arriba
			//mirar a ver si cabe en dos lineas (o si no queda ms remedio)
			bool b=false;
			if(k==1){i=0; b=true;} if(k==1) goto b_decidido;
			j=n/2;
			for(i=0;i<k;i++){
				if(Math.Abs(possiblebreaks[i])>j) break;
			}
			if(i==k) i=k-1;
			k1=Math.Abs(possiblebreaks[i]);
			if(possiblebreaks[i]>0) l1=k1;
			else l1=k1+1;
			w0=MeasureText(texto.Substring(0,k1)).Width;
			w1=MeasureText(texto.Substring(l1,n-l1)).Width;
			if(w0>maxhsize && w1>maxhsize){b=false; goto b_decidido;}
			if(w0==w1 && w0<=maxhsize){b=true; goto b_decidido;}
			if(w0<w1){
				for(i++;i<k;i++){
					v0=w0;
					v1=w1;
					k1=Math.Abs(possiblebreaks[i]);
					if(possiblebreaks[i]>0) l1=k1;
					else l1=k1+1;
					w0=MeasureText(texto.Substring(0,k1)).Width;
					w1=MeasureText(texto.Substring(l1,n-l1)).Width;
					if(w0>=w1) break;
				}
				if(i==k){
					if(w0<=maxhsize){i--; b=true;}
					else{b=false;}
					goto b_decidido;
				}
			}else{
				v0=w0; v1=w1;
				for(i--;i>=0;i--){
					w0=v0;
					w1=v1;
					k1=Math.Abs(possiblebreaks[i]);
					if(possiblebreaks[i]>0) l1=k1;
					else l1=k1+1;
					v0=MeasureText(texto.Substring(0,k1)).Width;
					v1=MeasureText(texto.Substring(l1,n-l1)).Width;
					if(v0<=v1) break;
				}
				i++;
				if(i==0){
					if(w1<=maxhsize) b=true;
					else b=false;
					goto b_decidido;
				}
			}
			if(v1<w0){w0=v0; w1=v1; i--;}
			if(w0<=maxhsize && w1<=maxhsize) b=true;
		b_decidido:
			if(b==true){
				boxes=new Box[2];
				boxes[0].first=0;
				k1=possiblebreaks[i];
				boxes[0].n=Math.Abs(k1);
				if(k1>0) l1=k1;
				else l1=-k1+1;
				boxes[1].first=l1;
				boxes[1].n=n-l1;
				boxes[0].box=MeasureText(texto.Substring(0,boxes[0].n));
				boxes[1].box=MeasureText(texto.Substring(l1,boxes[1].n));
				boxes[0].baseline=boxes[1].baseline=baseline;
				w1=boxes[0].box.Width;
				if(boxes[1].box.Width>w1) w1=boxes[1].box.Width;
				return boxes;
			}
		//3 or more lines
			int nlines,lx,kk;
			BreakPoint[] breakpoints, candidates;
			bool retrying=false;
			w1=maxhsize;
		retry:
			candidates=new BreakPoint[k+1];
			n=texto.Length;
			k1=0;
			for(nlines=0,i=-1;;){
				candidates[nlines].previous=i;
				for(i++;i<=k;i++){
					l1=Math.Abs(possiblebreaks[i]);
					w0=MeasureText(texto.Substring(k1,l1-k1)).Width;
					if(w0>w1) break;
					v0=w0;
				}
				i--;
				if(i==candidates[nlines].previous){v0=w0; i++;}
				candidates[nlines].pos=i;
				candidates[nlines++].width=v0;
				if(i==k) break;
				l1=possiblebreaks[i];
				if(l1>0) k1=l1;
				else k1=-l1+1;
			}
			breakpoints= new BreakPoint[nlines];
			Array.Copy(candidates,breakpoints,nlines);
			b=false;
			breakpoints[nlines-1].wmax=0;
			w1=breakpoints[nlines-1].width;
			lx=nlines-1;
			for(i=nlines-1;i>0;){
				i--;
				breakpoints[i].wmax=w1;
				if(breakpoints[i].width>w1){w1=breakpoints[i].width; lx=i;}
			}
			if(retrying) goto lines_decided;
			if(w1>maxhsize){retrying=true; goto retry;}
			candidates=new BreakPoint[nlines];
			while(true){
				if(lx==nlines-1 || (breakpoints[lx].pos-breakpoints[lx].previous==1)) goto lines_decided;
				v1=w1;
				Array.Copy(breakpoints,candidates,lx+1);
				i=breakpoints[lx].previous;
				if(lx==0) k1=0;
				else{k1=possiblebreaks[i];	if(k1<0) k1=-k1+1;}
				for(j=lx;j<nlines-1;){
					candidates[j].previous=i;
					kk=breakpoints[j].pos;
					for(i++;i<=kk;i++){
						l1=Math.Abs(possiblebreaks[i]);
						w0=MeasureText(texto.Substring(k1,l1-k1)).Width;
						if(w0>=v1) break;
						v0=w0;
					}
					i--;
					if(i==candidates[j].previous) goto lines_decided;
					candidates[j].pos=i;
					candidates[j].width=v0;
					if(i==kk){
						candidates[j].wmax=breakpoints[j].wmax;
						Array.Copy(candidates,lx,breakpoints,lx,j+1-lx);
						break;
					}
					j++;
					l1=possiblebreaks[i];
					if(l1>0) k1=l1;
					else k1=-l1+1;
				}
				if(j==nlines-1){
					v0=MeasureText(texto.Substring(k1,n-k1)).Width;
					if(v0>=v1) goto lines_decided;
					Array.Copy(candidates,0,breakpoints,0,nlines-1);
					breakpoints[j].previous=i;
					w1=breakpoints[nlines-1].width=v0;
					lx=nlines-1;
				}else{
					w1=breakpoints[j].wmax;
					for(i=j+1;i<nlines;i++){
						if(breakpoints[i].wmax!=w1) break;
					}
					lx=i;
				}
				for(i=lx;i>0;){
					i--;
					breakpoints[i].wmax=w1;
					if(breakpoints[i].width>w1){w1=breakpoints[i].width; lx=i;}
				}
			}
		lines_decided:
			candidates=null;
			boxes= new Box[nlines];
			l1=0;
			for(i=0;i<nlines;i++){
				k1=l1;
				l1=possiblebreaks[breakpoints[i].pos];
				boxes[i].first=k1;
				boxes[i].n=Math.Abs(l1)-k1;
				boxes[i].box= MeasureText(texto.Substring(k1,boxes[i].n));
				boxes[i].baseline=baseline;
				if(l1<0) l1=-l1+1;
			}
			return boxes;
		}
		protected void setlabel(){
			if(this.Parent==null && this.Dock!=DockStyle.None) return;
			Size sz;
			int bln=Lines;
			bool bsz=false;
			string texto="";
			if(this.Text!=null && this.Text!=""){
				char c=this.Text[this.Text.Length-1];
				if(c<='\r' && c>='\n') texto=this.Text.Substring(0,this.Text.Length-1);	//one end-of-line at the end of the original text is removed
				else texto=this.Text.TrimEnd(new char[]{' ','\t'});	//all other are respected
			}
			if(texto=="" || this.Font==null){
				boxes=new Box[0];
				if(this.size== new Size(0,0)) return;
				if(autosizex) size.Width=0;
				if(autosizey) size.Height=0;
				if(size!=base.Size) bsz=true;
				goto done;
			}
			Graphics g=this.CreateGraphics();

			int maxhsize, maxvsize;		//si autosizex=false, setting Size, Width or Height changes size and hence this is the value to be used.
			if(CanAutoSizex) maxhsize=maxwidth;	else maxhsize=CurrentWidth;		maxhsize-=Margins.H;		//Such is the value returned by
			if(CanAutoSizey) maxvsize=maxheight;	else maxvsize=CurrentHeight;		maxvsize-=Margins.V;		//CurrentWidth/Height
			Point pt= new Point(0);	//#$%&

			onelinebox=MeasureText(texto);
			float pixelsize=this.Font.Size*g.DpiY/72.0F;	//Not 72.27
			int lineheight=(int)(pixelsize+0.5F);
			int baseline=(int)(this.Font.FontFamily.GetCellAscent(this.Font.Style)*pixelsize/Font.FontFamily.GetEmHeight(this.Font.Style)-0.5F);

			int i,n,k,l,ll,j;
			int[] prov, newlines;
			n=texto.Length;
			prov= new int[n];
			for(k=0,i=0;i<n;i++){
				if(texto[i]<='\r' && texto[i]>='\n'){
					prov[k++]=i;
				}
			}
			newlines= new int[k+1];
			Array.Copy(prov,newlines,k);
			newlines[k++]=n;
			prov=null;

			Box[][] bboxes=new Box[k][];
			int[] firstchars=new int[k];
			int[] groupwidths=new int[k];
			ll=-1;
			for(i=0;i<k;i++){
				l=ll+1;
				ll=newlines[i];
				while(l<ll && Char.IsWhiteSpace(texto[l])) l++;	//ll may be igual a n
				firstchars[i]=l;
				if(ll==l){	//firstchars[i]==newlines[i]
					bboxes[i]=new Box[0];
					groupwidths[i]=0;
				}else{
					bboxes[i]=decide_boxes(maxhsize,baseline,texto.Substring(l,ll-l),out groupwidths[i]);
				}
				if(bboxes[i].Length==0){	//so that the MidLine valignment mode works properly
					bboxes[i]=new Box[1];
					bboxes[i][0].first=0;	//l will be added later
					bboxes[i][0].n=0;
					bboxes[i][0].Location=new Point(0,0);
					bboxes[i][0].box=new Rectangle(0,0,0,lineheight);
					bboxes[i][0].baseline=baseline;
				}
			}
			n=0;
			for(i=0;i<k;i++){
				n+=bboxes[i].Length;
			}
			boxes=new Box[n];
			l=0;
			for(i=0;i<k;i++){
				ll=bboxes[i].Length;
				for(j=0;j<ll;j++){
					boxes[l]=bboxes[i][j];
					boxes[l++].first+=firstchars[i];
				}
				bboxes[i]=null;
			}
			bboxes=null;

			sz=this.size;
			if(CanAutoSizex){
				int w1=0;
				for(i=0;i<k;i++){
					if(groupwidths[i]>w1) w1=groupwidths[i];
				}
				if(w1>maxhsize) sz.Width=maxhsize;
				else sz.Width=w1;
				sz.Width+=margins.H;
			}
			totalheight=boxes[0].box.Height;
			for(i=1;i<n;i++)
				totalheight+=interlinespace+boxes[i].box.Height;
			if(CanAutoSizey){
				if(totalheight>maxheight) sz.Height=maxheight;
				else sz.Height=totalheight;
				sz.Height+=margins.V;
			}
			size=sz;
			if(sz!=base.Size) bsz=true;
			int currenttop;
			currenttop=margins.Top+Basicas._gcVarios.floor(alignmentxy.AlignY*(this.InteriorHeight-totalheight)+0.5F);
			for(i=0;i<n;i++){
				boxes[i].Location=boxes[i].box.Location;	//Height ya incluye un strut
				boxes[i].box.Location=new Point(margins.Left+Basicas._gcVarios.floor(alignmentxy.AlignX*(this.InteriorWidth-boxes[i].box.Width)+0.5F), currenttop);
				boxes[i].Location=boxes[i].box.Location-new Size(boxes[i].Location);
				currenttop+=interlinespace+boxes[i].box.Height;
			}
	done:
			update_offsetx();
			update_offsety();
			if(bln!=Lines) OnLinesChanged(EventArgs.Empty);
			if(bsz){
				OnInternalSizeChanged(EventArgs.Empty);
				base.Size=size;	//Actually set the size. This calls OnSizeChanged()
			}
			if(this.Location!=base.Location){
				OnInternalLocationChanged(EventArgs.Empty);
				base.Location=this.Location;	//Set the Location. This calls OnLocationChanged();
			}
			this.Invalidate();
		}

		protected void setvlabel(){
			bool bsz=false;
			int i, n=boxes.Length;
			if(n==0) return;

			totalheight=boxes[0].box.Height;
			for(i=1;i<n;i++)
				totalheight+=interlinespace+boxes[i].box.Height;
			Size sz=this.size;
			if(CanAutoSizey){
				if(totalheight>maxheight) sz.Height=maxheight;
				else sz.Height=totalheight;
				sz.Height+=margins.V;
				size=sz;
			}
			if(sz!=base.Size){bsz=true;}
			int currenttop, dy;
			currenttop=margins.Top+Basicas._gcVarios.floor(alignmentxy.AlignY*(this.InteriorHeight-totalheight)+0.5F);
			for(i=0;i<n;i++){
				dy=boxes[i].box.Top-boxes[i].Location.Y;
				boxes[i].box.Location=new Point(boxes[i].box.X, currenttop);
				boxes[i].Location.Y=boxes[i].box.Top-dy;
				currenttop+=interlinespace+boxes[i].box.Height;
			}
			update_offsety();
			if(bsz){
				OnInternalSizeChanged(EventArgs.Empty);
				if(bsz) base.Size=size;	//Actually set the size. This calls OnSizeChanged()
			}
			if(this.Location!=base.Location){
				OnInternalLocationChanged(EventArgs.Empty);
				base.Location=this.Location;	//Set the Location. This calls OnLocationChanged();
			}
			this.Invalidate();
		}
		protected void placeboxes(){
			int currenttop;
			currenttop=margins.Top+Basicas._gcVarios.floor(alignmentxy.AlignY*(this.InteriorHeight-totalheight)+0.5F);
			int i, n=boxes.Length;
			for(i=0;i<n;i++){
				boxes[i].Location=boxes[i].box.Location;
				boxes[i].box.Location=new Point(margins.Left+Basicas._gcVarios.floor(alignmentxy.AlignX*(this.InteriorWidth-boxes[i].box.Width)+0.5F), currenttop);
				boxes[i].Location=boxes[i].box.Location-new Size(boxes[i].Location);
				currenttop+=interlinespace+boxes[i].box.Height;
			}
			if(positionmodey!=PositionModeY.None) update_offsety();
			if(this.Top!=base.Top){
				OnInternalLocationChanged(EventArgs.Empty);
				base.Location=this.Location;
			}
			this.Invalidate();
		}

		protected virtual void OnLinesChanged(EventArgs e){
			if(LinesChanged!=null) LinesChanged(this, e);
		}
		protected virtual void OnInternalSizeChanged(EventArgs e){
			if(InternalSizeChanged!=null) InternalSizeChanged(this, e);
		}
		protected virtual void OnInternalLocationChanged(EventArgs e){
			if(InternalLocationChanged!=null) InternalLocationChanged(this, e);
		}

		protected override void OnPaint(System.Windows.Forms.PaintEventArgs e){
			base.OnPaint(e);
			if(this.Text!=""){
				System.Drawing.SolidBrush b;
				if(this.Enabled) b= new SolidBrush(this.ForeColor);
				else	b= new SolidBrush(System.Drawing.SystemColors.GrayText);
				Point pF= new Point(0);	//Si no el #$%& protesta en la instruccin siguiente
				for(int i=0;i<boxes.Length;i++){
					e.Graphics.DrawString(this.Text.Substring(boxes[i].first,boxes[i].n),this.Font,b, boxes[i].Location);
					//e.Graphics.DrawRectangle(new Pen(Color.Blue, 1), new Rectangle(boxes[i].box.Location, boxes[i].box.Size-new Size(1,1)));
				}
				//e.Graphics.DrawRectangle(new Pen(Color.Yellow, 1), new Rectangle(new Point(margins.Left,margins.Top), new Size(this.InteriorWidth-1,this.InteriorHeight-1)));
				//e.Graphics.DrawRectangle(new Pen(Color.Red, 1), new Rectangle(new Point(0,0), this.Bounds.Size-new Size(1,1)));
				b.Dispose();
			}
		}
	}

	public class PaddedLabel : BaseLabel{
		public PaddedLabel(){
			Autoref=false;
			AutoSizey=false;
			alignmentxy.AlignY=0.5F;
		}
		protected override Size DefaultSize{
			get {return new Size(150, 15);}
		}
		protected override Margenes DefaultMargins{
			get{return new Margenes(6,6,0,0);}
		}
		public int dWidth{
			get{return Margins.Left;}
			set{this.Margins= new Margenes(value, value, Margins.Top, Margins.Bottom);}
		}
	}
	public class LabelRight : BaseLabel{
		public LabelRight(){
			this.TextAlign= ContentAlignment.MiddleRight;
			this.PositionModeY= PositionModeY.MidLine;
		}
	}
}
