﻿using Globales;

namespace Aerotri{
	internal static class Textos{
		public enum Cods : uint{
			Caption,
			MsgCaption,
			Acercade,
			FullTitle,
			Manualpath,
			AbrirTrabajo,
			GuardarTrabajo,
			Guardarconfiguración,
			Unidades_de_los_giros,
			Radianes,
			g_centesimales,
			g_sexagesimales,
			Herramientas,
			Transformación_de_ficheros,
			Fotogramas,
			Valores_aproximados_y_apoyo,
			Unión_de_modelos,
			Sensor,
			Cónico,
			Modelo_local,
			Datos_de_entrada,
			Config_cálculo,
			Ficheros_de_salida,
			Fichero_fotogramas,
			Fichero_apoyo,
			Fichero_gps,
			Fichero_cámara,
			Un_fichero,
			Una_carpeta,
			Son_ya_ajustados,
			Precisiones,
			Fotocoordenadas,
			Apoyo,
			Planimetría,
			Altimetría,
			GPS,
			INS,
			Estimador,
			MMcc,
			Robusto,
			Puntos_de_apoyo,
			Fijos,
			Variables,
			Sistema_de_coordenadas,
			Config_valores_aproximados,
			Estimador_robusto,
			Autocalibración,
			Tratamiento_de_las_coordenadas,
			Fotocoordenadas_xy,
			Apoyo_XY,
			Apoyo_PlaniZ,
			Individual,
			Conjunto,
			GPS_INS,
			Errores_sistemáticos,
			Offset,
			No_error,
			Constante,
			Lineal,
			Calcular_fotos_intermedias,
			Interpolar_residuos,
			Diferencia_INS_kappa,
			Cámara_girada,
			Fotos_giradas,
			Escala_marcas_residuos,
			Valores_ajustados,
			Opciones_generales,
			Ficheros_pdf,
			Símbolos_unidades,
			Cifras_decimales,
			Pares,
			Ficheros_de_información,
			Texto,
			Binario,
			Hoja_pdf,
			Centros_puros,
			Gráfico,
			Archivo_ini,
			Otros_ficheros,
			Residuos,
			Estadísticas,
			Ficheros_log,
			Gráfico_de_residuos,
			Sólo_valores_aproximados,
			Ajuste_completo,
			Calcular,
			GPS_INS_ccpp,
			Archivos_de_cámara,
			Ventana_de_comandos,
			Fichero_valores_aproximados,
			Incrementos,
			Residuos_elevados,
			Hoja_pdf_int,
			Cálculo_terminado,
			Calculando_valores_aproximados,
			Realizando_el_ajuste_del_bloque,
			Esperando_a_que_termine_el_cálculo,
			Leyendo_el_fichero_de_trabajo,
			Escribiendo_el_fichero_de_trabajo,
			Escribiendo_el_fichero_de_configuración,
			De_esta_manera_la_configuración,
			Fichero_de_valores_aproximados,
			Fichero_de_modelo_local,
			No_se_ha_podido_abrir_ajbloque,
			Desea_continuar_con_el_ajuste,
			Error_en_valores_aproximados,
			Mirar_el_fichero_de_proceso,
			para_posibles_puntos_erróneos,
			Si_desea_continuar,
			Debe_indicar_modelo_local,
			Debe_indicar_apoyo,
			Desea_calcular_en_sistema_arbitrario,
			Error_en_la_escritura_del_fichero_de_trabajo,
			No_se_pudo_abrir_para_escribirlo,
			El_fichero_no_se_escribió_correctamente,
			PREPARA_RELATIVA_BASE,
			relativa_Debe_indicar_fotogramas,
			relativa_Nombre_fotogramas_no_válido,
			relativa_La_extensión_ftm_está_reservada,
			relativa_Debe_indicar_cámara,
			relativa_Nombre_cámara_no_válido,
			relativa_Nombre_GPSINS_no_válido,
			relativa_Debe_indicar_precisión_de_fotocoordenadas,
			relativa_Precisión_de_fotocoordenadas_no_número,
			relativa_Precisión_de_fotocoordenadas_no_cero,
			relativa_Precisión_de_fotocoordenadas_positivo,
			PREPARA_ABSOLUTA_BASE,
			ajbloque_Debe_indicar_fotogramas,
			ajbloque_Nombre_fotogramas_no_válido,
			ajbloque_La_extensión_ftm_está_reservada,
			ajbloque_Debe_indicar_cámara,
			ajbloque_Nombre_cámara_no_válido,
			ajbloque_Debe_indicar_valores_aproximados,
			ajbloque_Nombre_valores_aproximados_no_válido,
			ajbloque_Nombre_apoyo_no_válido,
			ajbloque_Nombre_GPSINS_no_válido,
			ajbloque_Debe_indicar_precisión_de_fotocoordenadas,
			ajbloque_Precisión_de_fotocoordenadas_no_número,
			ajbloque_Precisión_de_fotocoordenadas_no_cero,
			ajbloque_Precisión_de_fotocoordenadas_positivo,
			ajbloque_Debe_indicar_precisión_apoyo_plani,
			ajbloque_Precisión_de_apoyo_plani_no_número,
			ajbloque_Precisión_de_apoyo_plani_no_cero,
			ajbloque_Precisión_de_apoyo_plani_positivo,
			ajbloque_Debe_indicar_precisión_apoyo_alti,
			ajbloque_Precisión_de_apoyo_alti_no_número,
			ajbloque_Precisión_de_apoyo_alti_no_cero,
			ajbloque_Precisión_de_apoyo_alti_positivo,
			ajbloque_Debe_indicar_precisión_GPS_plani,
			ajbloque_Precisión_de_GPS_plani_no_número,
			ajbloque_Precisión_de_GPS_plani_no_cero,
			ajbloque_Precisión_de_GPS_plani_positivo,
			ajbloque_Debe_indicar_precisión_GPS_alti,
			ajbloque_Precisión_de_GPS_alti_no_número,
			ajbloque_Precisión_de_GPS_alti_no_cero,
			ajbloque_Precisión_de_GPS_alti_positivo,
			ajbloque_Debe_indicar_precisión_INS_ΩΦ,
			ajbloque_Precisión_de_INS_ΩΦ_no_número,
			ajbloque_Precisión_de_INS_ΩΦ_no_cero,
			ajbloque_Precisión_de_INS_ΩΦ_positivo,
			ajbloque_Debe_indicar_precisión_INS_Kappa,
			ajbloque_Precisión_de_INS_Kappa_no_número,
			ajbloque_Precisión_de_INS_Kappa_no_cero,
			ajbloque_Precisión_de_INS_Kappa_positivo,
			Valor_de_ondulación_del_geoide_erróneo,
			Parámetros_a_calcular,
			Focal,
			Punto_principal,
			Modelo_polinómico,
			Impar,
			Completo,
			Radial_tangencial,
			Vector_giratorio,
			Función_de_distorsión,
			Radial_simétrica,
			Tangencial_sim,
			Asimétricas,
			Radial,
			Tangencial,
			Serie1,
			Serie2,
			Errores_sistemáticos_GPS,
			Sin_errores_0,
			Permanente_Offset,
			Constante_1,
			Lineal_2,
			Valor_mínimo_puntos_comunes_erróneo,
			Valor_parámetro_camino_erróneo,
			Tipo_de_ajuste,
			Fuerza_mmcc,
			Valores_aproximados,
			Minimo_número_puntos_comunes,
			Deduce_automáticamente,
			El_siguiente_valor,
			Parámetro_de_camino,
			Uso_de_GPS,
			No_emplear,
			Emplear_si_todos,
			Para_los_ficheros_de_entrada,
			Guardar_ruta_relativa,
			Guardar_ruta_absoluta,
			Valor_decimales_fotocoordenadas_erróneo,
			Valor_decimales_puntos_erróneo,
			Valor_decimales_GPS_erróneo,
			Valor_decimales_INS_erróneo,
			Escritura_de_los_residuos,
			dos_cifras_significativas,
			Número_de_decimales_fijo,
			Deducir,
			Este_valor,
			Fotocoordenadas_breve,
			Matrices_de_rotación,
			Ficheros_Digi1,
			Ficheros_Digi2,
			Directorio_de_generación_relativo_a_fotos,
			Ficheros_IMaster1,
			Ficheros_IMaster2,
			Igual_que_el_idioma_del_programa,
			Otro,
			Log_del_ajuste,
			Log_básico,
			Lectura_y_escritura_de_ficheros,
			Proceso,
			Otros,
			Logs_de_pdf,
			Observaciones_GPS,
			Puntos_de_control,
			Estadísticas_de_los_residuos,
			Puntos_con_algún_residuo_elevado,
			Parámetros_ajustados,
			Centros_de_proyección,
			Puntos,
			Parámetros_GPS,
			Matrices_de_rotación_de_los_fotogramas,
			Muestra,
			Todos,
			Mostrar_html_al_final,
			Redundancias_parciales,
			Por_grupos,
			Por_grupos_a_posteriori,
			Covarianzas_Correlaciones,
			Cv_ccpp,
			Crr_ccpp,
			Cv_apoyo,
			Crr_apoyo,
			Valor_mínimo_puntos_comunes_modelo_erróneo,
			Mínimo_puntos_comunes_formar_modelo,
			Generación_de_pares,
			Solo_pares_principales,
			Solo_pasadas_principales,
			También_pasadas_secundarias,
			Todos_con_minimo_puntos_comunes,
			Orientación_de_las_pasadas,
			Orientar_las_pasadas_en_el_mismo_sentido,
			Transformación_de_ficheros_de_puntos,
			Fichero_de_origen,
			Fichero_a_generar,
			Transformar,
			Tarea_terminada,
			No_se_ha_podido_abrir_el_fichero_transfficheros,
			Debe_indicar_ambos_ficheros,
			La_extensión_ftm_está_reservada,
			Transformación_de_ficheros_de_ccpp,
			Opciones_del_formato,
			Sin_marcar,
			Marcado_prm,
			Marcado_pym,
			Tipo0,
			Tipo1,
			Pares_a_generar,
			Pairs_one,
			Pairs_both,
			Transformación_de_ficheros_de_camara,
			NTEXTOS,
		}

		private static readonly string[] esp,eng,it;
		private static readonly string[][] textos;

		static Textos(){
			textos=new string[(int)Idioma.NIDIOMAS][];
			esp=new string[(int)Cods.NTEXTOS];
			eng=new string[(int)Cods.NTEXTOS];
			it=new string[(int)Cods.NTEXTOS];
			setup_esp();
			setup_eng();
			setup_it();

			textos[(int)Idioma.Esp]=esp;
			textos[(int)Idioma.Eng]=eng;
			textos[(int)Idioma.It]=it;

			for(int i=0;i<(int)Idioma.NIDIOMAS;i++){
				string[] tt=textos[i];
				tt[(int)Cods.ajbloque_Debe_indicar_fotogramas]=tt[(int)Cods.relativa_Debe_indicar_fotogramas];
				tt[(int)Cods.ajbloque_Nombre_fotogramas_no_válido]=tt[(int)Cods.relativa_Nombre_fotogramas_no_válido];
				tt[(int)Cods.ajbloque_La_extensión_ftm_está_reservada]=tt[(int)Cods.relativa_La_extensión_ftm_está_reservada];
				tt[(int)Cods.ajbloque_Debe_indicar_cámara]=tt[(int)Cods.relativa_Debe_indicar_cámara];
				tt[(int)Cods.ajbloque_Nombre_cámara_no_válido]=tt[(int)Cods.relativa_Nombre_cámara_no_válido];
				tt[(int)Cods.ajbloque_Nombre_GPSINS_no_válido]=tt[(int)Cods.relativa_Nombre_GPSINS_no_válido];
				tt[(int)Cods.ajbloque_Debe_indicar_precisión_de_fotocoordenadas]=tt[(int)Cods.relativa_Debe_indicar_precisión_de_fotocoordenadas];
				tt[(int)Cods.ajbloque_Precisión_de_fotocoordenadas_no_número]=tt[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_número];
				tt[(int)Cods.ajbloque_Precisión_de_fotocoordenadas_no_cero]=tt[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_cero];
				tt[(int)Cods.ajbloque_Precisión_de_fotocoordenadas_positivo]=tt[(int)Cods.relativa_Precisión_de_fotocoordenadas_positivo];
			}
		}

		public static string get_texto(Cods cod, Idioma idioma){
			string[] t=textos[(int)idioma];
				if(t==null) t=textos[(int)Idioma.Esp];
			string s=t[(int)cod];
				if(s==null) s=textos[(int)Idioma.Esp][(int)cod];
			return s;
		}

		static void setup_esp(){
			esp[(int)Cods.Caption]="Aerotri";
			esp[(int)Cods.MsgCaption]="Aerotri";
			esp[(int)Cods.Acercade]="Acerca de Aerotri";
			esp[(int)Cods.FullTitle]="Aerotri: Ajuste de aerotriangulaciones";
			esp[(int)Cods.Manualpath]="Manuales_html\\esp\\Aerotri.htm";
			esp[(int)Cods.AbrirTrabajo]="Abrir trabajo";
			esp[(int)Cods.GuardarTrabajo]="Guardar trabajo";
			esp[(int)Cods.Guardarconfiguración]="Guardar la configuración actual como configuración por defecto...";
			esp[(int)Cods.Unidades_de_los_giros]="Unidades de los giros";
			esp[(int)Cods.Radianes]="Radianes";
			esp[(int)Cods.g_centesimales]="g. centesimales";
			esp[(int)Cods.g_sexagesimales]="g. sexagesimales";
			esp[(int)Cods.Herramientas]="Herramientas";
			esp[(int)Cods.Transformación_de_ficheros]="Transformación de ficheros";
			esp[(int)Cods.Fotogramas]="Fotogramas";
			esp[(int)Cods.Valores_aproximados_y_apoyo]="Valores aproximados y apoyo";
			esp[(int)Cods.GPS_INS_ccpp]="Centros de proyección y eventos GPS";
			esp[(int)Cods.Archivos_de_cámara]="Arcihvos de cámara";
			esp[(int)Cods.Ventana_de_comandos]="Ventana de comandos";
			esp[(int)Cods.Unión_de_modelos]="Unión de modelos";
			esp[(int)Cods.Sensor]="Sensor";
			esp[(int)Cods.Cónico]="Cónico";
			esp[(int)Cods.Modelo_local]="Modelo local";
			esp[(int)Cods.Datos_de_entrada]="Datos de entrada";
			esp[(int)Cods.Config_cálculo]="Configuración del cálculo";
			esp[(int)Cods.Ficheros_de_salida]="Ficheros de salida";
			esp[(int)Cods.Fichero_fotogramas]="Fichero de fotogramas";
			esp[(int)Cods.Fichero_valores_aproximados]="Fichero de valores aproximados";
			esp[(int)Cods.Fichero_apoyo]="Fichero de apoyo";
			esp[(int)Cods.Fichero_gps]="Fichero de GPS/INS";
			esp[(int)Cods.Fichero_cámara]="Fichero de cámara";
			esp[(int)Cods.Un_fichero]="Un fichero";
			esp[(int)Cods.Una_carpeta]="Una carpeta";
			esp[(int)Cods.Son_ya_ajustados]="Son ya valores ajustados";
			esp[(int)Cods.Precisiones]="   Precisiones ";
			esp[(int)Cods.Fotocoordenadas]="Fotocoordenadas";
			esp[(int)Cods.Apoyo]="Apoyo";
			esp[(int)Cods.Planimetría]="Planmietría";
			esp[(int)Cods.Altimetría]="Altimetría";
			esp[(int)Cods.GPS]="GPS";
			esp[(int)Cods.INS]="INS";
			esp[(int)Cods.Estimador]="Estimador";
			esp[(int)Cods.MMcc]="Mínimo cuadrático";
			esp[(int)Cods.Robusto]="Robusto";
			esp[(int)Cods.Puntos_de_apoyo]="Puntos de apoyo";
			esp[(int)Cods.Fijos]="Fijos";
			esp[(int)Cods.Variables]="Variables";
			esp[(int)Cods.Sistema_de_coordenadas]="Sistema de coordenadas";
			esp[(int)Cods.Config_valores_aproximados]="Configuración del cálculo de valores aproximados";
			esp[(int)Cods.Estimador_robusto]="Estimador robusto";
			esp[(int)Cods.Autocalibración]="Autocalibración";
			esp[(int)Cods.Tratamiento_de_las_coordenadas]="Tratamiento de las coordenadas";
			esp[(int)Cods.Fotocoordenadas_xy]="Fotocoordenadas x/y";
			esp[(int)Cods.Apoyo_XY]="Apoyo X/Y";
			esp[(int)Cods.Apoyo_PlaniZ]="Apoyo Planim./Z";
			esp[(int)Cods.Individual]="Individual";
			esp[(int)Cods.Conjunto]="Conjunto";
			esp[(int)Cods.GPS_INS]="GPS/INS";
			esp[(int)Cods.Errores_sistemáticos]="Errores sistemáticos";
			esp[(int)Cods.Offset]="Offset";
			esp[(int)Cods.No_error]="No";
			esp[(int)Cods.Constante]="Constante";
			esp[(int)Cods.Lineal]="Lineal";
			esp[(int)Cods.Calcular_fotos_intermedias]="Calcular fotogramas intermedios del fichero GPS/INS";
			esp[(int)Cods.Interpolar_residuos]="Interpolar residuos";
			esp[(int)Cods.Diferencia_INS_kappa]="En caso de diferencia entre los valores del sistema inercial y los giros de las fotografías";
			esp[(int)Cods.Cámara_girada]="La cámara estaba girada";
			esp[(int)Cods.Fotos_giradas]="Las fotografías fueron giradas a posteriori";
			esp[(int)Cods.Escala_marcas_residuos]="Escala para las marcas de los residuos";
			esp[(int)Cods.Opciones_generales]="Opciones generales";
			esp[(int)Cods.Ficheros_pdf]="Ficheros pdf";
			esp[(int)Cods.Símbolos_unidades]="Símbolos de unidades";
			esp[(int)Cods.Cifras_decimales]="Cifras decimales";
			esp[(int)Cods.Pares]="Pares";
			esp[(int)Cods.Ficheros_de_información]="Ficheros de información";
			esp[(int)Cods.Texto]="Texto";
			esp[(int)Cods.Binario]="Binario";
			esp[(int)Cods.Hoja_pdf]="Hoja resumen en pdf";
			esp[(int)Cods.Valores_ajustados]="Valores ajustados";
			esp[(int)Cods.Centros_puros]="Centros puros";
			esp[(int)Cods.Hoja_pdf_int]="Hoja pdf";
			esp[(int)Cods.Gráfico]="Gráfico";
			esp[(int)Cods.Archivo_ini]="Archivo ini";
			esp[(int)Cods.Otros_ficheros]="Otros ficheros";
			esp[(int)Cods.Residuos]="Residuos";
			esp[(int)Cods.Incrementos]="Incrementos a los valores aproximados";
			esp[(int)Cods.Residuos_elevados]="Residuos elevados";
			esp[(int)Cods.Estadísticas]="Estadísticas";
			esp[(int)Cods.Ficheros_log]="Ficheros log";
			esp[(int)Cods.Gráfico_de_residuos]="Gráfico de residuos";
			esp[(int)Cods.Sólo_valores_aproximados]="Sólo valores aproximados";
			esp[(int)Cods.Ajuste_completo]="Ajuste completo";
			esp[(int)Cods.Calcular]="Calcular";

			esp[(int)Cods.Cálculo_terminado]="Cálculo terminado"; //20
			esp[(int)Cods.Calculando_valores_aproximados]="Calculando valores aproximados";
			esp[(int)Cods.Realizando_el_ajuste_del_bloque]="Realizando el ajuste del bloque";
			esp[(int)Cods.Esperando_a_que_termine_el_cálculo]="Esperando a que termine el cálculo";
			esp[(int)Cods.Leyendo_el_fichero_de_trabajo]="Leyendo el fichero de trabajo";
			esp[(int)Cods.Escribiendo_el_fichero_de_trabajo]="Escribiendo el fichero de trabajo";
			esp[(int)Cods.Escribiendo_el_fichero_de_configuración]="Escribiendo el fichero de configuración";
			esp[(int)Cods.De_esta_manera_la_configuración]="De esta manera la configuración actual será la que tenga el programa al abrirse.";
			esp[(int)Cods.Fichero_de_valores_aproximados]="Fichero de valores aproximados";
			esp[(int)Cods.Fichero_de_modelo_local]="Fichero de modelo local";
			esp[(int)Cods.No_se_ha_podido_abrir_ajbloque]="No se ha podido abrir el fichero ajbloque.dll";
			esp[(int)Cods.Desea_continuar_con_el_ajuste]="¿Desea continuar con el ajuste?"; //31
			esp[(int)Cods.Error_en_valores_aproximados]="Error en el cálculo de valores aproximados: ";
			esp[(int)Cods.Mirar_el_fichero_de_proceso]="Mirar el final del fichero de proceso (.pro)";
			esp[(int)Cods.para_posibles_puntos_erróneos]=", para la información sobre posibles puntos erróneos.";
			esp[(int)Cods.Si_desea_continuar]="Si desea continuar e intentar el ajuste del bloque, debe pulsar otra vez el botón de calcular";
			esp[(int)Cods.Debe_indicar_modelo_local]="Debe indicar un fichero de modelo local";
			esp[(int)Cods.Debe_indicar_apoyo]="Debe indicar un fichero de apoyo";
			esp[(int)Cods.Desea_calcular_en_sistema_arbitrario]="¿Desea calcular de todas formas en un sistema de coordenadas arbitrario (los puntos de apoyo y datos GPS existentes se respetarán)?";
			esp[(int)Cods.Error_en_la_escritura_del_fichero_de_trabajo]="Error en la escritura del fichero de trabajo.";
			esp[(int)Cods.No_se_pudo_abrir_para_escribirlo]="No se pudo abrir el fichero para escribirlo";
			esp[(int)Cods.El_fichero_no_se_escribió_correctamente]="El fichero no se escribió correctamente";
			esp[(int)Cods.PREPARA_RELATIVA_BASE]="";
			esp[(int)Cods.relativa_Debe_indicar_fotogramas]="Debe indicar algún fichero de fotogramas";
			esp[(int)Cods.relativa_Nombre_fotogramas_no_válido]="El nombre indicado para el fichero de fotogramas contiene caracteres no válidos";
			esp[(int)Cods.relativa_La_extensión_ftm_está_reservada]="Error en el nombre del fichero de fotogramas: La extensión ftm está reservada a ficheros de Aerotri";
			esp[(int)Cods.relativa_Debe_indicar_cámara]="Debe indicar un fichero de cámara";
			esp[(int)Cods.relativa_Nombre_cámara_no_válido]="El nombre indicado para el fichero de cámara contiene caracteres no válidos";
			esp[(int)Cods.relativa_Nombre_GPSINS_no_válido]="El nombre indicado para el fichero de GPS/INS contiene caracteres no válidos";
			esp[(int)Cods.relativa_Debe_indicar_precisión_de_fotocoordenadas]="Debe indicar un valor para la precisión de las fotocoordenadas"; //9
			esp[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_número]="El texto escrito para la precisión de las fotocoordenadas no es un número";
			esp[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_cero]="El valor de precisión de las fotocoordenadas no puede ser cero";
			esp[(int)Cods.relativa_Precisión_de_fotocoordenadas_positivo]="El valor de precisión de las fotocoordenadas tiene que ser positivo";
			esp[(int)Cods.PREPARA_ABSOLUTA_BASE]="";
			esp[(int)Cods.ajbloque_Debe_indicar_valores_aproximados]="Debe indicar un fichero de valores aproximados"; //7
			esp[(int)Cods.ajbloque_Nombre_valores_aproximados_no_válido]="El nombre indicado para el fichero de valores aproximados contiene caracteres no válidos";
			esp[(int)Cods.ajbloque_Nombre_apoyo_no_válido]="El nombre indicado para el fichero de apoyo contiene caracteres no válidos"; //10
			esp[(int)Cods.ajbloque_Debe_indicar_precisión_apoyo_plani]="Debe indicar un valor para la precisión planimétrica del apoyo"; //18
			esp[(int)Cods.ajbloque_Precisión_de_apoyo_plani_no_número]="El texto escrito para la precisión planimétrica del apoyo no es un número";
			esp[(int)Cods.ajbloque_Precisión_de_apoyo_plani_no_cero]="El valor de precisión planimétrica del apoyo no puede ser cero";
			esp[(int)Cods.ajbloque_Precisión_de_apoyo_plani_positivo]="El valor de precisión planimétrica del apoyo tiene que ser positivo";
			esp[(int)Cods.ajbloque_Debe_indicar_precisión_apoyo_alti]="Debe indicar un valor para la precisión altimétrica del apoyo";
			esp[(int)Cods.ajbloque_Precisión_de_apoyo_alti_no_número]="El texto escrito para la precisión altimétrica del apoyo no es un número"; //23
			esp[(int)Cods.ajbloque_Precisión_de_apoyo_alti_no_cero]="El valor de precisión altimétrica del apoyo no puede ser cero";
			esp[(int)Cods.ajbloque_Precisión_de_apoyo_alti_positivo]="El valor de precisión altimétrica del apoyo tiene que ser positivo";
			esp[(int)Cods.ajbloque_Debe_indicar_precisión_GPS_plani]="Debe indicar un valor para la precisión planimétrica del GPS";
			esp[(int)Cods.ajbloque_Precisión_de_GPS_plani_no_número]="El texto escrito para la precisión planimétrica del GPS no es un número";
			esp[(int)Cods.ajbloque_Precisión_de_GPS_plani_no_cero]="El valor de precisión planimétrica del GPS no puede ser cero";
			esp[(int)Cods.ajbloque_Precisión_de_GPS_plani_positivo]="El valor de precisión planimétrica del GPS tiene que ser positivo";
			esp[(int)Cods.ajbloque_Debe_indicar_precisión_GPS_alti]="Debe indicar un valor para la precisión altimétrica del GPS"; //30
			esp[(int)Cods.ajbloque_Precisión_de_GPS_alti_no_número]="El texto escrito para la precisión altimétrica del GPS no es un número";
			esp[(int)Cods.ajbloque_Precisión_de_GPS_alti_no_cero]="El valor de precisión altimétrica del GPS no puede ser cero";
			esp[(int)Cods.ajbloque_Precisión_de_GPS_alti_positivo]="El valor de precisión altimétrica del GPS tiene que ser positivo";
			esp[(int)Cods.ajbloque_Debe_indicar_precisión_INS_ΩΦ]="Debe indicar un valor para la precisión Ω y Φ del INS";
			esp[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_no_número]="El texto escrito para la precisión Ω y Φ del INS no es un número";
			esp[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_no_cero]="El valor de precisión Ω y Φ del INS no puede ser cero";
			esp[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_positivo]="El valor de precisión Ω y Φ del INS tiene que ser positivo"; //37
			esp[(int)Cods.ajbloque_Debe_indicar_precisión_INS_Kappa]="Debe indicar un valor para la precisión Kappa del INS";
			esp[(int)Cods.ajbloque_Precisión_de_INS_Kappa_no_número]="El texto escrito para la precisión Kappa del INS no es un número";
			esp[(int)Cods.ajbloque_Precisión_de_INS_Kappa_no_cero]="El valor de precisión Kappa del INS no puede ser cero";
			esp[(int)Cods.ajbloque_Precisión_de_INS_Kappa_positivo]="El valor de precisión Kappa del INS tiene que ser positivo"; //41
			esp[(int)Cods.Valor_de_ondulación_del_geoide_erróneo]="Valor de ondulación del geoide erróneo";
			esp[(int)Cods.Parámetros_a_calcular]="Parametros a calcular";
			esp[(int)Cods.Focal]="Focal";
			esp[(int)Cods.Punto_principal]="Punto principal";
			esp[(int)Cods.Modelo_polinómico]="Modelo polinómico";
			esp[(int)Cods.Impar]="Impar";
			esp[(int)Cods.Completo]="Completo";
			esp[(int)Cods.Radial_tangencial]="Radial / tangencial";
			esp[(int)Cods.Vector_giratorio]="Vector giratorio";
			esp[(int)Cods.Función_de_distorsión]="Función de distorsión";
			esp[(int)Cods.Radial_simétrica]="Radial simétrica";
			esp[(int)Cods.Tangencial_sim]="Tangencial sim.";
			esp[(int)Cods.Asimétricas]="Asimétricas";
			esp[(int)Cods.Radial]="Radial";
			esp[(int)Cods.Tangencial]="Tangencial";
			esp[(int)Cods.Serie1]="Serie 1";
			esp[(int)Cods.Serie2]="Serie 2";
			esp[(int)Cods.Errores_sistemáticos_GPS]="Errores sistemáticos del GPS e INS";
			esp[(int)Cods.Sin_errores_0]="Sin errores (Tipo 0)";
			esp[(int)Cods.Permanente_Offset]="Permantente (Offset)";
			esp[(int)Cods.Constante_1]="Constante (Tipo 1)";
			esp[(int)Cods.Lineal_2]="Lineal (Tipo 2)";
			esp[(int)Cods.Valor_mínimo_puntos_comunes_erróneo]="Valor del mínimo número de puntos en común\npara la orientación de dos fotogrmas erróneo";
			esp[(int)Cods.Valor_parámetro_camino_erróneo]="Valor del parmámetro de camino erróneo";
			esp[(int)Cods.Tipo_de_ajuste]="Tipo de ajuste";
			esp[(int)Cods.Fuerza_mmcc]="Fuerza mm.cc. puro";
			esp[(int)Cods.Valores_aproximados]="Valores aproximados";
			esp[(int)Cods.Minimo_número_puntos_comunes]="Mínimo nº de puntos en común para orientar dos fotogramas";
			esp[(int)Cods.Deduce_automáticamente]="Deduce automáticamente";
			esp[(int)Cods.El_siguiente_valor]="El siguiente valor";
			esp[(int)Cods.Parámetro_de_camino]="Parámetro de camino";
			esp[(int)Cods.Uso_de_GPS]="Uso de las coordenadas GPS e INS";
			esp[(int)Cods.No_emplear]="No emplear";
			esp[(int)Cods.Emplear_si_todos]="Emplear si están todos";
			esp[(int)Cods.Para_los_ficheros_de_entrada]="Para los ficheros de entrada";
			esp[(int)Cods.Guardar_ruta_relativa]="Guardar la ruta relativa";
			esp[(int)Cods.Guardar_ruta_absoluta]="Guardar la ruta absoluta";
			esp[(int)Cods.Valor_decimales_fotocoordenadas_erróneo]="Valor erróneo para el número de cifas decimales de las fotocoordenadas";
			esp[(int)Cods.Valor_decimales_puntos_erróneo]="Valor erróneo para el número de cifas decimales de los puntos";
			esp[(int)Cods.Valor_decimales_GPS_erróneo]="Valor erróneo para el número de cifas decimales del GPS";
			esp[(int)Cods.Valor_decimales_INS_erróneo]="Valor erróneo para el número de cifas decimales del INS";
			esp[(int)Cods.Escritura_de_los_residuos]="Escritura de los residuos";
			esp[(int)Cods.dos_cifras_significativas]="2 cifras significativas";
			esp[(int)Cods.Número_de_decimales_fijo]="Número de decimales fijo";
			esp[(int)Cods.Deducir]="Deducir";
			esp[(int)Cods.Este_valor]="Este valor";
			esp[(int)Cods.Fotocoordenadas_breve]="Fotocoordenadas";
			esp[(int)Cods.Matrices_de_rotación]="Matrices de rotación";
			esp[(int)Cods.Ficheros_Digi1]="Ficheros .rel, .abs y .abs2";
			esp[(int)Cods.Ficheros_Digi2]="Ficheros .f y .mod";
			esp[(int)Cods.Directorio_de_generación_relativo_a_fotos]="Directorio de generación, relativo al fichero de fotogramas";
			esp[(int)Cods.Ficheros_IMaster1]="Ficheros .ext, .pairlist y .rel";
			esp[(int)Cods.Ficheros_IMaster2]="Ficheros .imc";
			esp[(int)Cods.Igual_que_el_idioma_del_programa]="Igual que el idioma del programa";
			esp[(int)Cods.Otro]="Otro";
			esp[(int)Cods.Log_del_ajuste]="Log del ajuste";
			esp[(int)Cods.Log_básico]="Log básico";
			esp[(int)Cods.Lectura_y_escritura_de_ficheros]="Lectura y escritura de ficheros";
			esp[(int)Cods.Proceso]="Proceso";
			esp[(int)Cods.Otros]="Otros";
			esp[(int)Cods.Logs_de_pdf]="Logs de la generación de los pdf";
			esp[(int)Cods.Observaciones_GPS]="Observaciones GPS/INS";
			esp[(int)Cods.Puntos_de_control]="Puntos de control";
			esp[(int)Cods.Estadísticas_de_los_residuos]="Estadísticas de los residuos";
			esp[(int)Cods.Puntos_con_algún_residuo_elevado]="Puntos con algún residuo elevado";
			esp[(int)Cods.Parámetros_ajustados]="Parámetros ajustados";
			esp[(int)Cods.Centros_de_proyección]="Centros de proyección";
			esp[(int)Cods.Puntos]="Puntos";
			esp[(int)Cods.Parámetros_GPS]="Parámetros GPS/INS";
			esp[(int)Cods.Matrices_de_rotación_de_los_fotogramas]="Matrices de rotación de los fotogramas";
			esp[(int)Cods.Muestra]="Muestra";
			esp[(int)Cods.Todos]="Todos";
			esp[(int)Cods.Mostrar_html_al_final]="Mostrar automáticamente html al terminar el cálculo";
			esp[(int)Cods.Redundancias_parciales]="Redundancias parciales";
			esp[(int)Cods.Por_grupos]="Por grupos";
			esp[(int)Cods.Por_grupos_a_posteriori]="Por grupos, a posteriori";
			esp[(int)Cods.Covarianzas_Correlaciones]="Covarianzas (Cv.) / Correlaciones (Crr.)";
			esp[(int)Cods.Cv_ccpp]="Cv. de los centros de proyección";
			esp[(int)Cods.Crr_ccpp]="Crr. de los centros de proyección";
			esp[(int)Cods.Cv_apoyo]="Cv. de los puntos de apoyo";
			esp[(int)Cods.Crr_apoyo]="Crr. de los puntos de apoyo";
			esp[(int)Cods.Valor_mínimo_puntos_comunes_modelo_erróneo]="Valor erróneo para el mínimo número de puntos en común para formar modelo";
			esp[(int)Cods.Mínimo_puntos_comunes_formar_modelo]="Mínimo número de puntos en común para formar modelo";
			esp[(int)Cods.Generación_de_pares]="Generación de pares";
			esp[(int)Cods.Solo_pares_principales]="Solo pares principales";
			esp[(int)Cods.Solo_pasadas_principales]="Solo pasadas principales";
			esp[(int)Cods.También_pasadas_secundarias]="También pares de las pasadas secundarias";
			esp[(int)Cods.Todos_con_minimo_puntos_comunes]="Todos con el mínimo nº. de puntos en común";
			esp[(int)Cods.Orientación_de_las_pasadas]="Orientación de las pasadas";
			esp[(int)Cods.Orientar_las_pasadas_en_el_mismo_sentido]="Orientar las pasadas en el mismo sentido";
			esp[(int)Cods.Transformación_de_ficheros_de_puntos]="Transformación de ficheros de fotogramas";
			esp[(int)Cods.Fichero_de_origen]="Fichero de origen";
			esp[(int)Cods.Fichero_a_generar]="Fichero a generar";
			esp[(int)Cods.Transformar]="Transformar";
			esp[(int)Cods.Tarea_terminada]="Tarea terminada";
			esp[(int)Cods.No_se_ha_podido_abrir_el_fichero_transfficheros]="No se ha podido abrir el fichero transfficheros.dll";
			esp[(int)Cods.Debe_indicar_ambos_ficheros]="Debe indicar ambos ficheros";
			esp[(int)Cods.La_extensión_ftm_está_reservada]="La extensión ftm está reservada a ficheros marcados";
			esp[(int)Cods.Transformación_de_ficheros_de_puntos]="Transformación de ficheros de puntos";
			esp[(int)Cods.Transformación_de_ficheros_de_ccpp]="Transformación de ficheros de cc.pp. y eventos GPS";
			esp[(int)Cods.Opciones_del_formato]="Opciones del formato";
			esp[(int)Cods.Sin_marcar]="Sin marcar";
			esp[(int)Cods.Marcado_prm]="Marcado prm";
			esp[(int)Cods.Marcado_pym]="Marcado pym";
			esp[(int)Cods.Tipo0]="Tipo 0";
			esp[(int)Cods.Tipo1]="Tipo 1";
			esp[(int)Cods.Pares_a_generar]="Pares a generar";
			esp[(int)Cods.Pairs_one]="Solamente 1ª-2ª";
			esp[(int)Cods.Pairs_both]="Ambos: 1ª-2ª y 2ª-1ª";
			esp[(int)Cods.Transformación_de_ficheros_de_camara]="Transformación de ficheros de cámara";
		}
		static void setup_eng(){
			eng[(int)Cods.Caption]="Aerotri";
			eng[(int)Cods.MsgCaption]="Aerotri";
			eng[(int)Cods.Acercade]="About Aerotri";
			eng[(int)Cods.FullTitle]="Aerotri: Aerotriangulacion Adjustment";
			eng[(int)Cods.Manualpath]="Manuales_html\\eng\\Aerotri_eng.htm";
			eng[(int)Cods.AbrirTrabajo]="Open work";
			eng[(int)Cods.GuardarTrabajo]="Save work";
			eng[(int)Cods.Guardarconfiguración]="Save current configuration as default...";
			eng[(int)Cods.Unidades_de_los_giros]="Angle units";
			eng[(int)Cods.Radianes]="Radians";
			eng[(int)Cods.g_centesimales]="Centesimal d.";
			eng[(int)Cods.g_sexagesimales]="Sexagesimal d.";
			eng[(int)Cods.Herramientas]="Tools";
			eng[(int)Cods.Transformación_de_ficheros]="File transformation";
			eng[(int)Cods.Fotogramas]="Photographs";
			eng[(int)Cods.Valores_aproximados_y_apoyo]="Approximate values and control";
			eng[(int)Cods.GPS_INS_ccpp]="Projection centers and GPS events";
			eng[(int)Cods.Archivos_de_cámara]="Camera files";
			eng[(int)Cods.Ventana_de_comandos]="Command Window";
			eng[(int)Cods.Unión_de_modelos]="Joining models";
			eng[(int)Cods.Sensor]="Sensor";
			eng[(int)Cods.Cónico]="Conic";
			eng[(int)Cods.Modelo_local]="Local model";
			eng[(int)Cods.Datos_de_entrada]="Input data";
			eng[(int)Cods.Config_cálculo]="Adjustment configuration";
			eng[(int)Cods.Ficheros_de_salida]="Output files";
			eng[(int)Cods.Fichero_fotogramas]="Photographs file";
			eng[(int)Cods.Fichero_valores_aproximados]="Approximate values file";
			eng[(int)Cods.Fichero_apoyo]="Control file";
			eng[(int)Cods.Fichero_gps]="GPS/INS file";
			eng[(int)Cods.Fichero_cámara]="Camera file";
			eng[(int)Cods.Un_fichero]="A file";
			eng[(int)Cods.Una_carpeta]="A folder";
			eng[(int)Cods.Son_ya_ajustados]="These are adjusted values";
			eng[(int)Cods.Precisiones]="   Precisions ";
			eng[(int)Cods.Fotocoordenadas]="Photo coordinates";
			eng[(int)Cods.Apoyo]="Control points";
			eng[(int)Cods.Planimetría]="Planimetric";
			eng[(int)Cods.Altimetría]="Altimetric";
			eng[(int)Cods.GPS]="GPS";
			eng[(int)Cods.INS]="INS";
			eng[(int)Cods.Estimador]="Estimator";
			eng[(int)Cods.MMcc]="Least squares";
			eng[(int)Cods.Robusto]="Robust";
			eng[(int)Cods.Puntos_de_apoyo]= "Control";
			eng[(int)Cods.Fijos]="Fixed";
			eng[(int)Cods.Variables]="Variable";
			eng[(int)Cods.Sistema_de_coordenadas]="Coordinate system";
			eng[(int)Cods.Config_valores_aproximados]="Config. of the computation of approximate values";
			eng[(int)Cods.Estimador_robusto]="Robust estimator";
			eng[(int)Cods.Autocalibración]="Self calibration";
			eng[(int)Cods.Tratamiento_de_las_coordenadas]="Handling of the coordinates";
			eng[(int)Cods.Fotocoordenadas_xy]="Photo coordinates x/y";
			eng[(int)Cods.Apoyo_XY]="Control X/Y";
			eng[(int)Cods.Apoyo_PlaniZ]="Control Planim./Z";
			eng[(int)Cods.Individual]="Individual";
			eng[(int)Cods.Conjunto]="Together";
			eng[(int)Cods.GPS_INS]="GPS/INS";
			eng[(int)Cods.Errores_sistemáticos]="Systematic errors";
			eng[(int)Cods.Offset]="Offset";
			eng[(int)Cods.No_error]="No";
			eng[(int)Cods.Constante]="Constant";
			eng[(int)Cods.Lineal]="Linear";
			eng[(int)Cods.Calcular_fotos_intermedias]="Calculate intermediate photographs from GPS/INS file";
			eng[(int)Cods.Interpolar_residuos]="Interpolate residuals";
			eng[(int)Cods.Diferencia_INS_kappa]="In case of difference between the inertial system values and the photographs' rotations";
			eng[(int)Cods.Cámara_girada]="The camera was actually rotated";
			eng[(int)Cods.Fotos_giradas]="The images were rotated afterwards";
			eng[(int)Cods.Escala_marcas_residuos]="Scale for the residual marks";
			eng[(int)Cods.Opciones_generales]="General settings";
			eng[(int)Cods.Ficheros_pdf]="Pdf files";
			eng[(int)Cods.Símbolos_unidades]="unit symbols";
			eng[(int)Cods.Cifras_decimales]="Decimal digits";
			eng[(int)Cods.Pares]="Pairs";
			eng[(int)Cods.Ficheros_de_información]="Information files";
			eng[(int)Cods.Texto]="Text";
			eng[(int)Cods.Binario]="Binary";
			eng[(int)Cods.Hoja_pdf]="Pdf report sheet";
			eng[(int)Cods.Valores_ajustados]="Adjusted values";
			eng[(int)Cods.Centros_puros]="Naked centers";
			eng[(int)Cods.Hoja_pdf_int]="Pdf sheet";
			eng[(int)Cods.Gráfico]="Graphic";
			eng[(int)Cods.Archivo_ini]="Ini files";
			eng[(int)Cods.Otros_ficheros]="Other files";
			eng[(int)Cods.Residuos]="Residuals";
			eng[(int)Cods.Incrementos]="Increments to the approximate values";
			eng[(int)Cods.Residuos_elevados]="High residuals";
			eng[(int)Cods.Estadísticas]="Statistics";
			eng[(int)Cods.Ficheros_log]="Log files";
			eng[(int)Cods.Gráfico_de_residuos]="Residuals plot";
			eng[(int)Cods.Sólo_valores_aproximados]="Approximate values only";
			eng[(int)Cods.Ajuste_completo]="Complete adjustment";
			eng[(int)Cods.Calcular]="Calculate";

			eng[(int)Cods.Cálculo_terminado]="Calculation finished";
			eng[(int)Cods.Calculando_valores_aproximados]="Computing approximate values";
			eng[(int)Cods.Realizando_el_ajuste_del_bloque]="Carrying out block adjustment";
			eng[(int)Cods.Esperando_a_que_termine_el_cálculo]="Waiting for the end the computation";
			eng[(int)Cods.Leyendo_el_fichero_de_trabajo]="Reading the Aerotri work file";
			eng[(int)Cods.Escribiendo_el_fichero_de_trabajo]="Writting the Aerotri work file";
			eng[(int)Cods.Escribiendo_el_fichero_de_configuración]="Writing the configuration file";
			eng[(int)Cods.De_esta_manera_la_configuración]="The current configuration will become the configuration every time the program starts.";
			eng[(int)Cods.Fichero_de_valores_aproximados]="Approximate values file";
			eng[(int)Cods.Fichero_de_modelo_local]="Local model file";
			eng[(int)Cods.No_se_ha_podido_abrir_ajbloque]="The file ajbloque.dll couldn't be opened";
			eng[(int)Cods.Desea_continuar_con_el_ajuste]="Would you like to continue the adjustment?";
			eng[(int)Cods.Error_en_valores_aproximados]="Error computing approximate values: ";
			eng[(int)Cods.Mirar_el_fichero_de_proceso]="Look at the end of the process file (.pro)";
			eng[(int)Cods.para_posibles_puntos_erróneos]=", for information about possible wrong points.";
			eng[(int)Cods.Si_desea_continuar]="If you want to carry on and try to adjust the block, you will need to press the calculate button again";
			eng[(int)Cods.Debe_indicar_modelo_local]="A local model file has to be specified";
			eng[(int)Cods.Debe_indicar_apoyo]="A control file has to be specified";
			eng[(int)Cods.Desea_calcular_en_sistema_arbitrario]="Would you like the adjutment to take place nonetheless, in an arbitrary coordinate system (existing control points and GPS data will be respected)?";
			eng[(int)Cods.Error_en_la_escritura_del_fichero_de_trabajo]="Error when writing the work file.";
			eng[(int)Cods.No_se_pudo_abrir_para_escribirlo]="The file could not be opened for writting";
			eng[(int)Cods.El_fichero_no_se_escribió_correctamente]="The file could not be written properly";
			eng[(int)Cods.PREPARA_RELATIVA_BASE]="";
			eng[(int)Cods.relativa_Debe_indicar_fotogramas]="A photographs file has to be specified";
			eng[(int)Cods.relativa_Nombre_fotogramas_no_válido]="The name given for the photographs file includes invalid characters";
			eng[(int)Cods.relativa_La_extensión_ftm_está_reservada]="Error in the photographs file name: The extension ftm can only be used with Aerotri files";
			eng[(int)Cods.relativa_Debe_indicar_cámara]="An camera file has to be specified";
			eng[(int)Cods.relativa_Nombre_cámara_no_válido]="The name given for the camera file includes invalid characters";
			eng[(int)Cods.relativa_Nombre_GPSINS_no_válido]="The name given for the GPS/INS file includes invalid characters";
			eng[(int)Cods.relativa_Debe_indicar_precisión_de_fotocoordenadas]="A value for the photo coordinates precision must be specified";
			eng[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_número]="The text written for the photo coordinates precision is not a number";
			eng[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_cero]="The photo coordinates precision value cannot be zero";
			eng[(int)Cods.relativa_Precisión_de_fotocoordenadas_positivo]="The photo coordinages precision value must be a positive number";
			eng[(int)Cods.PREPARA_ABSOLUTA_BASE]="";
			eng[(int)Cods.ajbloque_Debe_indicar_valores_aproximados]="An approximate values file has to be specified";
			eng[(int)Cods.ajbloque_Nombre_valores_aproximados_no_válido]="The name given for the approximate values file includes invalid characters";
			eng[(int)Cods.ajbloque_Nombre_apoyo_no_válido]="The name given for the control file includes invalid characters";
			eng[(int)Cods.ajbloque_Debe_indicar_precisión_apoyo_plani]="A value for the planimetric control point precision must be specified";
			eng[(int)Cods.ajbloque_Precisión_de_apoyo_plani_no_número]="The text written for the planimetric control point precision is not a number";
			eng[(int)Cods.ajbloque_Precisión_de_apoyo_plani_no_cero]="The planimetric control point precision value cannot be zero";
			eng[(int)Cods.ajbloque_Precisión_de_apoyo_plani_positivo]="The planimetric control point precision value must be a positive number";
			eng[(int)Cods.ajbloque_Debe_indicar_precisión_apoyo_alti]="A value for the altimetric control point precision must be specified";
			eng[(int)Cods.ajbloque_Precisión_de_apoyo_alti_no_número]="The text written for the altimetric control point precision is not a number";
			eng[(int)Cods.ajbloque_Precisión_de_apoyo_alti_no_cero]="The altimetric control point precision value cannot be zero";
			eng[(int)Cods.ajbloque_Precisión_de_apoyo_alti_positivo]="The altimetric control point precision value must be a positive number";
			eng[(int)Cods.ajbloque_Debe_indicar_precisión_GPS_plani]="A value for the planimetric GPS precision must be specified";
			eng[(int)Cods.ajbloque_Precisión_de_GPS_plani_no_número]="The text written for the planimetric GPS precision is not a number";
			eng[(int)Cods.ajbloque_Precisión_de_GPS_plani_no_cero]="The planimetric GPS precision value cannot be zero";
			eng[(int)Cods.ajbloque_Precisión_de_GPS_plani_positivo]="The planimetric GPS precision value must be a positive number";
			eng[(int)Cods.ajbloque_Debe_indicar_precisión_GPS_alti]="A value for the altimetric GPS precision must be specified";
			eng[(int)Cods.ajbloque_Precisión_de_GPS_alti_no_número]="The text written for the altimetric GPS precision is not a number";
			eng[(int)Cods.ajbloque_Precisión_de_GPS_alti_no_cero]="The altimetric GPS precision value cannot be zero";
			eng[(int)Cods.ajbloque_Precisión_de_GPS_alti_positivo]="The altimetric GPS precision value must be a positive number";
			eng[(int)Cods.ajbloque_Debe_indicar_precisión_INS_ΩΦ]="A value for the INS Ω and Φ precision must be specified";
			eng[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_no_número]="The text written for the INS Ω and Φ precision is not a number";
			eng[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_no_cero]="The INS Ω and Φ precision value cannot be zero";
			eng[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_positivo]="The INS Ω and Φ precision value must be a positive number";
			eng[(int)Cods.ajbloque_Debe_indicar_precisión_INS_Kappa]="A value for the INS Kappa precision must be specified";
			eng[(int)Cods.ajbloque_Precisión_de_INS_Kappa_no_número]="The text written for the INS Kappa precision is not a number";
			eng[(int)Cods.ajbloque_Precisión_de_INS_Kappa_no_cero]="The INS Kappa precision value cannot be zero";
			eng[(int)Cods.ajbloque_Precisión_de_INS_Kappa_positivo]="The INS Kappa precision value must be a positive number";
			eng[(int)Cods.Valor_de_ondulación_del_geoide_erróneo]="Wrong value for the geoid ondulation";
			eng[(int)Cods.Parámetros_a_calcular]="Parameter settings";
			eng[(int)Cods.Focal]="Focal length";
			eng[(int)Cods.Punto_principal]="Principal point";
			eng[(int)Cods.Modelo_polinómico]="Polynomial model";
			eng[(int)Cods.Impar]="Odd";
			eng[(int)Cods.Completo]="Complete";
			eng[(int)Cods.Radial_tangencial]="Radial / tangential";
			eng[(int)Cods.Vector_giratorio]="Rotating vector";
			eng[(int)Cods.Función_de_distorsión]="Function of distortion";
			eng[(int)Cods.Radial_simétrica]="Radial, symmetric";
			eng[(int)Cods.Tangencial_sim]="Tangential, sym.";
			eng[(int)Cods.Asimétricas]="Asymmetric";
			eng[(int)Cods.Radial]="Radial";
			eng[(int)Cods.Tangencial]="Tangential";
			eng[(int)Cods.Serie1]="Series 1";
			eng[(int)Cods.Serie2]="Series 2";
			eng[(int)Cods.Errores_sistemáticos_GPS]="Systematic errors of GPS and INS";
			eng[(int)Cods.Sin_errores_0]="Error free (Type 0)";
			eng[(int)Cods.Permanente_Offset]="Permanent (Offset)";
			eng[(int)Cods.Constante_1]="Constant (Type 1)";
			eng[(int)Cods.Lineal_2]="Linear (Type 2)";
			eng[(int)Cods.Valor_mínimo_puntos_comunes_erróneo]="Wrong value for the minimum number of common\npoints to orientate two photographs";
			eng[(int)Cods.Valor_parámetro_camino_erróneo]="Wrong value for the path parameter";
			eng[(int)Cods.Tipo_de_ajuste]="Type of adjustment";
			eng[(int)Cods.Fuerza_mmcc]="Force plain least sq.";
			eng[(int)Cods.Valores_aproximados]="Approximate values";
			eng[(int)Cods.Minimo_número_puntos_comunes]="Minimum nº of common points to orientate two photographs";
			eng[(int)Cods.Deduce_automáticamente]="Automatically guess";
			eng[(int)Cods.El_siguiente_valor]="This value";
			eng[(int)Cods.Parámetro_de_camino]="Path parameter";
			eng[(int)Cods.Uso_de_GPS]="Usage of GPS and INS data";
			eng[(int)Cods.No_emplear]="Do not use";
			eng[(int)Cods.Emplear_si_todos]="Use if all are present";
			eng[(int)Cods.Para_los_ficheros_de_entrada]="For the input files";
			eng[(int)Cods.Guardar_ruta_relativa]="Save relative path";
			eng[(int)Cods.Guardar_ruta_absoluta]="Save absolute path";
			eng[(int)Cods.Valor_decimales_fotocoordenadas_erróneo]="Wrong value for the number of decimal figures for photo coordinates";
			eng[(int)Cods.Valor_decimales_puntos_erróneo]="Wrong value for the number of decimal figures for points";
			eng[(int)Cods.Valor_decimales_GPS_erróneo]="Wrong value for the number of decimal figures for the GPS";
			eng[(int)Cods.Valor_decimales_INS_erróneo]="Wrong value for the number of decimal figures for the INS";
			eng[(int)Cods.Escritura_de_los_residuos]="Displaying of residuals";
			eng[(int)Cods.dos_cifras_significativas]="2 significant digits";
			eng[(int)Cods.Número_de_decimales_fijo]="A fixed number of decimal places";
			eng[(int)Cods.Deducir]="Guess";
			eng[(int)Cods.Este_valor]="This value";
			eng[(int)Cods.Matrices_de_rotación]="Rotation matrices";
			eng[(int)Cods.Fotocoordenadas_breve]="Photo coord.";
			eng[(int)Cods.Ficheros_Digi1]="Files .rel, .abs and .abs2";
			eng[(int)Cods.Ficheros_Digi2]="Files .f and .mod";
			eng[(int)Cods.Directorio_de_generación_relativo_a_fotos]="Directory where to place the files, relative to the photographs file";
			eng[(int)Cods.Ficheros_IMaster1]="Files .ext, .pairlist and .rel";
			eng[(int)Cods.Ficheros_IMaster2]="Files .imc";
			eng[(int)Cods.Igual_que_el_idioma_del_programa]="Same as program language";
			eng[(int)Cods.Otro]="Other";
			eng[(int)Cods.Log_del_ajuste]="Log of the adjustment";
			eng[(int)Cods.Log_básico]="Basic log";
			eng[(int)Cods.Lectura_y_escritura_de_ficheros]="File reading and writting";
			eng[(int)Cods.Proceso]="Process";
			eng[(int)Cods.Otros]="Others";
			eng[(int)Cods.Logs_de_pdf]="Logs of the pdf's generation";
			eng[(int)Cods.Observaciones_GPS]="GPS/INS observations";
			eng[(int)Cods.Puntos_de_control]="Check points";
			eng[(int)Cods.Estadísticas_de_los_residuos]="Statistics of the residuals";
			eng[(int)Cods.Puntos_con_algún_residuo_elevado]="Points with high residuals";
			eng[(int)Cods.Parámetros_ajustados]="Adjusted parametres";
			eng[(int)Cods.Centros_de_proyección]="Projection centres";
			eng[(int)Cods.Puntos]="Points";
			eng[(int)Cods.Parámetros_GPS]="GPS/INS parametres";
			eng[(int)Cods.Matrices_de_rotación_de_los_fotogramas]="Rotation matrices of the photographs";
			eng[(int)Cods.Muestra]="Sample";
			eng[(int)Cods.Todos]="All";
			eng[(int)Cods.Mostrar_html_al_final]="Automatically show html when finished the calculation";
			eng[(int)Cods.Redundancias_parciales]="Partial redundancies";
			eng[(int)Cods.Por_grupos]="Groups";
			eng[(int)Cods.Por_grupos_a_posteriori]="Groups, a posteriori";
			eng[(int)Cods.Covarianzas_Correlaciones]="Covariances (Cv.) / Correlations (Crr.)";
			eng[(int)Cods.Cv_ccpp]="Cv. of the projection centres";
			eng[(int)Cods.Crr_ccpp]="Crr. of the projection centres";
			eng[(int)Cods.Cv_apoyo]="Cv. of control points";
			eng[(int)Cods.Crr_apoyo]="Crr. of control points";
			eng[(int)Cods.Valor_mínimo_puntos_comunes_modelo_erróneo]="Wrong value for the minimum number of common points in order to form a model";
			eng[(int)Cods.Mínimo_puntos_comunes_formar_modelo]="Least number of common points in order to form a model";
			eng[(int)Cods.Generación_de_pares]="Pair generation";
			eng[(int)Cods.Solo_pares_principales]="Only the main pairs";
			eng[(int)Cods.Solo_pasadas_principales]="Only the main strips";
			eng[(int)Cods.También_pasadas_secundarias]="Pairs from secondary strips too";
			eng[(int)Cods.Todos_con_minimo_puntos_comunes]="All pairs having the least nº. of common points";
			eng[(int)Cods.Orientación_de_las_pasadas]="Strip orientation";
			eng[(int)Cods.Orientar_las_pasadas_en_el_mismo_sentido]="Make the strips follow a unique sense";
			eng[(int)Cods.Transformación_de_ficheros_de_puntos]="Transformation of files: photographs";
			eng[(int)Cods.Fichero_de_origen]="Fichero de origen";
			eng[(int)Cods.Fichero_a_generar]="Fichero a generar";
			eng[(int)Cods.Transformar]="Transformar";
			eng[(int)Cods.Tarea_terminada]="Task finished";
			eng[(int)Cods.No_se_ha_podido_abrir_el_fichero_transfficheros]="The file transfficheros.dll couldn't be opened";
			eng[(int)Cods.Debe_indicar_ambos_ficheros]="Both files have to be specified";
			eng[(int)Cods.La_extensión_ftm_está_reservada]="The extension ftm can only be used with marked files";
			eng[(int)Cods.Transformación_de_ficheros_de_puntos]="Transformation of files: points";
			eng[(int)Cods.Transformación_de_ficheros_de_ccpp]="Transformation of files: cc.pp. and GPS events";
			eng[(int)Cods.Opciones_del_formato]="File format options";
			eng[(int)Cods.Sin_marcar]="Not marked";
			eng[(int)Cods.Marcado_prm]="Marked prm";
			eng[(int)Cods.Marcado_pym]="Marked pym";
			eng[(int)Cods.Tipo0]="Type 0";
			eng[(int)Cods.Tipo1]="Type 1";
			eng[(int)Cods.Transformación_de_ficheros_de_camara]="Transformation of files: camera files";
			eng[(int)Cods.Pares_a_generar]="Pairs to be created";
			eng[(int)Cods.Pairs_one]="Only 1ª-2ª";
			eng[(int)Cods.Pairs_both]="Both: 1ª-2ª and 2ª-1ª";
		}
		static void setup_it(){
			it[(int)Cods.Caption]="Aerotri";
			it[(int)Cods.MsgCaption]="Aerotri";
			it[(int)Cods.Acercade]="Su Aerotri";
			it[(int)Cods.FullTitle]="Aerotri: Calcolo di triangolazioni d'immagini";
			it[(int)Cods.Manualpath]="Manuales_html\\it\\Aerotri_it.htm";
			it[(int)Cods.AbrirTrabajo]="Apri lavoro";
			it[(int)Cods.GuardarTrabajo]="Salva il lavoro";
			it[(int)Cods.Guardarconfiguración]="Salva la configurazione attuale come la configurazione per difetto...";
			it[(int)Cods.Unidades_de_los_giros]="Unità dei giri";
			it[(int)Cods.Radianes]="Radianti";
			it[(int)Cods.g_centesimales]="g. centesimali";
			it[(int)Cods.g_sexagesimales]="g. sessagesimali";
			it[(int)Cods.Herramientas]="Strumenti";
			it[(int)Cods.Transformación_de_ficheros]="Trasformazione di file";
			it[(int)Cods.Fotogramas]="Fotogrammi";
			it[(int)Cods.Valores_aproximados_y_apoyo]="Punti";
			it[(int)Cods.GPS_INS_ccpp]="Centri di proiezione ed eventi GPS";
			it[(int)Cods.Archivos_de_cámara]="File di camera";
			it[(int)Cods.Ventana_de_comandos]="Ventana di commandi";
			it[(int)Cods.Unión_de_modelos]="Unione di modelli";
			it[(int)Cods.Sensor]="Sensore";
			it[(int)Cods.Cónico]="Conico";
			it[(int)Cods.Modelo_local]="Modello locale";
			it[(int)Cods.Datos_de_entrada]="Dati di entrata";
			it[(int)Cods.Config_cálculo]="Configurazione del calcolo";
			it[(int)Cods.Ficheros_de_salida]="File d'uscita";
			it[(int)Cods.Fichero_fotogramas]="File di fotogrammi";
			it[(int)Cods.Fichero_apoyo]="File di appoggio";
			it[(int)Cods.Fichero_gps]="File di GPS/INS";
			it[(int)Cods.Fichero_cámara]="File di camera";
			it[(int)Cods.Un_fichero]="Un file";
			it[(int)Cods.Una_carpeta]="Una cartella";
			it[(int)Cods.Son_ya_ajustados]="Sono già valori compensati";
			it[(int)Cods.Precisiones]="   Precisioni ";
			it[(int)Cods.Fotocoordenadas]="Coordinate immagine";
			it[(int)Cods.Apoyo]="Appoggio";
			it[(int)Cods.Planimetría]="Planimetria";
			it[(int)Cods.Altimetría]="Altimetria";
			it[(int)Cods.GPS]="GPS";
			it[(int)Cods.INS]="INS";
			it[(int)Cods.Estimador]="Estimatore";
			it[(int)Cods.MMcc]="Minimi cuadrati";
			it[(int)Cods.Robusto]="Robusto";
			it[(int)Cods.Puntos_de_apoyo]="Punti di appoggio";
			it[(int)Cods.Fijos]="Fissi";
			it[(int)Cods.Variables]="Variabili";
			it[(int)Cods.Sistema_de_coordenadas]="Sistema di coordinate";
			it[(int)Cods.Config_valores_aproximados]="Configurazione del calcolo dei valori approssimati";
			it[(int)Cods.Estimador_robusto]="Estimatore robusto";
			it[(int)Cods.Autocalibración]="Autocalibrazione";
			it[(int)Cods.Tratamiento_de_las_coordenadas]="Tratamento delle coordinate";
			it[(int)Cods.Fotocoordenadas_xy]="Coordinate immagine x/y";
			it[(int)Cods.Apoyo_XY]="Appoggio X/Y";
			it[(int)Cods.Apoyo_PlaniZ]="Appoggio Planim./Z";
			it[(int)Cods.Individual]="Individuale";
			it[(int)Cods.Conjunto]="Congiunto";
			it[(int)Cods.GPS_INS]="GPS/INS";
			it[(int)Cods.Errores_sistemáticos]="Errori sistematici";
			it[(int)Cods.Offset]="Offset";
			it[(int)Cods.No_error]="No";
			it[(int)Cods.Constante]="Costante";
			it[(int)Cods.Lineal]="Lineare";
			it[(int)Cods.Calcular_fotos_intermedias]="Calcolare fotogrammi intermezzi del file GPS/INS";
			it[(int)Cods.Interpolar_residuos]="Interpolare residui";
			it[(int)Cods.Diferencia_INS_kappa]="In caso di differenza tra i valori del sistema inerziale e i giri delle fotografie";
			it[(int)Cods.Cámara_girada]="La camera era girata";
			it[(int)Cods.Fotos_giradas]="Le fotografie furono girate a posteriori";
			it[(int)Cods.Escala_marcas_residuos]="Scala per i segni dei residui";
			it[(int)Cods.Opciones_generales]="Opzioni generali";
			it[(int)Cods.Ficheros_pdf]="File pdf";
			it[(int)Cods.Símbolos_unidades]="Símboli delle unità";
			it[(int)Cods.Cifras_decimales]="Cifre decimali";
			it[(int)Cods.Pares]="Pari";
			it[(int)Cods.Ficheros_de_información]="File d'informazione";
			it[(int)Cods.Texto]="Testo";
			it[(int)Cods.Binario]="Binario";
			it[(int)Cods.Hoja_pdf]="Foglio di sintesi in pdf";
			it[(int)Cods.Valores_ajustados]="Valori compensati";
			it[(int)Cods.Centros_puros]="Centri puri";
			it[(int)Cods.Hoja_pdf_int]="Foglio pdf";
			it[(int)Cods.Gráfico]="Grafico";
			it[(int)Cods.Archivo_ini]="File ini";
			it[(int)Cods.Otros_ficheros]="Altri file";
			it[(int)Cods.Residuos]="Residui";
			it[(int)Cods.Incrementos]="Incrementi dei valori approssimati";
			it[(int)Cods.Residuos_elevados]="Residui elevati";
			it[(int)Cods.Estadísticas]="Statistiche";
			it[(int)Cods.Ficheros_log]="File log";
			it[(int)Cods.Gráfico_de_residuos]="Grafico dei residui";
			it[(int)Cods.Sólo_valores_aproximados]="Solo valori approssimati";
			it[(int)Cods.Ajuste_completo]="Compensazione completa";
			it[(int)Cods.Calcular]="Calcola";

			it[(int)Cods.Cálculo_terminado]="Calcolo finito";
			it[(int)Cods.Calculando_valores_aproximados]="Calcolando valori approssimati";
			it[(int)Cods.Realizando_el_ajuste_del_bloque]="Realizzando la compensazione del blocco";
			it[(int)Cods.Esperando_a_que_termine_el_cálculo]="Aspettando che finisca il calcolo";
			it[(int)Cods.Leyendo_el_fichero_de_trabajo]="Leggendo il file di lavoro";
			it[(int)Cods.Escribiendo_el_fichero_de_trabajo]="Scrivendo il file di lavoro";
			it[(int)Cods.Escribiendo_el_fichero_de_configuración]="Scrivendo il file di configurazione";
			it[(int)Cods.De_esta_manera_la_configuración]="La configurazione attuale sarà la che mostre il programa sempre nella sua apertura.";
			it[(int)Cods.Fichero_de_valores_aproximados]="File di valori approssimati";
			it[(int)Cods.Fichero_de_modelo_local]="File di modello locale";
			it[(int)Cods.No_se_ha_podido_abrir_ajbloque]="Non è possibile aprire il file ajbloque.dll";
			it[(int)Cods.Desea_continuar_con_el_ajuste]="Vuoi continuare la compensazione?";
			it[(int)Cods.Error_en_valores_aproximados]="Errore nel calcolo di valori approssimati: ";
			it[(int)Cods.Mirar_el_fichero_de_proceso]="Mira la fine del file di processo (.pro)";
			it[(int)Cods.para_posibles_puntos_erróneos]=", per l'informazione interessante ai possibile punti erronei.";
			it[(int)Cods.Si_desea_continuar]="Se vuoi continuare e tentare di compensare il blocco, devi premere un'altra volta il pulsante \"Calcola\"";
			it[(int)Cods.Debe_indicar_modelo_local]="Deve indicare un file di modello locale";
			it[(int)Cods.Debe_indicar_apoyo]="Deve indicare un file di appoggio";
			it[(int)Cods.Desea_calcular_en_sistema_arbitrario]="Vuoi calcolare nonostante in un sistema di coordinate arbitrario (i punti di appoggio e i dati GPS esistenti saranno rispettati)?";
			it[(int)Cods.Error_en_la_escritura_del_fichero_de_trabajo]="Errore nella scritura del file di lavoro.";
			it[(int)Cods.No_se_pudo_abrir_para_escribirlo]="Non è stato possibile aprire il file per scriverlo";
			it[(int)Cods.El_fichero_no_se_escribió_correctamente]="Il file non è stato scrito correttamente";
			it[(int)Cods.PREPARA_RELATIVA_BASE]="";
			it[(int)Cods.relativa_Debe_indicar_fotogramas]="Deve indicare un file di fotogrammi";
			it[(int)Cods.relativa_Nombre_fotogramas_no_válido]="Il nome indicato per il file di fotogrammi contiene caratteri invalidi";
			it[(int)Cods.relativa_La_extensión_ftm_está_reservada]="Errore nel nome del file di fotogrammi: l'estensione ftm solo può utilizzarsi con file di Aerotri";
			it[(int)Cods.relativa_Debe_indicar_cámara]="Deve indicare un file di camera";
			it[(int)Cods.relativa_Nombre_cámara_no_válido]="Il nome indicato per il file di camera contiene caratteri invalidi";
			it[(int)Cods.relativa_Nombre_GPSINS_no_válido]="Il nome indicato per il file di GPS/INS contiene caratteri invalidi";
			it[(int)Cods.relativa_Debe_indicar_precisión_de_fotocoordenadas]="Deve indicare un valore per la precisione delle coordinate immagine";
			it[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_número]="Il testo scritto per la precisione delle coordinate immagine non è un numero";
			it[(int)Cods.relativa_Precisión_de_fotocoordenadas_no_cero]="Il valore indicato per la precisione delle coordinate immagine non può essere zero";
			it[(int)Cods.relativa_Precisión_de_fotocoordenadas_positivo]="Il valore indicato per la precisione delle coordinate immagine dev'essere positivo";
			it[(int)Cods.PREPARA_ABSOLUTA_BASE]="";
			it[(int)Cods.ajbloque_Debe_indicar_valores_aproximados]="Deve indicare un file di valori approssimati";
			it[(int)Cods.ajbloque_Nombre_valores_aproximados_no_válido]="Il nome indicato per il file di valori approssimati contiene caratteri invalidi";
			it[(int)Cods.ajbloque_Nombre_apoyo_no_válido]="Il nome indicato per il file di appoggio contiene caratteri invalidi";
			it[(int)Cods.ajbloque_Debe_indicar_precisión_apoyo_plani]="Deve indicare un valore per la precisione planimetrica dell'appoggio";
			it[(int)Cods.ajbloque_Precisión_de_apoyo_plani_no_número]="Il testo scritto per la precisione planimetrica dell'appoggio non è un numero";
			it[(int)Cods.ajbloque_Precisión_de_apoyo_plani_no_cero]="Il valore indicato per la precisione planimetrica dell'appoggio non può essere zero";
			it[(int)Cods.ajbloque_Precisión_de_apoyo_plani_positivo]="Il valore indicato per la precisione planimetrica dell'appoggio dev'essere positivo";
			it[(int)Cods.ajbloque_Debe_indicar_precisión_apoyo_alti]="Deve indicare un valore per la precisione altimetrica dell'appoggio";
			it[(int)Cods.ajbloque_Precisión_de_apoyo_alti_no_número]="Il testo scritto per la precisione altimetrica dell'appoggio non è un numero";
			it[(int)Cods.ajbloque_Precisión_de_apoyo_alti_no_cero]="Il valore indicato per la precisione altimetrica dell'appoggio non può essere zero";
			it[(int)Cods.ajbloque_Precisión_de_apoyo_alti_positivo]="Il valore indicato per la precisione altimetrica dell'appoggio dev'essere positivo";
			it[(int)Cods.ajbloque_Debe_indicar_precisión_GPS_plani]="Deve indicare un valore per la precisione planimetrica del GPS";
			it[(int)Cods.ajbloque_Precisión_de_GPS_plani_no_número]="Il testo scritto per la precisione planimetrica del GPS non è un numero";
			it[(int)Cods.ajbloque_Precisión_de_GPS_plani_no_cero]="Il valore indicato per la precisione planimetrica del GPS non può essere zero";
			it[(int)Cods.ajbloque_Precisión_de_GPS_plani_positivo]="Il valore indicato per la precisione planimetrica del GPS dev'essere positivo";
			it[(int)Cods.ajbloque_Debe_indicar_precisión_GPS_alti]="Deve indicare un valore per la precisione altimetrica del GPS";
			it[(int)Cods.ajbloque_Precisión_de_GPS_alti_no_número]="Il testo scritto per la precisione altimetrica del GPS non è un numero";
			it[(int)Cods.ajbloque_Precisión_de_GPS_alti_no_cero]="Il valore indicato per la precisione altimetrica del GPS non può essere zero";
			it[(int)Cods.ajbloque_Precisión_de_GPS_alti_positivo]="Il valore indicato per la precisione altimetrica del GPS dev'essere positivo";
			it[(int)Cods.ajbloque_Debe_indicar_precisión_INS_ΩΦ]="Deve indicare un valore per la precisione Ω e Φ dell'INS";
			it[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_no_número]="Il testo scritto per la precisione Ω e Φ dell'INS non è un numero";
			it[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_no_cero]="Il valore indicato per la precisione Ω e Φ dell'INS non può essere zero";
			it[(int)Cods.ajbloque_Precisión_de_INS_ΩΦ_positivo]="Il valore indicato per la precisione Ω e Φ dell'INS dev'essere positivo";
			it[(int)Cods.ajbloque_Debe_indicar_precisión_INS_Kappa]="Deve indicare un valore per la precisione Kappa dell'INS";
			it[(int)Cods.ajbloque_Precisión_de_INS_Kappa_no_número]="Il testo scritto per la precisione Kappa dell'INS non è un numero";
			it[(int)Cods.ajbloque_Precisión_de_INS_Kappa_no_cero]="Il valore indicato per la precisione Kappa dell'INS non può essere zero";
			it[(int)Cods.ajbloque_Precisión_de_INS_Kappa_positivo]="Il valore indicato per la precisione Kappa dell'INS dev'essere positivo";
			it[(int)Cods.Valor_de_ondulación_del_geoide_erróneo]="Valore di ondulazione del geoide erroneo";
			it[(int)Cods.Parámetros_a_calcular]="Parametri da calcolare";
			it[(int)Cods.Focal]="Focale";
			it[(int)Cods.Punto_principal]="Punto principale";
			it[(int)Cods.Modelo_polinómico] ="Modello polinomico";
			it[(int)Cods.Impar]="Impari";
			it[(int)Cods.Completo]="Completo";
			it[(int)Cods.Radial_tangencial]="Radiale / tangenziale";
			it[(int)Cods.Vector_giratorio]="Vettore giratorio";
			it[(int)Cods.Función_de_distorsión]="Funzione di distorsione";
			it[(int)Cods.Radial_simétrica]="Radiale simmetrica";
			it[(int)Cods.Tangencial_sim]="Tangenziale sim.";
			it[(int)Cods.Asimétricas]="Asimmetriche";
			it[(int)Cods.Radial]="Radiale";
			it[(int)Cods.Tangencial]="Tangenziale";
			it[(int)Cods.Serie1]="Serie 1";
			it[(int)Cods.Serie2]="Serie 2";
			it[(int)Cods.Errores_sistemáticos_GPS]="Errori sistematici del GPS e dell'INS";
			it[(int)Cods.Sin_errores_0]="Senza errori (Tipo 0)";
			it[(int)Cods.Permanente_Offset]="Permanente (Offset)";
			it[(int)Cods.Constante_1]= "Costante (Tipo 1)";
			it[(int)Cods.Lineal_2]="Lineare (Tipo 2)";
			it[(int)Cods.Valor_mínimo_puntos_comunes_erróneo]="Valore del minimo numero di punti comuni\nper l'orientazione di due fotogrammi erroneo";
			it[(int)Cods.Valor_parámetro_camino_erróneo]="Valore del parametro di camino erroneo";
			it[(int)Cods.Tipo_de_ajuste]="Tipo di calcolo";
			it[(int)Cods.Fuerza_mmcc]="Forza mm.cc. puro";
			it[(int)Cods.Valores_aproximados]="Valori approssimati";
			it[(int)Cods.Minimo_número_puntos_comunes]="Minimo nº di punti comuni per l'orientazione di due fotogrammi";
			it[(int)Cods.Deduce_automáticamente]="Deduce automaticamente";
			it[(int)Cods.El_siguiente_valor]="Questo valore";
			it[(int)Cods.Parámetro_de_camino]="Parametro di camino";
			it[(int)Cods.Uso_de_GPS]="Uso delle coordinate GPS e INS";
			it[(int)Cods.No_emplear]="Non impiegare";
			it[(int)Cods.Emplear_si_todos]="Impiegare se tutti sono presenti";
			it[(int)Cods.Para_los_ficheros_de_entrada]="Per i file di entrata";
			it[(int)Cods.Guardar_ruta_relativa]="Salva il pathname relativo";
			it[(int)Cods.Guardar_ruta_absoluta]="Salva il pathname assoluto";
			it[(int)Cods.Valor_decimales_fotocoordenadas_erróneo]="Valore erroneo di numero di cifre decimali per le coordinate immagine";
			it[(int)Cods.Valor_decimales_puntos_erróneo]="Valore erroneo di numero di cifre decimali per i punti";
			it[(int)Cods.Valor_decimales_GPS_erróneo]="Valore erroneo di numero di cifre decimali per il GPS";
			it[(int)Cods.Valor_decimales_INS_erróneo]="Valore erroneo di numero di cifre decimali per l'INS";
			it[(int)Cods.Escritura_de_los_residuos]="Escritura dei residui";
			it[(int)Cods.dos_cifras_significativas]="2 cifre significanti";
			it[(int)Cods.Número_de_decimales_fijo]="Numero di decimali fissi";
			it[(int)Cods.Deducir]="Dedurre";
			it[(int)Cods.Este_valor]="Questo valore";
			it[(int)Cods.Matrices_de_rotación]="Matrice di rotazione";
			it[(int)Cods.Fotocoordenadas_breve]="Coord. immagine";
			it[(int)Cods.Ficheros_Digi1]="File .rel, .abs e .abs2";
			it[(int)Cods.Ficheros_Digi2]="File .f e .mod";
			it[(int)Cods.Directorio_de_generación_relativo_a_fotos]="Direttorio dove generare i file, in relazione al file di fotogrammi";
			it[(int)Cods.Ficheros_IMaster1]="File .ext, .pairlist e .rel";
			it[(int)Cods.Ficheros_IMaster2]="File .imc";
			it[(int)Cods.Igual_que_el_idioma_del_programa]="Uguale che l'idioma del programma";
			it[(int)Cods.Otro]="Altro";
			it[(int)Cods.Log_del_ajuste]="Log della compensazione";
			it[(int)Cods.Log_básico]="Log basico";
			it[(int)Cods.Lectura_y_escritura_de_ficheros]="Lettura ed escritura di file";
			it[(int)Cods.Proceso]="Processo";
			it[(int)Cods.Otros]="Altri";
			it[(int)Cods.Logs_de_pdf]="Logs della generazione dei pdf";
			it[(int)Cods.Observaciones_GPS]="Osservazioni GPS/INS";
			it[(int)Cods.Puntos_de_control]="Punti di controllo";
			it[(int)Cods.Estadísticas_de_los_residuos]="Statistiche dei residui";
			it[(int)Cods.Puntos_con_algún_residuo_elevado]="Punti con residui elevati";
			it[(int)Cods.Parámetros_ajustados]="Parametri compensati";
			it[(int)Cods.Centros_de_proyección]="Centri di proiezione";
			it[(int)Cods.Puntos]="Punti";
			it[(int)Cods.Parámetros_GPS]="Parametri GPS/INS";
			it[(int)Cods.Matrices_de_rotación_de_los_fotogramas]="Matrice di rotazione dei fotogrammi";
			it[(int)Cods.Muestra]="Camipone";
			it[(int)Cods.Todos]="Tutti";
			it[(int)Cods.Mostrar_html_al_final]="Mostrare automaticamente html al terminare il calcolo";
			it[(int)Cods.Redundancias_parciales]="Ridondanza parziale";
			it[(int)Cods.Por_grupos]="Per gruppi";
			it[(int)Cods.Por_grupos_a_posteriori]="Per gruppi, a posteriori";
			it[(int)Cods.Covarianzas_Correlaciones]="Covarianze (Cv.) / Correlazioni (Crr.)";
			it[(int)Cods.Cv_ccpp]="Cvr. dei centri di proiezione";
			it[(int)Cods.Crr_ccpp]="Crr. dei centri di proiezione";
			it[(int)Cods.Cv_apoyo]="Cv. dei punti di appoggio";
			it[(int)Cods.Crr_apoyo]="Crr. dei punti di appoggio";
			it[(int)Cods.Valor_mínimo_puntos_comunes_modelo_erróneo]="Valore erroneo del minimo número di punti comuni per formare modello";
			it[(int)Cods.Mínimo_puntos_comunes_formar_modelo]="Minimo número di punti comuni per formare modello";
			it[(int)Cods.Generación_de_pares]="Generación de pares";
			it[(int)Cods.Solo_pares_principales]="Solo pares principales";
			it[(int)Cods.Solo_pasadas_principales]="Solo pasadas principales";
			it[(int)Cods.También_pasadas_secundarias]="También pares de las pasadas secundarias";
			it[(int)Cods.Todos_con_minimo_puntos_comunes]="Todos con el mínimo nº. de puntos en común";
			it[(int)Cods.Orientación_de_las_pasadas]="Orientación de las pasadas";
			it[(int)Cods.Orientar_las_pasadas_en_el_mismo_sentido]="Orientar las pasadas en el mismo sentido";
			it[(int)Cods.Transformación_de_ficheros_de_puntos]="Trasformazione di file di fotogrammi";
			it[(int)Cods.Fichero_de_origen]="File originale";
			it[(int)Cods.Fichero_a_generar]="File da generare";
			it[(int)Cods.Transformar]="Trasforma";
			it[(int)Cods.Tarea_terminada]="Compito finito";
			it[(int)Cods.No_se_ha_podido_abrir_el_fichero_transfficheros]="Non è possibile aprire il file transfficheros.dll";
			it[(int)Cods.Debe_indicar_ambos_ficheros]="Deve indicare ambedue file";
			it[(int)Cods.La_extensión_ftm_está_reservada]="L'estensione ftm solo può utilizzarsi con file segnati";
			it[(int)Cods.Transformación_de_ficheros_de_puntos]="Trasformazione di file di punti";
			it[(int)Cods.Transformación_de_ficheros_de_ccpp]="Trasformazione di file di cc.pp. ed eventi GPS";
			it[(int)Cods.Opciones_del_formato]="Opzioni del formato";
			it[(int)Cods.Sin_marcar]="Senza segnare";
			it[(int)Cods.Marcado_prm]="Segnato prm";
			it[(int)Cods.Marcado_pym]="Segnato pym";
			it[(int)Cods.Tipo0]="Tipo 0";
			it[(int)Cods.Tipo1]="Tipo 1";
			it[(int)Cods.Transformación_de_ficheros_de_camara]="Trasformazione di file di camera";
			it[(int)Cods.Pares_a_generar]="Pari da generare";
			it[(int)Cods.Pairs_one]="Soltanto 1ª-2ª";
			it[(int)Cods.Pairs_both]="Ambedue: 1ª-2ª e 2ª-1ª";
		}
	}
}
