using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public class FormAcercade : ControlesAt.FormAerotri{
		private Label LblFecha;
		private Label LblVersion;
		private Label LblTitulo;
		public Label LabelIcono;
		public string titulo;
		public string cabecera;
		public string fecha;
		private String Sversion;

		public FormAcercade(System.Type tipo, Globales.Idioma _idioma){
			InitializeComponent();
			idioma=_idioma;
			this.BackColor= Globales.Colores.NETColor(Globales.Colores.cForm);

			System.Reflection.AssemblyName aaa= System.Reflection.Assembly.GetAssembly(tipo).GetName();
			Version version=aaa.Version;
			Sversion=version.Major.ToString() + "." + version.Minor.ToString() + "." + version.Build.ToString();

			titulo="";
			cabecera="";
			fecha="";
		}

	#region InitializeComponent
		private void InitializeComponent()	{
			LblFecha= new Label();
			LblVersion= new Label();
			LblTitulo= new Label();
			LabelIcono= new Label();
			//
			// LblFecha
			//
			LblFecha.FlatStyle= FlatStyle.System;
			LblFecha.Location= new Point(65, 72);
			LblFecha.Size= new Size(160, 16);
			LblFecha.TextAlign= ContentAlignment.TopCenter;
			//
			// LblVersion
			//
			LblVersion.FlatStyle= FlatStyle.System;
			LblVersion.Location= new Point(65, 44);
			LblVersion.Size= new Size(160, 16);
			LblVersion.TextAlign= ContentAlignment.TopCenter;
			//
			// LblTitulo
			//
			LblTitulo.FlatStyle= FlatStyle.System;
			LblTitulo.Font= new System.Drawing.Font("Sylfaen", 11.25F);
			LblTitulo.Location= new Point(9, 8);
			LblTitulo.Size= new Size(240, 24);
			LblTitulo.TextAlign= ContentAlignment.TopCenter;
			//
			// LabelIcono
			//
			LabelIcono.Location= new Point(17, 44);
			LabelIcono.Size= new Size(40, 40);
			//
			// FormAcercade
			//
			this.ClientSize= new Size(258, 103);
			this.Controls.AddRange(new Control[]{
				LblFecha,	LblVersion,
				LblTitulo,	LabelIcono,
			});
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.MaximizeBox= false;
			this.MinimizeBox= false;
			this.ShowInTaskbar= false;
		}
	#endregion

		protected override void OnLoad(System.EventArgs e){
			LblVersion.Text=Textos.get_texto(Textos.Cods.Versin,idioma) + " " +Sversion;
			this.Text= titulo;
			LblTitulo.Text= cabecera;
			LblFecha.Text= fecha;

			base.OnLoad(e);
		}

		protected override void OnSizeChanged(EventArgs e){
			LblTitulo.Width=this.ClientSize.Width-18;
			LblVersion.Width=this.ClientSize.Width-98;
			LblFecha.Width=this.LblVersion.Width;
			base.OnSizeChanged(e);
		}
	}
}
