#define NUEVO

using System;
using System.Drawing;
using System.Windows.Forms;
using Globales;
using System.Runtime.InteropServices;
using ControlesAt;
using PanelesSub;
using System.IO;

namespace Grafico
{
	internal struct ConfiguracionPrograma{
		public string OpenPath;
	}

	public struct ConfiguracionEspecial{	//Configuracin especial para elementos individuales
		public uint elemento;	//As -1 es mayor que todos
		public uint tipo;	//Tipo de informacin almacenada en config[]
		public int valor;
	}
	public struct ConfiguracionGrafico2{	//Lo que no se pasa al programa de dibujar
		public float radio;
	}

	public class PicturemalditoNET: Control{
		public Rectangle FormerPos;
		public void set_FormerPosLocation(Point p){FormerPos.Location=p;}
		public event PaintEventHandler myPaint;

		protected override void OnPaint(PaintEventArgs e){
			base.OnPaint(e);
			myPaint(this,e);
		}
		protected override void OnVisibleChanged(EventArgs e){
			if(this.Visible){
				FormerPos.Location=this.PointToScreen(this.ClientRectangle.Location);
				FormerPos.Size=this.ClientRectangle.Size;
			}
			base.OnVisibleChanged(e);
		}
		protected override void OnSizeChanged(EventArgs e){
			if(this.PointToScreen(new Point(0,0)).X<-10000) return;
			base.OnSizeChanged(e);
			FormerPos.Location=this.PointToScreen(this.ClientRectangle.Location);
			FormerPos.Size=this.ClientRectangle.Size;
		}
	}

	public class NumberedTreeNode : TreeNode{
		uint number;
		public uint Number{
			get{return number;}
			set{number=value; set_text();}
		}
		string name;
		public new string Name{
			get{return name;}
			set{name=value; set_text();}
		}
		private void set_text(){
			this.Text=number.ToString();
			if(name!=null) this.Text+=": "+name;
		}

		public NumberedTreeNode(){
			number=0;
			Name=null;
		}
		public NumberedTreeNode(uint _n, string _name){
			number=_n; Name=_name;
		}
	}
	unsafe public class TreeViewOnOff : TreeView{
		public bool editando;
		public uint *tipos;	//tipos presentes;
		public TreeViewOnOff() : base(){
			tipos=(uint*)0;
			editando=false;
		}
	}

	internal class Ordenes{
		public const ushort None=0;
	}
	internal class OrdenesCtr{
		public const ushort Mano=1;
	}
	internal class OrdenesW{
		public const ushort Ventana=1,
								Lupa=2;
	}
	internal class OrdenesAna{
		public const ushort Infor=1,
								Texto=2;
	}
	internal class OrdenesEdit{
	}

	public struct Orden{
		public ushort orden;
		public byte estado;	//0 indica que simplemente se ha seleccionado. >=1 son sucesivos estados
		public int Xdown, Ydown;
	}

	public unsafe class PanelGrafico : PanelesSub.PanelSubordinado
	{
		protected const byte Esp=(byte)Globales.Idioma.Esp;
		protected const byte Eng=(byte)Globales.Idioma.Eng;
		protected const byte It=(byte)Globales.Idioma.It;

		internal System.Windows.Forms.OpenFileDialog Open1;
		internal System.Windows.Forms.SaveFileDialog Save1;
		private System.Windows.Forms.MenuItem AAbrir,	ACerrar,
															AAbrirConfiguracion,
															AGuardarConfiguracion,	AGuardarConfigDefecto,
															AExportar,
																AEDgn2D,	AEDgn3D,	AEBin,	AEeps;
		private System.Windows.Forms.ContextMenu MenuVer;
		private System.Windows.Forms.MenuItem VElementos;
		private System.Windows.Forms.ContextMenu MenuBuscar;
		private System.Windows.Forms.MenuItem BBuscar;
		private System.Windows.Forms.Panel panelBottom;
			private System.Windows.Forms.Label	LabelCoordenadaX,
														LabelCoordenadaY;
			internal System.Windows.Forms.Button Ajustar,
														Zmenos,	Zmas,
														Lupa;
			private ControlesAt.NoControl Separador1;
			private System.Windows.Forms.ContainerControl MoveUpDown;
			private System.Windows.Forms.Button MoveUp, MoveDown;
			private System.Windows.Forms.Button MoveLeft, MoveRight;
			private System.Windows.Forms.Timer Timer1;
		internal System.Windows.Forms.Panel PanelTop;
			internal ControlesAt.BotonToolBar Informacion,	Texto;
			internal System.Windows.Forms.ComboBox CBoxConfig;
		private System.Windows.Forms.Splitter SplitterRight;
		internal TreeViewOnOff TreeOnOff;
		internal PicturemalditoNET Picture1;

	#region Variables
		private bool idioma_read;
		internal System.Reflection.Assembly ThisAssembly;
		internal ConfiguracionPrograma ConfigPrograma;
		private byte press_button;
		private float resto;
		public InterComGrafico.GraficoCompleto grafico;
		public InterComGrafico.Vista vista0;
		internal bool bad_cfg;
		internal byte res_subpixel;
		string[] Filtergra,
					Filtercfg;

		KeyEventHandler keydown_handler;
		bool modoaj;
		Keys keystate;	//esto debera poder obtenerse en cualquier momento sin tener que andar manejando eventos
							//Ajustar, zoom + y zoom - no se tratan como rdenes. (Se ejecutan de manera instantnea)
		Orden ordenctr,		//orden que se est ejecutando por tener alguna tecla pulsada
				 ordenw,		//window. Se repite zlupa, zventana no.
				 ordenana;	//o. analisis.	Se reemplazan, se repiten.
				 //ordenedit;	//o. edicin.	Se acumulan entre s. Algunas se repiten y otras no. But it doesn't exist. This is not an editor yet.
		public string titulo;	//si ==null indica que no hay grfico cargado
		bool modificado;
		System.Windows.Forms.Cursor CursorLupa, CursorMano, CursorPuno;
		System.Windows.Forms.Cursor CursorInformacion_net, CursorTexto_net;
		const System.Globalization.NumberStyles Hex=System.Globalization.NumberStyles.AllowHexSpecifier;

		//Si tuvieses implementados las referencias a objetos de paso por valor, no me haran falta los punteros
		//pero claro... Mucho correr pa'alante con pies de barro, y no pienso perder tiempo en la inutilidad de encapsular
	#if !NUEVO
		internal ConfiguracionLogica* pCurrentLogic;	 //esta estructura y todas sus subestructuras, y hasta los int bsicos
		internal ConfiguracionGrafico* pCurrentConfig/*, ConfigProvisional*/;//Es cada formulario llamado el que gestiona CurrentConfig.
		internal ConfiguracionGrafico2 CurrentConfig2;	//Lo que no se le pasa al programa;
		FormElementos FormElementos1;
	#endif
		FormExportarbin Exportarbin1;
		FormExportardgn Exportardgn1;
		FormInfoElemento FormInfoElemento1;
		FormBuscarElementos FormBuscar1;

		System.IntPtr listadeElementos;
		int nElementos, telemento;
		private ConfiguracionEspecial* pCE;
		private int nCE;
		public sbyte decX, decY, decZ;
		static internal InterComGrafico.Criterio[] CriteriosInternos;
		byte[] byteInternos;
		byte[] MostrarInternos;
	#endregion

	#region Inicializacin
		public PanelGrafico(PanelesSub.Duenno _owner, Idioma idioma_inicial, IntPtr _enlaces) : base(_owner,idioma_inicial){
			sizable=true;
			ThisAssembly=System.Reflection.Assembly.GetExecutingAssembly();
			InitializeComponent();
			if(Myowner.modo==2){
				this.AAbrir.Visible=false;
				this.Picture1.AllowDrop=false;
			}
		}
		unsafe public PanelGrafico() : base(){
			sizable=true;
			ThisAssembly=System.Reflection.Assembly.GetExecutingAssembly();
			InitializeComponent();
		}
		protected override void inizializeb(string[] argv){
			short n;
			string _titulo;
			string ext;

			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(ThisAssembly.GetManifestResourceStream("Grafico.IconGrafico.ico"));
			ParentForm.MinimumSize= new System.Drawing.Size(240, 200);

			titulo=null;

			set_cfg_defecto();
			try{abre_cfg(AppPath+"Configuraciones\\Grafico\\porDefecto.cfg");}
			catch(Exception){}
			set_CriteriosInternos();
			byteInternos=new byte[14];
			MostrarInternos=new byte[14];
			MostrarInternos[0]=MostrarInternos[1]=1;

			idioma_read=false;
			lee_ficheroConfiguracion("Grafico.config");
			if(!idioma_read && Myowner.modo==0){
				idioma_read=PanelesSub.varias.read_reg_language("Aerotri","InstallLanguage",ref base.idioma);
			}
			nCE=-1;

			vista0.ventana.mx=0;
			vista0.ventana.my=0;
			vista0.ventana.MX=Picture1.Width;
			vista0.ventana.MY=Picture1.Height;
			vista0.square=1;
			decZ=decY=decX=-1;

		#if !NUEVO
			FormElementos1=new FormElementos(this);
		#endif
			Exportarbin1=new FormExportarbin(this);
			Exportardgn1=new FormExportardgn(this);
			FormInfoElemento1=new FormInfoElemento(idioma);
			FormBuscar1=new FormBuscarElementos(this);
			FormAcercade1=new FormAcercade(typeof(PanelGrafico),idioma);
			FormAcercade1.Icon= icono;
			FormAcercade1.LabelIcono.Image= icono.ToBitmap();

		#if !NUEVO
			FormElementos1.Owner=ParentForm;
		#endif
			Exportarbin1.Owner=ParentForm;
			Exportardgn1.Owner=ParentForm;
			FormInfoElemento1.Owner=ParentForm;
			FormBuscar1.Owner=ParentForm;
			FormAcercade1.Owner=ParentForm;

			CursorLupa=new Cursor(ThisAssembly.GetManifestResourceStream("Grafico.CursorLupa.cur"));
			CursorMano=new Cursor(ThisAssembly.GetManifestResourceStream("Grafico.CursorMano.cur"));
			CursorPuno=new Cursor(ThisAssembly.GetManifestResourceStream("Grafico.CursorPuo.cur"));
			CursorInformacion_net=new Cursor(ThisAssembly.GetManifestResourceStream("Grafico.CursorInformacion_net.cur"));
			CursorTexto_net=new Cursor(ThisAssembly.GetManifestResourceStream("Grafico.CursorTexto_net.cur"));

			EnabledFalse();
			n=(short)argv.Length;
			if(n==0) goto Finext;
			_titulo=argv[n-1];
			try{
				ext=System.IO.Path.GetExtension(_titulo);
				ConfigPrograma.OpenPath=System.IO.Path.GetDirectoryName(_titulo);
			}catch(ArgumentException){goto Finext;}
			switch(ext.ToLower()){
				case ".gra":
					Abre_fichero(_titulo,true);
					Ajustar_Click(this,EventArgs.Empty);
					break;
			}

		Finext:
			modificado=false;
			colores();
			update_idioma();
		}
		void set_cfg_defecto(){
		#if NUEVO
			res_subpixel=2;
		#else
			pCurrentConfig->ver=0x208F;
			pCurrentConfig->ver2=0;

			pCurrentLogic->CprecisionespM_from_cp=true;
			pCurrentLogic->CprecisionespA_from_pM=true;
			pCurrentLogic->CTpuntosA_from_puntosM=true;
			pCurrentLogic->CTpuntosC_from_puntosA=true;
			pCurrentLogic->c_Tfotogramas_from_ccpp=false;
			pCurrentLogic->c_Tfotogramas_from_fotogramas=true;
			pCurrentLogic->c_TpuntosM_from_puntosM=true;
			pCurrentLogic->c_TpuntosAc_from_puntosAc=true;
			pCurrentLogic->c_TpuntosAi_from_puntosAi=true;
			pCurrentLogic->c_TpuntosCc_from_puntosCc=true;
			pCurrentLogic->c_TpuntosCi_from_puntosCi=true;

			pCurrentConfig->initialize();
			pCurrentConfig->Cfotogramas.cp.forma= 0001;
			pCurrentConfig->Cfotogramas.cp.color= 0x00FFFF;
			pCurrentConfig->Cfotogramas.lpen.color= 0xFFBB00;
			pCurrentConfig->Cfotogramas.escala=1;

			pCurrentConfig->CpuntosM.forma= 0010;
			pCurrentConfig->CpuntosM.color=	0x907880;
			pCurrentConfig->CpuntosAc.forma= 0740;
			pCurrentConfig->CpuntosAc.color=	0x0000FF;
			pCurrentConfig->CpuntosAi.forma= 0740;
			pCurrentConfig->CpuntosAi.color=	0x88FF88;
			pCurrentConfig->CpuntosCc.forma= 0116;
			pCurrentConfig->CpuntosCc.color=	0x7700DD;
			pCurrentConfig->CpuntosCi.forma= 0116;
			pCurrentConfig->CpuntosCi.color=	0x88FF88;

			pCurrentConfig->Cresiduosf.punto= 0;
			pCurrentConfig->Cresiduosf.segmento.escala=500;
			pCurrentConfig->Cresiduosf.segmento.lpen.color=0x7700BB;
			pCurrentConfig->Cdistorsion.punto= 1;
			pCurrentConfig->Cdistorsion.segmento.escala=100;
			pCurrentConfig->Cdistorsion.segmento.lpen.color=0x880088;
			pCurrentConfig->CresiduoscpP.punto=0;
			pCurrentConfig->CresiduoscpP.segmento.escala=2000;
			pCurrentConfig->CresiduoscpP.segmento.lpen.color= 0x7700DD;
			pCurrentConfig->CresiduoscpG.escala=2000;
			pCurrentConfig->CresiduoscpG.forma=0;
			pCurrentConfig->CresiduoscpG.lpen1.color= 0x00FFFF;
			pCurrentConfig->CresiduoscpG.lpen2.color= 0x00DDFF;
			pCurrentConfig->CresiduospA.punto=0;
			pCurrentConfig->CresiduospA.segmento.escala=2000;
			pCurrentConfig->CresiduospA.segmento.lpen.color=0x0080FF;
			pCurrentConfig->CresiduospC.punto=0;
			pCurrentConfig->CresiduospC.segmento.escala=2000;
			pCurrentConfig->CresiduospC.segmento.lpen.color=0x8000FF;

			pCurrentConfig->Cprecisionescp.Celipse.lpen.color= 0x700000;
			pCurrentConfig->Cprecisionescp.Celipse.escala=2000;
			pCurrentConfig->Cprecisionescp.Csegmento.lpen.color= 0x64008C;
			pCurrentConfig->Cprecisionescp.Csegmento.escala=2000;

			pCurrentConfig->CprecisionespM=pCurrentConfig->Cprecisionescp;
			pCurrentConfig->CprecisionespA=pCurrentConfig->CprecisionespM;

			pCurrentConfig->CTfotogramas.color=	0xFFBB00;
			pCurrentConfig->CTpuntosM.color=	0x907880;
			pCurrentConfig->CTpuntosA.color=		0x0000FF;
			pCurrentConfig->CTpuntosC.color=		0x7700DD;
			pCurrentConfig->colorTpuntosAi=		0x88FF88;
			pCurrentConfig->colorTpuntosCi=		0x88FF88;

			CurrentConfig2.radio=3;
		#endif
		}
		static void set_CriteriosInternos(){
			CriteriosInternos= new InterComGrafico.Criterio[14];

			CriteriosInternos[0].tipoM=CriteriosInternos[0].tipom=8;	//cc.pp.
			CriteriosInternos[1].tipoM=CriteriosInternos[1].tipom=0;	//puntos
			CriteriosInternos[2].tipoM=CriteriosInternos[2].tipom=1;
			CriteriosInternos[2].criterio=2;	CriteriosInternos[2].subtipom=0x007;	//puntosA
			CriteriosInternos[3].tipoM=CriteriosInternos[3].tipom=1;
			CriteriosInternos[3].criterio=2;	CriteriosInternos[3].subtipom=0x070;	//puntosC

			//precisiones
			CriteriosInternos[4].tipom=2;	CriteriosInternos[4].tipoM=5;		//cp
			CriteriosInternos[4].criterio=1;
			CriteriosInternos[6]=CriteriosInternos[5]=CriteriosInternos[4];
			CriteriosInternos[5].subtipoM=CriteriosInternos[5].subtipom=1;	//pM
			CriteriosInternos[6].subtipoM=CriteriosInternos[6].subtipom=2;	//pA
			//Un hueco por si acaso;
			CriteriosInternos[7].tipom=0;	CriteriosInternos[7].tipoM=255;

			//residuos et sim.
			CriteriosInternos[8].tipoM=CriteriosInternos[8].tipom=6;		//foto
			CriteriosInternos[8].criterio=1;
			CriteriosInternos[9]=CriteriosInternos[8];
			CriteriosInternos[9].subtipoM=CriteriosInternos[9].subtipom=1;	//distorsion
			CriteriosInternos[10].tipoM=CriteriosInternos[10].tipom=7;		//cpP
			CriteriosInternos[10].criterio=1;
			CriteriosInternos[13]=CriteriosInternos[12]=CriteriosInternos[11]=CriteriosInternos[10];
			CriteriosInternos[11].subtipoM=CriteriosInternos[11].subtipom=1;	//cpG
			CriteriosInternos[12].subtipoM=CriteriosInternos[12].subtipom=2;	//pA
			CriteriosInternos[13].subtipoM=CriteriosInternos[13].subtipom=3;	//pC
		}

		protected override void lee_ficheroConfiguracion(string nombre){
			base.lee_ficheroConfiguracion(nombre);
			ConfigPrograma.OpenPath=__OpenPath;
		}
		protected override void procesa_linea_config(string tipo, string[] palabras){
			if(!idioma_read) if(tipo=="Idioma") idioma_read=true;
			base.procesa_linea_config (tipo, palabras);
		}
	#endregion

	#region InitializeComponent
		protected override void Dispose(bool disposing){
			base.Dispose(disposing);
		}

		private void InitializeComponent(){
			Picture1= new PicturemalditoNET();
			SplitterRight= new Splitter();
			TreeOnOff= new TreeViewOnOff();
			Informacion= new ControlesAt.BotonToolBar();
			Texto= new ControlesAt.BotonToolBar();
			CBoxConfig= new ComboBox();
			Open1= new OpenFileDialog();
			Save1	= new SaveFileDialog();
			AAbrir= new MenuItem();
			ACerrar= new MenuItem();
			AAbrirConfiguracion= new MenuItem();
			AGuardarConfiguracion= new MenuItem();
			AGuardarConfigDefecto= new MenuItem();
			AExportar= new MenuItem();
			AEDgn2D= new MenuItem();
			AEDgn3D= new MenuItem();
			AEBin= new MenuItem();
			AEeps= new MenuItem();
			MenuVer=new ContextMenu();
			VElementos= new MenuItem();
			MenuBuscar=new ContextMenu();
			BBuscar= new MenuItem();
			panelBottom= new Panel();
				Ajustar= new Button();
				Zmas= new Button();
				Zmenos= new Button();
				Lupa= new Button();
				Separador1= new NoControl();
				MoveUpDown= new ContainerControl();
					MoveUp= new Button();
					MoveDown= new Button();
				MoveLeft= new Button();
				MoveRight= new Button();
				LabelCoordenadaX= new Label();
				LabelCoordenadaY= new Label();
			PanelTop= new Panel();
			PanelMenu1.Controls.Remove(PanelMenu1.gLabels("Archivo"));
			PanelMenu1.AddLabel("Buscar",MenuBuscar);
			PanelMenu1.AddLabel("Ver",MenuVer);
			PanelMenu1.Controls.Add(PanelMenu1.gLabels("Archivo"));
			Filtergra=new string[(byte)Idioma.NIDIOMAS];
			Filtercfg=new string[(byte)Idioma.NIDIOMAS];
			Filtergra[(byte)Idioma.Esp]= "Grficos Aerotri (*.gra)|*.gra";
			Filtergra[(byte)Idioma.Eng]="Aerotri graphics(*.gra)|*.gra"; 
			Filtergra[(byte)Idioma.It]= "Grafico di Aerotri (*.gra)|*.gra";
			Filtercfg[(byte)Idioma.Esp]="Ficheros de configuracin (*.cfg)|*.cfg|Ficheros de Texto (*.txt)|*.txt|Todos los ficheros (*.*)|*.*";
			Filtercfg[(byte)Idioma.Eng]="Configuration files (*.cfg)|*.cfg|Text files (*.txt)|*.txt|All files (*.*)|*.*";
			Filtercfg[(byte)Idioma.It]="File di configurazione (*.cfg)|*.cfg|File di Testo (*.txt)|*.txt|Tutti i file (*.*)|*.*";
			//
			// MenuArchivo
			//
			MenuArchivo.MenuItems.AddRange(new MenuItem[] {AAbrir, ACerrar, AAbrirConfiguracion,
																				AGuardarConfiguracion, AExportar,
																				AGuardarConfigDefecto});
			//
			// AAbrir, etc.
			//
			AAbrir.Index= 0;		AAbrir.Click+= new EventHandler(AAbrir_Click);
			ACerrar.Index= 1;		ACerrar.Click+= new EventHandler(ACerrar_Click);

			AAbrirConfiguracion.Index= 2;		AAbrirConfiguracion.Click+= new EventHandler(AAbrirConfiguracion_Click);
			AGuardarConfiguracion.Index= 3;	AGuardarConfiguracion.Click+= new EventHandler(AGuardarConfiguracion_Click);
			AGuardarConfigDefecto.Index= 4;	AGuardarConfigDefecto.Click+= new EventHandler(AGuardarConfigDefecto_Click);
			//
			// AExportar
			AExportar.Index= 5;
			AExportar.MenuItems.AddRange(new MenuItem[] {AEDgn2D, AEDgn3D, AEBin, AEeps});
			//
			// AEDgn2D
			AEDgn2D.Index= 0;	AEDgn2D.Text= "Dgn 2D";		AEDgn2D.Click+= new EventHandler(AEDgn2D_Click);
			AEDgn3D.Index= 1;	AEDgn3D.Text= "Dgn 3D";		AEDgn3D.Click+= new EventHandler(AEDgn3D_Click);
			AEBin.Index= 2;			AEBin.Text= "Bin";					AEBin.Click+= new EventHandler(AEBin_Click);
			AEeps.Index= 3;			AEeps.Text= "eps";					AEeps.Click+= new EventHandler(AEeps_Click);
			//AEeps.Visible=false;
			//
			// MenuVer
			//
			MenuVer.MenuItems.AddRange(new MenuItem[]{VElementos});
		#if !NUEVO
			VElementos.Click+= new EventHandler(VElementos_Click);
		#endif
			//
			// MenuBuscar
			//
			MenuBuscar.MenuItems.Add(BBuscar);
			//
			// BBuscar
			BBuscar.Index= 0;
			BBuscar.Click+= new EventHandler(BBuscar_Click);
			//
			// Informacion, Texto, CBoxConfig
			//
			Informacion.Dock= DockStyle.Left;
			Texto.Dock= DockStyle.Left;
			//CBoxConfig.Dock= DockStyle.Left;
			Informacion.Location= new Point(0,0);		Informacion.Size= new Size(26,26);		Informacion.TabIndex=0;
			Texto.Location= new Point(0,0);				Texto.Size= new Size(26,26);				Texto.TabIndex=1;
			CBoxConfig.Location=new Point(60,3);		CBoxConfig.Size= new Size(120,21);		CBoxConfig.TabIndex=2;
			//
			Informacion.Image= new System.Drawing.Bitmap(ThisAssembly.GetManifestResourceStream("Grafico.Informacion_net.bmp"));
			Informacion.ImageAlign=ContentAlignment.BottomCenter;
			Texto.Image= new System.Drawing.Bitmap(ThisAssembly.GetManifestResourceStream("Grafico.Texto_net.bmp"));
			Texto.ImageAlign=ContentAlignment.BottomCenter;
			//
			CBoxConfig.DropDownStyle= ComboBoxStyle.DropDownList;
			//
			Informacion.Click+= new EventHandler(Informacion_Click);
			Texto.Click+= new EventHandler(Texto_Click);
			CBoxConfig.SelectedIndexChanged+= new EventHandler(CBoxConfig_SelectedIndexChanged);
			//
			// PanelTop
			//
			PanelTop.Controls.AddRange(new Control[]{
				CBoxConfig,
				Texto,			Informacion
			});
			PanelTop.Dock= DockStyle.Top;
			PanelTop.Location= new Point(0, 59);
			PanelTop.Size= new Size(580, 26);
			PanelTop.TabIndex= 34;
			//
			// Ajustar
			//
			Ajustar.BackColor= SystemColors.Control;
			Ajustar.Dock= DockStyle.Right;
			Ajustar.Image= new System.Drawing.Bitmap(ThisAssembly.GetManifestResourceStream("Grafico.Icono_Ajustar_net.bmp"));
			Ajustar.Location= new Point(563, 0);
			Ajustar.Size= new Size(17, 17);
			Ajustar.TabIndex= 0;
			Ajustar.Click+= new EventHandler(Ajustar_Click);
			//
			// Zmas
			//
			Zmas.BackColor= SystemColors.Control;
			Zmas.Dock= DockStyle.Right;
			Zmas.Image= new System.Drawing.Bitmap(ThisAssembly.GetManifestResourceStream("Grafico.Icono_Zmas_net.bmp"));
			Zmas.Location= new Point(529, 0);
			Zmas.Size= new Size(17, 17);
			Zmas.TabIndex= 1;
			Zmas.Click+= new EventHandler(Zmas_Click);
			//
			// Zmenos
			//
			Zmenos.BackColor= SystemColors.Control;
			Zmenos.Dock= DockStyle.Right;
			Zmenos.Image= new System.Drawing.Bitmap(ThisAssembly.GetManifestResourceStream("Grafico.Icono_Zmenos_net.bmp"));
			Zmenos.Location= new Point(546, 0);
			Zmenos.Size= new Size(17, 17);
			Zmenos.TabIndex= 2;
			Zmenos.Click+= new EventHandler(Zmenos_Click);
			//
			// Lupa
			//
			Lupa.BackColor= SystemColors.Control;
			Lupa.Dock= DockStyle.Right;
			Lupa.Image= new System.Drawing.Bitmap(ThisAssembly.GetManifestResourceStream("Grafico.Icono_Lupa_net.bmp"));
			Lupa.Location= new Point(512, 0);
			Lupa.Size= new Size(17, 17);
			Lupa.TabIndex= 3;
			Lupa.Click+= new EventHandler(Lupa_Click);
			//
			// Separador
			//
			Separador1.Width=3;
			Separador1.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			Separador1.Dock= DockStyle.Right;
			Separador1.TabIndex= 5;
			//
			// MoveUpDown, Up, Down
			//
			MoveUpDown.Dock=DockStyle.Right;
			MoveUpDown.Size= new Size(17, 17);
			MoveUpDown.TabIndex= 6;
			//
			// MoveUp, Down
			//
			MoveUp.Dock=DockStyle.Top;
			MoveUp.Size= new Size(17, MoveUpDown.Height/2);
			MoveUp.Font= new Font("Marlett", 5F, FontStyle.Regular, GraphicsUnit.Point, (byte)2);
			MoveUp.Text="5";
			MoveUp.TabIndex= 0;
			//
			MoveDown.Dock=DockStyle.Bottom;
			MoveDown.Size= MoveUp.Size;
			MoveDown.Font=MoveUp.Font;
			MoveDown.Text="6";
			MoveDown.TabIndex= 1;
			//
			MoveUpDown.Controls.Add(MoveDown);
			MoveUpDown.Controls.Add(MoveUp);
			//
			// MoveLeft, Right
			//
			MoveLeft.Dock=DockStyle.Right;
			MoveRight.Dock=DockStyle.Right;
			MoveLeft.Size= new Size(9, 17);
			MoveLeft.Font= MoveUp.Font;
			MoveLeft.Text="3";
			MoveLeft.TabIndex= 7;

			MoveRight.Size=MoveLeft.Size;
			MoveRight.Font=MoveLeft.Font;
			MoveRight.Text="4";
			MoveRight.TabIndex= 8;
			//
			MoveUp.MouseDown+= new MouseEventHandler(MoveV_Down);			MoveUp.MouseUp+=new MouseEventHandler(MoveV_Up);
			MoveDown.MouseDown+= new MouseEventHandler(MoveV_Down);		MoveDown.MouseUp+=new MouseEventHandler(MoveV_Up);
			MoveLeft.MouseDown+= new MouseEventHandler(MoveH_Down);			MoveLeft.MouseUp+=new MouseEventHandler(MoveH_Up);
			MoveRight.MouseDown+= new MouseEventHandler(MoveH_Down);		MoveRight.MouseUp+=new MouseEventHandler(MoveH_Up);
			//
			// LabelCoordenadaX, Y
			//
			LabelCoordenadaX.Dock= DockStyle.Left;		LabelCoordenadaX.TextAlign=ContentAlignment.MiddleLeft;
			LabelCoordenadaY.Dock= DockStyle.Left;		LabelCoordenadaY.TextAlign=ContentAlignment.MiddleLeft;
			LabelCoordenadaX.Location= new Point(0,0);		LabelCoordenadaX.Size= new Size(80,17);		LabelCoordenadaX.TabIndex= 0;
			LabelCoordenadaY.Location= new Point(0, 0);		LabelCoordenadaY.Size= new Size(80,17);		LabelCoordenadaY.TabIndex= 1;
			//
			// panelBottom
			//
			panelBottom.Controls.AddRange(new Control[]{
				LabelCoordenadaY, LabelCoordenadaX,
				MoveLeft, MoveRight,	MoveUpDown,
				Separador1,
				Lupa,
				Zmas,		Zmenos,
				Ajustar
			});
			panelBottom.Dock= DockStyle.Bottom;
			panelBottom.Location= new Point(0, 359);
			panelBottom.Size= new Size(580, 17);
			panelBottom.TabIndex= 32;
			//
			// TreeOnOff
			//
			TreeOnOff.Dock=DockStyle.Right;
			TreeOnOff.TabIndex=29;
			TreeOnOff.CheckBoxes=true;
			TreeOnOff.AfterCheck+=new TreeViewEventHandler(TreeOnOff_AfterCheck);
			//
			// SplitterRight
			//
			SplitterRight.Dock=DockStyle.Right;
			SplitterRight.MinExtra=80;
			SplitterRight.MinSize=4;
			SplitterRight.TabIndex=30;
			//
			// Picture1
			//
			Picture1.BackColor= Color.Black;
			Picture1.Dock= DockStyle.Fill;
			Picture1.Location= new Point(0, 18);
			Picture1.Size= new Size(563, 341);
			Picture1.TabIndex= 31;
			Picture1.TabStop= false;
			Picture1.myPaint+= new PaintEventHandler(Picture1_myPaint);
			Picture1.SizeChanged+= new EventHandler(Picture1_SizeChanged);
			Picture1.MouseUp+= new MouseEventHandler(Picture1_MouseUp);
			Picture1.MouseMove+= new MouseEventHandler(Picture1_MouseMove);
			Picture1.MouseDown+= new MouseEventHandler(Picture1_MouseDown);
			Picture1.AllowDrop=true;
			Picture1.DragEnter+=new DragEventHandler(Picture1_DragEnter);
			Picture1.DragDrop+=new DragEventHandler(Picture1_DragDrop);
			//
			// PanelGrafico
			//
			this.Controls.Remove(this.PanelMenu1);
			this.Controls.Add(Picture1);
			this.Controls.Add(SplitterRight);
			this.Controls.Add(TreeOnOff);
			this.Controls.Add(this.panelBottom);
			this.Controls.Add(this.PanelTop);
			this.Controls.Add(this.PanelMenu1);
			this.Size= new Size(580, 376);
			this.Load+=new EventHandler(PanelGrafico_Load);
		}
		protected void PanelGrafico_Load(object sender,EventArgs e){
			this.ParentForm.LocationChanged+=new EventHandler(ParentForm_LocationChanged);
			keydown_handler=new KeyEventHandler(ParentForm_KeyDown);
			this.ParentForm.KeyDown+=keydown_handler;
			this.ParentForm.KeyUp+=new KeyEventHandler(ParentForm_KeyUp);
			foreach(Control o in this.Controls){
				o.KeyDown+=keydown_handler;
				o.KeyUp+=new KeyEventHandler(ParentForm_KeyUp);
			}
		}
	#endregion
		protected void ParentForm_KeyDown(object sender,KeyEventArgs e){
			try{
				this.ParentForm.KeyDown-=keydown_handler;
				foreach(Control o in this.Controls) o.KeyDown-=keydown_handler;
			}catch(Exception){}
			keystate=e.KeyData;
			if(titulo==null) return;

			//e.Handled=true;
			if(ordenctr.estado!=0) return;
			reset_orden_ctr();
		}
		protected void ParentForm_KeyUp(object sender,KeyEventArgs e){
			try{
				this.ParentForm.KeyDown+=keydown_handler;
				foreach(Control o in this.Controls) o.KeyDown+=keydown_handler;
			}catch(Exception){}
			keystate=e.KeyData;
			if(titulo==null) return;

			//e.Handled=true;
			if(ordenctr.orden!=0 && ordenctr.estado==0){
				reset_orden_ctr();
			}
		}
		void reset_orden_ctr(){
			ordenctr.estado=0;
			if((keystate&Keys.Control)!=0){
				ordenctr.orden=OrdenesCtr.Mano;
				Picture1.Cursor=CursorMano;
			}else{
				ordenctr.orden=0;
				fallto_orden_w();
			}
		}

		protected override int cierra_todo(){
			if(modificado){
			}
			if(titulo!=null) EliminaGrafico();
			guarda_ficheroConfiguracion("Grafico.config");
			return 0;
		}
		protected override void escribe_fConfiguracion(System.IO.StreamWriter fconfig){
			base.escribe_fConfiguracion_comienzo(fconfig);
			fconfig.WriteLine("OpenPath \"" + ConfigPrograma.OpenPath +"\"");
		}

		private void Picture1_DragEnter(object sender,DragEventArgs e){
			if(e.Data.GetDataPresent(DataFormats.FileDrop)){
				e.Effect= DragDropEffects.Copy;
			}else{
				e.Effect= DragDropEffects.None;
			}
		}
		private void Picture1_DragDrop(object sender,DragEventArgs e){
			String[] files;
			try{
				files= (string[])e.Data.GetData(DataFormats.FileDrop);
				if(files.Length!=0){
					Abrir_un_Fichero(files[0]);
				}
			}catch(Exception){}
		}

	#region Archivo-Abrir/Cerrar
		private void AAbrir_Click(object sender,System.EventArgs e){
			ahora_no_se_puede_cerrar=1;
			if(Methods.AAbrir(Open1,ref ConfigPrograma.OpenPath,Filtergra[(byte)idioma],1)==null){
				ahora_no_se_puede_cerrar=0;
				return;
			}
			Abrir_un_Fichero(Open1.FileName);
			ahora_no_se_puede_cerrar=0;
		}
		public void Abrir_un_Fichero(string filename){
			set_message(global_text(Globales.Textos.Cods.Abriendo_un_fichero));
			Abre_fichero(filename,true);
			Ajustar_Click(this,EventArgs.Empty);
			modificado=false;
		}

		public void Abre_fichero(string s, bool b_abre_cfg){
			int nret;
			string txt="";
			if(titulo!=null) EliminaGrafico();
			System.IntPtr P_fichero=Marshal.StringToHGlobalUni(s);
			try{
				unsafe{fixed(InterComGrafico.GraficoCompleto *pg=&grafico){
						nret=InterComGrafico.carga_todo(P_fichero,pg);
				}}
			}catch{
				try{unsafe{fixed(InterComGrafico.GraficoCompleto *pg=&grafico){InterComGrafico.free_all(pg);}}}
				catch{}
				MessageBox.Show(textos(1));
				EliminaGrafico();
				Marshal.FreeHGlobal(P_fichero);
				return;
			}
			Marshal.FreeHGlobal(P_fichero);
			if(nret!=0 && nret<100){
				unsafe{fixed(InterComGrafico.GraficoCompleto *pg=&grafico){InterComGrafico.free_all(pg);}}
			}
			if(nret==4){
				/*MessageBox.Show(textos(25),Globales.Textos.YesNo(idioma),1);
				if(MessageBox.returnedButton!=1) return;
				string ss=Path.GetFileNameWithoutExtension(s);
				ss+="_2.gra";
				System.IntPtr P_s, P_ss;
				P_s=Marshal.StringToHGlobalUni(s);
				P_ss=Marshal.StringToHGlobalUni(ss);
				nret=InterComGrafico.transforma_fichero(P_s,P_ss);
				Marshal.FreeHGlobal(P_ss);
				Marshal.FreeHGlobal(P_s);
				if(nret==-10){
					MessageBox.Show(textos());
					return;
				}
				s=Path.ChangeExtension(s,"cfg");
				if(System.IO.File.Exists(s)){
					try{System.IO.File.Copy(s,Path.GetFileNameWithoutExtension(s)+"_2.cfg",false);}
					catch{}
				}
				Abre_fichero(ss,b_abre_cfg);
				return;*/
			}
			if(nret!=0){
				if(nret>=100){
					txt=textos(6);
				}else{switch(nret){
					case -2: txt=textos(7); break;
					case 1: txt=textos(16,s); break;
					case 2: txt=textos(2); break;
					case 3: txt=textos(4); break;
					case 4: txt=textos(9); break;
					default: txt=textos(10); break;
				}}
				MessageBox.Show(txt);
				if(nret<100) return;
			}
			for(int i=0; i<grafico.configs.n; i++){
				CBoxConfig.Items.Add(new string(grafico.configs.ppio[i].nombre));
			}
			if(grafico.configs.n!=0) CBoxConfig.SelectedIndex=0;
			titulo=s;

			//TreeOnOff
			unsafe{uint *puint;
				InterComGrafico.get_tipos_presentes(grafico.fgrafico,&puint);
				TreeOnOff.tipos=puint;
			}
			cambia_configuracion();

			//Vistas
			unsafe{fixed(InterComGrafico.Vista* pvista=&vista0){
					nret=InterComGrafico.setup_vista_identity(pvista,(uint)Picture1.Height,(uint)Picture1.Width,grafico.fgrafico,grafico.otherdata);
			}}
			if(nret!=0) MessageBox.Show(textos(8));
			final();
		}

		/*public void GetfromMemory(InterComGrafico.Transf_Terr_ventana _Transf, System.IntPtr _pfdibujo, int _tamanno, string _titulo){
			Transf=_Transf;
			pfdibujo=_pfdibujo; tamanno=_tamanno;
			titulo=_titulo;
			fixed(System.IntPtr* p_otherdata=&otherdata){
			//fixed(InterComGrafico.Vista* pvista=&vista0){
				InterComGrafico.Crea_otherdata(pfdibujo,0,p_otherdata);//,pvista);
			}//}
			abre_cfg(titulo);
			final();
			Ajustar_Click(this,EventArgs.Empty);
		}*/
		private void final(){
			ParentForm.Text=titulo;
		#if !NUEVO
			unsafe{fixed(InterComGrafico.Criterio* pC=CriteriosInternos){
				fixed(byte* pb=byteInternos){
					InterComGrafico.busca_existentes(otherdata,pC,14,pb);
					existcambiado=true;
			}}}
			if(FormElementos1.Visible==true){
				set_Mostrar_de_exist();
				FormElementos1.reset(MostrarInternos);
				FormElementos1.Actualiza(pCurrentConfig,pCurrentLogic);
			}
		#endif
			decX=InterComGrafico.retrive_precisionX(grafico.fgrafico,grafico.otherdata);
			decY=InterComGrafico.retrive_precisionY(grafico.fgrafico,grafico.otherdata);
			decZ=InterComGrafico.retrive_precisionZ(grafico.fgrafico);
			EnabledTrue();
			Timer1=new Timer();
			Timer1.Enabled=true;
			Timer1.Interval=50;
		}

		public int abre_cfg(string s){//devuelve 1 si otherdata==NULL, y todo se libera
			string cfg;
			cfg=Basicas._gcVarios.crea_nombre(s,'c','f','g');
			System.IntPtr P_fichero, P_mensaje;
			System.IntPtr P_textos= IntPtr.Zero;
			int nret;

			P_mensaje=Marshal.AllocHGlobal(1024);
			P_fichero=Marshal.StringToHGlobalUni(cfg);
			string mensaje, errores;
			fixed(InterComGrafico.Vector_Gra_Configuracion *pconfigs=&grafico.configs){
				nret=InterComGrafico.annade_one_config(pconfigs);
			}
			if(nret==-2) mensaje=textos(8);
			else{
				nret=InterComGrafico.carga_configuracion(P_fichero,grafico.configs.ppio+grafico.configs.n-1,&P_textos,P_mensaje,(byte)idioma);
			}
			Marshal.FreeHGlobal(P_fichero);
			
			if(nret==0 || nret==2){
				mensaje=null; bad_cfg=false;
			}else{
				mensaje=Marshal.PtrToStringUni(P_mensaje);
				bad_cfg=true;
			}

			errores=null;
			if(P_textos!=System.IntPtr.Zero){
				errores="";
				InterComGrafico.LinkedCstring links;
				System.IntPtr next=P_textos;
				while(next!=System.IntPtr.Zero){
					links=*(InterComGrafico.LinkedCstring*)(next.ToPointer());
					next=links.next;
					errores=errores+Marshal.PtrToStringUni(links.s1)+"\n";
				}
				InterComGrafico.free_linkedStrings(P_textos);
				MessageBox.Label1.AlignmentX=0;
			}
			if(mensaje!=null || errores!=null){
				if(errores==null){
					MessageBox.Show(mensaje);
				}else{
					if(mensaje==null) mensaje="Se produjeron los siguientes errores en la lectura del fichero de configuracin:\n\n";
					else mensaje+="\n\nAdems, antes de que se detuviese la lectura del fichero, se haban producido los siguientes errores:\n\n";
					MessageBox.Show(mensaje+errores);
					MessageBox.Label1.AlignmentX=0.5F;
				}
			}
			Marshal.FreeHGlobal(P_mensaje);
			return 0;
		}

		private void ACerrar_Click(object sender,System.EventArgs e){
			EliminaGrafico();
		}
		public void EliminaGrafico(){
			if(TreeOnOff.tipos!=(void*)0) InterComGrafico.graficos_free(new IntPtr((void*)TreeOnOff.tipos));
			fixed(InterComGrafico.GraficoCompleto *pg=&grafico){
			fixed(InterComGrafico.Vista *pvista=&vista0){
				InterComGrafico.free_all(pg);
				InterComGrafico.free_vista(pvista);
			}}
			borra_ConfigEspecial();
			FormBuscar1.borra();
			Timer1.Stop();
			Timer1.Enabled=false;
			Timer1.Dispose();
			titulo=null;
			Picture1.Refresh();
			CBoxConfig.Items.Clear();
			TreeOnOff.Nodes.Clear();
			ParentForm.Text=ParentForm.Name;
			LabelCoordenadaY.Text=LabelCoordenadaX.Text="";
			EnabledFalse();
		}

		public void EnabledTrue(){
			ACerrar.Enabled=true;
			AExportar.Enabled=true;
			AAbrirConfiguracion.Enabled=true;
			AGuardarConfiguracion.Enabled=true;
			AGuardarConfigDefecto.Enabled=true;
			PanelMenu1.gLabels("Ver").Enabled=true;
			PanelMenu1.gLabels("Buscar").Enabled=true;
			PanelTop.Enabled=true;
			reinicia_ConfigEspecial();
			if(FormBuscar1.Visible) FormBuscar1.Tipo_Changed();
			Picture1.Cursor=Cursors.Default;
		#if !NUEVO
			FormElementos1.SuperTab1.Enabled=true;
		#endif
		}
		public void EnabledFalse(){
			this.titulo=null;

			ACerrar.Enabled=false;
			AExportar.Enabled=false;
			AAbrirConfiguracion.Enabled=false;
			AGuardarConfiguracion.Enabled=false;
			AGuardarConfigDefecto.Enabled=false;
			PanelMenu1.gLabels("Ver").Enabled=false;
			PanelMenu1.gLabels("Buscar").Enabled=false;
			PanelTop.Enabled=false;
		#if !NUEVO
			FormElementos1.SuperTab1.Enabled=false;
		#endif

			keystate=Keys.None;
			ordenana.orden=ordenw.orden=ordenctr.orden=Ordenes.None;
			ordenctr.estado=ordenw.estado=ordenana.estado=0;
			nElementos=0; telemento=0;
			Picture1.Cursor=Cursors.Default;
		}
	#endregion

	#region Archivo-Configuracion
		private void AAbrirConfiguracion_Click(Object sender,System.EventArgs e){
			string s="", openpath, provisional;
			ahora_no_se_puede_cerrar=1;
			openpath=ConfigPrograma.OpenPath;
			provisional=AppPath+"Configuraciones\\Grafico\\porDefecto.cfg";
			s=Methods.AAbrir(Open1, ref provisional, Filtercfg[(byte)idioma],1);
			if(s==null) goto @return;

			string cfg=Basicas._gcVarios.crea_nombre(titulo,'c','f','g');
			try{System.IO.File.Copy(s,cfg,true);}
			catch(System.IO.IOException){
				MessageBox.Show(textos(14,cfg));
				goto @return;
			}
			catch(Exception){goto @return;}
			set_message(textos(31));
			abre_cfg(titulo);
		#if !NUEVO
			redibuja();
		#else
			redibuja();
		#endif
		@return:
			ConfigPrograma.OpenPath=openpath;
			ahora_no_se_puede_cerrar=0;
		}

		private void AGuardarConfiguracion_Click(Object sender,System.EventArgs e){
			string s, openpath, provisional;
			ahora_no_se_puede_cerrar=1;
			openpath=ConfigPrograma.OpenPath;
			provisional=AppPath+"Configuraciones\\Grafico\\porDefecto.cfg";
			s=Methods.AAbrir(Save1, ref provisional, Filtercfg[(byte)idioma],1);
			if(s==null) goto @return;
		#if !NUEVO
			guarda_configuracion(s);
		#endif
		@return:
			ConfigPrograma.OpenPath=openpath;
			ahora_no_se_puede_cerrar=0;
		}

		private void AGuardarConfigDefecto_Click(Object sender,System.EventArgs e){
			if(ShowMessageWait(textos(20),Globales.Textos.OKCancel(idioma),1)!=1) return;
			string s=AppPath+"Configuraciones\\Grafico\\porDefecto.cfg";
			for(int i=0; i<MostrarInternos.Length; i++)
				MostrarInternos[i]=(byte)1;

			ahora_no_se_puede_cerrar=1;
			set_message(textos(32));
		#if !NUEVO
			guarda_configuracion(s);
			set_Mostrar_de_exist();
		#endif
			ahora_no_se_puede_cerrar=0;
		}
	#endregion

		unsafe private void cambia_configuracion(){
			TreeOnOff.editando=true;
			TreeOnOff.Nodes.Clear();
			for(uint *ptr=TreeOnOff.tipos;*ptr!=unchecked((uint)-1);ptr++){
				string significado=null;
				if(grafico.configs.n!=0){
					grafico.pconfig=grafico.configs.ppio+grafico.kconfig;
					InterComGrafico.SolvedSignificados *signs;
					signs=InterComGrafico.get_SolvedSignificados((*ptr)<<12,(byte)0,grafico.pconfig);
					if(signs==(void*)0){
						MessageBox.Show(textos(7));
						return;
					}
					string Sig, SigR;
					Sig=new string(signs->Significado);
					SigR=new string(signs->SignificadoR);
					if(Sig!="" && SigR!="") significado=Sig+". "+SigR;
					else if(Sig!="") significado=Sig;
					else significado=SigR;
				}
				NumberedTreeNode treen= new NumberedTreeNode(*ptr,significado);
				treen.Checked=Basicas.Hash_utils.get_Hash_uint(&grafico.pconfig->fconfig->ver.ver,*ptr)==0;
				TreeOnOff.Nodes.Add(treen);
			}
			TreeOnOff.editando=false;
		}
		private void CBoxConfig_SelectedIndexChanged(object sender,System.EventArgs e){
			if(titulo==null || CBoxConfig.SelectedIndex<0) return;
			grafico.kconfig=(uint)CBoxConfig.SelectedIndex;
			cambia_configuracion();
			Picture1.Focus();
			redibuja();
		}
		unsafe private void TreeOnOff_AfterCheck(object sender,TreeViewEventArgs e){
			if(TreeOnOff.editando) return;
			if(grafico.configs.n==0) return;
			IntPtr offs;
			offs=Marshal.AllocHGlobal((TreeOnOff.Nodes.Count+1)*sizeof(uint));
			uint *ptr=(uint*)offs.ToPointer();
			foreach(TreeNode node in TreeOnOff.Nodes){
				if(!node.Checked) *ptr++=((NumberedTreeNode)node).Number;
			}
			*ptr=unchecked((uint)-1);

			grafico.pconfig=grafico.configs.ppio+grafico.kconfig;
			if((void*)grafico.pconfig->fconfig==(void*)0) return;
			InterComGrafico.Set_Ver_offs(&grafico.pconfig->fconfig->ver,(uint*)offs.ToPointer());
			Marshal.FreeHGlobal(offs);
			redibuja();
			return;
		}

	#region Exportar
	#if !NUEVO
		private void AEDgn2D_Click(object sender,System.EventArgs e){
			exportar_dgn(false);
		}
		private void AEDgn3D_Click(object sender,System.EventArgs e){
			exportar_dgn(true);
		}
		private void AEBin_Click(object sender,System.EventArgs e){
			exportar_bin();
		}
		private void AEeps_Click(object sender,System.EventArgs e){}
	#else
		private void AEDgn2D_Click(object sender,System.EventArgs e){}
		private void AEDgn3D_Click(object sender,System.EventArgs e){}
		private void AEBin_Click(object sender,System.EventArgs e){}
		private void AEeps_Click(object sender,System.EventArgs e){
			exportar_eps();
		}
	#endif

	#if !NUEVO
		private void exportar_dgn(bool D3){
			string nombre;
			int nret;
			System.IntPtr P_mensaje;
			OpcionesDgn Ocopia;
			Ocopia.fsemilla=System.IntPtr.Zero;

			if(tamanno==0){
				MessageBox.Show(textos(23)); return;
			}

			ahora_no_se_puede_cerrar=1;
			P_mensaje=Marshal.AllocHGlobal(512);
			nombre=Basicas._gcVarios.crea_nombre(titulo,'d','g','n');
			Save1.FileName=nombre;
			Save1.Filter="*.dgn|*.dgn";
			if(Save1.ShowDialog()!=DialogResult.OK || Save1.FileName=="") goto @return;
			Exportardgn1.ShowDialog();
			if(Exportardgn1.mi_DialogResult==DialogResult.Cancel) goto @return;
			Ocopia=Exportardgn1.O;
			if(Exportardgn1.mi_DialogResult==DialogResult.Ignore || Exportardgn1.TxtBot1.Text=="") Ocopia.fsemilla=System.IntPtr.Zero;
			else{
				try{
					if(System.IO.Path.GetFullPath(Exportardgn1.TxtBot1.Text)==System.IO.Path.GetFullPath(Save1.FileName)){
						MessageBox.Show(textos(32));
						goto @return;
					}
				}catch(Exception){}
				Ocopia.fsemilla=Marshal.StringToHGlobalUni(Exportardgn1.TxtBot1.Text);
			}
			set_message(textos(50));
			try{
				nret=InterComGrafico.gra_a_dgn(pfdibujo,tamanno,Marshal.StringToHGlobalUni(Save1.FileName),Convert.ToByte(D3),pCurrentConfig,&Ocopia,P_mensaje,idioma);
			}catch(System.IO.IOException){
				MessageBox.Show(textos(14,nombre));
				goto @return;
			}
			if(nret!=0) MessageBoxAT.Show(Marshal.PtrToStringUni(P_mensaje));

		@return:
			if(Ocopia.fsemilla!=System.IntPtr.Zero) Marshal.FreeHGlobal(Ocopia.fsemilla);
			Marshal.FreeHGlobal(P_mensaje);
			ahora_no_se_puede_cerrar=0;
		}

		void exportar_bin(){
			string nombre;
			int nret;
			System.IntPtr P_mensaje;

			if(tamanno==0){
				MessageBox.Show(textos(23)); return;
			}

			ahora_no_se_puede_cerrar=1;
			P_mensaje=Marshal.AllocHGlobal(512);
			nombre=Basicas._gcVarios.crea_nombre(titulo,'b','i','n');
			Save1.FileName=nombre;
			Save1.Filter="";
			if(Save1.ShowDialog()!=DialogResult.OK || Save1.FileName=="") goto @return;
			Exportarbin1.ShowDialog();
			if(Exportarbin1.mi_DialogResult!=DialogResult.OK) goto @return;
			OpcionesDigi Ocopia=Exportarbin1.O;
			set_message(textos(11));
			try{
				unsafe{fixed(InterComGrafico.Transf_Terr_ventana* t=&Transf){
					nret=InterComGrafico.gra_a_bin(pfdibujo,tamanno,t,Marshal.StringToHGlobalUni(Save1.FileName),pCurrentConfig,&Ocopia,P_mensaje,idioma);
				}}
			}catch(System.IO.IOException){
				MessageBox.Show(textos(13));
				goto @return;
			}
			if(nret!=0) MessageBoxAT.Show(Marshal.PtrToStringUni(P_mensaje));

		@return:
			Marshal.FreeHGlobal(P_mensaje);
			ahora_no_se_puede_cerrar=0;
		}
	#else
		void exportar_eps(){
			string nombre;
			//int nret;
			System.IntPtr P_mensaje;
			InterComGrafico.OpcionesPs opciones_ps;

			if(titulo==null){
				MessageBox.Show(textos(3)); return;
			}

			ahora_no_se_puede_cerrar=1;
			P_mensaje=Marshal.AllocHGlobal(512);
			nombre=Basicas._gcVarios.crea_nombre(titulo,'e','p','s');
			opciones_ps.escala=0.000016F;
			opciones_ps.grueso_lineas=0.4F;
			opciones_ps.size_formas=0.8F;
			opciones_ps.margen_iz=0.5F;	//en cm
			opciones_ps.margen_de=0.5F;
			opciones_ps.margen_ar=0.5F;
			opciones_ps.margen_ab=0.5F;
			Save1.FileName=nombre;
			Save1.Filter="";
			if(Save1.ShowDialog()!=DialogResult.OK || Save1.FileName=="") goto @return;
			try{
				fixed(InterComGrafico.Vista* pvista=&vista0){
					//nret=InterComGrafico.gra_a_ps(grafico,Marshal.StringToHGlobalUni(Save1.FileName),(byte)1,pvista,pCE,&opciones_ps,P_mensaje,idioma);
				}
			}catch(System.IO.IOException){
				MessageBox.Show(global_text(Globales.Textos.Cods.Noseha_podido_guardar));
				goto @return;
			}
			//if(nret!=0) MessageBoxAT.Show(Marshal.PtrToStringUni(P_mensaje));

		@return:
			Marshal.FreeHGlobal(P_mensaje);
			ahora_no_se_puede_cerrar=0;
		}
	#endif
	#endregion

#if !NUEVO
	#region fichero de configuracin
	#region Leer
		private int lee_configuracion(StreamReader file1){
			string[] palabras;	//Para que el tonto no proteste
			short n;

			set_cfg_defecto();
			bool font_set, color_set;
			string color_from;
			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return 0;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case @"\begin":
						if(n==1){
							file1.Close();
							return 0;
						}
						switch(palabras[1]){
							case "Info": file1.Close(); return 1;
							case "Ver": lee_ver(file1); break;
							case "Fotogramas": lee_fotogramas(file1, &pCurrentConfig->Cfotogramas); break;
							case "PuntosM": lee_punto(file1, &pCurrentConfig->CpuntosM); break;
							case "PuntosAc": lee_punto(file1, &pCurrentConfig->CpuntosAc); break;
							case "PuntosAi": lee_punto(file1, &pCurrentConfig->CpuntosAi); break;
							case "PuntosCc": lee_punto(file1, &pCurrentConfig->CpuntosCc); break;
							case "PuntosCi": lee_punto(file1, &pCurrentConfig->CpuntosCi); break;
							case "Componentes":
								if(n>5 && palabras[2]=="de" && palabras[3]=="precision" && palabras[4]=="de"){
								  switch(palabras[5]){
									case "cc.pp.": lee_precisionXYZ(file1, &pCurrentConfig->Cprecisionescp); break;
									case "puntos":
										lee_precisionXYZ(file1, &pCurrentConfig->CprecisionespM);
										pCurrentLogic->CprecisionespM_from_cp=false;
										break;
									case "puntosA":
										lee_precisionXYZ(file1, &pCurrentConfig->CprecisionespA);
										pCurrentLogic->CprecisionespA_from_pM=false;
										break;
								}}
								break;
							case "Distorsion": lee_residuo(file1, &pCurrentConfig->Cdistorsion); break;
							case "Residuos":
								if(n>3 && palabras[2]=="de"){
								  switch(palabras[3]){
									case "fotocoordenadas": lee_residuo(file1, &pCurrentConfig->Cresiduosf); break;
									case "cc.pp.,P":  lee_residuo(file1, &pCurrentConfig->CresiduoscpP); break;
									//case "cc.pp.,G":  lee_giro(file1, &pCurrentConfig->CresiduoscpP); break;
									case "puntosA": lee_residuo(file1, &pCurrentConfig->CresiduospA); break;
									case "puntosC": lee_residuo(file1, &pCurrentConfig->CresiduospC); break;
								}}
								break;
							case "Textos":
								font_set=false;
								color_set=false;
								if(n>3){switch(palabras[3]){
									case "fotogramas":
										lee_texto_mas(file1, &pCurrentConfig->CTfotogramas, out font_set, out color_set, out color_from);
										if(color_set || color_from!=""){
											pCurrentLogic->c_Tfotogramas_from_ccpp=false;
											pCurrentLogic->c_Tfotogramas_from_fotogramas=false;
										}
										if(!color_set && color_from!=""){
											if(color_from=="ccpp") pCurrentLogic->c_Tfotogramas_from_ccpp=true;
											else if(color_from=="fotogramas") pCurrentLogic->c_Tfotogramas_from_fotogramas=true;
										}
										break;
									case "puntos":
										lee_texto(file1, &pCurrentConfig->CTpuntosM, out font_set, out color_set);
										if(color_set) pCurrentLogic->c_TpuntosM_from_puntosM=false;
										break;
									case "puntosA":
										lee_texto(file1, &pCurrentConfig->CTpuntosA, out font_set, out color_set);
										if(font_set)  pCurrentLogic->CTpuntosA_from_puntosM=false;
										if(color_set)pCurrentLogic->c_TpuntosAc_from_puntosAc=false;
										break;
									case "puntosC":
										lee_texto(file1, &pCurrentConfig->CTpuntosC, out font_set, out color_set);
										if(font_set)  pCurrentLogic->CTpuntosC_from_puntosA=false;
										if(color_set)pCurrentLogic->c_TpuntosCc_from_puntosCc=false;
										break;
									case "puntosAi":
										lee_color(file1, &pCurrentConfig->colorTpuntosAi);
										pCurrentLogic->c_TpuntosAi_from_puntosAi=false;
										break;
									case "puntosCi":
										lee_color(file1, &pCurrentConfig->colorTpuntosCi);
										pCurrentLogic->c_TpuntosCi_from_puntosCi=false;
										break;
								}}
								break;
						}//\begin
						break;
					default: return 1;	//fichero nuevo
				}//linea
			}while(file1.Peek()>=0);
			file1.Close();

			if(pCurrentLogic->CprecisionespM_from_cp==true) pCurrentConfig->CprecisionespM=pCurrentConfig->Cprecisionescp;
			if(pCurrentLogic->CprecisionespA_from_pM==true) pCurrentConfig->CprecisionespA=pCurrentConfig->CprecisionespM;
			if(pCurrentLogic->CTpuntosA_from_puntosM==true) pCurrentConfig->CTpuntosA.lfont=pCurrentConfig->CTpuntosM.lfont;
			if(pCurrentLogic->CTpuntosC_from_puntosA==true) pCurrentConfig->CTpuntosC.lfont=pCurrentConfig->CTpuntosA.lfont;

			if(pCurrentLogic->c_Tfotogramas_from_ccpp==true) pCurrentConfig->CTfotogramas.color=pCurrentConfig->Cfotogramas.cp.color;
			if(pCurrentLogic->c_Tfotogramas_from_fotogramas==true) pCurrentConfig->CTfotogramas.color=pCurrentConfig->Cfotogramas.lpen.color;
			if(pCurrentLogic->c_TpuntosM_from_puntosM==true) pCurrentConfig->CTpuntosM.color=pCurrentConfig->CpuntosM.color;
			if(pCurrentLogic->c_TpuntosAc_from_puntosAc==true) pCurrentConfig->CTpuntosA.color=pCurrentConfig->CpuntosAc.color;
			if(pCurrentLogic->c_TpuntosCc_from_puntosCc==true) pCurrentConfig->CTpuntosC.color=pCurrentConfig->CpuntosCc.color;
			if(pCurrentLogic->c_TpuntosAi_from_puntosAi==true) pCurrentConfig->colorTpuntosAi=pCurrentConfig->CpuntosAi.color;
			if(pCurrentLogic->c_TpuntosCi_from_puntosCi==true) pCurrentConfig->colorTpuntosCi=pCurrentConfig->CpuntosCi.color;

			return 0;
		}

		void lee_ver(StreamReader file1){
			string[] palabras;
			short i,n;
			ushort l, vver1, vver0;
			string s;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				if(palabras[0]==@"\end") return;
				if(n>1){
					vver1=0;	vver0=0xFFFF;
					s=palabras[1];
					n=(short)s.Length;
					if(n>16) n=16;
					for(i=0,l=1;i<n;i++,l<<=1){
						if(s[i]=='0') vver0&=(ushort)~l;
						else vver1|=l;
					}
					switch(palabras[0]){
						case "Ver": pCurrentConfig->ver|=vver1; pCurrentConfig->ver&=vver0; break;
						case "Ver2": pCurrentConfig->ver2|=vver1; pCurrentConfig->ver2&=vver0; break;
						case "Ver3": pCurrentConfig->ver3|=vver1; pCurrentConfig->ver3&=vver0; break;
					}
				}
			}while(file1.Peek()>=0);
		}

		void lee_fotogramas(StreamReader file1, ConfigFotograma* pCfotogramas){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case @"\begin":
						if(n==1){file1.Close();	return;}
						switch(palabras[1]){
							case "CP": lee_punto(file1, &pCfotogramas->cp); break;
						}
						break;
					case "Escala":
						if(n>1){try{
							pCfotogramas->escala=Basicas._gcVarios.atofl(palabras[1].ToCharArray());
						}catch(Exception){}
						}break;
					case "Color":
						if(n>1){try{
							pCfotogramas->lpen.color= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_punto(StreamReader file1, ConfigPunto* pCPunto){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "Color":
						if(n>1){try{
							pCPunto->color= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_precisionXYZ(StreamReader file1, ConfigPrecisionXYZ* pCPrec){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case @"\begin":
						if(n==1){
							file1.Close();
							return;
						}
						switch(palabras[1]){
							case "Elipses": lee_elipse(file1, &pCPrec->Celipse); break;
							case "Segmentos": lee_segmento(file1, &pCPrec->Csegmento); break;
						}
						break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_elipse(StreamReader file1, Config_elipse* pCElipse){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "Color":
						if(n>1){try{
							pCElipse->lpen.color= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case "Escala":
						if(n>1){try{
							pCElipse->escala= Basicas._gcVarios.atofl(palabras[1].ToCharArray());
						}catch(Exception){}
						}break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}
		void lee_segmento(StreamReader file1, Config_segmento* pCSegmento){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "Color":
						if(n>1){try{
							pCSegmento->lpen.color= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case "Escala":
						if(n>1){try{
							pCSegmento->escala= Basicas._gcVarios.atofl(palabras[1].ToCharArray());
						}catch(Exception){}
						}break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_residuo(StreamReader file1, ConfigResiduo* pCResiduo){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "Punto":
						if(n>1){try{
							pCResiduo->punto= byte.Parse(palabras[1]);
						}catch(Exception){}
						}break;
					case "Color":
						if(n>1){try{
							pCResiduo->segmento.lpen.color= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case "Escala":
						if(n>1){try{
							pCResiduo->segmento.escala= Basicas._gcVarios.atofl(palabras[1].ToCharArray());
						}catch(Exception){}
						}break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_texto(StreamReader file1, ConfigTexto* pCTexto, out bool font_set, out bool color_set){
			string[] palabras;
			short n;

			font_set=false;
			color_set=false;
			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "Size":
						font_set=true;
						if(n>1){try{
							pCTexto->lfont.lfHeight= Int32.Parse(palabras[1]);
						}catch(Exception){}
						}break;
					case "Color":
						color_set=true;
						if(n>1){try{
							pCTexto->color= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_texto_mas(StreamReader file1, ConfigTexto* pCTexto, out bool font_set, out bool color_set, out string color_from){
			string[] palabras;
			short n;

			font_set=false;
			color_set=false;
			color_from="";
			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "Size":
						font_set=true;
						if(n>1){try{
							pCTexto->lfont.lfHeight= Int32.Parse(palabras[1]);
						}catch(Exception){}
						}break;
					case "Color":
						color_set=true;
						if(n>1){try{
							pCTexto->color= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case "ColorFrom":
						color_set=false;
						if(n>1) color_from=palabras[1];
						break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_color(StreamReader file1, UInt32* pcolor){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek() < 0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "Color":
						if(n>1){try{
							*pcolor= UInt32.Parse(palabras[1],Hex);
						}catch(Exception){}
						}break;
					case @"\end" : return;
				}
			}while(file1.Peek()>=0);
		}
	#endregion
	#region Escribir
		void guarda_configuracion(string s){
			StreamWriter File1;
			try{
				File1=new StreamWriter(s, false,System.Text.Encoding.Default);
			}catch(System.IO.IOException){
				MessageBox.Show(textos(14,s));
				return;
			}
			escribe_configuracion(File1);
		}
		 void escribe_configuracion(StreamWriter File1){
			short i,l;

			File1.WriteLine("%Grafico");
			File1.WriteLine(@"\begin Ver");
			File1.Write("Ver ");
			for(i=0,l=1;i<16;i++,l<<=1){
				if((pCurrentConfig->ver&l)!=0) File1.Write('1');
				else File1.Write('0');
			}
			File1.WriteLine();
			File1.Write("Ver2 ");
			for(i=0,l=1;i<8;i++,l<<=1){
				if((pCurrentConfig->ver2&l)!=0) File1.Write('1');
				else File1.Write('0');
			}
			File1.WriteLine();
			File1.Write("Ver3 ");
			for(i=0,l=1;i<6;i++,l<<=1){
				if((pCurrentConfig->ver3&l)!=0) File1.Write('1');
				else File1.Write('0');
			}
			File1.WriteLine();
			File1.WriteLine(@"\end");

			File1.WriteLine();
			if(MostrarInternos[0]!=0){
				File1.WriteLine(@"\begin Fotogramas");
				File1.WriteLine(@"\begin CP");
				File1.WriteLine("Color "+pCurrentConfig->Cfotogramas.cp.color.ToString("X06"));
				File1.WriteLine(@"\end");
				File1.WriteLine("Escala "+pCurrentConfig->Cfotogramas.escala.ToString());
				File1.WriteLine("Color "+pCurrentConfig->Cfotogramas.lpen.color.ToString("X06"));
				File1.WriteLine(@"\end");
			}

			if(MostrarInternos[1]!=0){
				File1.WriteLine(@"\begin PuntosM");
				File1.WriteLine("Forma "+pCurrentConfig->CpuntosM.forma.ToString());
				File1.WriteLine("Color "+pCurrentConfig->CpuntosM.color.ToString("X06"));
				File1.WriteLine(@"\end");
			}
			if(MostrarInternos[2]!=0){
				File1.WriteLine(@"\begin PuntosAc");
				File1.WriteLine("Forma "+pCurrentConfig->CpuntosAc.forma.ToString());
				File1.WriteLine("Color "+pCurrentConfig->CpuntosAc.color.ToString("X06"));
				File1.WriteLine(@"\end");
				File1.WriteLine(@"\begin PuntosAi");
				File1.WriteLine("Forma "+pCurrentConfig->CpuntosAi.forma.ToString());
				File1.WriteLine("Color "+pCurrentConfig->CpuntosAi.color.ToString("X06"));
				File1.WriteLine(@"\end");
			}
			if(MostrarInternos[3]!=0){
				File1.WriteLine(@"\begin PuntosCc");
				File1.WriteLine("Forma "+pCurrentConfig->CpuntosCc.forma.ToString());
				File1.WriteLine("Color "+pCurrentConfig->CpuntosCc.color.ToString("X06"));
				File1.WriteLine(@"\end");
				File1.WriteLine(@"\begin PuntosCi");
				File1.WriteLine("Forma "+pCurrentConfig->CpuntosCi.forma.ToString());
				File1.WriteLine("Color "+pCurrentConfig->CpuntosCi.color.ToString("X06"));
				File1.WriteLine(@"\end");
			}

			File1.WriteLine();
			if(MostrarInternos[4]!=0){
				File1.WriteLine(@"\begin Componentes de precision de cc.pp.");
				escribe_precisiones(File1, &pCurrentConfig->Cprecisionescp);
				File1.WriteLine(@"\end");
			}

			if(MostrarInternos[5]!=0 && !pCurrentLogic->CprecisionespM_from_cp){
				File1.WriteLine();
				File1.WriteLine(@"\begin Componentes de precision de puntos");
				escribe_precisiones(File1, &pCurrentConfig->CprecisionespM);
				File1.WriteLine(@"\end");
			}

			if(MostrarInternos[6]!=0 && !pCurrentLogic->CprecisionespA_from_pM){
				File1.WriteLine();
				File1.WriteLine(@"\begin Componentes de precision de puntosA");
				escribe_precisiones(File1, &pCurrentConfig->CprecisionespA);
				File1.WriteLine(@"\end");
			}

			File1.WriteLine();
			if(MostrarInternos[8]!=0){
				File1.WriteLine(@"\begin Residuos de fotocoordenadas");
				escribe_residuos(File1, &pCurrentConfig->Cresiduosf);
				File1.WriteLine(@"\end");
			}
			if(MostrarInternos[9]!=0){
				File1.WriteLine(@"\begin Distorsion");
				escribe_residuos(File1, &pCurrentConfig->Cdistorsion);
				File1.WriteLine(@"\end");
			}
			if(MostrarInternos[10]!=0){
				File1.WriteLine(@"\begin Residuos de cc.pp.,P");
				escribe_residuos(File1, &pCurrentConfig->CresiduoscpP);
				File1.WriteLine(@"\end");
			}
			if(MostrarInternos[11]!=0){
				File1.WriteLine(@"\begin Residuos de cc.pp.,G");
				//escribe_giro(File1, &pCurrentConfig->Cresiduosf);
				File1.WriteLine(@"\end");
			}
			if(MostrarInternos[12]!=0){
				File1.WriteLine(@"\begin Residuos de puntosA");
				escribe_residuos(File1, &pCurrentConfig->CresiduospA);
				File1.WriteLine(@"\end");
			}
			if(MostrarInternos[13]!=0){
				File1.WriteLine(@"\begin Residuos de puntosC");
				escribe_residuos(File1, &pCurrentConfig->CresiduospC);
				File1.WriteLine(@"\end");
			}

			File1.WriteLine();
			if(MostrarInternos[0]!=0){
				File1.WriteLine(@"\begin Textos de fotogramas");
				File1.WriteLine("Size "+pCurrentConfig->CTfotogramas.lfont.lfHeight.ToString());
				if(pCurrentLogic->c_Tfotogramas_from_ccpp){
					File1.WriteLine("ColorFrom ccpp");
				}else if(pCurrentLogic->c_Tfotogramas_from_fotogramas){
					File1.WriteLine("ColorFrom fotogramas");
				}else{
					File1.WriteLine("Color "+pCurrentConfig->CTfotogramas.color.ToString("X06"));
				}
				File1.WriteLine(@"\end");
			}

			if(MostrarInternos[1]!=0){
				File1.WriteLine(@"\begin Textos de puntos");
				File1.WriteLine("Size "+pCurrentConfig->CTpuntosM.lfont.lfHeight.ToString());
				if(!pCurrentLogic->c_TpuntosM_from_puntosM) File1.WriteLine("Color "+pCurrentConfig->CTpuntosM.color.ToString("X06"));
				File1.WriteLine(@"\end");
			}

			if(MostrarInternos[2]!=0){
				File1.WriteLine(@"\begin Textos de puntosA");
				if(!pCurrentLogic->CTpuntosA_from_puntosM){
					File1.WriteLine("Size "+pCurrentConfig->CTpuntosA.lfont.lfHeight.ToString());
				}
				if(!pCurrentLogic->c_TpuntosAc_from_puntosAc) File1.WriteLine("Color "+pCurrentConfig->CTpuntosA.color.ToString("X06"));
				File1.WriteLine(@"\end");
				if(!pCurrentLogic->c_TpuntosAi_from_puntosAi){
					File1.WriteLine(@"\begin Textos de puntosAi");
					File1.WriteLine("Color "+pCurrentConfig->colorTpuntosAi.ToString("X06"));
					File1.WriteLine(@"\end");
				}
			}

			if(MostrarInternos[3]!=0){
				File1.WriteLine(@"\begin Textos de puntosC");
				if(!pCurrentLogic->CTpuntosC_from_puntosA || MostrarInternos[2]==0){
					File1.WriteLine("Size "+pCurrentConfig->CTpuntosC.lfont.lfHeight.ToString());
				}
				if(!pCurrentLogic->c_TpuntosCc_from_puntosCc) File1.WriteLine("Color "+pCurrentConfig->CTpuntosC.color.ToString("X06"));
				File1.WriteLine(@"\end");
				if(!pCurrentLogic->c_TpuntosCi_from_puntosCi){
					File1.WriteLine(@"\begin Textos de puntosCi");
					File1.WriteLine("Color "+pCurrentConfig->colorTpuntosCi.ToString("X06"));
					File1.WriteLine(@"\end");
				}
			}

			File1.Close();
		}
//		void escribe_segmento(StreamWriter File1, ref Config_segmento CSegmento){
//			File1.WriteLine("Escala "+CSegmento.escala.ToString());
//			File1.WriteLine("Color "+CSegmento.lpen.color.ToString("X06"));
//		}
		void escribe_precisiones(StreamWriter File1, ConfigPrecisionXYZ* pCprecision){
			File1.WriteLine(@"\begin Elipses");
			File1.WriteLine("Escala "+pCprecision->Celipse.escala.ToString());
			File1.WriteLine("Color "+pCprecision->Celipse.lpen.color.ToString("X06"));
			File1.WriteLine(@"\end");
			File1.WriteLine(@"\begin Segmentos");
			File1.WriteLine("Escala "+pCprecision->Csegmento.escala.ToString());
			File1.WriteLine("Color "+pCprecision->Csegmento.lpen.color.ToString("X06"));
			File1.WriteLine(@"\end");
		}
		void escribe_residuos(StreamWriter File1, ConfigResiduo* pCresiduo){
			File1.WriteLine("Punto "+pCresiduo->punto.ToString());
			File1.WriteLine("Escala "+pCresiduo->segmento.escala.ToString());
			File1.WriteLine("Color "+pCresiduo->segmento.lpen.color.ToString("X06"));
		}
	#endregion
	#endregion
#endif

	#region Pintar
		private void ParentForm_LocationChanged(object sender,EventArgs e){
			if(this.ParentForm.Location.X<-10000) return;
			Rectangle former=Picture1.FormerPos;
			if(Picture1.Size==former.Size)	//No funciona
				Picture1.set_FormerPosLocation(Picture1.PointToScreen(Picture1.ClientRectangle.Location));
		}
		private void Picture1_SizeChanged(object sender,EventArgs e){
			if(titulo==null) return;
			Point dd, DD;
			Point p;
			Rectangle former=Picture1.FormerPos;

			p=Picture1.PointToScreen(Picture1.ClientRectangle.Location);
			dd=p-new Size(former.Location);
			DD=dd+Picture1.ClientRectangle.Size-former.Size;
			if(modoaj){
				unsafe{fixed(InterComGrafico.Vista* pvista=&vista0){
					InterComGrafico.V_cambia_tamanno_ventana(pvista,dd.X,dd.Y,DD.X,DD.Y);
					InterComGrafico.calcula_sis_lienzo_ajustado(pvista,0.1F);
				}}
				if(dd.X>=0 && dd.Y>=0 && DD.X<=0 && DD.Y<=0) redibuja();
			}else{
				if(dd.X!=0 || dd.Y!=0) InterComGrafico.clear_fondo(Picture1.Handle);
				desplaza(dd.X,dd.Y,DD.X,DD.Y);
				if(dd.X!=0 || dd.Y!=0) copia();
			}
		}

	#region Paint
		private void Picture1_myPaint(object sender,PaintEventArgs e){
			if(titulo==null){
				InterComGrafico.clear_fondo(Picture1.Handle);
				return;
			}

			/*if(modoaj){
				dibuja_y_copia(2);
				return;
			}*/
			InterComGrafico.RectVentana rect;
			rect.x0=e.ClipRectangle.X;
			rect.y0=e.ClipRectangle.Y;
			rect.ancho=e.ClipRectangle.Width;
			rect.alto=e.ClipRectangle.Height;
			copia(rect);
		}

		internal void redibuja(){
			if(titulo==null) return;
			byte reason;
			if(modoaj) reason=2;
			else reason=1;
			dibuja_y_copia(reason);
		}
		internal void redibuja(ConfiguracionEspecial* pE){
			if(titulo==null) return;
			pCE=pE;
			dibuja_y_copia(3);
		}
		unsafe internal void dibuja(byte reason, InterComGrafico.RectVentana rect){
			fixed(InterComGrafico.Vista* pvista=&vista0){
				InterComGrafico.dibuja_nuevo(grafico,pvista,reason,rect,res_subpixel,pCE);
			}
		}
		internal void dibuja_y_copia(byte reason){
			dibuja_y_copia(reason,Picture1.ClientRectangle);
		}
		internal void dibuja_y_copia(byte reason, InterComGrafico.RectVentana rect){
			if(reason!=0) rect=Picture1.ClientRectangle;
			dibuja(reason,rect);
			copia(rect);
		}
		internal void copia(){copia(Picture1.ClientRectangle);}
		internal void copia(InterComGrafico.RectVentana rect){
			InterComGrafico.Lienzo l;
			l.matriz=vista0.lienzo.matriz;
			l.nrows=vista0.lienzo.nrows;
			l.ncols=vista0.lienzo.ncols;
			rect.x0+=vista0.ventana.mx;
			rect.y0+=vista0.ventana.my;

			InterComGrafico.pinta_rectangulo(Picture1.Handle,vista0.ventana.mx,vista0.ventana.my, l,rect);
		}

	#endregion
	#endregion

	#region Mover

	#region Move_arrows
		private void MoveH_Down(object sender,MouseEventArgs e){
			if(titulo==null) return;

			if(sender==(object)MoveLeft) press_button=0;
			else press_button=1;
			resto=0;
			MoveH_one(this,EventArgs.Empty);
			Timer1.Tick+=new EventHandler(MoveH_one);
			Timer1.Start();
		}
		private void MoveH_Up(object sender,MouseEventArgs e){
			if(titulo==null)  return;

			Timer1.Stop();
			Timer1.Tick-=new EventHandler(MoveH_one);
			try{Timer1.Tick-=new EventHandler(MoveH_one);}	//El ratn puede quedarse pillado
			catch(Exception){}		//y habr 2 Mouse_Down por un Mouse_Up
			resto=0;
		}
		private void MoveH_one(object sender,EventArgs e){
			if(titulo==null)  return;
			float delta=Picture1.Width*0.015F+resto;
			int ndelta=(int)(delta+0.5F);
			resto=delta-(float)ndelta;
			if(press_button==0) ndelta=-ndelta;
			desplaza(ndelta,0,ndelta,0);
			copia();

		}
		private void MoveV_Down(object sender,MouseEventArgs e){
			if(titulo==null)  return;
			if(sender==(object)MoveUp) press_button=0;
			else press_button=1;
			resto=0;
			MoveV_one(this,EventArgs.Empty);
			Timer1.Tick+=new EventHandler(MoveV_one);
			Timer1.Start();
		}
		private void MoveV_Up(object sender,MouseEventArgs e){
			if(titulo==null) return;

			Timer1.Stop();
			Timer1.Tick-=new EventHandler(MoveV_one);
			try{Timer1.Tick-=new EventHandler(MoveV_one);}	//El ratn puede quedarse pillado
			catch(Exception){}		//y habr 2 Mouse_Down por un Mouse_Up
			resto=0;
		}
		private void MoveV_one(object sender,EventArgs e){
			if(titulo==null)  return;
			float delta=Picture1.Height*0.015F+resto;
			int ndelta=(int)(delta+0.5F);
			resto=delta-(float)ndelta;
			if(press_button==0) ndelta=-ndelta;
			desplaza(0,ndelta,0,ndelta);
			copia();
		}
	#endregion

	#region vista
		internal void desplaza(int dx, int dy, int DX, int DY){
			modoaj=false;
		fixed(InterComGrafico.Vista *pvista=&vista0){
			InterComGrafico.V_cambia_tamanno_ventana(pvista,dx,dy,DX,DY);
			
			InterComGrafico.RectVentana rect, rect0;
			if(dy<0){
				rect.x0=0; rect.y0=0;
				rect.alto=-dy;
				rect.ancho=Picture1.Width;
				InterComGrafico.obtiene_invalido(pvista,rect,&rect0);
				if(rect0.alto!=0) dibuja(0,rect0);
			}
			if(DY>0){
				rect.x0=0; rect.y0=Picture1.Height-DY;
				rect.alto=DY;
				rect.ancho=Picture1.Width;
				InterComGrafico.obtiene_invalido(pvista,rect,&rect0);
				if(rect0.alto!=0) dibuja(0,rect0);
			}
			if(dx<0 || DX>0){
				if(dy<0) rect.y0=-dy;	else rect.y0=0;
				rect.alto=Picture1.Height-rect.y0;
				if(DY>0) rect.alto-=DY;
				if(dx<0){
					rect.x0=0;
					rect.ancho=-dx;
					InterComGrafico.obtiene_invalido(pvista,rect,&rect0);
					if(rect0.alto!=0) dibuja(0,rect0);
				}
				if(DX>0){
					rect.x0=Picture1.Width-DX;
					rect.ancho=DX;
					InterComGrafico.obtiene_invalido(pvista,rect,&rect0);
					if(rect0.alto!=0) dibuja(0,rect0);
				}
			}
		}}

		private void Ajustar_Click(object sender,System.EventArgs e){
			Picture1.Focus();	//So that it is removed from the pressed button
			modoaj=true;
			unsafe{fixed(InterComGrafico.Vista* pvista=&vista0){
				InterComGrafico.calcula_sis_lienzo_ajustado(pvista,0.1F);
			}}
			redibuja();
		}

		private void ZoomVentana_do(float xmin,float ymin,float xmax,float ymax){
			modoaj=false;
			int nret;
			unsafe{fixed(InterComGrafico.Vista* pvista=&vista0){
				nret=InterComGrafico.V_zoom(pvista,xmin,ymin,xmax,ymax);
			}}
			if(nret!=0) return;
			redibuja();
			if((xmin+xmax)!=Picture1.Width || (ymin+ymax)!=Picture1.Height)
				Cursor.Position=Picture1.PointToScreen(new Point(Picture1.Width/2,Picture1.Height/2));
		}

		private void Zmas_Click(object sender,System.EventArgs e){
			float x4,y4;
			Picture1.Focus();
			if(titulo==null) return;

			x4=Picture1.Width*0.25F;
			y4=Picture1.Height*0.25F;
			ZoomVentana_do(x4,y4,Picture1.Width-x4,Picture1.Height-y4);
		}
		private void Zmenos_Click(object sender,System.EventArgs e){
			float x2,y2;
			Picture1.Focus();
			if(titulo==null) return;

			x2=Picture1.Width*0.5F;
			y2=Picture1.Height*0.5F;
			ZoomVentana_do(-x2,-y2,Picture1.Width+x2,Picture1.Height+y2);
		}
		private void Zlupa_do(float X,float Y){
			float x4,y4;
			x4=Picture1.Width*0.25F;
			y4=Picture1.Height*0.25F;
			ZoomVentana_do(X-x4,Y-y4,X+x4,Y+y4);
		}
		protected override void OnMouseWheel(MouseEventArgs e){
			base.OnMouseWheel(e);
			if(titulo==null) return;

			float X,Y;
			Point p=this.PointToClient(Picture1.PointToScreen(new Point(0,0)));
			X=(float)(e.X-p.X)+0.5F;
			Y=(float)(e.Y-p.Y)+0.5F;
			if(e.Delta>0){
				float x2,y2;
				x2=Picture1.Width*0.420448F;
				y2=Picture1.Height*0.420228F;
				ZoomVentana_do(X-x2,Y-y2,X+x2,Y+y2);
			}else{
				float x2,y2;
				x2=Picture1.Width*0.594604F;
				y2=Picture1.Height*0.594604F;
				ZoomVentana_do(X-x2,Y-y2,X+x2,Y+y2);
			}
		}
	#endregion
	#endregion

	#region Buscar
		private void BBuscar_Click(object sender,System.EventArgs e){
			FormBuscar1.Show();
		}
	#endregion

	#region Ver, Representacion
	#if !NUEVO
		private void VElementos_Click(object sender,System.EventArgs e){
			if(existcambiado){
				set_Mostrar_de_exist();
				FormElementos1.reset(MostrarInternos);
			}
			FormElementos1.Actualiza(pCurrentConfig,pCurrentLogic);
			//I cannot get the address inside FormElementos1 by &PanelPadre.CurrentConfig (even if I'm requiring the address of exactly the same object, since PanelPadre is a reference). This fu... C#
			//the structures CurrentConfig and CurrentLogic are not fixed any more,
			//so the stored pointers at FormElementos1 may become obsolete.
			//But this *&%$ language does not leave me any other option
			//The documentation about value/reference is full of lies, and the language full of holes
			//12-2008 Changed CurrentConfig/Logic to pointers to unmanaged memory. The above no longer applies; no problems any more
			FormElementos1.Show();
		}
		void set_Mostrar_de_exist(){
			int i;
			MostrarInternos[0]=1;
			MostrarInternos[1]=byteInternos[1];
			MostrarInternos[2]=byteInternos[2];
			MostrarInternos[3]=byteInternos[3];
			if((MostrarInternos[6]=byteInternos[6])!=0)
				MostrarInternos[5]=1;
			else MostrarInternos[5]=byteInternos[5];
			if(MostrarInternos[6]!=0) MostrarInternos[4]=1;
			else MostrarInternos[4]=byteInternos[4];

			for(i=8;i<14;i++)
				MostrarInternos[i]=byteInternos[i];
			existcambiado=false;
		}
	#endif
	#endregion

	#region Maneja ConfigEspecial
		internal void borra_ConfigEspecial()
		{
			if(pCE!=null){Marshal.FreeHGlobal(new IntPtr(pCE)); pCE=(ConfiguracionEspecial*)0;}
			nCE=-1;
		}
		internal void reinicia_ConfigEspecial(){
			if(pCE!=null) Marshal.FreeHGlobal(new IntPtr(pCE));
			pCE=(ConfiguracionEspecial*)Marshal.AllocHGlobal(sizeof(ConfiguracionEspecial));
			nCE=0;
			pCE[0].elemento=unchecked((uint)-1);  pCE[0].tipo=0;
		}
		internal void libera_ConfigEspecial(){
			int i;
			for(i=0;i<nCE;i++){
				if(pCE[i].tipo==1) pCE[i].tipo=0;
			}
		}
		internal void libera_ConfigEspecial(short tipo){
			int i;
			for(i=0;i<nCE;i++){
				if(pCE[i].tipo==tipo) pCE[i].tipo=0;
			}
		}
		internal void libera_ConfigEspecial(uint n,short tipo){
			int i;
			for(i=0;pCE[i].elemento<n;i++);
			for(;pCE[i].elemento==n;i++){
				if(pCE[i].tipo==tipo) pCE[i].tipo=0;
			}
		}
		internal int busca_ConfigEspecial(uint n,short tipo){
			int i;
			for(i=0;pCE[i].elemento<n;i++);
			for(;pCE[i].elemento==n;i++){
				if(pCE[i].tipo==tipo) return i;
			}
			return -1;
		}
		internal int busca_y_libera_ConfigEspecial(uint n,short tipo){
			int i;
			for(i=0;pCE[i].elemento<n;i++);
			for(;pCE[i].elemento==n;i++){
				if(pCE[i].tipo==tipo){pCE[i].tipo=0; return i;}
			}
			return -1;
		}
		internal void inserta_ConfigEspecial(uint n,uint tipo, int valor){
			int i,j,icero;
			int size;
			for(i=0;pCE[i].elemento<n;i++);
			if(pCE[i].elemento==n){
				for(;pCE[i].elemento==n && pCE[i].tipo!=0 && pCE[i].tipo!=tipo;i++);
				if(i<nCE && pCE[i].tipo==0){
					icero=i;	//Acordarse de dnde hay un cero libre
					for(;pCE[i].elemento==n && pCE[i].tipo!=tipo;i++);
					if(pCE[i].elemento!=n) i=icero;
				}
			}
			if(!(pCE[i].elemento==n || (i<nCE && pCE[i].tipo==0))){
				nCE++;
				size=(nCE+1)*sizeof(ConfiguracionEspecial);
				pCE=(ConfiguracionEspecial*)Marshal.ReAllocHGlobal(new IntPtr((void*)pCE),new IntPtr((void*)&size)).ToPointer();
				for(j=nCE;j>i;j--) pCE[j]=pCE[j-1];
			}
			pCE[i].elemento=n;  pCE[i].tipo=tipo;  pCE[i].valor=valor;
		}
	#endregion

	#region Herramientas_Click
		private void Lupa_Click(object sender,System.EventArgs e){
			Picture1.Focus();
			if(titulo==null) return;
			ordenw.orden=OrdenesW.Lupa;
			ordenw.estado=0;
			Picture1.Cursor=CursorLupa;
		}
		/*private void ZVentana_Click(object sender,System.EventArgs e){
			Picture1.Focus();
			if(titulo==null) return;
			ordenw.orden=2; ordenw.estado=0;
			Picture1.Cursor=CursorCruzHV;
		}*/

		private void Informacion_Click(object sender,System.EventArgs e){
			Picture1.Focus();
		#if !NUEVO
			if(tamanno==0) return;
		#else
			if(titulo==null) return;
		#endif
			clear_orden_w(false);
			ordenana.orden=OrdenesAna.Infor;
			if(nElementos==0) ordenana.estado=0;
			else ordenana.estado=1;
			Picture1.Cursor=CursorInformacion_net;
		}
		private void Texto_Click(object sender,System.EventArgs e){
			Picture1.Focus();
		#if !NUEVO
			if(tamanno==0) return;
		#else
			if(titulo==null) return;
		#endif
			clear_orden_w(false);
			ordenana.orden=OrdenesAna.Texto;
			if(nElementos==0) ordenana.estado=0;
			else ordenana.estado=1;
			Picture1.Cursor=CursorTexto_net;
		}
	#endregion

	#region Busca/SeleccionaElementos
		bool BuscaSelecciona(int x,int y){
			BuscaElementos(x,y);
			if(nElementos==0) return false;
			ResaltaElemento();
			return true;
		}
		unsafe private void BuscaElementos(int x,int y){
			if(nElementos!=0){
				InterComGrafico.graficos_free(listadeElementos);
				listadeElementos=System.IntPtr.Zero;
			}
			nElementos=0; telemento=0;
		#if !NUEVO
			fixed(System.IntPtr* pl=&listadeElementos){fixed(int* pn=&nElementos){
			fixed(InterComGrafico.Transf_Terr_ventana* t=&Transf){
				InterComGrafico.selecciona_elementos_viejo(pfdibujo,otherdata,tamanno,x,y,CurrentConfig2.radio,t,pl,pn,pCurrentConfig);
			}}}
		#else
			/*fixed(InterComGrafico.FicheroGrafico* pf=&str_fichero){
			fixed(System.IntPtr* pl=&listadeElementos){fixed(int* pn=&nElementos){
			fixed(InterComGrafico.Vista* pvista=&vista0){fixed(InterComGrafico.ConfiguracionGrafico* pconfig=&graf_cfg){
				InterComGrafico.selecciona_elementos(Picture1.Handle,pf,pvista,x,y,CurrentConfig2.radio,pl,pn,pconfig,pCE);
			}}}}}*/
		#endif
			telemento=0;
		}
		private void ResaltaElemento(){
			libera_ConfigEspecial();
			inserta_ConfigEspecial(((uint*)listadeElementos.ToPointer())[telemento],1,0x00FFFFFF);//(int)graf_cfg.resalte);
		#if !NUEVO
			redibuja();
		#else
			//redibuja(1);
		#endif
		}
	#endregion

	#region Seleccionar un elemento del fichero por orden directa
		internal void encuentra(uint i){	//selecciona el elemento i del fichero
			elimina_seleccionados();
			libera_ConfigEspecial();
			if(nElementos!=0){
				InterComGrafico.graficos_free(listadeElementos);
				listadeElementos=System.IntPtr.Zero;
			}
			unsafe{fixed(System.IntPtr* pl=&listadeElementos){
				InterComGrafico.selecciona_elemento(pl,i);
			}}
			nElementos=1;
			telemento=0;
		#if !NUEVO
			unsafe{fixed(InterComGrafico.Transf_Terr_ventana* t=&Transf){
				InterComGrafico.situa_en_elemento(pfdibujo,otherdata,tamanno,t,i);
			}}
		#endif
			seleccionado_in_order();
			inserta_ConfigEspecial(i,1,0x00FFFFFF);//(int)graf_cfg.resalte);
		#if !NUEVO
			redibuja();
		#else
			//redibuja(1);
		#endif
		}
		void seleccionado_in_order(){
			//jump over orden_w
			if(ordenana.orden!=0){
				switch(ordenana.orden){
					case OrdenesAna.Infor: ordenana.estado=1; break;
					case OrdenesAna.Texto: ordenana.estado=1; break;
				}
				return;
			}
		}
	#endregion

	private void Picture1_MouseDown(object sender,System.Windows.Forms.MouseEventArgs e){
			if(titulo==null) return;
			if(e.Button!=MouseButtons.Left) return;

			if(ordenctr.orden!=0){
				if(ordenctr.estado!=0) return;
				ordenctr.Xdown=e.X;
				ordenctr.Ydown=e.Y;
				switch(ordenctr.orden){
				case OrdenesCtr.Mano:
					Picture1.Cursor=CursorPuno;
					ordenctr.estado=1;
					break;
				}
				return;
			}
			if(ordenw.orden!=0){
				if(ordenw.estado!=0) return;
				ordenw.Xdown=e.X;
				ordenw.Ydown=e.Y;
				switch(ordenw.orden){
					case OrdenesW.Lupa: Zlupa_do(e.X+0.5F,e.Y+0.5F); break;
					case OrdenesW.Ventana:
						/*ordenw.estado=1;*/
						break;
				}
				return;
			}
			if(ordenana.orden!=0){
				if(ordenana.estado==0){
					ordenana.Xdown=e.X;
					ordenana.Ydown=e.Y;
				}
				switch(ordenana.orden){
					case OrdenesAna.Infor:
						if(ordenana.estado==0){if(BuscaSelecciona(e.X,e.Y)) ordenana.estado=1;}
						else Mostrar_Informacion();
						break;
					case OrdenesAna.Texto:
						if(ordenana.estado==0){if(BuscaSelecciona(e.X,e.Y)) ordenana.estado=1;}
						else Mostrar_Texto();
						break;
				}
				return;
			}
			/*if(ordeneedit.orden!=0){
			}*/
			{Keys prov=keystate;
			keystate=Keys.Control; reset_orden_ctr();
			keystate=prov;}
			Picture1_MouseDown(sender,e);
		}

	#region MouseMove
		private void Picture1_MouseMove(object sender,System.Windows.Forms.MouseEventArgs e){
			InterComGrafico.punto_Dbl pp;
			sbyte dd;
			string sdec;
			if(titulo==null) return;

			unsafe{fixed(InterComGrafico.Vista* pv=&vista0){
					pp=InterComGrafico.V_ventana_a_interno(pv,e.X+0.5F,e.Y+0.5F);
					InterComGrafico.interno_a_terreno(&pp,grafico.otherdata);
			}}
			dd=decX; if(decX<0) dd=3;
			sdec="F"+dd.ToString();
			LabelCoordenadaX.Text=pp.X.ToString(sdec);
			dd=decY; if(decY<0) dd=3;
			sdec="F"+dd.ToString();
			LabelCoordenadaY.Text=pp.Y.ToString(sdec);

			if(ordenctr.orden!=0){
				if(ordenctr.estado==0) return;
				switch(ordenctr.orden){
				case OrdenesCtr.Mano:
					int dx,dy;
					dx=ordenctr.Xdown-e.X;
					dy=ordenctr.Ydown-e.Y;
					desplaza(dx,dy,dx,dy);
					copia();
					break;
				}
				ordenctr.Xdown=e.X;
				ordenctr.Ydown=e.Y;
				return;
			}
			if(ordenw.orden!=0){
				if(ordenw.estado==0) return;
				switch(ordenw.orden){
				case OrdenesW.Ventana: //zventana
					break;
				default: return;
				}
				ordenw.Xdown=e.X;
				ordenw.Ydown=e.Y;
				return;
			}
			if(ordenana.orden!=0){
				if(ordenana.estado==0) return;
				switch(ordenana.orden){
					default: return;
				}
				/*ordenana.Xdown=e.X;
				ordenana.Ydown=e.Y;
				return;*/
			}
			//no ordenedit yet
			return;
		}
	#endregion

	#region MouseUp y fin de orden
		private void Picture1_MouseUp(object sender,System.Windows.Forms.MouseEventArgs e){
			if(titulo==null) return;
			if(ordenctr.orden!=0){
				//No hay rdenes que se repiten
				reset_orden_ctr();
				return;
			}
			if(ordenw.orden!=0){
				ordenw.estado=0;
				if(e.Button==MouseButtons.Left){
					if(ordenw.orden==OrdenesW.Lupa) return;		//rdenes que se repiten
					ordenw.orden=0;
					fallto_orden_ana();
				}
				else if(e.Button==MouseButtons.Right){
					ordenw.orden=0;
					fallto_orden_ana();
				}
				return;
			}

			if(ordenana.orden!=0){
				if(e.Button!=MouseButtons.Right) return;
				if(ordenana.estado==1){
					if(nElementos==0 || ++telemento==nElementos){limpia(); ordenana.estado=0;}
					else{ResaltaElemento();}
				}else{
					ordenana.orden=0;
					fallto_orden_e();
				}
				return;
			}
		}
		void fallto_orden_w(){
			switch(ordenw.orden){
				case OrdenesW.Lupa: Picture1.Cursor=CursorLupa; return;
				case OrdenesW.Ventana:
					//Picture1.Cursor=CursorCruzHV;
					return;
			}
			fallto_orden_ana();
		}
		void fallto_orden_ana(){
			if(ordenana.orden==0){fallto_orden_e(); return;}
			switch(ordenana.orden){
				case OrdenesAna.Infor:
					Picture1.Cursor=CursorInformacion_net;
					break;
				case OrdenesAna.Texto:
					Picture1.Cursor=CursorTexto_net;
					break;
			}
		}
		void fallto_orden_e(){
			//if(ordenedit.orden==0){
				Picture1.Cursor=Cursors.Default;
				return;
			//}
		}

		void clear_orden_w(bool bcur){
			if(ordenw.orden==OrdenesW.Ventana){
				//
			}
			ordenw.orden=0; ordenw.estado=0;
			if(bcur) Picture1.Cursor=CursorMano;
		}

		void elimina_seleccionados(){
			if(nElementos!=0){
				InterComGrafico.graficos_free(listadeElementos);
				listadeElementos=System.IntPtr.Zero;
			}
			nElementos=0; telemento=0;
		}
		void limpia(){
			elimina_seleccionados();
			libera_ConfigEspecial();
		#if !NUEVO
			redibuja();
		#else
			//redibuja(1);
		#endif
		}
	#endregion

	#region Ejecutar rdenes
		private void Mostrar_Informacion(){
			if(nElementos<=telemento) return;
			uint n;
			InterComGrafico.InformaciondeElemento infor;
			libera_ConfigEspecial();
			unsafe{
				n=((uint*)listadeElementos.ToPointer())[telemento];
			#if !NUEVO
				InterComGrafico.devuelve_informacion_viejo(pfdibujo,otherdata,tamanno,n,&infor,idioma);
			#else
				InterComGrafico.devuelve_informacion(grafico,n,&infor,(byte)idioma);
			#endif
				if(infor.tipo==255)goto @return;
			}

			string nombre_tipo=Marshal.PtrToStringUni(infor.nombre_tipo);
			string nombre;
			switch(idioma){
				case Idioma.Eng: nombre_tipo+=" (Type "; break;
				case Idioma.It: nombre_tipo+=" (Tipo "; break;
				default:nombre_tipo+=" (Tipo "; break;
			}
			nombre_tipo+=(infor.tipo&0xFF).ToString()+")";
			switch(idioma){
				case Idioma.Eng: nombre="Name"; break;
				case Idioma.It: nombre="Nome"; break;
				default:nombre="Nombre"; break;
			}
			FormInfoElemento1.Show();
			FormInfoElemento1.Focus();
			FormInfoElemento1.DisplayInfo(nombre_tipo,Marshal.PtrToStringUni(infor.nombre_subtipo),nombre,Marshal.PtrToStringAnsi(infor.nombre),infor.extremos,decX,Marshal.PtrToStringAnsi(infor.descripcion));
		@return:
		#if NUEVO
			if(infor.nombre_subtipo!=IntPtr.Zero) InterComGrafico.graficos_free(infor.nombre_subtipo);
		#endif
			if(infor.nombre!=IntPtr.Zero) InterComGrafico.graficos_free(infor.nombre);
			if(infor.descripcion!=IntPtr.Zero) InterComGrafico.graficos_free(infor.descripcion);
			if(infor.adicional!=IntPtr.Zero) InterComGrafico.graficos_free(infor.adicional);
			limpia();
			ordenana.estado=0;
		}

		private void Mostrar_Texto(){
			uint n;
			int i;
			if(nElementos<=telemento) return;
			libera_ConfigEspecial();
			unsafe{
				n=((uint*)listadeElementos.ToPointer())[telemento];
				i=busca_y_libera_ConfigEspecial(n,4);
				if(i==-1) inserta_ConfigEspecial(n,4,0);
			}
			limpia();
			ordenana.estado=0;
		}
	#endregion

		protected override void colores(){
			base.colores();
			this.panelBottom.BackColor=Globales.Colores.NETColor(Colores.cBoton);
			this.PanelTop.BackColor=Globales.Colores.NETColor(Colores.cForm);
			TreeOnOff.BackColor=Globales.Colores.NETColor(Colores.cFormLabel);
		}

	#region etiquetas_idiomas
		protected override void etiquetas_esp(){
			ParentForm.Name="Grfico";
			if(titulo==null) ParentForm.Text="Grfico";
			MessageBoxAT.Caption="Grfico";

			base.etiquetas_esp();
			AAbrir.Text="Abrir...";
			ACerrar.Text="Cerrar";
			AAbrirConfiguracion.Text= "Abrir configuracin...";
			AGuardarConfiguracion.Text= "Guardar configuracin...";
			AGuardarConfigDefecto.Text= "Guardar la configuracin actual como configuracin por defecto...";
			AExportar.Text="Exportar...";
			AAcercade.Text= "Acerca de Grfico";
			ManualPath= "Manuales_html\\esp\\Grafico.htm";
			FormAcercade1.titulo="Acerca de Grfico";
			FormAcercade1.cabecera="Editor de grficos de Aerotri";
			FormAcercade1.fecha="16 de mayo de 2011";

			PanelMenu1.gLabels("Ver").Text="Ver";
			VElementos.Text="Representacin de elementos...";
			PanelMenu1.gLabels("Buscar").Text="Buscar";
			BBuscar.Text="Buscar...";
		}
		protected override void etiquetas_eng(){
			ParentForm.Name="Graphic";
			if(titulo==null) ParentForm.Text="Graphic";
			MessageBoxAT.Caption="Graphic";

			base.etiquetas_eng();
			AAbrir.Text="Open...";
			ACerrar.Text="Close";
			AAbrirConfiguracion.Text= "Open configuration...";
			AGuardarConfiguracion.Text= "Save configuration...";
			AGuardarConfigDefecto.Text= "Save current configuration as default...";
			AExportar.Text="Export...";
			AAcercade.Text= "About Graphic";
			ManualPath= "Manuales_html\\eng\\Graphic.htm";
			FormAcercade1.titulo="About Graphic";
			FormAcercade1.cabecera="Aerotri graphics editor";
			FormAcercade1.fecha="May 16, 2011";

			PanelMenu1.gLabels("Ver").Text="View";
			VElementos.Text="Element representation...";
			PanelMenu1.gLabels("Buscar").Text="Find";
			BBuscar.Text="Find...";
		}
		protected override void etiquetas_it(){

			ParentForm.Name="Grafico";
			if(titulo==null) ParentForm.Text="Grafico";
			MessageBoxAT.Caption="Grafico";

			base.etiquetas_it();
			AAbrir.Text="Apri...";
			ACerrar.Text="Chiudi";
			AAbrirConfiguracion.Text= "Apri configurazione...";
			AGuardarConfiguracion.Text= "Salva configurazione...";
			AGuardarConfigDefecto.Text= "Salva la configurazione attuale come la configurazione per difetto...";
			AExportar.Text="Esporta...";
			AAcercade.Text= "Su Grafico";
			ManualPath= "Manuales_html\\it\\Grafico_it.htm";
			FormAcercade1.titulo="Su Grafico ";
			FormAcercade1.cabecera="Editore di grafici di Aerotri";
			FormAcercade1.fecha="16 maggio 2011";

			PanelMenu1.gLabels("Ver").Text="Vedi";
			VElementos.Text="Rappresentazione di elementi...";
			PanelMenu1.gLabels("Buscar").Text="Trova";
			BBuscar.Text="Trova...";
		}
	#endregion

	#region textos
		static readonly string[] textos_esp={
			"Error inesperado al leer el fichero",//20
			null,
			"No es un fichero de grfico de Aerotri",//22
			"No hay ninguna imagen abierta",//23
			"La versin de este fichero de grfico es demasiado reciente para poder abrilo con este visor",//24
			"La versin de este fichero de grfico es demasiado antigua. Debe transformarse a la versin actual.\nDesea transformarlo?",//25
			"Error en la lectura de la informacin de configuracin. Algunas de las opciones de dibujo pueden haberse perdido.\nLa geometra no se ve afectada por esto",//26
			"No hay memoria suficiente para cargar el grfico",//27
			"No hay memoria suficiente; est llena",//28
			"La versin de este fichero de grfico es demasiado antigua",//29
			"Error desconocido en la lectura del fichero",//30
			"Elemento no encontrado",//31
			"El fichero semilla no puede ser el mismo que el fichero exportado",//32
			null,null,null,null,null,null,null,null,
			"La configuracin actual ser asignada a todos los grfico de nueva creacin.",//40
			null,null,null,null,null,null,null,null,null,//49
			"Saving the file",//50
			"Leyendo el fichero de configuracin",//51
			"Escribiendo el fichero de configuracin",//52
		};
		static readonly string[] textos_eng={
			"Unexpected error when reading the file",//20
			null,
			"It is not an Aerotri graphic file",//21
			"There isn't any opened image",//22
			"The version of this graphic file is too recent to be opened with this viewer",//23
			"The version of this graphic file is too old. It should be transformed to the current version before opening.\nDo you wish to transform it?",//24
			"Error reading the configuration information. Some drawing options may have been lost.\nThe geometry is not affected by this",//25
			"Not enough memory to load the graphic",//26
			"Run out of memory; the memory is full",//27
			"The version of this graphic file is too old",//28
			"Unknown error when reading the file",//29
			"Element not found",//30
			"The seed file cannot be the same as the exported file",//31
			null,null,null,null,null,null,null,null,
			"The current configuration will be assigned to every newly created graphic.",//40
			null,null,null,null,null,null,null,null,null,//49
			"Salvando il file",//50
			"Reading the configuration file",//51
			"Writing the configuration file",//52
		};
		static readonly string[] textos_it={
			"Errore inaspettato nella nella lettura del file",//20
			null,
			"Non  un file di grafico di Aerotri",//21
			"Non c' nessuna immagine aperta",//22
			"La versione di questo file di grafico  troppo recente per potere aprirlo con questo visore",//23
			"La versione di questo file di grafico  troppo vechia. Deve essere trasformato alla versione attuale.\nVuoi trasformarlo?",//24
			"Errore nella lettura dell'informazione di configurazione. Qualche opzione di disegno possono essere perdute.\nLa geometria non viene alterata da questo fatto",//25
			"Non c' memoria abastanza per caricare il grafico",//26
			"La c' memoria abbastanza;  piena",//27
			"La versione di questo file di grafico  troppo vechia",//28
			"Errore sconociuto nella lettura del file",//29
			"Elemento non trovato",//30
			"Il file di seme non pu essere lo stesso che il file esportato",//31
			null,null,null,null,null,null,null,null,
			"La configurazione attuale sar assegnata a tutti i grafici di nuova creazione.",//40
			null,null,null,null,null,null,null,null,null,//49
			"Guardando el fichero",//50
			"Leggendo il file di configurazione",//51
			"Scrivendo il file di configurazione",//52
		};
		internal string global_text(Globales.Textos.Cods cod){
			return Globales.Textos.get_texto(cod,idioma);
		}
		internal string textos(short i){
			if(i>32) return "";

			string txt;
			switch(idioma){
				case Idioma.Eng: txt=textos_eng[i]; break;
				case Idioma.It: txt=textos_it[i]; break;
				default:txt=textos_esp[i]; break;
			}
			if(txt==null) return "";
			return txt;
		}
		internal string textos(short i, string s){
			if(i<20) return Globales.Textos.get_texto(i,s,idioma);
			string txt="";
			switch(idioma){
			 case Idioma.Eng:
				switch(i){
					case 26: txt= "The file "+s+" couldn't be opened for writing"; break;
				}
				break;
			 case Idioma.It:
				switch(i){
					case 26: txt= "Il file "+s+" non ha potuto essere aperto per scriverne"; break;
				}
				break;
			 default:
				switch(i){
					case 26: txt= "No se ha podido abrir el fichero "+s+" para escribir"; break;
				}
				break;
			}
			return txt;
		}
	#endregion
	}
}
