#define NUEVO
using System;
using System.Runtime.InteropServices;

namespace Grafico{
	unsafe public class InterComGrafico{
		//nuevo
		public struct FicheroConfig_ptrs{
			public IntPtr fichero_config0,
					fichero_config1,
					fichero_config2,
					fichero_config3,
					fichero_config4,
					fichero_config5,
					fichero_config6,
					fichero_config7,
					fichero_config8,
					fichero_config9,
					fichero_config10,
					fichero_config11,
					fichero_config12,
					fichero_config13,
					fichero_config14,
					fichero_config15;
		}

		public struct Afin90{
			public double Tx,Ty,lx,ly;
		}
		public struct Extremos2D{
			public double mx,MX,my,MY;
		}
#if NUEVO
		public struct Extremos3D{
			public double mx,MX,my,MY,mz,MZ;
		}
		public struct M33{
			public double m_00,m_01,m_02,
							m_10,m_11,m_12,
							m_20,m_21,m_22;
		}
#else
		public struct Transf_Terr_ventana{
			public System.IntPtr pTc;
			public Afin90 afin90;
			public Extremos2D extremosT,
									extremosI;
			public int minxv, maxxv, minyv, maxyv;
			public float	margeniz,  margende,
							margenar, margenab; //va de 0 a 1; si es >0.5 la imagen sale invertida
			public byte square;	//bool
		}
#endif
#if NUEVO
		unsafe public struct DatosDibujo{	//Para el modelo, para ajbloque
			public System.IntPtr hwnd_graf;
			public byte ConfigDibujo;
		}

		public struct Lienzo{
			public uint *matriz;
			public uint nrows, ncols;
		}
		public struct Vista{
			public struct __0_{
				public byte identity;
				public M33 M;
				public double active_depth;
				public Extremos3D ExtremosV;	//Absolutos de esta vista
				public uint corners; //xbbbxaaa. Los bits aaa indican la esquina que da el valor mnimo para la X_vista.
									//Es el punto (!a_0*mx+a_0*MX, !a_1*my+a_1*MY, !a_2*mZ+a_2*MZ).
									//Anlogamente, bbb indica la esquina que da la mnima Y_vista.
			}
			public struct __1_{
				public int mx,MX,my,MY;		//ventana con respecto al lienzo
			}
			public __0_ sis_vista;
			public Afin90 sis_lienzo;	//vista a lienzo
			public byte square;
			public Extremos2D	minmaxV;	//de lo que se ve en cada momento
			public __1_ ventana;				//vista_a_lienzo(minmaxV)=ventana
			public byte updated;
			public IntPtr pinfo;	//Puntero a informacin grfica almacenada para cada vista. Si !=NULL hay memoria reservada
			public Lienzo lienzo;
		}

		public struct VerInfo{
			public Basicas.Hash ver;		//Los elementos presentes son los que estn off
			public Basicas.Hash verT;	//Los elementos presentes son los que estn on
			public System.IntPtr criterios; //Apunta a un elemento LinkedSeleccionVer
		}

		public struct Gra_FConfiguracion{
			public System.IntPtr files_depend;	//Apunta a un array de const char16_t*
			public struct _0_{
				public System.IntPtr fformas;	//nombre del fichero. char16_t
			};
			public _0_ ficheros;
			public uint fondo,	//color de fondo
						  resalte;	//color de los elementos resaltados
			public System.IntPtr qualitynames;	//Apunta a un array de const char16_t*
			public Basicas.Hash tipos;
			public	System.IntPtr agrupaciones,	//Apunta a un array de 255 punteros
									  jerarquas;		//Apunta a un elemento LinkedJerarquia
			public VerInfo ver;
		}

		public struct LinkedSolvedQuality{
			public LinkedSolvedQuality *next;
			public uint name;
			public uint valor;
		}
		public struct SolvedQualities{		//NULL significa que no se han resuelto. Si se resuelve y no hay ninguna
			public LinkedSolvedQuality *cualidades;	//se apuntar a No_solved_quality, cuyo nombre est a 0.
			public LinkedSolvedQuality *cualid_texto;
		}	
		public struct SolvedSignificados{
			public char *Significado;
			public char *SignificadoR;
		}
		public struct Gra_Configuracion{
			public uint vbyte0;
			public char* nombre;
			public Gra_FConfiguracion *fconfig;
			public IntPtr pformas;	//LinkedGrupoFormas*
			public Basicas.Hash solved;
		}
		public struct Vector_Gra_Configuracion{
			public Gra_Configuracion *ppio;
			public uint n, N;
		}

		public struct LinkedCstring{
			public System.IntPtr next;
			public System.IntPtr s1;
		}

		public struct GraficoCompleto{
			public System.IntPtr fgrafico;
			public System.IntPtr otherdata;
			public Vector_Gra_Configuracion configs;
			public uint kconfig;
			public Gra_Configuracion *pconfig;
		}

		public struct RectVentana{
			public int x0,y0;
			public int alto,ancho;
			public static implicit operator RectVentana(System.Drawing.Rectangle r){
				RectVentana a;
				a.x0=r.Left;
				a.y0=r.Top;
				a.ancho=r.Width;
				a.alto=r.Height;
				return a;
			}
		}
#else
		public struct LOGPEN{
			public uint style;
			public int x;
			public int y;	//unused
			public uint color;
			public void initialize(){
				style=0;
				y=x=0;
				color=0;
			}
			public static bool operator ==(LOGPEN a, LOGPEN b){
				return(a.style==b.style && a.x==b.x && a.y==b.y && a.color==b.color);
			}
			public static bool operator !=(LOGPEN a, LOGPEN b){return !(a==b);}
		}
		public struct LOGFONT{
			public int lfHeight;
			public int lfWidth;
			public int lfEscapement;
			public int lfOrientation;
			public int lfWeight;
			public byte lfItalic;
			public byte lfUnderline;
			public byte lfStrikeOut;
			public byte lfCharSet;
			public byte lfOutPrecision;
			public byte lfClipPrecision;
			public byte lfQuality;
			public byte lfPitchAndFamily;
			System.UInt32 lfFontName0_3, lfFontName4_7, lfFontName8_11, lfFontName12_15;	//Viva el .NET
			System.UInt32 lfFontName16_19, lfFontName20_23, lfFontName24_27, lfFontName28_31;

			public void initialize(){
				lfWidth=0;	lfEscapement=0;
				lfOrientation=0;		lfItalic=0;
				lfUnderline=0;	lfStrikeOut=0;
				lfCharSet=0;	lfClipPrecision=0;
				lfHeight=14;
				lfWeight=400;
				lfOutPrecision=8;
				lfQuality=4;
				lfPitchAndFamily= 1<<4;
				lfFontName0_3= 'T'|'i'<<8 | ('m'|'e'<<8)<<16;
				lfFontName4_7= 's'|' '<<8 | ('N'|'e'<<8)<<16;
				lfFontName8_11= 'w'|' '<<8 | ('R'|'o'<<8)<<16;
				lfFontName12_15= 'm'|'a'<<8 | ('n'|'\0'<<8)<<16;
			}
		}

		public struct RECT{
			public int left;
			public int top;
			public int right;
			public int bottom;
		}

		unsafe public struct DatosDibujo{	//Para el modelo, para ajbloque
			public System.IntPtr hwnd_graf;
			public Transf_Terr_ventana* Transf;
			public byte ConfigDibujo;
			public System.IntPtr* pfdibujo;
			public int* tamanno;
		}
#endif

		public struct Extremos{
			public double Xmin; public double Xmax;
			public double Ymin; public double Ymax;
			public double Zmin; public double Zmax;
		}
		unsafe public struct InformaciondeElemento{
			public uint tipo;
			public System.IntPtr nombre_tipo;		//char16_t
			public System.IntPtr nombre_subtipo;	//char16_t
			public System.IntPtr nombre;		//char
			public Extremos extremos;
			public System.IntPtr descripcion;	//char
			public System.IntPtr adicional;
		}
		public struct punto_Dbl{
			public double X, Y, Z;
		}

		public struct Criterio{
			public byte tipom, tipoM;
			public byte criterio;
			public byte subtipom, subtipoM;
		}

		public struct OpcionesPs{
			public float escala;	//pasa de las unidades del fichero a metros
			public float margen_iz, margen_de;	//en cm
			public float margen_ab, margen_ar;
			public float grueso_lineas;	//pxel/punto
			public float size_formas;	//pxel_forma/punto
		}

		[DllImport("Win_utils.dll")] public static extern void clear_fondo(IntPtr hwnd);
		[DllImport("Win_utils.dll")] public static extern void pinta_rectangulo(IntPtr hwnd, int xv, int yv, Lienzo lienzo, RectVentana rect);
		/*[DllImport("Graficos.dll")] public static extern int transforma_fichero(System.IntPtr fichero,System.IntPtr fichero_n);	//REVISAR
		[DllImport("Graficos.dll")] public static extern int gra_a_dgn(System.IntPtr pfdibujo,int tamanno, System.IntPtr ficherodgn,byte D3, Grafico.ConfiguracionGrafico* C,OpcionesDgn* O,System.IntPtr mensaje,byte idioma);
		[DllImport("Graficos.dll")] public static extern int gra_a_bin(System.IntPtr pfdibujo,int tamanno,Transf_Terr_ventana* t, System.IntPtr ficherobin, Grafico.ConfiguracionGrafico* C,OpcionesDigi* O,System.IntPtr mensaje,byte idioma);*/

		[DllImport("grafico_cargar.dll")] public static extern int carga_fichero(System.IntPtr fichero,IntPtr* pfdibujo);
		[DllImport("grafico_cargar.dll")] public static extern int carga_ficherocfg(System.IntPtr fichero,Gra_FConfiguracion* config, System.IntPtr* ptextos_error, System.IntPtr P_mensaje,byte idioma);
		[DllImport("grafico_cargar.dll")] public static extern int carga_formas(System.IntPtr fichero,System.IntPtr *linked_formas, System.IntPtr P_mensaje,byte idioma);
		[DllImport("grafico_cargar.dll")] public static extern int carga_configuracion(System.IntPtr fichero,Gra_Configuracion* config, System.IntPtr* ptextos_error, System.IntPtr P_mensaje,byte idioma);
		[DllImport("grafico_cargar.dll")] public static extern int carga_todo(System.IntPtr ficherof, GraficoCompleto *grafico);
		[DllImport("grafico_cargar.dll")] public static extern int annade_one_config(Vector_Gra_Configuracion *configs);

		//[DllImport("Graficos.dll")] public static extern void get_next_string(System.IntPtr next,LinkedCstring* returned);
		[DllImport("grafico_cargar.dll")] public static extern void free_fgrafico(System.IntPtr pfdibujo);
		[DllImport("grafico_cargar.dll")] public static extern void free_otherdata(System.IntPtr otherdata);
		[DllImport("grafico_cargar.dll")] public static extern void free_Configgra(Gra_Configuracion *config);
		[DllImport("grafico_cargar.dll")] public static extern void free_all(GraficoCompleto *grafico);
		[DllImport("grafico_cargar.dll")] public static extern void free_linkedStrings(System.IntPtr plist);

		[DllImport("grafico_cargar.dll")] public static extern sbyte retrive_precisionZ(IntPtr pfichero);
		[DllImport("grafico_cargar.dll")] public static extern sbyte retrive_precisionX(IntPtr pfichero, IntPtr otherdata);
		[DllImport("grafico_cargar.dll")] public static extern sbyte retrive_precisionY(IntPtr pfichero, IntPtr otherdata);
		[DllImport("grafico_cargar.dll")] public static extern void interno_a_terreno(punto_Dbl* P, IntPtr otherdata);

		[DllImport("grafico_cargar.dll")] public static extern void get_tipos_presentes(IntPtr pfichero, uint* *ptipos);
		[DllImport("grafico_cargar.dll")] public static extern void Set_Ver_offs(VerInfo *ver,uint* nums);
		[DllImport("grafico_cargar.dll")] public static extern void Set_VerT_ons(VerInfo *ver,uint* nums);

		[DllImport("Graficos.dll")] public static extern int setup_vista_identity(Vista *vista, uint nfilas, uint ncols, System.IntPtr pfichreo, System.IntPtr otherdata);
		[DllImport("Graficos.dll")] public static extern void free_vista(Vista *vista);
		[DllImport("Graficos.dll")] public static extern void calcula_sis_lienzo_ajustado(Vista *vista, float margen);
		[DllImport("Graficos.dll")] public static extern  int V_cambia_tamanno_ventana(Vista *vista, int dx, int dy, int DX, int DY);
		[DllImport("Graficos.dll")] public static extern  int V_zoom(Vista *vista, float x, float y, float X, float Y);
		[DllImport("Graficos.dll")] public static extern  void obtiene_invalido(Vista *lienzo, RectVentana rect, RectVentana *invalido);
		[DllImport("Graficos.dll")] public static extern int dibuja_nuevo(GraficoCompleto grafico, Vista* vista, byte reason, RectVentana rect, byte res_subpixel, ConfiguracionEspecial* CE);
		[DllImport("Graficos.dll")] public static extern punto_Dbl V_ventana_a_interno(Vista *vista, float x,float y);

		[DllImport("Graficos.dll")] public static extern SolvedQualities* get_SolvedQualities(uint Tipo,byte bstipo,Gra_Configuracion *config);
		[DllImport("Graficos.dll")] public static extern SolvedSignificados* get_SolvedSignificados(uint Tipo,byte bstipo,Gra_Configuracion *config);
		/*[DllImport("Graficos.dll")] public static extern System.IntPtr busca_portipo(System.IntPtr otherdata, byte tipom,byte tipoM,byte criterio, byte subtipom,byte subtipoM);
		[DllImport("Graficos.dll")] public static extern int busca_portipo_e_indice(System.IntPtr otherdata, byte tipom,byte tipoM,byte criterio, byte subtipom,byte subtipoM,uint i);
		[DllImport("Graficos.dll")] public static extern System.IntPtr* busca_existentes(System.IntPtr otherdata, Criterio* criterios,uint n, byte* encontrados);*/
		[DllImport("Graficos.dll")] public static extern void selecciona_elementos(System.IntPtr hwnd,IntPtr pfdibujo, Vista* vista, int x,int y,float r, System.IntPtr* pElementos,int* nElementos, Gra_Configuracion* config, ConfiguracionEspecial* CE);
		[DllImport("Graficos.dll")] public static extern void selecciona_elemento(System.IntPtr* pElementos,uint i);	//Simplemente para que la reserva de memoria se haga en la dll graficos.
		//[DllImport("Graficos.dll")] public static extern void situa_en_elemento(System.IntPtr pfdibujo,System.IntPtr otherdata, int tamanno, Transf_Terr_ventana* t, uint i);
		[DllImport("Graficos.dll")] public static extern void devuelve_informacion(GraficoCompleto grafico, uint n,InformaciondeElemento* pInfoElemento,byte idioma);
		[DllImport("Graficos.dll")] public static extern void graficos_free(System.IntPtr pfdibujo);

		[DllImport("Graficos.dll")] public static extern int gra_a_dgn(IntPtr pfdibujo, System.IntPtr ficherodgn,byte D3, Gra_Configuracion* C,OpcionesDgn* O,System.IntPtr mensaje,byte idioma);
		[DllImport("Graficos.dll")] public static extern int gra_a_bin(IntPtr pfdibujo, System.IntPtr ficherobin, Gra_Configuracion* C,OpcionesDigi* O,System.IntPtr mensaje,byte idioma);
		[DllImport("Graficos.dll")] public static extern int gra_a_ps(IntPtr pfdibujo, System.IntPtr ficherops,byte eps, Vista* pv, Gra_Configuracion* C,ConfiguracionEspecial* CE, OpcionesPs *opciones_ps, System.IntPtr mensaje,byte idioma);
	}
}
