#define NUEVO
#if !NUEVO
using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Grafico{

	unsafe class GBoxTexto : GroupBox{
		public System.Windows.Forms.Label		LblColor;
		public System.Windows.Forms.Button	BotColor;
		public System.Windows.Forms.Label		LblSize;
		public System.Windows.Forms.TextBox	TextSize;
		public ConfigTexto* CTexto;
		public ControlesAt.FormColor	Color1;
		protected ControlesAt.EventVoid	redibuja;
		public static Size PreferedSize(){
			return new Size(216,64);
		}

		 public GBoxTexto(FormColor _Color1, EventVoid _redibuja){	//Debera ser ref ConfigTexto, pero luego es imposible asignar la referencia. En fin...
			Color1=_Color1;
			InitializeComponent();
			 redibuja=_redibuja;
		}

		private void InitializeComponent(){
			LblColor= new Label();
			BotColor=new Button();
			LblSize= new Label();
			TextSize= new TextBox();
			this.Size=PreferedSize();
			//
			// LblColor
			LblColor.FlatStyle=FlatStyle.System;
			LblColor.Location= new Point(this.Width-134, 18);
			LblColor.Size= new Size(60, 16);
			LblColor.TabIndex= 0;
			LblColor.TextAlign= ContentAlignment.TopRight;
			//
			// BotColor
			BotColor.Location=new Point(this.Width-68,16);
			BotColor.Size=new Size(52,18);
			BotColor.FlatStyle=FlatStyle.Popup;
			BotColor.TabIndex= 1;
			BotColor.Click+=new EventHandler(BotColor_Click);
			//
			// LblSize
			LblSize.FlatStyle=FlatStyle.System;
			LblSize.Size= new Size(72, 16);
			LblSize.Location= new Point(LblColor.Right-LblSize.Width, 42);
			LblSize.TabIndex= 2;
			LblSize.TextAlign= ContentAlignment.TopRight;
			//
			// TextSize
			TextSize.Location= new Point(BotColor.Left, 40);
			TextSize.Size= new Size(60, 16);
			TextSize.TabIndex= 3;
			TextSize.TextChanged+= new EventHandler(TextSize_TextChanged);
			//
			// this
			this.Controls.Add(LblColor);
			this.Controls.Add(BotColor);
			this.Controls.Add(LblSize);
			this.Controls.Add(TextSize);
			this.Text="GroupBox Texto";
		}

		public virtual void Actualiza(ConfigTexto* _Config){
			CTexto=_Config;
			TextSize.Text=CTexto->lfont.lfHeight.ToString();
			BotColor.BackColor=FuncionesColor.color_to_Color(CTexto->color);
		}

		private void TextSize_TextChanged(Object sender,System.EventArgs e){
			int ee;
			try{ee=Int16.Parse(TextSize.Text);}
			catch(Exception){return;}

			CTexto->lfont.lfHeight=ee;
			redibuja();
		}
		private void BotColor_Click(object sender,EventArgs e){
			Color1.PanelColor1.Color=CTexto->color;
			Color1.ShowDialog();
			if(CTexto->color!=Color1.PanelColor1.Color){
				CTexto->color=Color1.PanelColor1.Color;
				BotColor.BackColor=FuncionesColor.color_to_Color(CTexto->color);
				redibuja();
			}
		}
	}

	unsafe class GBoxTextoa : GBoxTexto{
		public CheckBox ChkIgual;
		public EventHandler IgualChanged;

		public GBoxTextoa(FormColor _Color1, EventVoid _redibuja) : base(_Color1,_redibuja){
			ChkIgual=new CheckBox();

			this.Height+=28;
			foreach(Control c in this.Controls){
				if(c.TabIndex>1){
					c.Top+=28;
					c.TabIndex+=1;
				}
			}
			ChkIgual.FlatStyle=FlatStyle.System;
			ChkIgual.Location=new Point(this.Width-148, BotColor.Top);
			ChkIgual.Size=new Size(144,16);
			LblColor.Left=ChkIgual.Left-LblColor.Width-6;
			LblColor.Top+=12;
			BotColor.Left=ChkIgual.Left;
			BotColor.Top+=24;

			ChkIgual.TabIndex=1;
			BotColor.TabIndex=2;

			this.Controls.Add(ChkIgual);
			ChkIgual.CheckedChanged+=new EventHandler(ChkIgual_CheckedChanged);
		}
		public void Actualiza(bool igual, ConfigTexto * _Config){
			base.Actualiza (_Config);
			ChkIgual.Checked=igual;
		}

		private void ChkIgual_CheckedChanged(object sender,EventArgs e){
			BotColor.Enabled=!ChkIgual.Checked;
			IgualChanged(ChkIgual, EventArgs.Empty);
		}
	}

	unsafe class GBoxTextob : GBoxTexto{
		public CheckBox ChkIgual, ChkIgualb;
		public EventHandler IgualChanged, IgualbChanged;

		public GBoxTextob(FormColor _Color1, EventVoid _redibuja) : base(_Color1,_redibuja){
			ChkIgual=new CheckBox();
			ChkIgualb=new CheckBox();

			this.Height+=52;
			foreach(Control c in this.Controls){
				if(c.TabIndex>1){
					c.Top+=52;
					c.TabIndex+=2;
				}
			}
			ChkIgual.FlatStyle=FlatStyle.System;
			ChkIgualb.FlatStyle=FlatStyle.System;
			ChkIgual.Location=new Point(this.Width-148, BotColor.Top);
			ChkIgual.Size=new Size(144,16);
			ChkIgualb.Left=ChkIgual.Left;
			ChkIgualb.Top=ChkIgual.Top+24;
			ChkIgualb.Size=ChkIgual.Size;
			LblColor.Left=ChkIgual.Left-LblColor.Width-6;
			LblColor.Top+=22;
			BotColor.Left=ChkIgual.Left;
			BotColor.Top+=48;

			ChkIgual.TabIndex=1;
			ChkIgualb.TabIndex=2;
			BotColor.TabIndex=3;

			this.Controls.Add(ChkIgual);
			this.Controls.Add(ChkIgualb);
			ChkIgual.CheckedChanged+=new EventHandler(ChkIgual_CheckedChanged);
			ChkIgualb.CheckedChanged+=new EventHandler(ChkIgualb_CheckedChanged);
		}
		public void Actualiza(bool igual, bool igualb, ConfigTexto * _Config){
			base.Actualiza (_Config);
			ChkIgual.Checked=igual;
			ChkIgualb.Checked=igualb;
		}

		private void ChkIgual_CheckedChanged(object sender,EventArgs e){
			if(ChkIgual.Checked) ChkIgualb.Checked=false;
			BotColor.Enabled=!(ChkIgual.Checked || ChkIgualb.Checked);
			IgualChanged(ChkIgual, EventArgs.Empty);
		}
		private void ChkIgualb_CheckedChanged(object sender,EventArgs e){
			if(ChkIgualb.Checked) ChkIgual.Checked=false;
			BotColor.Enabled=!(ChkIgual.Checked || ChkIgualb.Checked);
			IgualbChanged(ChkIgual, EventArgs.Empty);
		}
	}

	unsafe class GBoxTextoa_i : GBoxTextoa{
		public System.Windows.Forms.Label			LblColor_i;
		public System.Windows.Forms.CheckBox	ChkIgual_i;
		public System.Windows.Forms.Button		BotColor_i;
		public EventHandler Igual_iChanged;
		private int ExtraWidth;

		public uint* pcolor_i;
		public GBoxTextoa_i(FormColor _Color1, EventVoid _redibuja) : base(_Color1,_redibuja){
			ExtraWidth=GBoxTexto.PreferedSize().Width+4;
			this.Width+=ExtraWidth;
			foreach(Control c in this.Controls){
				if(c.TabIndex>2){
					c.TabIndex+=3;
					c.Left+=20;
				}
			}
			InitializeComponent();
		}
		private void InitializeComponent(){
			LblColor_i=new Label();
			ChkIgual_i=new CheckBox();
			BotColor_i=new Button();

			//LblColor
			LblColor_i.FlatStyle=FlatStyle.System;
			LblColor_i.Location=new Point(LblColor.Left+ExtraWidth, LblColor.Top);
			LblColor_i.Size= LblColor.Size;
			LblColor_i.TabIndex=3;
			LblColor_i.TextAlign= ContentAlignment.TopRight;

			//ChkIgual_i
			ChkIgual_i.FlatStyle=FlatStyle.System;
			ChkIgual_i.Location=new Point(ChkIgual.Left+ExtraWidth, ChkIgual.Top);
			ChkIgual_i.Size= ChkIgual.Size;
			ChkIgual_i.TabIndex=4;
			ChkIgual_i.CheckedChanged+=new EventHandler(ChkIgual_i_CheckedChanged);

			//BotColor_i
			BotColor_i.Location=new Point(BotColor.Left+ExtraWidth, BotColor.Top);
			BotColor_i.Size= BotColor.Size;
			BotColor_i.TabIndex=5;
			BotColor_i.FlatStyle= FlatStyle.Popup;
			BotColor_i.Click+=new EventHandler(BotColor_i_Click);

			this.Controls.Add(LblColor_i);
			this.Controls.Add(ChkIgual_i);
			this.Controls.Add(BotColor_i);
		}

		public void Actualiza(bool igual, ConfigTexto * _Config, bool igual_i, uint* _pcolor_i){
			base.Actualiza(igual, _Config);
			ChkIgual_i.Checked=igual_i;
			pcolor_i=_pcolor_i;
			BotColor_i.BackColor=FuncionesColor.color_to_Color(*pcolor_i);
		}

		private void ChkIgual_i_CheckedChanged(object sender,EventArgs e){
			BotColor_i.Enabled=!ChkIgual_i.Checked;
			Igual_iChanged(ChkIgual_i, EventArgs.Empty);
		}

		private void BotColor_i_Click(object sender,EventArgs e){
			Color1.PanelColor1.Color=*pcolor_i;
			Color1.ShowDialog();
			if(*pcolor_i!=Color1.PanelColor1.Color){
				*pcolor_i=Color1.PanelColor1.Color;
				BotColor_i.BackColor=FuncionesColor.color_to_Color(*pcolor_i);
				redibuja();
			}
		}
	}


	unsafe class GBoxLinea : GroupBox{
		public System.Windows.Forms.Label		LblColor;
		public System.Windows.Forms.Button	BotColor;
		public System.Windows.Forms.Label		LblEscala;
		public System.Windows.Forms.TextBox	TextEscala;

		public ControlesAt.FormColor	Color1;
		public InterComGrafico.LOGPEN* lpen;
		public float* escala;
		public EventHandler ColorChanged;
		public EventHandler EscalaChanged;

		public static Size PreferedSize(){
			return new Size(216,68);
		}

		 public GBoxLinea(FormColor _Color1){
			Color1=_Color1;
			InitializeComponent();
		}

		private void InitializeComponent(){
			LblColor= new Label();
			BotColor=new Button();
			LblEscala= new Label();
			TextEscala= new TextBox();
			this.Size=PreferedSize();
			//
			// LblColor
			LblColor.FlatStyle=FlatStyle.System;
			LblColor.Location= new Point(this.Width-134, 42);
			LblColor.Size= new Size(60, 16);
			LblColor.TabIndex= 2;
			LblColor.TextAlign= ContentAlignment.TopRight;
			//
			// BotColor
			BotColor.Location=new Point(this.Width-68,40);
			BotColor.Size=new Size(52,18);
			BotColor.FlatStyle=FlatStyle.Popup;
			BotColor.TabIndex= 3;
			BotColor.Click+=new EventHandler(BotColor_Click);
			//
			// LblEscala
			LblEscala.FlatStyle=FlatStyle.System;
			LblEscala.Size= new Size(92, 30);
			LblEscala.Location= new Point(LblColor.Right-LblEscala.Width, 12);
			LblEscala.TabIndex= 2;
			LblEscala.TextAlign= ContentAlignment.MiddleRight;
			//
			// TextEscala
			TextEscala.Location= new Point(BotColor.Left, 16);
			TextEscala.Size= new Size(60, 16);
			TextEscala.TabIndex= 3;
			TextEscala.TextChanged+= new EventHandler(TextEscala_TextChanged);
			//
			// this
			this.Controls.Add(LblEscala);
			this.Controls.Add(TextEscala);
			this.Controls.Add(LblColor);
			this.Controls.Add(BotColor);
			this.Text="GroupBox Linea";
		}

		public virtual void Actualiza(InterComGrafico.LOGPEN* _lpen, float* _escala){
			lpen=_lpen;
			BotColor.BackColor=FuncionesColor.color_to_Color(lpen->color);
			escala=_escala;
			TextEscala.Text=escala->ToString();
		}

		private void BotColor_Click(object sender,EventArgs e){
			Color1.PanelColor1.Color=lpen->color;
			Color1.ShowDialog();
			if(lpen->color!=Color1.PanelColor1.Color){
				lpen->color=Color1.PanelColor1.Color;
				BotColor.BackColor=FuncionesColor.color_to_Color(lpen->color);
				ColorChanged(BotColor, e);
			}
		}
		private void TextEscala_TextChanged(object sender,EventArgs e){
			float ee;
			try{ee=Basicas._gcVarios.atofl(TextEscala.Text.ToCharArray());}
			catch(Exception){return;}

			if(*escala!=ee){
				*escala=ee;
				TextEscala.Text=ee.ToString();
				EscalaChanged(TextEscala, e);
			}
		}
	}
	unsafe class GBoxPunto : GroupBox{
		public System.Windows.Forms.Label		LblColor;
		public System.Windows.Forms.Button	BotColor;
		//public System.Windows.Forms.Label		Lblforma;
		//public System.Windows.Forms.Label		Dibforma;

		public EventHandler ColorChanged;
		public ConfigPunto* CPunto;
		public ControlesAt.FormColor	Color1;
		private ControlesAt.EventVoid	redibuja;
		public static Size PreferedSize(){
			return GBoxLinea.PreferedSize();
		}

		 public GBoxPunto(FormColor _Color1, EventVoid _redibuja){
			Color1=_Color1;
			InitializeComponent();
			 redibuja=_redibuja;
		}

		private void InitializeComponent(){
			LblColor= new Label();
			BotColor=new Button();
			//LblForma= new Label();
			//DibForma= new Label();
			this.Size=PreferedSize();
			//
			// LblColor
			LblColor.FlatStyle=FlatStyle.System;
			LblColor.Location= new Point(this.Width-134, 42);
			LblColor.Size= new Size(60, 16);
			LblColor.TabIndex= 2;
			LblColor.TextAlign= ContentAlignment.TopRight;
			//
			// BotColor
			BotColor.Location=new Point(this.Width-68,40);
			BotColor.Size=new Size(52,18);
			BotColor.FlatStyle=FlatStyle.Popup;
			BotColor.TabIndex= 3;
			BotColor.Click+=new EventHandler(BotColor_Click);
//			//
//			// LblForma
//			LblForma.FlatStyle=FlatStyle.System;
//			LblForma.Size= new Size(72, 16);
//			LblForma.Location= new Point(LblColor.Right-LblSize.Width, 18);
//			LblForma.TabIndex= 0;
//			LblForma.TextAlign= ContentAlignment.TopRight;
//			//
//			// DibForma
//			DibForma.Location= new Point(BotColor.Left, 16);
//			DibForma.Size= new Size(52, 16);
//			DibForma.TabIndex= 1;
			//
			// this
			//this.Controls.Add(LblForma);
			//this.Controls.Add(DibForma);
			this.Controls.Add(LblColor);
			this.Controls.Add(BotColor);
			this.Text="GroupBox Punto";
		}

		public virtual void Actualiza(ConfigPunto* _Config){
			CPunto=_Config;
			BotColor.BackColor=FuncionesColor.color_to_Color(CPunto->color);
		}
		private void BotColor_Click(object sender,EventArgs e){
			Color1.PanelColor1.Color=CPunto->color;
			Color1.ShowDialog();
			if(CPunto->color!=Color1.PanelColor1.Color){
				CPunto->color=Color1.PanelColor1.Color;
				BotColor.BackColor=FuncionesColor.color_to_Color(CPunto->color);
				ColorChanged(BotColor, EventArgs.Empty);
			}
		}
	}

	unsafe class GBoxResiduo : GroupBox{
		public System.Windows.Forms.Label			LblPunto;
		public System.Windows.Forms.CheckBox	ChkPunto;
		public System.Windows.Forms.Label		LblColor;
		public System.Windows.Forms.Button	BotColor;
		public System.Windows.Forms.Label		LblEscala;
		public System.Windows.Forms.TextBox	TextEscala;

		public ControlesAt.FormColor	Color1;
		public byte* punto;
		public InterComGrafico.LOGPEN* lpen;
		public float* escala;
		public EventHandler ColorChanged;
		public EventHandler EscalaChanged;
		public EventHandler PuntoChanged;

		public static Size PreferedSize(){
			return new Size(412,44);
		}

		 public GBoxResiduo(FormColor _Color1){
			Color1=_Color1;
			InitializeComponent();
		}

		private void InitializeComponent(){
			LblPunto= new Label();
			ChkPunto= new CheckBox();
			LblColor= new Label();
			BotColor=new Button();
			LblEscala= new Label();
			TextEscala= new TextBox();
			this.Size=new Size(436,44);
			//
			// LblPunto
			LblPunto.FlatStyle=FlatStyle.System;
			LblPunto.Location= new Point(4, 16);
			LblPunto.Size= new Size(80, 16);
			LblPunto.TabIndex= 0;
			LblPunto.TextAlign= ContentAlignment.TopRight;
			//
			// ChkPunto
			ChkPunto.Location= new Point(LblPunto.Right+4, 16);
			ChkPunto.Size= new Size(16, 16);
			ChkPunto.TabIndex= 1;
			ChkPunto.CheckedChanged+=new EventHandler(ChkPunto_CheckedChanged);
			//
			// LblColor
			LblColor.FlatStyle=FlatStyle.System;
			LblColor.Location= new Point(this.Width-134, 18);
			LblColor.Size= new Size(60, 16);
			LblColor.TabIndex= 4;
			LblColor.TextAlign= ContentAlignment.TopRight;
			//
			// BotColor
			BotColor.Location=new Point(this.Width-68,16);
			BotColor.Size=new Size(52,18);
			BotColor.FlatStyle=FlatStyle.Popup;
			BotColor.TabIndex= 5;
			BotColor.Click+=new EventHandler(BotColor_Click);
			//
			// LblEscala
			LblEscala.FlatStyle=FlatStyle.System;
			LblEscala.Size= new Size(104, 30);
			LblEscala.Location= new Point(110+(this.Width-GBoxResiduo.PreferedSize().Width)/2, 12);
			LblEscala.TabIndex= 2;
			LblEscala.TextAlign= ContentAlignment.MiddleRight;
			//
			// TextEscala
			TextEscala.Location= new Point(LblEscala.Right+ 6, 16);
			TextEscala.Size= new Size(60, 16);
			TextEscala.TabIndex= 3;
			TextEscala.TextChanged+= new EventHandler(TextEscala_TextChanged);
			//
			// this
			this.Controls.Add(LblPunto);
			this.Controls.Add(ChkPunto);
			this.Controls.Add(LblEscala);
			this.Controls.Add(TextEscala);
			this.Controls.Add(LblColor);
			this.Controls.Add(BotColor);
		}

		public virtual void Actualiza(byte* _punto,InterComGrafico.LOGPEN* _lpen, float* _escala){
			ChkPunto.Checked=(*_punto!=0);
			lpen=_lpen;
			BotColor.BackColor=FuncionesColor.color_to_Color(lpen->color);
			escala=_escala;
			TextEscala.Text=escala->ToString();
			punto=_punto;
		}

		private void ChkPunto_CheckedChanged(object sender,EventArgs e){
			if(punto==(byte*)0) return;
			if(!ChkPunto.Checked) *punto=0;
			else *punto=1;
			PuntoChanged(ChkPunto, e);
		}
		private void BotColor_Click(object sender,EventArgs e){
			Color1.PanelColor1.Color=lpen->color;
			Color1.ShowDialog();
			if(lpen->color!=Color1.PanelColor1.Color){
				lpen->color=Color1.PanelColor1.Color;
				BotColor.BackColor=FuncionesColor.color_to_Color(lpen->color);
				ColorChanged(BotColor, e);
			}
		}
		private void TextEscala_TextChanged(object sender,EventArgs e){
			float ee;
			try{ee=Basicas._gcVarios.atofl(TextEscala.Text.ToCharArray());}
			catch(Exception){return;}

			if(*escala!=ee){
				*escala=ee;
				TextEscala.Text=ee.ToString();
				EscalaChanged(TextEscala, e);
			}
		}
	}

	unsafe class PanelPrecisiones : ContainerControl{
		public GBoxLinea GBoxelipse;
		public GBoxLinea GBoxsegmento;

		public ControlesAt.FormColor		Color1;
		public Grafico.ConfigPrecisionXYZ*	CPrec;

		 public PanelPrecisiones(FormColor _Color1){
			Color1=_Color1;
			InitializeComponent();
		}

		private void InitializeComponent(){
			GBoxelipse= new GBoxLinea(Color1);
			GBoxsegmento= new GBoxLinea(Color1);
			//
			// GBoxelipse
			//
			GBoxelipse.Location= new Point(4,0);
			GBoxelipse.TabIndex= 0;
			GBoxelipse.Text= "Elipse XY";
			//
			// GBoxsegmento
			//
			GBoxsegmento.Location= new Point(GBoxelipse.Right+4,0);
			GBoxsegmento.TabIndex= 1;
			GBoxsegmento.Text= "Segmento Z";
			//
			// this
			//
			this.Controls.Add(this.GBoxelipse);
			this.Controls.Add(this.GBoxsegmento);
			this.Width=GBoxsegmento.Right;
			this.Height=GBoxelipse.Bottom;
		}

		public virtual void Actualiza(ConfigPrecisionXYZ* _Config){
			CPrec=_Config;
			GBoxelipse.Actualiza(&CPrec->Celipse.lpen, &CPrec->Celipse.escala);
			GBoxsegmento.Actualiza(&CPrec->Csegmento.lpen, &CPrec->Csegmento.escala);
		}

		public virtual void etiquetas_esp(){
			this.GBoxelipse.Text= "Elipse";
			this.GBoxelipse.LblEscala.Text= "Escala aplicada para visualizarlas:";
			this.GBoxelipse.LblColor.Text= "Color:";
			this.GBoxsegmento.Text= "Segmento";
			this.GBoxsegmento.LblEscala.Text= "Escala aplicada para visualizarlos:";
			this.GBoxsegmento.LblColor.Text= "Color:";
		}
		public virtual void etiquetas_eng(){
			this.GBoxelipse.Text= "Ellipse";
			this.GBoxelipse.LblEscala.Text= "Displaying\n scale:";
			this.GBoxelipse.LblColor.Text= "Color:";
			this.GBoxsegmento.Text= "Segment";
			this.GBoxsegmento.LblEscala.Text= "Displaying\n scale:";
			this.GBoxsegmento.LblColor.Text= "Color:";
		}
		public virtual void etiquetas_it(){
			this.GBoxelipse.Text= "Ellisse";
			this.GBoxelipse.LblEscala.Text= "Scala applicata per la visualizzazione:";
			this.GBoxelipse.LblColor.Text= "Colore:";
			this.GBoxsegmento.Text= "Segmento";
			this.GBoxsegmento.LblEscala.Text= "Scala applicata per la visualizzazione:";
			this.GBoxsegmento.LblColor.Text= "Colore:";
		}
	}

	unsafe class PanelPrecisionesa: PanelPrecisiones{
		public System.Windows.Forms.CheckBox ChkIgual;
		public EventHandler IgualChanged;

		public PanelPrecisionesa(FormColor _Color1) : base(_Color1){
			ChkIgual= new CheckBox();

			ChkIgual.FlatStyle=FlatStyle.System;
			ChkIgual.Location=new Point(4,4);
			ChkIgual.Size=new Size(164,16);
			ChkIgual.TabIndex=0;
			ChkIgual.CheckedChanged+=new EventHandler(ChkIgual_CheckedChanged);

			GBoxelipse.Top+=28;	GBoxsegmento.Top+=28;
			this.Height+=28;
			GBoxelipse.TabIndex= 1;
			GBoxsegmento.TabIndex= 2;

			this.Controls.Add(ChkIgual);
		}

		public virtual void Actualiza(ConfigPrecisionXYZ* _Config, bool igual){
			base.Actualiza(_Config);
			ChkIgual.Checked=igual;
		}

		private void ChkIgual_CheckedChanged(object sender,EventArgs e){
			GBoxelipse.Enabled=!ChkIgual.Checked;
			GBoxsegmento.Enabled=GBoxelipse.Enabled;
			IgualChanged(ChkIgual, EventArgs.Empty);
		}
	}

	unsafe class PanelResiduos : ContainerControl{
		public GBoxResiduo GBoxresiduo;

		public ControlesAt.FormColor Color1;
		public Grafico.ConfigResiduo*	CResiduo;

		 public PanelResiduos(FormColor _Color1){
			Color1=_Color1;
			InitializeComponent();
		}

		private void InitializeComponent(){
			GBoxresiduo= new GBoxResiduo(Color1);
			//
			// GBoxResiduo
			GBoxresiduo.Location= new Point(4,0);
			GBoxresiduo.TabIndex= 0;
			//
			// this
			//
			this.Controls.Add(this.GBoxresiduo);
			this.Width=GBoxresiduo.Right;
			this.Height=GBoxresiduo.Bottom;
		}

		public virtual void Actualiza(ConfigResiduo* _Config){
			CResiduo=_Config;
			GBoxresiduo.Actualiza(&CResiduo->punto, &CResiduo->segmento.lpen, &CResiduo->segmento.escala);
		}

		public virtual void etiquetas_esp(){
			this.GBoxresiduo.LblPunto.Text= "Mostrar el punto";
			this.GBoxresiduo.LblEscala.Text= "Escala aplicada\n para la visualizacin:";
			this.GBoxresiduo.LblColor.Text= "Color:";
		}
		public virtual void etiquetas_eng(){
			this.GBoxresiduo.LblPunto.Text= "Show the point";
			this.GBoxresiduo.LblEscala.Text= "Displaying\n scale:";
			this.GBoxresiduo.LblColor.Text= "Color:";
		}
		public virtual void etiquetas_it(){
			this.GBoxresiduo.LblPunto.Text= "Mostra il punto";
			this.GBoxresiduo.LblEscala.Text= "Scala applicata per\n la visualizzazione:";
			this.GBoxresiduo.LblColor.Text= "Colore:";
		}
	}

}
#endif
