using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Grafico
{
	public class FormInfoElemento : ControlesAt.FormAerotri
	{
		private System.Windows.Forms.ContainerControl PanelTipo;
		private System.Windows.Forms.Label LabelTipo;
		private System.Windows.Forms.Label LabelSubtipo;
		private System.Windows.Forms.Label LabelNombre;
		private System.Windows.Forms.Panel PanelInfo;
		private ControlesAt.NoControl label2;
		private System.Windows.Forms.Label LabelInfo;
		private ControlesAt.NoControl control1;
		private ControlesAt.NoControl control2;
		private System.Windows.Forms.Label LabelExtremosI;
		private System.Windows.Forms.ContainerControl panelExtremos;
		private System.Windows.Forms.Label LabelExtremosD;

		public FormInfoElemento(Globales.Idioma _idioma)
		{
			InitializeComponent();
			set_idioma(_idioma);
			colores();
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			PanelTipo= new ContainerControl();
			LabelTipo= new Label();
			LabelSubtipo= new Label();
			LabelNombre= new Label();
			PanelInfo= new Panel();
			control1= new NoControl();
			LabelInfo= new Label();
			label2= new NoControl();
			LabelExtremosI= new Label();
			control2= new NoControl();
			panelExtremos= new ContainerControl();
			LabelExtremosD= new Label();
			//
			// PanelTipo
			//
			PanelTipo.Controls.Add(LabelTipo);
			PanelTipo.Dock= DockStyle.Top;
			PanelTipo.Location= new Point(0, 0);
			PanelTipo.Name= "PanelTipo";
			PanelTipo.Size= new Size(298, 32);
			PanelTipo.TabIndex= 0;
			//
			// LabelTipo
			//
			LabelTipo.Dock= DockStyle.Bottom;
			LabelTipo.Location= new Point(0, 4);
			LabelTipo.Name= "LabelTipo";
			LabelTipo.Size= new Size(298, 28);
			LabelTipo.TabIndex= 0;
			LabelTipo.Text= "Tipo";
			LabelTipo.TextAlign= ContentAlignment.MiddleCenter;
			//
			// LabelSubtipo
			//
			LabelSubtipo.Dock= DockStyle.Top;
			LabelSubtipo.Location= new Point(0, 32);
			LabelSubtipo.Name= "LabelSubtipo";
			LabelSubtipo.Size= new Size(298, 20);
			LabelSubtipo.TabIndex= 1;
			LabelSubtipo.Text= "Subtipo";
			LabelSubtipo.TextAlign= ContentAlignment.MiddleLeft;
			//
			// LabelNombre
			//
			LabelNombre.Dock= DockStyle.Top;
			LabelNombre.Location= new Point(0, 52);
			LabelNombre.Name= "LabelNombre";
			LabelNombre.Size= new Size(298, 20);
			LabelNombre.TabIndex= 3;
			LabelNombre.Text= "Nombre";
			LabelNombre.TextAlign= ContentAlignment.MiddleLeft;
			//
			// PanelInfo
			//
			PanelInfo.BackColor= SystemColors.Window;
			PanelInfo.BorderStyle= System.Windows.Forms.BorderStyle.Fixed3D;
			PanelInfo.Controls.Add(LabelInfo);
			PanelInfo.Controls.Add(control1);
			PanelInfo.Controls.Add(label2);
			PanelInfo.Controls.Add(panelExtremos);
			PanelInfo.Dock= DockStyle.Fill;
			PanelInfo.Location= new Point(0, 72);
			PanelInfo.Name= "PanelInfo";
			PanelInfo.Size= new Size(298, 197);
			PanelInfo.TabIndex= 4;
			//
			// control1
			//
			control1.BackColor= SystemColors.Window;
			control1.Dock= DockStyle.Top;
			control1.Location= new Point(0, 45);
			control1.Name= "control1";
			control1.Size= new Size(294, 1);
			control1.TabIndex= 3;
			//
			// LabelInfo
			//
			LabelInfo.Dock= DockStyle.Fill;
			LabelInfo.Location= new Point(0, 46);
			LabelInfo.Name= "LabelInfo";
			LabelInfo.Size= new Size(294, 147);
			LabelInfo.TabIndex= 2;
			LabelInfo.Text= "label3";
			//
			// label2
			//
			label2.BackColor= Color.Black;
			label2.Dock= DockStyle.Top;
			label2.Location= new Point(0, 44);
			label2.Name= "label2";
			label2.Size= new Size(294, 1);
			label2.TabIndex= 1;
			//
			// LabelExtremosI
			//
			LabelExtremosI.Dock= DockStyle.Left;
			LabelExtremosI.Location= new Point(0, 1);
			LabelExtremosI.Name= "LabelExtremosI";
			LabelExtremosI.Size= new Size(150, 43);
			LabelExtremosI.TabIndex= 0;
			LabelExtremosI.Text= "Izquierda";
			//
			// control2
			//
			control2.BackColor= SystemColors.Window;
			control2.Dock= DockStyle.Top;
			control2.Location= new Point(0, 0);
			control2.Name= "control2";
			control2.Size= new Size(294, 1);
			control2.TabIndex= 4;
			//
			// panelExtremos
			//
			panelExtremos.Controls.Add(LabelExtremosD);
			panelExtremos.Controls.Add(LabelExtremosI);
			panelExtremos.Controls.Add(control2);
			panelExtremos.Dock= DockStyle.Top;
			panelExtremos.Location= new Point(0, 0);
			panelExtremos.Name= "panelExtremos";
			panelExtremos.Size= new Size(294, 44);
			panelExtremos.TabIndex= 5;
			//
			// LabelExtremosD
			//
			LabelExtremosD.Dock= DockStyle.Fill;
			LabelExtremosD.Location= new Point(150, 1);
			LabelExtremosD.Name= "LabelExtremosD";
			LabelExtremosD.Size= new Size(144, 43);
			LabelExtremosD.TabIndex= 5;
			LabelExtremosD.Text= "Derecha";
			//
			// FormInfoElemento
			//
			this.ClientSize= new Size(298, 269);
			this.Controls.Add(this.PanelInfo);
			this.Controls.Add(LabelNombre);
			this.Controls.Add(LabelSubtipo);
			this.Controls.Add(this.PanelTipo);
			this.Icon= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Grafico.IconGrafico.ico"));
			this.MaximizeBox= false;
			this.MinimizeBox= false;
		}
	#endregion

		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

		public void DisplayInfo(string tipo, string subtipo, string nombreNombre, string nombre, InterComGrafico.Extremos extremos,sbyte dec, string texto){
			string sdec;
			Graphics g=LabelExtremosI.CreateGraphics();
			string saux;
			float wd;

			LabelTipo.Text=tipo;
			if(subtipo==null || subtipo==""){
				LabelSubtipo.Visible=false;
			}else{
				LabelSubtipo.Visible=true;
				LabelSubtipo.Text=subtipo;
			}
			LabelNombre.Text=nombreNombre + ": " + nombre;
			if(dec<0) dec=7;
			sdec="F"+dec.ToString();
			saux="Xmin= " + extremos.Xmin.ToString(sdec)+'\n';
			saux+="Ymin= " + extremos.Ymin.ToString(sdec)+'\n';
			saux+="Zmin= " + extremos.Zmin.ToString(sdec)+'\n';
			wd=g.MeasureString(saux,LabelExtremosI.Font).Width;
			LabelExtremosI.Width=(int)wd+8;
			LabelExtremosI.Text=saux;
			LabelExtremosD.Text="Xmax= " +extremos.Xmax.ToString(sdec)+"\n";
			LabelExtremosD.Text+="Ymax= " +extremos.Ymax.ToString(sdec)+"\n";
			LabelExtremosD.Text+="Zmax= " +extremos.Zmax.ToString(sdec)+"\n";
			LabelInfo.Text=texto;
		}

		private void colores(){
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			this.PanelTipo.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
		}

		protected override void update_idioma(){
			switch(idioma){
				case Globales.Idioma.Eng: etiquetas_eng(); break;
				case Globales.Idioma.It: etiquetas_it(); break;
				default:etiquetas_esp(); break;
			}
		}

		void etiquetas_esp(){
			this.Text="Informacin de elemento";
		}
		void etiquetas_eng(){
			this.Text="Element Information";
		}
		void etiquetas_it(){
			this.Text="Informazione di elemento";
		}
	}
}
