using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using PanelesSub;

namespace Grafico
{
	public struct OpcionesDgn{
		public System.IntPtr fsemilla;
	}

	public class FormExportardgn : ControlesAt.DependentForm
	{
		internal ControlesAt.LabelTxtBotAbrir TxtBot1;
		private System.Windows.Forms.FileDialog Open1;
		private ControlesAt.BotAceptar Cancelar, Aceptar, ASinSemilla;

		public OpcionesDgn O;
		internal DialogResult mi_DialogResult;

		public FormExportardgn(ControlesAt.IEntorno _Entorno) : base(_Entorno)
		{
			InitializeComponent();
			this.AcceptButton=Aceptar;
			this.CancelButton=Cancelar;
			mi_DialogResult=DialogResult.Cancel;

			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			TxtBot1= new ControlesAt.LabelTxtBotAbrir();
			Open1=new OpenFileDialog();
			Cancelar= new ControlesAt.BotAceptar();
			Aceptar= new ControlesAt.BotAceptar();
			ASinSemilla=new ControlesAt.BotAceptar();
			//
			// TxtBot1
			//
			TxtBot1.TextLocation= new Point(84, 28);		TxtBot1.TabIndex= 1;
			TxtBot1.Click+=new EventHandler(TxtBot1_Click);
			//
			// Aceptar, Cancelar
			//
			Aceptar.Location= new Point(12, 78);		Aceptar.Size= new Size(60, 22);		Aceptar.TabIndex= 4;
			ASinSemilla.Location= new Point(88, 72);	ASinSemilla.Size= new Size(96, 34);	ASinSemilla.TabIndex= 5;
			Cancelar.Location= new Point(200, 78);		Cancelar.Size= new Size(60, 22);		Cancelar.TabIndex=6;
			Aceptar.Click+= new EventHandler(Aceptar_Click);
			ASinSemilla.Click+= new EventHandler(ASinSemilla_Click);
			Cancelar.Click+= new EventHandler(Cancelar_Click);
			//
			// FormExportardgn
			//
			this.ClientSize= new Size(274, 127);
			this.Controls.Add(Cancelar);
			this.Controls.Add(ASinSemilla);
			this.Controls.Add(Aceptar);
			this.Controls.Add(TxtBot1);
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.Icon= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Grafico.IconGrafico.ico"));
			this.MaximizeBox= false;
		}
	#endregion

		protected override void OnLoad(System.EventArgs e){
			mi_DialogResult=DialogResult.Cancel;
			base.OnLoad(e);
		}

		private void Aceptar_Click(object sender,System.EventArgs e){
			mi_DialogResult=DialogResult.OK;
			this.Hide();
		}
		private void ASinSemilla_Click(object sender,System.EventArgs e){
			mi_DialogResult=DialogResult.Ignore;
			this.Hide();
		}
		private void Cancelar_Click(object sender,System.EventArgs e){
			mi_DialogResult=DialogResult.Cancel;
			this.Hide();
		}
		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

		private void TxtBot1_Click(object sender,EventArgs e){
			SetFilter1(Open1);
			Open1.FilterIndex=1;
			//ahora_no_se_puede_cerrar=1;
			if(Open1.ShowDialog()!=DialogResult.OK) return;
			//ahora_no_se_puede_cerrar=0;
			TxtBot1.Text=Open1.FileName;
		}
		private void SetFilter1(FileDialog Open1){
			switch(idioma){
				case Globales.Idioma.Eng:  Open1.Filter="dgn files (*.dgn)|*.dgn"; break;
				case Globales.Idioma.It:  Open1.Filter="File dgn (*.dgn)|*.dgn"; break;
				default:Open1.Filter="Ficheros dgn (*.dgn)|*.dgn"; break;
			}
		}

		protected override void update_idioma(){
			switch(idioma){
				case Globales.Idioma.Eng:  etiquetas_eng(); break;
				case Globales.Idioma.It:  etiquetas_it(); break;
				default:etiquetas_esp(); break;
			}
		}
		void etiquetas_esp(){
			this.Text="Opciones de exportacin a dgn";
			Aceptar.Text="Exportar";
			ASinSemilla.Text="Exportar sin archivo semilla";
			Cancelar.Text="Cancelar";
			TxtBot1.L.Text="Archivo semilla";
		}
		void etiquetas_eng(){
			this.Text= "Options of the exportation to dgn";
			Aceptar.Text="Export";
			ASinSemilla.Text="Export without seed file";
			Cancelar.Text="Cancel";
			TxtBot1.L.Text="Seed file";
		}
		void etiquetas_it(){
			this.Text= "Opzioni dell'esportazione a dgn";
			Aceptar.Text="Esporta";
			ASinSemilla.Text="Esporta senza file di seme";
			Cancelar.Text="Cancela";
			TxtBot1.L.Text="File di seme";
		}
	}
}
