using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using PanelesSub;

namespace Grafico
{
	public struct OpcionesDigi{
		public int kunidad;
		public uint puntoselipse;
		public float htexto;
	}
	public class FormExportarbin : ControlesAt.DependentForm
	{
		private System.Windows.Forms.TextBox Txtunidad;
		private System.Windows.Forms.TextBox TxtEpuntos;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private ControlesAt.BotAceptar Cancelar,	Aceptar;

		public OpcionesDigi O;
		internal DialogResult mi_DialogResult;

		public FormExportarbin(ControlesAt.IEntorno _Entorno) : base(_Entorno)
		{
			InitializeComponent();
			this.AcceptButton=Aceptar;
			this.CancelButton=Cancelar;
			mi_DialogResult=DialogResult.Cancel;

			O.kunidad=100;
			O.puntoselipse=48;
			O.htexto=float.PositiveInfinity;
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			Txtunidad= new TextBox();
			label1= new Label();
			label2= new Label();
			TxtEpuntos= new TextBox();
			Cancelar= new ControlesAt.BotAceptar();
			Aceptar= new ControlesAt.BotAceptar();
			//
			// Txtunidad
			//
			Txtunidad.Location= new Point(120, 24);
			Txtunidad.TabIndex= 0;
			Txtunidad.Text= "";
			//
			// label1
			//
			label1.FlatStyle= System.Windows.Forms.FlatStyle.System;
			label1.Location= new Point(24, 28);
			label1.Size= new Size(88, 16);
			label1.TabIndex= 1;
			label1.TextAlign= ContentAlignment.TopRight;
			//
			// label2
			//
			label2.FlatStyle= System.Windows.Forms.FlatStyle.System;
			label2.Location= new Point(16, 60);
			label2.Size= new Size(96, 28);
			label2.TabIndex= 3;
			label2.TextAlign= ContentAlignment.TopRight;
			//
			// TxtEpuntos
			//
			TxtEpuntos.Location= new Point(120, 64);
			TxtEpuntos.TabIndex= 2;
			TxtEpuntos.Text= "";
			//
			// Cancelar
			//
			Cancelar.Location= new Point(160, 108);
			Cancelar.Size= new Size(60, 22);
			Cancelar.TabIndex= 5;
			Cancelar.Click+= new EventHandler(Cancelar_Click);
			//
			// Aceptar
			//
			Aceptar.Location= new Point(36, 108);
			Aceptar.Size= new Size(60, 22);
			Aceptar.TabIndex= 4;
			Aceptar.Click+= new EventHandler(Aceptar_Click);
			//
			// FormExportarbin
			//
			this.ClientSize= new Size(254, 147);
			this.Controls.Add(Cancelar);
			this.Controls.Add(Aceptar);
			this.Controls.Add(label2);
			this.Controls.Add(TxtEpuntos);
			this.Controls.Add(label1);
			this.Controls.Add(Txtunidad);
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.Icon= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Grafico.IconGrafico.ico"));
			this.MaximizeBox= false;
		}
	#endregion

		protected override void OnLoad(System.EventArgs e){
			Txtunidad.Text=(1.0/O.kunidad).ToString();
			TxtEpuntos.Text=O.puntoselipse.ToString();
			mi_DialogResult=DialogResult.Cancel;
			base.OnLoad(e);
		}

		private void Aceptar_Click(object sender,System.EventArgs e){
			mi_DialogResult=DialogResult.OK;
			this.Hide();
		}
		private void Cancelar_Click(object sender,System.EventArgs e){
			mi_DialogResult=DialogResult.Cancel;
			this.Hide();
		}
		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

		protected override void update_idioma(){
			switch(idioma){
				case Globales.Idioma.Eng:  etiquetas_eng(); break;
				case Globales.Idioma.It:  etiquetas_it(); break;
				default:etiquetas_esp(); break;
			}
		}

		void etiquetas_esp(){
			this.Text="Opciones de exportacin a bin";
			Aceptar.Text="Exportar";
			Cancelar.Text="Cancelar";
			label1.Text="Unidad mnima";
			label2.Text="Nmero de puntos en las elipses";
		}
		void etiquetas_eng(){
			this.Text= "Options of the exportation to bin";
			Aceptar.Text="Export";
			Cancelar.Text="Cancel";
			label1.Text="Minimum unit";
			label2.Text="Number of points in the ellipses";
		}
		void etiquetas_it(){
			this.Text= "Opzioni dell'esportazione a bin";
			Aceptar.Text="Esporta";
			Cancelar.Text="Cancela";
			label1.Text="Unit minima";
			label2.Text="Numero de punti nelle ellisse";
		}
	}
}
