#define NUEVO
#if !NUEVO
using System;
using System.Drawing;
using System.Windows.Forms;
using ControlesAt;
using System.Runtime.InteropServices;

namespace Grafico
{
	/// <summary>
	/// Descripcin breve de FormElementos.
	/// </summary>
	unsafe public class FormElementos : ControlesAt.FormTools
	{
		internal ControlesAt.SuperTabControl SuperTab1;
		private ControlesAt.TabRow	RowBasica,
											RowPrecisiones,
											RowResiduos;
		private ControlesAt.PaddedLabel LblPrincipales;
		private ControlesAt.LabelTab Bfotogramas,		BpuntosM,
											BpuntosA,		BpuntosC;
		private ControlesAt.PaddedLabel LblPrecisiones;
		private ControlesAt.LabelTab Bprecisionescp,	BprecisionespM,
											BprecisionespA;
		private ControlesAt.PaddedLabel LblResiduos;
		private ControlesAt.LabelTab Bresiduosf,		Bdistorsion,
											BresiduoscpP,	BresiduoscpG,
											BresiduospA,		BresiduospC;
		private System.Windows.Forms.ContainerControl	Panelfotogramas,
																	PanelpuntosM,
																	PanelpuntosA,
																	PanelpuntosC;

		private PanelPrecisiones Panelprecisionescp;
		private PanelPrecisionesa	PanelprecisionespM,
										PanelprecisionespA;
		private PanelResiduos	Panelresiduosf,
									Paneldistorsion,
									PanelresiduoscpP;
		private  System.Windows.Forms.ContainerControl PanelresiduoscpG;
		private PanelResiduos	PanelresiduospA,
									PanelresiduospC;

		private GBoxLinea GBoxfotogramas;
		private GBoxPunto GBoxccpp;
		private GBoxTextob GBoxTextosf;

		private GBoxPunto GBoxpuntosM;
		private GBoxTextoa GBoxTextospM;

		private GBoxPunto GBoxpuntosAc;
		private GBoxPunto GBoxpuntosAi;
		private GBoxTextoa_i GBoxTextospA;

		private GBoxPunto GBoxpuntosCc;
		private GBoxPunto GBoxpuntosCi;
		private GBoxTextoa_i GBoxTextospC;

		private System.Windows.Forms.Panel panel1;
		private ControlesAt.BotAceptar Aceptar,	Cancelar;

		private ConfiguracionGrafico* pOldConfig;
		private ConfiguracionLogica* pOldLogic;
		private ConfiguracionGrafico* pC;
		private ConfiguracionLogica* pL;

		private ControlesAt.FormColor Color1;
		internal bool SuspendDibuja;

		PanelGrafico PanelPadre;
		public FormElementos(PanelGrafico Form1)
		{
			PanelPadre=Form1;
			Color1= new FormColor(Form1);
			InitializeComponent();
			this.AcceptButton=Aceptar;
			this.CancelButton=Cancelar;

			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			this.AddOwnedForm(Color1);
			set_idioma(PanelPadre.Idioma);
		}

	#region InitializeComponent
		protected override void Dispose(bool disposing){
			base.Dispose(disposing);
			IntPtr pP;
			pP=new System.IntPtr(pOldConfig);
			if(pP!=System.IntPtr.Zero){
				Marshal.FreeHGlobal(pP);
				pOldConfig=(ConfiguracionGrafico*)System.IntPtr.Zero.ToPointer();
			}
			pP=new System.IntPtr(pOldLogic);
			if(pP!=System.IntPtr.Zero){
				Marshal.FreeHGlobal(pP);
				pOldLogic=(ConfiguracionLogica*)System.IntPtr.Zero.ToPointer();
			}
		}

		private void InitializeComponent()
		{
			pOldConfig=(ConfiguracionGrafico*)Marshal.AllocHGlobal(sizeof(ConfiguracionGrafico)).ToPointer();
			pOldLogic=(ConfiguracionLogica*)Marshal.AllocHGlobal(sizeof(ConfiguracionLogica)).ToPointer();
			EventVoid redib=new EventVoid(redibuja);
			SuperTab1= new SuperTabControl();
			RowBasica= new TabRow();
			RowPrecisiones= new TabRow();
			RowResiduos= new TabRow();
			LblPrincipales= new PaddedLabel();
			Bfotogramas=new LabelTab();
			BpuntosM=	 new LabelTab();
			BpuntosA	=	 new LabelTab();
			BpuntosC=	 new LabelTab();
			LblPrecisiones= new PaddedLabel();
			Bprecisionescp=	 new LabelTab();
			BprecisionespM=new LabelTab();
			BprecisionespA=	 new LabelTab();
			LblResiduos= new PaddedLabel();
			Bresiduosf=		new LabelTab();
			Bdistorsion=		new LabelTab();
			BresiduoscpG=	new LabelTab();
			BresiduoscpP=	new LabelTab();
			BresiduospA=	new LabelTab();
			BresiduospC=	new LabelTab();
			Panelfotogramas=new ContainerControl();
			PanelpuntosM=	new ContainerControl();
			PanelpuntosA=	new ContainerControl();
			PanelpuntosC=	new ContainerControl();
			Panelprecisionescp=	new PanelPrecisiones(Color1);
			PanelprecisionespM=	new PanelPrecisionesa(Color1);
			PanelprecisionespA=	new PanelPrecisionesa(Color1);
			Panelresiduosf=		new PanelResiduos(Color1);
			Paneldistorsion=		new PanelResiduos(Color1);
			PanelresiduoscpP=	new PanelResiduos(Color1);
			PanelresiduoscpG=	new ContainerControl();
			PanelresiduospA=	new PanelResiduos(Color1);
			PanelresiduospC=	new PanelResiduos(Color1);

			GBoxfotogramas= new GBoxLinea(Color1);
			GBoxccpp= new GBoxPunto(Color1,redib);
			GBoxTextosf= new GBoxTextob(Color1, redib);

			GBoxpuntosM= new GBoxPunto(Color1, redib);
			GBoxTextospM= new GBoxTextoa(Color1, redib);

			GBoxpuntosAc= new GBoxPunto(Color1, redib);
			GBoxpuntosAi= new GBoxPunto(Color1, redib);
			GBoxTextospA= new GBoxTextoa_i(Color1, redib);

			GBoxpuntosCc= new GBoxPunto(Color1, redib);
			GBoxpuntosCi= new GBoxPunto(Color1, redib);
			GBoxTextospC= new GBoxTextoa_i(Color1, redib);

			Panelprecisionescp= new PanelPrecisiones(Color1);
			PanelprecisionespM= new PanelPrecisionesa(Color1);
			PanelprecisionespA= new PanelPrecisionesa(Color1);

			panel1= new Panel();
			Cancelar=new BotAceptar();
			Aceptar= new BotAceptar();
			//
			// panel1
			//
			this.panel1.Controls.Add(this.Cancelar);
			this.panel1.Controls.Add(this.Aceptar);
			panel1.Dock= DockStyle.Bottom;
			panel1.Location= new Point(0, 255);
			panel1.Size= new Size(350, 44);
			panel1.TabIndex= 1;
			//
			// Aceptar, Cancelar
			//
			Aceptar.Location= new Point(64, 8);			Aceptar.TabIndex= 0;
			Cancelar.Location= new Point(228, 8);		Cancelar.TabIndex=1;
			Cancelar.Click+= new EventHandler(Cancelar_Click);
			Aceptar.Click+= new EventHandler(Aceptar_Click);

			//
			// SuperTab1
			//
			SuperTab1.Location= new Point(0, 0);
			SuperTab1.TabIndex= 0;
			//SuperTab1.SizeChanged+=new EventHandler(SuperTab1_SizeChanged);	//Ya lo haremos despus de aadir la ltima fila
			SuperTab1.Width= 444;
			RowBasica.BackColor= Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
			RowPrecisiones.BackColor= Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
			RowResiduos.BackColor= Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
			SuperTab1.DefaultActiveLabel.BorderStyle= BorderStyle.None;
			//
			// LblPrincipales
			//
			LblPrincipales.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			LblPrincipales.TabIndex=0;
			LblPrincipales.Font= new System.Drawing.Font("Microsoft Sans Serif", 8F);
			LblPrincipales.TextAlign= ContentAlignment.MiddleRight;
			//
			// Panelfotogramas
			//
			this.Panelfotogramas.Controls.Add(this.GBoxfotogramas);
			this.Panelfotogramas.Controls.Add(this.GBoxccpp);
			this.Panelfotogramas.Controls.Add(this.GBoxTextosf);
			//
			// GBoxfotogramas
			//
			GBoxfotogramas.Location=new Point(4,4);
			GBoxfotogramas.TabIndex= 0;
			GBoxfotogramas.EscalaChanged+= new EventHandler(TextEscala_f_TextChanged);
			GBoxfotogramas.ColorChanged+= new EventHandler(BotColor_f_ColorChanged);
			//
			// GBoxccpp
			//
			GBoxccpp.Location=new Point(GBoxfotogramas.Right+4,4);
			GBoxccpp.TabIndex= 1;
			GBoxccpp.ColorChanged+= new EventHandler(GBoxccpp_ColorChanged);
			//
			// GBoxTextos_f
			GBoxTextosf.Location= new Point(4,GBoxfotogramas.Bottom+4);
			GBoxTextosf.TabIndex= 2;
			GBoxTextosf.IgualChanged+= new EventHandler(GBoxTextosf_IgualfChanged);
			GBoxTextosf.IgualbChanged+= new EventHandler(GBoxTextosf_IgualcpChanged);
			//
			// Bfotogramas
			//
			Panelfotogramas.Width=GBoxccpp.Right+4;
			Panelfotogramas.Height=GBoxTextosf.Bottom+4;
			Bfotogramas.TabIndex=1;
			Bfotogramas.AssociatedPanel=Panelfotogramas;

			//
			// PanelpuntosM
			//
			this.PanelpuntosM.Controls.Add(this.GBoxpuntosM);
			this.PanelpuntosM.Controls.Add(this.GBoxTextospM);
			//
			// GBoxpuntosM
			GBoxpuntosM.Location=new Point(4,4);
			GBoxpuntosM.TabIndex= 0;
			GBoxpuntosM.ColorChanged+= new EventHandler(GBoxpuntosM_ColorChanged);
			//
			// GBoxTextospM
			GBoxTextospM.Location= new Point(4,GBoxpuntosM.Bottom+4);
			GBoxTextospM.TabIndex= 1;
			GBoxTextospM.IgualChanged+= new EventHandler(GBoxTextospM_IgualChanged);
			//
			// BpuntosM
			//
			PanelpuntosM.Width= GBoxpuntosM.Right+4;
			PanelpuntosM.Height= GBoxTextospM.Bottom+4;
			BpuntosM.TabIndex=2;
			BpuntosM.AssociatedPanel=PanelpuntosM;

			//
			// PanelpuntosA
			//
			PanelpuntosA.Controls.Add(this.GBoxpuntosAc);
			PanelpuntosA.Controls.Add(this.GBoxpuntosAi);
			PanelpuntosA.Controls.Add(this.GBoxTextospA);
			//
			// GBoxpuntosAc
			GBoxpuntosAc.Location=new Point(4,4);
			GBoxpuntosAc.TabIndex= 0;
			GBoxpuntosAc.ColorChanged+= new EventHandler(GBoxpuntosAc_ColorChanged);
			//
			// GBoxpuntosAi
			GBoxpuntosAi.Location=new Point(GBoxpuntosAc.Right+4,4);
			GBoxpuntosAi.TabIndex= 1;
			GBoxpuntosAi.ColorChanged+= new EventHandler(GBoxpuntosAi_ColorChanged);
			//
			// GBoxTextospA
			//
			GBoxTextospA.Location= new Point(4,GBoxpuntosAc.Bottom+4);
			GBoxTextospA.TabIndex= 2;
			GBoxTextospA.IgualChanged+= new EventHandler(GBoxTextospA_IgualpAcChanged);
			GBoxTextospA.Igual_iChanged+=new EventHandler(GBoxTextospA_IgualpAiChanged);
			//
			GBoxTextospA.LblColor.Top-=9;			GBoxTextospA.LblColor.Height+=42;
			GBoxTextospA.LblColor_i.Top-=9;		GBoxTextospA.LblColor_i.Height+=42;
			GBoxTextospA.ChkIgual.Top+=4;		GBoxTextospA.ChkIgual.Height+=12;
			GBoxTextospA.ChkIgual_i.Top+=4;		GBoxTextospA.ChkIgual_i.Height+=12;
			GBoxTextospA.BotColor.Top+=16;		GBoxTextospA.BotColor.Left+=16;
			GBoxTextospA.BotColor_i.Top+=16;	GBoxTextospA.BotColor_i.Left+=16;
			GBoxTextospA.LblColor.Width+=16;
			GBoxTextospA.ChkIgual.Left+=16;		GBoxTextospA.ChkIgual.Width-=16;
			GBoxTextospA.LblColor_i.Width+=16;
			GBoxTextospA.ChkIgual_i.Left+=16;	GBoxTextospA.ChkIgual_i.Width-=16;
			foreach(Control c in GBoxTextospA.Controls){
				if(c.TabIndex>5) c.Top+=16;
			}
			GBoxTextospA.Height+=16;
			//
			// BpuntosA
			//
			PanelpuntosA.Width=GBoxpuntosAi.Right+4;
			PanelpuntosA.Height=GBoxTextospA.Bottom+4;
			BpuntosA.TabIndex=3;
			BpuntosA.AssociatedPanel=PanelpuntosA;

			//
			// PanelpuntosC
			//
			this.PanelpuntosC.Controls.Add(this.GBoxpuntosCc);
			this.PanelpuntosC.Controls.Add(this.GBoxpuntosCi);
			this.PanelpuntosC.Controls.Add(this.GBoxTextospC);
			//
			// GBoxpuntosCc
			GBoxpuntosCc.Location=new Point(4,4);
			GBoxpuntosCc.TabIndex= 0;
			GBoxpuntosCc.ColorChanged+= new EventHandler(GBoxpuntosCc_ColorChanged);
			//
			// GBoxpuntosCi
			GBoxpuntosCi.Location=new Point(GBoxpuntosCc.Right+4,4);
			GBoxpuntosCi.TabIndex= 1;
			GBoxpuntosCi.ColorChanged+= new EventHandler(GBoxpuntosCi_ColorChanged);
			//
			// GBoxTextospC
			//
			GBoxTextospC.Location= new Point(4,GBoxpuntosCc.Bottom+4);
			GBoxTextospC.TabIndex= 2;
			GBoxTextospC.IgualChanged+= new EventHandler(GBoxTextospC_IgualpCcChanged);
			GBoxTextospC.Igual_iChanged+=new EventHandler(GBoxTextospC_IgualpCiChanged);
			//
			GBoxTextospC.LblColor.Top-=9;			GBoxTextospC.LblColor.Height+=42;
			GBoxTextospC.LblColor_i.Top-=9;		GBoxTextospC.LblColor_i.Height+=42;
			GBoxTextospC.ChkIgual.Top+=4;		GBoxTextospC.ChkIgual.Height+=12;
			GBoxTextospC.ChkIgual_i.Top+=4;		GBoxTextospC.ChkIgual_i.Height+=12;
			GBoxTextospC.BotColor.Top+=16;		GBoxTextospC.BotColor.Left+=16;
			GBoxTextospC.BotColor_i.Top+=16;	GBoxTextospC.BotColor_i.Left+=16;
			GBoxTextospC.LblColor.Width+=16;
			GBoxTextospC.ChkIgual.Left+=16;		GBoxTextospC.ChkIgual.Width-=16;
			GBoxTextospC.LblColor_i.Width+=16;
			GBoxTextospC.ChkIgual_i.Left+=16;	GBoxTextospC.ChkIgual_i.Width-=16;
			foreach(Control c in GBoxTextospC.Controls){
				if(c.TabIndex>5) c.Top+=16;
			}
			GBoxTextospC.Height+=16;
			//
			// BpuntosC
			//
			PanelpuntosC.Width=GBoxpuntosCi.Right+4;
			PanelpuntosC.Height=GBoxTextospC.Bottom+4;
			BpuntosC.TabIndex=4;
			BpuntosC.AssociatedPanel=PanelpuntosC;

			//
			// RowBasica
			//
			RowBasica.AddOtherControl(LblPrincipales);
			RowBasica.AddTabSelector(Bfotogramas);
			RowBasica.AddTabSelector(BpuntosM);
			RowBasica.AddTabSelector(BpuntosA);
			RowBasica.AddTabSelector(BpuntosC);

			//
			// LblPrecisiones
			//
			LblPrecisiones.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			LblPrecisiones.TabIndex=0;
			LblPrecisiones.Font= new System.Drawing.Font("Microsoft Sans Serif", 8F);
			LblPrecisiones.TextAlign= ContentAlignment.MiddleRight;
			//
			// Panelprecisionescp
			//
			Panelprecisionescp.GBoxelipse.EscalaChanged+= new EventHandler(elipsecp_EscalaChanged);
			Panelprecisionescp.GBoxelipse.ColorChanged+= new EventHandler(elipsecp_ColorChanged);
			Panelprecisionescp.GBoxsegmento.EscalaChanged+= new EventHandler(segmentocp_EscalaChanged);
			Panelprecisionescp.GBoxsegmento.ColorChanged+= new EventHandler(segmentocp_ColorChanged);
			//
			// Bprecisionescp
			//
			Panelprecisionescp.Width+=4;
			Panelprecisionescp.Height+=4;
			Bprecisionescp.TabIndex= 1;
			Bprecisionescp.AssociatedPanel= Panelprecisionescp;
			//
			// PanelprecisionespM
			//
			PanelprecisionespM.IgualChanged+= new EventHandler(PanelprecisionespM_IgualChanged);
			PanelprecisionespM.GBoxelipse.EscalaChanged+= new EventHandler(elipsepM_EscalaChanged);
			PanelprecisionespM.GBoxelipse.ColorChanged+= new EventHandler(elipsepM_ColorChanged);
			PanelprecisionespM.GBoxsegmento.EscalaChanged+= new EventHandler(segmentopM_EscalaChanged);
			PanelprecisionespM.GBoxsegmento.ColorChanged+= new EventHandler(segmentopM_ColorChanged);
			//
			// BprecisionespM
			//
			PanelprecisionespM.Width+=4;
			PanelprecisionespM.Height+=4;
			BprecisionespM.TabIndex= 2;
			BprecisionespM.AssociatedPanel= PanelprecisionespM;
			//
			// PanelprecisionespA
			//
			PanelprecisionespA.IgualChanged+= new EventHandler(PanelprecisionespA_IgualChanged);
			PanelprecisionespA.GBoxelipse.EscalaChanged+= new EventHandler(dummyChanged);
			PanelprecisionespA.GBoxelipse.ColorChanged+= new EventHandler(dummyChanged);
			PanelprecisionespA.GBoxsegmento.EscalaChanged+= new EventHandler(dummyChanged);
			PanelprecisionespA.GBoxsegmento.ColorChanged+= new EventHandler(dummyChanged);
			//
			// BprecisionespA
			//
			PanelprecisionespA.Width+=4;
			PanelprecisionespA.Height+=4;
			BprecisionespA.AssociatedPanel= PanelprecisionespA;

			//
			// RowPrecisiones
			//
			RowPrecisiones.AddOtherControl(LblPrecisiones);
			RowPrecisiones.AddTabSelector(Bprecisionescp);
			RowPrecisiones.AddTabSelector(BprecisionespM);
			RowPrecisiones.AddTabSelector(BprecisionespA);

			//
			// LblResiduos
			//
			LblResiduos.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			LblResiduos.TabIndex=0;
			LblResiduos.Font= new System.Drawing.Font("Microsoft Sans Serif", 8F);
			LblResiduos.TextAlign= ContentAlignment.MiddleRight;
			//
			// Panelresiduosf
			//
			Panelresiduosf.GBoxresiduo.PuntoChanged+= new EventHandler(dummyChanged);
			Panelresiduosf.GBoxresiduo.EscalaChanged+= new EventHandler(dummyChanged);
			Panelresiduosf.GBoxresiduo.ColorChanged+= new EventHandler(dummyChanged);
			//
			// Bresiduosf
			Bresiduosf.TabIndex= 1;
			Bresiduosf.AssociatedPanel= Panelresiduosf;
			//
			// Paneldistorsion
			//
			Paneldistorsion.GBoxresiduo.PuntoChanged+= new EventHandler(dummyChanged);
			Paneldistorsion.GBoxresiduo.EscalaChanged+= new EventHandler(dummyChanged);
			Paneldistorsion.GBoxresiduo.ColorChanged+= new EventHandler(dummyChanged);
			//
			// Bdistorsion
			Bdistorsion.TabIndex= 2;
			Bdistorsion.AssociatedPanel= Paneldistorsion;
			//
			// PanelresiduoscpP
			//
			PanelresiduoscpP.GBoxresiduo.PuntoChanged+= new EventHandler(dummyChanged);
			PanelresiduoscpP.GBoxresiduo.EscalaChanged+= new EventHandler(dummyChanged);
			PanelresiduoscpP.GBoxresiduo.ColorChanged+= new EventHandler(dummyChanged);
			//
			// BresiduoscpP
			BresiduoscpP.TabIndex= 2;
			BresiduoscpP.AssociatedPanel= PanelresiduoscpP;
			//
			// PanelresiduoscpG
			//
			//
			// BresiduoscpG
			BresiduoscpG.TabIndex= 3;
			BresiduoscpG.AssociatedPanel= PanelresiduoscpG;
			//
			// PanelresiduospA
			//
			PanelresiduospA.GBoxresiduo.PuntoChanged+= new EventHandler(dummyChanged);
			PanelresiduospA.GBoxresiduo.EscalaChanged+= new EventHandler(dummyChanged);
			PanelresiduospA.GBoxresiduo.ColorChanged+= new EventHandler(dummyChanged);
			//
			// BresiduospA
			BresiduospA.TabIndex= 4;
			BresiduospA.AssociatedPanel= PanelresiduospA;
			//
			// PanelresiduospC
			//
			PanelresiduospC.GBoxresiduo.PuntoChanged+= new EventHandler(dummyChanged);
			PanelresiduospC.GBoxresiduo.EscalaChanged+= new EventHandler(dummyChanged);
			PanelresiduospC.GBoxresiduo.ColorChanged+= new EventHandler(dummyChanged);
			//
			// BresiduospC
			BresiduospC.TabIndex= 5;
			BresiduospC.AssociatedPanel= PanelresiduospC;

			//
			// RowResiduos
			//
			RowResiduos.AddOtherControl(LblResiduos);
			RowResiduos.AddTabSelector(Bresiduosf);
			RowResiduos.AddTabSelector(Bdistorsion);
			RowResiduos.AddTabSelector(BresiduoscpP);
			RowResiduos.AddTabSelector(BresiduoscpG);
			RowResiduos.AddTabSelector(BresiduospA);
			RowResiduos.AddTabSelector(BresiduospC);

			//Add the rows to the SuperTab
			SuperTab1.AddRow(RowBasica);
			SuperTab1.AddRow(RowPrecisiones);
			SuperTab1.SizeChanged+=new EventHandler(SuperTab1_SizeChanged);
			SuperTab1.AddRow(RowResiduos);
			//
			// FormElementos
			//
			//ClientSize determinado por panel1 y SuperTab1
			this.Controls.Add(this.SuperTab1);
			this.Controls.Add(this.panel1);
			//this.Icon= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Grafico.IconGrafico.ico"));
			this.MaximizeBox= false;
			this.MinimizeBox= false;
		}
	#endregion

		private void SuperTab1_SizeChanged(object sender,EventArgs e){
			this.ClientSize= new Size(SuperTab1.Width, SuperTab1.Height+panel1.Height);
			int d=this.ClientSize.Width-(Aceptar.Width+Cancelar.Width);
			Aceptar.Left=(d*3)/8;
			Cancelar.Left=this.ClientSize.Width-Aceptar.Left-Cancelar.Width;
		}

		public void reset(byte[] MostrarInternos){
			Bfotogramas.Visible=MostrarInternos[0]!=0;
			BpuntosM.Visible=MostrarInternos[1]!=0;
			BpuntosA.Visible=MostrarInternos[2]!=0;
			BpuntosC.Visible=MostrarInternos[3]!=0;
			RowBasica.Visible=true;

			Bprecisionescp.Visible=MostrarInternos[4]!=0;
			BprecisionespM.Visible=MostrarInternos[5]!=0;
			BprecisionespA.Visible=MostrarInternos[6]!=0;
			//Maldito .NET//RowPrecisiones.Visible= Bprecisionescp.Visible || BprecisionespM.Visible || BprecisionespA.Visible;
			RowPrecisiones.Visible= MostrarInternos[4]!=0 || MostrarInternos[5]!=0 || MostrarInternos[6]!=0;

			Bresiduosf.Visible=MostrarInternos[8]!=0;
			Bdistorsion.Visible=MostrarInternos[9]!=0;
			BresiduoscpP.Visible=MostrarInternos[10]!=0;
			BresiduoscpG.Visible=MostrarInternos[11]!=0;
			BresiduospA.Visible=MostrarInternos[12]!=0;
			BresiduospC.Visible=MostrarInternos[13]!=0;
			//Maldito .NET//RowResiduos.Visible= Bresiduosf.Visible || Bdistorsion.Visible || BresiduoscpP.Visible || BresiduoscpG.Visible || BresiduospA.Visible || BresiduospC.Visible;
			RowResiduos.Visible= MostrarInternos[8]!=0 || MostrarInternos[9]!=0 || MostrarInternos[10]!=0 || MostrarInternos[11]!=0 || MostrarInternos[12]!=0 || MostrarInternos[13]!=0;

			if(SuperTab1.CurrentSelector.C.Visible==false)
				SuperTab1.SelectAny();
		}
		internal void Actualiza(ConfiguracionGrafico* _pC, ConfiguracionLogica* _pL){
			pC=_pC;
			pL=_pL;
			*pOldConfig=*pC;
			*pOldLogic=*pL;

			SuspendDibuja=true;
			GBoxfotogramas.Actualiza(&pC->Cfotogramas.lpen, &pC->Cfotogramas.escala);
			GBoxccpp.Actualiza(&pC->Cfotogramas.cp);
			GBoxTextosf.Actualiza(pL->c_Tfotogramas_from_fotogramas, pOldLogic->c_Tfotogramas_from_ccpp, &pC->CTfotogramas);

			GBoxpuntosM.Actualiza(&pC->CpuntosM);
			GBoxTextospM.Actualiza(pL->c_TpuntosM_from_puntosM, &pC->CTpuntosM);

			GBoxpuntosAc.Actualiza(&pC->CpuntosAc);
			GBoxpuntosAi.Actualiza(&pC->CpuntosAi);
			GBoxTextospA.Actualiza(pL->c_TpuntosAc_from_puntosAc, &pC->CTpuntosA, pL->c_TpuntosAi_from_puntosAi, &pC->colorTpuntosAi);

			GBoxpuntosCc.Actualiza(&pC->CpuntosCc);
			GBoxpuntosCi.Actualiza(&pC->CpuntosCi);
			GBoxTextospC.Actualiza(pL->c_TpuntosCc_from_puntosCc, &pC->CTpuntosC, pL->c_TpuntosCi_from_puntosCi, &pC->colorTpuntosCi);

			Panelprecisionescp.Actualiza(&pC->Cprecisionescp);
			PanelprecisionespM.Actualiza(&pC->CprecisionespM, pL->CprecisionespM_from_cp);
			PanelprecisionespA.Actualiza(&pC->CprecisionespA, pL->CprecisionespA_from_pM);

			Panelresiduosf.Actualiza(&pC->Cresiduosf);
			Paneldistorsion.Actualiza(&pC->Cdistorsion);
			PanelresiduoscpP.Actualiza(&pC->CresiduoscpP);
			//PanelresiduoscpG.Actualiza(&pC->CresiduoscpG);
			PanelresiduospA.Actualiza(&pC->CresiduospA);
			PanelresiduospC.Actualiza(&pC->CresiduospC);
			SuspendDibuja=false;
		}

		protected override void OnVisibleChanged(EventArgs e){
			base.OnVisibleChanged(e);
			if(this.Visible==false) return;
			set_idioma(PanelPadre.Idioma);
		}
		internal void redibuja(){
			if(SuspendDibuja) return;
			PanelPadre.redibuja();
		}
		private void dummyChanged(object sender,EventArgs e){redibuja();}

	#region Panelfotogramas
		private void TextEscala_f_TextChanged(object sender,System.EventArgs e){
			float ee;
			try{ee=Basicas._gcVarios.atofl(GBoxfotogramas.TextEscala.Text.ToCharArray());}
			catch(Exception){return;}

			pC->Cfotogramas.escala=ee;
			redibuja();
		}
		private void BotColor_f_ColorChanged(object sender,EventArgs e){
			if(pL->c_Tfotogramas_from_fotogramas){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				pC->CTfotogramas.color=pC->Cfotogramas.lpen.color;
				GBoxTextosf.BotColor.BackColor=FuncionesColor.color_to_Color(pC->Cfotogramas.lpen.color);
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}

		private void GBoxccpp_ColorChanged(object sender,EventArgs e){
			if(pL->c_Tfotogramas_from_ccpp){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				pC->CTfotogramas.color=pC->Cfotogramas.cp.color;
				GBoxTextosf.BotColor.BackColor=FuncionesColor.color_to_Color(pC->Cfotogramas.cp.color);
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}

		private void GBoxTextosf_IgualfChanged(object sender,EventArgs e){
			if(GBoxTextosf.ChkIgual.Checked){
				pL->c_Tfotogramas_from_fotogramas=true;
				pL->c_Tfotogramas_from_ccpp=false;
				if(pC->CTfotogramas.color!=pC->Cfotogramas.lpen.color){
					pC->CTfotogramas.color=pC->Cfotogramas.lpen.color;
					GBoxTextosf.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CTfotogramas.color);
					redibuja();
				}
			}else{
				pL->c_Tfotogramas_from_fotogramas=false;
			}
		}
		private void GBoxTextosf_IgualcpChanged(object sender,EventArgs e){
			if(GBoxTextosf.ChkIgualb.Checked){
				pL->c_Tfotogramas_from_fotogramas=false;
				pL->c_Tfotogramas_from_ccpp=true;
				if(pC->CTfotogramas.color!=pC->Cfotogramas.cp.color){
					pC->CTfotogramas.color=pC->Cfotogramas.cp.color;
					GBoxTextosf.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CTfotogramas.color);
					redibuja();
				}
			}else{
				pL->c_Tfotogramas_from_fotogramas=false;
			}
		}
	#endregion

	#region PanelpuntosM
		private void GBoxpuntosM_ColorChanged(object sender,EventArgs e){
			if(pL->c_TpuntosM_from_puntosM){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				pC->CTpuntosM.color=pC->CpuntosM.color;
				GBoxTextospM.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CpuntosM.color);
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}

		private void GBoxTextospM_IgualChanged(object sender,EventArgs e){
			if(GBoxTextospM.ChkIgual.Checked){
				pL->c_TpuntosM_from_puntosM=true;
				if(pC->CTpuntosM.color!=pC->CpuntosM.color){
					pC->CTpuntosM.color=pC->CpuntosM.color;
					GBoxTextospM.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CTpuntosM.color);
					redibuja();
				}
			}else{
				pL->c_TpuntosM_from_puntosM=false;
			}
		}
	#endregion

	#region PanelpuntosA
		private void GBoxpuntosAc_ColorChanged(object sender,EventArgs e){
			if(pL->c_TpuntosAc_from_puntosAc){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				pC->CTpuntosA.color=pC->CpuntosAc.color;
				GBoxTextospA.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CpuntosAc.color);
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void GBoxpuntosAi_ColorChanged(object sender,EventArgs e){
			if(pL->c_TpuntosAi_from_puntosAi){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				pC->colorTpuntosAi=pC->CpuntosAi.color;
				GBoxTextospA.BotColor_i.BackColor=FuncionesColor.color_to_Color(pC->CpuntosAi.color);
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}

		private void GBoxTextospA_IgualpAcChanged(object sender,EventArgs e){
			if(GBoxTextospA.ChkIgual.Checked){
				pL->c_TpuntosAc_from_puntosAc=true;
				if(pC->CTpuntosA.color!=pC->CpuntosAc.color){
					pC->CTpuntosA.color=pC->CpuntosAc.color;
					GBoxTextospA.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CTpuntosA.color);
					redibuja();
				}
			}else{
				pL->c_TpuntosAc_from_puntosAc=false;
			}
		}

		private void GBoxTextospA_IgualpAiChanged(object sender,EventArgs e){
			if(GBoxTextospA.ChkIgual_i.Checked){
				pL->c_TpuntosAi_from_puntosAi=true;
				if(pC->colorTpuntosAi!=pC->CpuntosAi.color){
					pC->colorTpuntosAi=pC->CpuntosAi.color;
					GBoxTextospA.BotColor_i.BackColor=FuncionesColor.color_to_Color(pC->colorTpuntosAi);
					redibuja();
				}
			}else{
				pL->c_TpuntosAi_from_puntosAi=false;
			}
		}
	#endregion

	#region PanelpuntosC
		private void GBoxpuntosCc_ColorChanged(object sender,EventArgs e){
			if(pL->c_TpuntosCc_from_puntosCc){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				pC->CTpuntosC.color=pC->CpuntosCc.color;
				GBoxTextospC.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CpuntosCc.color);
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void GBoxpuntosCi_ColorChanged(object sender,EventArgs e){
			if(pL->c_TpuntosCi_from_puntosCi){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				pC->colorTpuntosCi=pC->CpuntosCi.color;
				GBoxTextospC.BotColor_i.BackColor=FuncionesColor.color_to_Color(pC->CpuntosCi.color);
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}

		private void GBoxTextospC_IgualpCcChanged(object sender,EventArgs e){
			if(GBoxTextospC.ChkIgual.Checked){
				pL->c_TpuntosCc_from_puntosCc=true;
				if(pC->CTpuntosC.color!=pC->CpuntosCc.color){
					pC->CTpuntosC.color=pC->CpuntosCc.color;
					GBoxTextospC.BotColor.BackColor=FuncionesColor.color_to_Color(pC->CTpuntosC.color);
					redibuja();
				}
			}else{
				pL->c_TpuntosCc_from_puntosCc=false;
			}
		}

		private void GBoxTextospC_IgualpCiChanged(object sender,EventArgs e){
			if(GBoxTextospC.ChkIgual_i.Checked){
				pL->c_TpuntosCi_from_puntosCi=true;
				if(pC->colorTpuntosCi!=pC->CpuntosCi.color){
					pC->colorTpuntosCi=pC->CpuntosCi.color;
					GBoxTextospC.BotColor_i.BackColor=FuncionesColor.color_to_Color(pC->colorTpuntosCi);
					redibuja();
				}
			}else{
				pL->c_TpuntosCi_from_puntosCi=false;
			}
		}
	#endregion

	#region Panelprecisionescp
		private void elipsecp_EscalaChanged(object sender,EventArgs e){
			if(pL->CprecisionespM_from_cp){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespM.GBoxelipse.TextEscala.Text=Panelprecisionescp.GBoxelipse.TextEscala.Text;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void elipsecp_ColorChanged(object sender,EventArgs e){
			if(pL->CprecisionespM_from_cp){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespM.GBoxelipse.BotColor.BackColor=Panelprecisionescp.GBoxelipse.BotColor.BackColor;
				PanelprecisionespM.GBoxelipse.lpen->color=Panelprecisionescp.GBoxelipse.lpen->color;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void segmentocp_EscalaChanged(object sender,EventArgs e){
			if(pL->CprecisionespM_from_cp){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespM.GBoxsegmento.TextEscala.Text=Panelprecisionescp.GBoxsegmento.TextEscala.Text;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void segmentocp_ColorChanged(object sender,EventArgs e){
			if(pL->CprecisionespM_from_cp){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespM.GBoxsegmento.BotColor.BackColor=Panelprecisionescp.GBoxsegmento.BotColor.BackColor;
				PanelprecisionespM.GBoxsegmento.lpen->color=Panelprecisionescp.GBoxsegmento.lpen->color;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
	#endregion

	#region PanelprecisionespM
		private void PanelprecisionespM_IgualChanged(object sender,EventArgs e){
			if(PanelprecisionespM.ChkIgual.Checked){
				pL->CprecisionespM_from_cp=true;
				if( pC->CprecisionespM!=pC->Cprecisionescp){
					pC->CprecisionespM=pC->Cprecisionescp;
					PanelprecisionespM.Actualiza(&pC->CprecisionespM, true);
					redibuja();
				}
			}else{
				pL->CprecisionespM_from_cp=false;
			}
		}
		private void elipsepM_EscalaChanged(object sender,EventArgs e){
			if(pL->CprecisionespA_from_pM){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespA.GBoxelipse.TextEscala.Text=PanelprecisionespM.GBoxelipse.TextEscala.Text;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void elipsepM_ColorChanged(object sender,EventArgs e){
			if(pL->CprecisionespA_from_pM){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespA.GBoxelipse.BotColor.BackColor=PanelprecisionespM.GBoxelipse.BotColor.BackColor;
				PanelprecisionespA.GBoxelipse.lpen->color=PanelprecisionespM.GBoxelipse.lpen->color;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void segmentopM_EscalaChanged(object sender,EventArgs e){
			if(pL->CprecisionespA_from_pM){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespA.GBoxsegmento.TextEscala.Text=PanelprecisionespM.GBoxsegmento.TextEscala.Text;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
		private void segmentopM_ColorChanged(object sender,EventArgs e){
			if(pL->CprecisionespA_from_pM){
				bool OldSuspend=SuspendDibuja;	SuspendDibuja=true;
				PanelprecisionespA.GBoxsegmento.BotColor.BackColor=PanelprecisionespM.GBoxsegmento.BotColor.BackColor;
				PanelprecisionespA.GBoxsegmento.lpen->color=PanelprecisionespM.GBoxsegmento.lpen->color;
				SuspendDibuja=OldSuspend;
			}
			redibuja();
		}
	#endregion

	#region PanelprecisionespA
		private void PanelprecisionespA_IgualChanged(object sender,EventArgs e){
			if(PanelprecisionespA.ChkIgual.Checked){
				pL->CprecisionespA_from_pM=true;
				if(pC->CprecisionespA!=pC->CprecisionespM){
					pC->CprecisionespA=pC->CprecisionespM;
					PanelprecisionespA.Actualiza(&pC->CprecisionespA, true);
					redibuja();
				}
			}else{
				pL->CprecisionespA_from_pM=false;
			}
		}
	#endregion

		private void Aceptar_Click(object sender,System.EventArgs e)
		{
			this.Hide();		//Al revs. En vez de ir guardando en VirtualConfig
		}						//y si se Acepta salvar, vamos cambiando CurrentConfig
		private void Cancelar_Click(object sender,System.EventArgs e){
			*PanelPadre.pCurrentConfig=*pOldConfig;
			*PanelPadre.pCurrentLogic=*pOldLogic;
			this.Hide();		//y si se cancela resituimos
			PanelPadre.redibuja();
		}
		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

		protected override void update_idioma(){
			switch(idioma){
				case 1: etiquetas_eng(); break;
				case 2: etiquetas_it(); break;
				default: etiquetas_esp(); break;
			}
		}

		void etiquetas_esp(){
			this.Text= "Elementos grficos";
			Aceptar.Text= "Aceptar";
			Cancelar.Text= "Cancelar";

			LblPrincipales.Text= "Elementos principales:";
			Bfotogramas.Text="Fotogramas";
			GBoxfotogramas.Text="Fotogramas";
			GBoxfotogramas.LblEscala.Text= "Escala aplicada para visualizarlos:";
			GBoxfotogramas.LblColor.Text= "Color:";
			GBoxccpp.Text= "Centros de proyeccin";
			GBoxccpp.LblColor.Text= "Color:";
			GBoxTextosf.Text= "Texto de los nombres";
			GBoxTextosf.LblColor.Text= "Color:";
			GBoxTextosf.ChkIgual.Text= "Igual que los fotogramas";
			GBoxTextosf.ChkIgualb.Text= "Igual que los cc.pp.";
			GBoxTextosf.LblSize.Text= "Tamao:";

			BpuntosM.Text= "Puntos";
			GBoxpuntosM.Text= "Puntos";
			GBoxpuntosM.LblColor.Text= "Color:";
			GBoxTextospM.Text= "Texto de los puntos";
			GBoxTextospM.LblColor.Text= "Color:";
			GBoxTextospM.ChkIgual.Text= "Igual que los puntos";
			GBoxTextospM.LblSize.Text= "Tamao:";

			BpuntosA.Text= "Puntos de apoyo";
			GBoxpuntosAc.Text= "Puntos de apoyo completos";
			GBoxpuntosAc.LblColor.Text= "Color:";
			GBoxpuntosAi.Text= "Puntos de apoyo incompletos";
			GBoxpuntosAi.LblColor.Text= "Color:";
			GBoxTextospA.Text= "Texto de los puntos de apoyo";
			GBoxTextospA.LblColor.Text= "Color del texto de los puntos de apoyo completos";
			GBoxTextospA.ChkIgual.Text= "Igual que los puntos de apoyo completos";
			GBoxTextospA.LblSize.Text= "Tamao:";
			GBoxTextospA.LblColor_i.Text= "Color del texto de los puntos de apoyo incompletos";
			GBoxTextospA.ChkIgual_i.Text= "Igual que los puntos de apoyo incompletos";

			BpuntosC.Text= "Puntos de control";
			GBoxpuntosCc.Text= "Puntos de control completos";
			GBoxpuntosCc.LblColor.Text= "Color:";
			GBoxpuntosCi.Text= "Puntos de control incompletos";
			GBoxpuntosCi.LblColor.Text= "Color:";
			GBoxTextospC.Text= "Texto de los puntos de control";
			GBoxTextospC.LblColor.Text= "Color del texto de los puntos de control completos";
			GBoxTextospC.ChkIgual.Text= "Igual que los puntos de control completos";
			GBoxTextospC.LblSize.Text= "Tamao:";
			GBoxTextospC.LblColor_i.Text= "Color del texto de los puntos de control incompletos";
			GBoxTextospC.ChkIgual_i.Text= "Igual que los puntos de control incompletos";

			LblPrecisiones.Text= "Componentes de precisin:";
			Bprecisionescp.Text= "cc.pp.";
			Panelprecisionescp.etiquetas_esp();

			BprecisionespM.Text= "puntos";
			PanelprecisionespM.ChkIgual.Text= "Iguales que las de los cc.pp.";
			PanelprecisionespM.etiquetas_esp();

			BprecisionespA.Text= "puntos de apoyo";
			PanelprecisionespA.ChkIgual.Text= "Iguales que las de los puntos";
			PanelprecisionespA.etiquetas_esp();

			LblResiduos.Text= "Residuos et sim.:";
			Bresiduosf.Text= "fotocoordenadas";
			Panelresiduosf.etiquetas_esp();

			Bdistorsion.Text= "distorsion";
			Paneldistorsion.etiquetas_esp();

			BresiduoscpP.Text= "cc.pp., punto";
			PanelresiduoscpP.etiquetas_esp();

			BresiduoscpG.Text= "cc.pp., giro";
			//PanelresiduoscpG.etiquetas_esp();

			BresiduospA.Text= "puntos de apoyo";
			PanelresiduospA.etiquetas_esp();

			BresiduospC.Text= "puntos de control";
			PanelresiduospC.etiquetas_esp();
		}
		void etiquetas_eng(){
			this.Text= "Graphic elements";
			Aceptar.Text="OK";
			Cancelar.Text="Cancel";

			LblPrincipales.Text= "Main elements:";
			Bfotogramas.Text="Photographs";
			GBoxfotogramas.Text="Photographs";
			GBoxfotogramas.LblEscala.Text= "Displaying\n scale:";
			GBoxfotogramas.LblColor.Text= "Color:";
			GBoxccpp.Text="Projection centres";
			GBoxccpp.LblColor.Text= "Color:";
			GBoxTextosf.Text="Text of names";
			GBoxTextosf.LblColor.Text= "Color:";
			GBoxTextosf.ChkIgual.Text= "The same as photographs";
			GBoxTextosf.ChkIgualb.Text= "The same as cc.pp.";
			GBoxTextosf.LblSize.Text= "Size:";

			BpuntosM.Text= "Points";
			GBoxpuntosM.Text= "Points";
			GBoxpuntosM.LblColor.Text= "Color:";
			GBoxTextospM.Text= "Text of points";
			GBoxTextospM.LblColor.Text= "Color:";
			GBoxTextospM.ChkIgual.Text= "The same as points";
			GBoxTextospM.LblSize.Text= "Size:";

			BpuntosA.Text= "Control points";
			GBoxpuntosAc.Text= "Complete control points";
			GBoxpuntosAc.LblColor.Text= "Color:";
			GBoxpuntosAi.Text= "Incomplete control points";
			GBoxpuntosAi.LblColor.Text= "Color:";
			GBoxTextospA.Text= "Text of control points";
			GBoxTextospA.LblColor.Text= "Color of the text of complete control points";
			GBoxTextospA.ChkIgual.Text= "The same as com- plete control points";
			GBoxTextospA.LblSize.Text= "Size:";
			GBoxTextospA.LblColor_i.Text= "Color of the text of incomplete control points";
			GBoxTextospA.ChkIgual_i.Text= "The same as incom- plete control points";

			BpuntosC.Text= "Check points";
			GBoxpuntosCc.Text= "Complete check points";
			GBoxpuntosCc.LblColor.Text= "Color:";
			GBoxpuntosCi.Text= "Incomplete check points";
			GBoxpuntosCi.LblColor.Text= "Color:";
			GBoxTextospC.Text= "Text of check points";
			GBoxTextospC.LblColor.Text= "Color of the text of complete check points";
			GBoxTextospC.ChkIgual.Text= "The same as com- plete check points";
			GBoxTextospC.LblSize.Text= "Size:";
			GBoxTextospC.LblColor_i.Text= "Color of the text of incomplete check points";
			GBoxTextospC.ChkIgual_i.Text= "The same as incom- plete check points";

			LblPrecisiones.Text= "Precision components:";
			Bprecisionescp.Text= "cc.pp.";
			Panelprecisionescp.etiquetas_eng();

			BprecisionespM.Text= "points";
			PanelprecisionespM.ChkIgual.Text= "The same as cc.pp.";
			PanelprecisionespM.etiquetas_eng();

			BprecisionespA.Text= "control points";
			PanelprecisionespA.ChkIgual.Text= "The same as points";
			PanelprecisionespA.etiquetas_eng();

			LblResiduos.Text= "Residuals et sim.:";
			Bresiduosf.Text= "photo coordinates";
			Panelresiduosf.etiquetas_eng();

			Bdistorsion.Text= "distortion";
			Paneldistorsion.etiquetas_eng();

			BresiduoscpP.Text= "cc.pp., point";
			PanelresiduoscpP.etiquetas_eng();

			BresiduoscpG.Text= "cc.pp., rotation";
			//PanelresiduoscpG.etiquetas_eng();

			BresiduospA.Text= "control points";
			PanelresiduospA.etiquetas_eng();

			BresiduospC.Text= "check points";
			PanelresiduospC.etiquetas_eng();

		}
		void etiquetas_it(){
			this.Text= "Elementi grafici";
			Aceptar.Text="OK";
			Cancelar.Text="Annulla";

			LblPrincipales.Text= "Elementi principali:";
			Bfotogramas.Text="Fotogrammi";
			GBoxfotogramas.Text="Fotogrammi";
			GBoxfotogramas.LblEscala.Text= "Scala applicata per la visualizzazione:";
			GBoxfotogramas.LblColor.Text= "Colore:";
			GBoxccpp.Text="Centri di Proiezione";
			GBoxccpp.LblColor.Text= "Colore:";
			GBoxTextosf.Text="Testo dei nomi";
			GBoxTextosf.LblColor.Text= "Colore:";
			GBoxTextosf.ChkIgual.Text= "Uguale che i fotogrammi";
			GBoxTextosf.ChkIgualb.Text= "Uguale che i cc.pp.";
			GBoxTextosf.LblSize.Text= "Grandezza:";

			BpuntosM.Text= "Punti";
			GBoxpuntosM.Text= "Punti";
			GBoxpuntosM.LblColor.Text= "Colore:";
			GBoxTextospM.Text= "Testo dei punti";
			GBoxTextospM.LblColor.Text= "Colore:";
			GBoxTextospM.ChkIgual.Text= "Uguale che i punti";
			GBoxTextospM.LblSize.Text= "Grandezza:";

			BpuntosA.Text= "Punti di appoggio";
			GBoxpuntosAc.Text= "Punti di appoggio completi";
			GBoxpuntosAc.LblColor.Text= "Colore:";
			GBoxpuntosAi.Text= "Punti di appoggio incompleti";
			GBoxpuntosAi.LblColor.Text= "Colore:";
			GBoxTextospA.Text= "Testo dei punti di appoggio";
			GBoxTextospA.LblColor.Text= "Colore del testo dei punti di appoggio completi";
			GBoxTextospA.ChkIgual.Text= "Uguale che i punti di appoggio completi";
			GBoxTextospA.LblSize.Text= "Grandezza:";
			GBoxTextospA.LblColor_i.Text= "Colore del testo dei punti di appoggio incompleti";
			GBoxTextospA.ChkIgual_i.Text= "Uguale che i punti di appoggio incompleti";

			BpuntosC.Text= "Punti di controllo";
			GBoxpuntosCc.Text= "Punti di controllo completi";
			GBoxpuntosCc.LblColor.Text= "Colore:";
			GBoxpuntosCi.Text= "Punti di controllo incompleti";
			GBoxpuntosCi.LblColor.Text= "Colore:";
			GBoxTextospC.Text= "Testo dei punti di controllo";
			GBoxTextospC.LblColor.Text= "Colore del testo dei punti di controllo completi";
			GBoxTextospC.ChkIgual.Text= "Uguale che i punti di controllo completi";
			GBoxTextospC.LblSize.Text= "Grandezza:";
			GBoxTextospC.LblColor_i.Text= "Colore del testo dei punti di controllo incompleti";
			GBoxTextospC.ChkIgual_i.Text= "Uguale che i punti di controllo incompleti";

			LblPrecisiones.Text= "Componenti di precisione:";
			Bprecisionescp.Text="cc.pp.";
			Panelprecisionescp.etiquetas_it();

			BprecisionespM.Text= "punti";
			PanelprecisionespM.ChkIgual.Text= "Uguale che quelle dei cc.pp.";
			PanelprecisionespM.etiquetas_it();

			BprecisionespA.Text= "punti di appoggio";
			PanelprecisionespA.ChkIgual.Text= "Uguale che quelle dei punti";
			PanelprecisionespA.etiquetas_it();

			LblResiduos.Text= "Residui et sim.:";
			Bresiduosf.Text= "coordinate immagine";
			Panelresiduosf.etiquetas_it();

			Bdistorsion.Text= "distorsione";
			Paneldistorsion.etiquetas_it();

			BresiduoscpP.Text= "cc.pp., punto";
			PanelresiduoscpP.etiquetas_it();

			BresiduoscpG.Text= "cc.pp., giro";
			//PanelresiduoscpG.etiquetas_it();

			BresiduospA.Text= "punti di appoggio";
			PanelresiduospA.etiquetas_it();

			BresiduospC.Text= "punti di controllo";
			PanelresiduospC.etiquetas_it();
		}
	}
}
#endif
